<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierImageDetail StructType
 * @subpackage Structs
 */
class SupplierImageDetail extends AbstractStructBase
{
    /**
     * The ImageName
     * @var string
     */
    public $ImageName;
    /**
     * The ImageCategory
     * @var string
     */
    public $ImageCategory;
    /**
     * The ImageUrl
     * @var string
     */
    public $ImageUrl;
    /**
     * Constructor method for SupplierImageDetail
     * @uses SupplierImageDetail::setImageName()
     * @uses SupplierImageDetail::setImageCategory()
     * @uses SupplierImageDetail::setImageUrl()
     * @param string $imageName
     * @param string $imageCategory
     * @param string $imageUrl
     */
    public function __construct($imageName = null, $imageCategory = null, $imageUrl = null)
    {
        $this
            ->setImageName($imageName)
            ->setImageCategory($imageCategory)
            ->setImageUrl($imageUrl);
    }
    /**
     * Get ImageName value
     * @return string|null
     */
    public function getImageName()
    {
        return $this->ImageName;
    }
    /**
     * Set ImageName value
     * @param string $imageName
     * @return \StructType\SupplierImageDetail
     */
    public function setImageName($imageName = null)
    {
        // validation for constraint: string
        if (!is_null($imageName) && !is_string($imageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageName, true), gettype($imageName)), __LINE__);
        }
        $this->ImageName = $imageName;
        return $this;
    }
    /**
     * Get ImageCategory value
     * @return string|null
     */
    public function getImageCategory()
    {
        return $this->ImageCategory;
    }
    /**
     * Set ImageCategory value
     * @param string $imageCategory
     * @return \StructType\SupplierImageDetail
     */
    public function setImageCategory($imageCategory = null)
    {
        // validation for constraint: string
        if (!is_null($imageCategory) && !is_string($imageCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageCategory, true), gettype($imageCategory)), __LINE__);
        }
        $this->ImageCategory = $imageCategory;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return \StructType\SupplierImageDetail
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplierImageDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
