<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierDetail StructType
 * @subpackage Structs
 */
class SupplierDetail extends AbstractStructBase
{
    /**
     * The ProposalId
     * @var string
     */
    public $ProposalId;
    /**
     * The VenueId
     * @var string
     */
    public $VenueId;
    /**
     * The VenueName
     * @var string
     */
    public $VenueName;
    /**
     * The VenueCode
     * @var string
     */
    public $VenueCode;
    /**
     * The VenueType
     * @var string
     */
    public $VenueType;
    /**
     * The VenueCity
     * @var string
     */
    public $VenueCity;
    /**
     * The VenueMMA
     * @var string
     */
    public $VenueMMA;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The RFPLastSentDate
     * @var string
     */
    public $RFPLastSentDate;
    /**
     * The RFPViewedDate
     * @var string
     */
    public $RFPViewedDate;
    /**
     * The RFPLastViewedDate
     * @var string
     */
    public $RFPLastViewedDate;
    /**
     * The ResponseReason
     * @var string
     */
    public $ResponseReason;
    /**
     * The ResponseReasonComment
     * @var string
     */
    public $ResponseReasonComment;
    /**
     * Constructor method for SupplierDetail
     * @uses SupplierDetail::setProposalId()
     * @uses SupplierDetail::setVenueId()
     * @uses SupplierDetail::setVenueName()
     * @uses SupplierDetail::setVenueCode()
     * @uses SupplierDetail::setVenueType()
     * @uses SupplierDetail::setVenueCity()
     * @uses SupplierDetail::setVenueMMA()
     * @uses SupplierDetail::setStatus()
     * @uses SupplierDetail::setRFPLastSentDate()
     * @uses SupplierDetail::setRFPViewedDate()
     * @uses SupplierDetail::setRFPLastViewedDate()
     * @uses SupplierDetail::setResponseReason()
     * @uses SupplierDetail::setResponseReasonComment()
     * @param string $proposalId
     * @param string $venueId
     * @param string $venueName
     * @param string $venueCode
     * @param string $venueType
     * @param string $venueCity
     * @param string $venueMMA
     * @param string $status
     * @param string $rFPLastSentDate
     * @param string $rFPViewedDate
     * @param string $rFPLastViewedDate
     * @param string $responseReason
     * @param string $responseReasonComment
     */
    public function __construct($proposalId = null, $venueId = null, $venueName = null, $venueCode = null, $venueType = null, $venueCity = null, $venueMMA = null, $status = null, $rFPLastSentDate = null, $rFPViewedDate = null, $rFPLastViewedDate = null, $responseReason = null, $responseReasonComment = null)
    {
        $this
            ->setProposalId($proposalId)
            ->setVenueId($venueId)
            ->setVenueName($venueName)
            ->setVenueCode($venueCode)
            ->setVenueType($venueType)
            ->setVenueCity($venueCity)
            ->setVenueMMA($venueMMA)
            ->setStatus($status)
            ->setRFPLastSentDate($rFPLastSentDate)
            ->setRFPViewedDate($rFPViewedDate)
            ->setRFPLastViewedDate($rFPLastViewedDate)
            ->setResponseReason($responseReason)
            ->setResponseReasonComment($responseReasonComment);
    }
    /**
     * Get ProposalId value
     * @return string|null
     */
    public function getProposalId()
    {
        return $this->ProposalId;
    }
    /**
     * Set ProposalId value
     * @param string $proposalId
     * @return \StructType\SupplierDetail
     */
    public function setProposalId($proposalId = null)
    {
        // validation for constraint: string
        if (!is_null($proposalId) && !is_string($proposalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proposalId, true), gettype($proposalId)), __LINE__);
        }
        $this->ProposalId = $proposalId;
        return $this;
    }
    /**
     * Get VenueId value
     * @return string|null
     */
    public function getVenueId()
    {
        return $this->VenueId;
    }
    /**
     * Set VenueId value
     * @param string $venueId
     * @return \StructType\SupplierDetail
     */
    public function setVenueId($venueId = null)
    {
        // validation for constraint: string
        if (!is_null($venueId) && !is_string($venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueId, true), gettype($venueId)), __LINE__);
        }
        $this->VenueId = $venueId;
        return $this;
    }
    /**
     * Get VenueName value
     * @return string|null
     */
    public function getVenueName()
    {
        return $this->VenueName;
    }
    /**
     * Set VenueName value
     * @param string $venueName
     * @return \StructType\SupplierDetail
     */
    public function setVenueName($venueName = null)
    {
        // validation for constraint: string
        if (!is_null($venueName) && !is_string($venueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueName, true), gettype($venueName)), __LINE__);
        }
        $this->VenueName = $venueName;
        return $this;
    }
    /**
     * Get VenueCode value
     * @return string|null
     */
    public function getVenueCode()
    {
        return $this->VenueCode;
    }
    /**
     * Set VenueCode value
     * @param string $venueCode
     * @return \StructType\SupplierDetail
     */
    public function setVenueCode($venueCode = null)
    {
        // validation for constraint: string
        if (!is_null($venueCode) && !is_string($venueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueCode, true), gettype($venueCode)), __LINE__);
        }
        $this->VenueCode = $venueCode;
        return $this;
    }
    /**
     * Get VenueType value
     * @return string|null
     */
    public function getVenueType()
    {
        return $this->VenueType;
    }
    /**
     * Set VenueType value
     * @param string $venueType
     * @return \StructType\SupplierDetail
     */
    public function setVenueType($venueType = null)
    {
        // validation for constraint: string
        if (!is_null($venueType) && !is_string($venueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueType, true), gettype($venueType)), __LINE__);
        }
        $this->VenueType = $venueType;
        return $this;
    }
    /**
     * Get VenueCity value
     * @return string|null
     */
    public function getVenueCity()
    {
        return $this->VenueCity;
    }
    /**
     * Set VenueCity value
     * @param string $venueCity
     * @return \StructType\SupplierDetail
     */
    public function setVenueCity($venueCity = null)
    {
        // validation for constraint: string
        if (!is_null($venueCity) && !is_string($venueCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueCity, true), gettype($venueCity)), __LINE__);
        }
        $this->VenueCity = $venueCity;
        return $this;
    }
    /**
     * Get VenueMMA value
     * @return string|null
     */
    public function getVenueMMA()
    {
        return $this->VenueMMA;
    }
    /**
     * Set VenueMMA value
     * @param string $venueMMA
     * @return \StructType\SupplierDetail
     */
    public function setVenueMMA($venueMMA = null)
    {
        // validation for constraint: string
        if (!is_null($venueMMA) && !is_string($venueMMA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueMMA, true), gettype($venueMMA)), __LINE__);
        }
        $this->VenueMMA = $venueMMA;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\SupplierDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get RFPLastSentDate value
     * @return string|null
     */
    public function getRFPLastSentDate()
    {
        return $this->RFPLastSentDate;
    }
    /**
     * Set RFPLastSentDate value
     * @param string $rFPLastSentDate
     * @return \StructType\SupplierDetail
     */
    public function setRFPLastSentDate($rFPLastSentDate = null)
    {
        // validation for constraint: string
        if (!is_null($rFPLastSentDate) && !is_string($rFPLastSentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPLastSentDate, true), gettype($rFPLastSentDate)), __LINE__);
        }
        $this->RFPLastSentDate = $rFPLastSentDate;
        return $this;
    }
    /**
     * Get RFPViewedDate value
     * @return string|null
     */
    public function getRFPViewedDate()
    {
        return $this->RFPViewedDate;
    }
    /**
     * Set RFPViewedDate value
     * @param string $rFPViewedDate
     * @return \StructType\SupplierDetail
     */
    public function setRFPViewedDate($rFPViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($rFPViewedDate) && !is_string($rFPViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPViewedDate, true), gettype($rFPViewedDate)), __LINE__);
        }
        $this->RFPViewedDate = $rFPViewedDate;
        return $this;
    }
    /**
     * Get RFPLastViewedDate value
     * @return string|null
     */
    public function getRFPLastViewedDate()
    {
        return $this->RFPLastViewedDate;
    }
    /**
     * Set RFPLastViewedDate value
     * @param string $rFPLastViewedDate
     * @return \StructType\SupplierDetail
     */
    public function setRFPLastViewedDate($rFPLastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($rFPLastViewedDate) && !is_string($rFPLastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPLastViewedDate, true), gettype($rFPLastViewedDate)), __LINE__);
        }
        $this->RFPLastViewedDate = $rFPLastViewedDate;
        return $this;
    }
    /**
     * Get ResponseReason value
     * @return string|null
     */
    public function getResponseReason()
    {
        return $this->ResponseReason;
    }
    /**
     * Set ResponseReason value
     * @param string $responseReason
     * @return \StructType\SupplierDetail
     */
    public function setResponseReason($responseReason = null)
    {
        // validation for constraint: string
        if (!is_null($responseReason) && !is_string($responseReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseReason, true), gettype($responseReason)), __LINE__);
        }
        $this->ResponseReason = $responseReason;
        return $this;
    }
    /**
     * Get ResponseReasonComment value
     * @return string|null
     */
    public function getResponseReasonComment()
    {
        return $this->ResponseReasonComment;
    }
    /**
     * Set ResponseReasonComment value
     * @param string $responseReasonComment
     * @return \StructType\SupplierDetail
     */
    public function setResponseReasonComment($responseReasonComment = null)
    {
        // validation for constraint: string
        if (!is_null($responseReasonComment) && !is_string($responseReasonComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseReasonComment, true), gettype($responseReasonComment)), __LINE__);
        }
        $this->ResponseReasonComment = $responseReasonComment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplierDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
