<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier StructType
 * @subpackage Structs
 */
class Supplier extends CvObject
{
    /**
     * The ImageDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierImageDetail[]
     */
    public $ImageDetail;
    /**
     * The RateHistoryDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierRateHistoryDetail[]
     */
    public $RateHistoryDetail;
    /**
     * The ExternalIdDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierExternalIdDetail[]
     */
    public $ExternalIdDetail;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The VenueCode
     * @var string
     */
    public $VenueCode;
    /**
     * The VenueType
     * @var string
     */
    public $VenueType;
    /**
     * The Brand
     * @var string
     */
    public $Brand;
    /**
     * The ChainAffiliation
     * @var string
     */
    public $ChainAffiliation;
    /**
     * The MainPhoneNumber
     * @var string
     */
    public $MainPhoneNumber;
    /**
     * The MainFaxNumber
     * @var string
     */
    public $MainFaxNumber;
    /**
     * The SalesPhoneNumber
     * @var string
     */
    public $SalesPhoneNumber;
    /**
     * The SalesFaxNumber
     * @var string
     */
    public $SalesFaxNumber;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * The VenueWebsiteURL
     * @var string
     */
    public $VenueWebsiteURL;
    /**
     * The CventStarRating
     * @var string
     */
    public $CventStarRating;
    /**
     * The Address1
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * @var string
     */
    public $Address2;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The State
     * @var string
     */
    public $State;
    /**
     * The StateCode
     * @var string
     */
    public $StateCode;
    /**
     * The PostalCode
     * @var string
     */
    public $PostalCode;
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The MetroArea
     * @var string
     */
    public $MetroArea;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The CancellationPolicy
     * @var string
     */
    public $CancellationPolicy;
    /**
     * The TotalSleepRooms
     * @var int
     */
    public $TotalSleepRooms;
    /**
     * The TotalSingleRooms
     * @var int
     */
    public $TotalSingleRooms;
    /**
     * The TotalDoubleRooms
     * @var int
     */
    public $TotalDoubleRooms;
    /**
     * The TotalSuites
     * @var int
     */
    public $TotalSuites;
    /**
     * The ProfileCompleteness
     * @var float
     */
    public $ProfileCompleteness;
    /**
     * The ProposalDefaultCompleteness
     * @var float
     */
    public $ProposalDefaultCompleteness;
    /**
     * Constructor method for Supplier
     * @uses Supplier::setImageDetail()
     * @uses Supplier::setRateHistoryDetail()
     * @uses Supplier::setExternalIdDetail()
     * @uses Supplier::setID()
     * @uses Supplier::setName()
     * @uses Supplier::setVenueCode()
     * @uses Supplier::setVenueType()
     * @uses Supplier::setBrand()
     * @uses Supplier::setChainAffiliation()
     * @uses Supplier::setMainPhoneNumber()
     * @uses Supplier::setMainFaxNumber()
     * @uses Supplier::setSalesPhoneNumber()
     * @uses Supplier::setSalesFaxNumber()
     * @uses Supplier::setSourceId()
     * @uses Supplier::setVenueWebsiteURL()
     * @uses Supplier::setCventStarRating()
     * @uses Supplier::setAddress1()
     * @uses Supplier::setAddress2()
     * @uses Supplier::setCity()
     * @uses Supplier::setState()
     * @uses Supplier::setStateCode()
     * @uses Supplier::setPostalCode()
     * @uses Supplier::setCountry()
     * @uses Supplier::setCountryCode()
     * @uses Supplier::setMetroArea()
     * @uses Supplier::setCurrency()
     * @uses Supplier::setDescription()
     * @uses Supplier::setCancellationPolicy()
     * @uses Supplier::setTotalSleepRooms()
     * @uses Supplier::setTotalSingleRooms()
     * @uses Supplier::setTotalDoubleRooms()
     * @uses Supplier::setTotalSuites()
     * @uses Supplier::setProfileCompleteness()
     * @uses Supplier::setProposalDefaultCompleteness()
     * @param \StructType\SupplierImageDetail[] $imageDetail
     * @param \StructType\SupplierRateHistoryDetail[] $rateHistoryDetail
     * @param \StructType\SupplierExternalIdDetail[] $externalIdDetail
     * @param string $iD
     * @param string $name
     * @param string $venueCode
     * @param string $venueType
     * @param string $brand
     * @param string $chainAffiliation
     * @param string $mainPhoneNumber
     * @param string $mainFaxNumber
     * @param string $salesPhoneNumber
     * @param string $salesFaxNumber
     * @param string $sourceId
     * @param string $venueWebsiteURL
     * @param string $cventStarRating
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $stateCode
     * @param string $postalCode
     * @param string $country
     * @param string $countryCode
     * @param string $metroArea
     * @param string $currency
     * @param string $description
     * @param string $cancellationPolicy
     * @param int $totalSleepRooms
     * @param int $totalSingleRooms
     * @param int $totalDoubleRooms
     * @param int $totalSuites
     * @param float $profileCompleteness
     * @param float $proposalDefaultCompleteness
     */
    public function __construct(array $imageDetail = array(), array $rateHistoryDetail = array(), array $externalIdDetail = array(), $iD = null, $name = null, $venueCode = null, $venueType = null, $brand = null, $chainAffiliation = null, $mainPhoneNumber = null, $mainFaxNumber = null, $salesPhoneNumber = null, $salesFaxNumber = null, $sourceId = null, $venueWebsiteURL = null, $cventStarRating = null, $address1 = null, $address2 = null, $city = null, $state = null, $stateCode = null, $postalCode = null, $country = null, $countryCode = null, $metroArea = null, $currency = null, $description = null, $cancellationPolicy = null, $totalSleepRooms = null, $totalSingleRooms = null, $totalDoubleRooms = null, $totalSuites = null, $profileCompleteness = null, $proposalDefaultCompleteness = null)
    {
        $this
            ->setImageDetail($imageDetail)
            ->setRateHistoryDetail($rateHistoryDetail)
            ->setExternalIdDetail($externalIdDetail)
            ->setID($iD)
            ->setName($name)
            ->setVenueCode($venueCode)
            ->setVenueType($venueType)
            ->setBrand($brand)
            ->setChainAffiliation($chainAffiliation)
            ->setMainPhoneNumber($mainPhoneNumber)
            ->setMainFaxNumber($mainFaxNumber)
            ->setSalesPhoneNumber($salesPhoneNumber)
            ->setSalesFaxNumber($salesFaxNumber)
            ->setSourceId($sourceId)
            ->setVenueWebsiteURL($venueWebsiteURL)
            ->setCventStarRating($cventStarRating)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setStateCode($stateCode)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setMetroArea($metroArea)
            ->setCurrency($currency)
            ->setDescription($description)
            ->setCancellationPolicy($cancellationPolicy)
            ->setTotalSleepRooms($totalSleepRooms)
            ->setTotalSingleRooms($totalSingleRooms)
            ->setTotalDoubleRooms($totalDoubleRooms)
            ->setTotalSuites($totalSuites)
            ->setProfileCompleteness($profileCompleteness)
            ->setProposalDefaultCompleteness($proposalDefaultCompleteness);
    }
    /**
     * Get ImageDetail value
     * @return \StructType\SupplierImageDetail[]|null
     */
    public function getImageDetail()
    {
        return $this->ImageDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setImageDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageDetailForArrayConstraintsFromSetImageDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierImageDetailItem) {
            // validation for constraint: itemType
            if (!$supplierImageDetailItem instanceof \StructType\SupplierImageDetail) {
                $invalidValues[] = is_object($supplierImageDetailItem) ? get_class($supplierImageDetailItem) : sprintf('%s(%s)', gettype($supplierImageDetailItem), var_export($supplierImageDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageDetail property can only contain items of type \StructType\SupplierImageDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierImageDetail[] $imageDetail
     * @return \StructType\Supplier
     */
    public function setImageDetail(array $imageDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($imageDetailArrayErrorMessage = self::validateImageDetailForArrayConstraintsFromSetImageDetail($imageDetail))) {
            throw new \InvalidArgumentException($imageDetailArrayErrorMessage, __LINE__);
        }
        $this->ImageDetail = $imageDetail;
        return $this;
    }
    /**
     * Add item to ImageDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierImageDetail $item
     * @return \StructType\Supplier
     */
    public function addToImageDetail(\StructType\SupplierImageDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierImageDetail) {
            throw new \InvalidArgumentException(sprintf('The ImageDetail property can only contain items of type \StructType\SupplierImageDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageDetail[] = $item;
        return $this;
    }
    /**
     * Get RateHistoryDetail value
     * @return \StructType\SupplierRateHistoryDetail[]|null
     */
    public function getRateHistoryDetail()
    {
        return $this->RateHistoryDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setRateHistoryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateHistoryDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateHistoryDetailForArrayConstraintsFromSetRateHistoryDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierRateHistoryDetailItem) {
            // validation for constraint: itemType
            if (!$supplierRateHistoryDetailItem instanceof \StructType\SupplierRateHistoryDetail) {
                $invalidValues[] = is_object($supplierRateHistoryDetailItem) ? get_class($supplierRateHistoryDetailItem) : sprintf('%s(%s)', gettype($supplierRateHistoryDetailItem), var_export($supplierRateHistoryDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateHistoryDetail property can only contain items of type \StructType\SupplierRateHistoryDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRateHistoryDetail[] $rateHistoryDetail
     * @return \StructType\Supplier
     */
    public function setRateHistoryDetail(array $rateHistoryDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($rateHistoryDetailArrayErrorMessage = self::validateRateHistoryDetailForArrayConstraintsFromSetRateHistoryDetail($rateHistoryDetail))) {
            throw new \InvalidArgumentException($rateHistoryDetailArrayErrorMessage, __LINE__);
        }
        $this->RateHistoryDetail = $rateHistoryDetail;
        return $this;
    }
    /**
     * Add item to RateHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRateHistoryDetail $item
     * @return \StructType\Supplier
     */
    public function addToRateHistoryDetail(\StructType\SupplierRateHistoryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierRateHistoryDetail) {
            throw new \InvalidArgumentException(sprintf('The RateHistoryDetail property can only contain items of type \StructType\SupplierRateHistoryDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RateHistoryDetail[] = $item;
        return $this;
    }
    /**
     * Get ExternalIdDetail value
     * @return \StructType\SupplierExternalIdDetail[]|null
     */
    public function getExternalIdDetail()
    {
        return $this->ExternalIdDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalIdDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalIdDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdDetailForArrayConstraintsFromSetExternalIdDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierExternalIdDetailItem) {
            // validation for constraint: itemType
            if (!$supplierExternalIdDetailItem instanceof \StructType\SupplierExternalIdDetail) {
                $invalidValues[] = is_object($supplierExternalIdDetailItem) ? get_class($supplierExternalIdDetailItem) : sprintf('%s(%s)', gettype($supplierExternalIdDetailItem), var_export($supplierExternalIdDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExternalIdDetail property can only contain items of type \StructType\SupplierExternalIdDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExternalIdDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierExternalIdDetail[] $externalIdDetail
     * @return \StructType\Supplier
     */
    public function setExternalIdDetail(array $externalIdDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdDetailArrayErrorMessage = self::validateExternalIdDetailForArrayConstraintsFromSetExternalIdDetail($externalIdDetail))) {
            throw new \InvalidArgumentException($externalIdDetailArrayErrorMessage, __LINE__);
        }
        $this->ExternalIdDetail = $externalIdDetail;
        return $this;
    }
    /**
     * Add item to ExternalIdDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierExternalIdDetail $item
     * @return \StructType\Supplier
     */
    public function addToExternalIdDetail(\StructType\SupplierExternalIdDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierExternalIdDetail) {
            throw new \InvalidArgumentException(sprintf('The ExternalIdDetail property can only contain items of type \StructType\SupplierExternalIdDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExternalIdDetail[] = $item;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Supplier
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Supplier
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get VenueCode value
     * @return string|null
     */
    public function getVenueCode()
    {
        return $this->VenueCode;
    }
    /**
     * Set VenueCode value
     * @param string $venueCode
     * @return \StructType\Supplier
     */
    public function setVenueCode($venueCode = null)
    {
        // validation for constraint: string
        if (!is_null($venueCode) && !is_string($venueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueCode, true), gettype($venueCode)), __LINE__);
        }
        $this->VenueCode = $venueCode;
        return $this;
    }
    /**
     * Get VenueType value
     * @return string|null
     */
    public function getVenueType()
    {
        return $this->VenueType;
    }
    /**
     * Set VenueType value
     * @param string $venueType
     * @return \StructType\Supplier
     */
    public function setVenueType($venueType = null)
    {
        // validation for constraint: string
        if (!is_null($venueType) && !is_string($venueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueType, true), gettype($venueType)), __LINE__);
        }
        $this->VenueType = $venueType;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \StructType\Supplier
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get ChainAffiliation value
     * @return string|null
     */
    public function getChainAffiliation()
    {
        return $this->ChainAffiliation;
    }
    /**
     * Set ChainAffiliation value
     * @param string $chainAffiliation
     * @return \StructType\Supplier
     */
    public function setChainAffiliation($chainAffiliation = null)
    {
        // validation for constraint: string
        if (!is_null($chainAffiliation) && !is_string($chainAffiliation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainAffiliation, true), gettype($chainAffiliation)), __LINE__);
        }
        $this->ChainAffiliation = $chainAffiliation;
        return $this;
    }
    /**
     * Get MainPhoneNumber value
     * @return string|null
     */
    public function getMainPhoneNumber()
    {
        return $this->MainPhoneNumber;
    }
    /**
     * Set MainPhoneNumber value
     * @param string $mainPhoneNumber
     * @return \StructType\Supplier
     */
    public function setMainPhoneNumber($mainPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mainPhoneNumber) && !is_string($mainPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainPhoneNumber, true), gettype($mainPhoneNumber)), __LINE__);
        }
        $this->MainPhoneNumber = $mainPhoneNumber;
        return $this;
    }
    /**
     * Get MainFaxNumber value
     * @return string|null
     */
    public function getMainFaxNumber()
    {
        return $this->MainFaxNumber;
    }
    /**
     * Set MainFaxNumber value
     * @param string $mainFaxNumber
     * @return \StructType\Supplier
     */
    public function setMainFaxNumber($mainFaxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mainFaxNumber) && !is_string($mainFaxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainFaxNumber, true), gettype($mainFaxNumber)), __LINE__);
        }
        $this->MainFaxNumber = $mainFaxNumber;
        return $this;
    }
    /**
     * Get SalesPhoneNumber value
     * @return string|null
     */
    public function getSalesPhoneNumber()
    {
        return $this->SalesPhoneNumber;
    }
    /**
     * Set SalesPhoneNumber value
     * @param string $salesPhoneNumber
     * @return \StructType\Supplier
     */
    public function setSalesPhoneNumber($salesPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($salesPhoneNumber) && !is_string($salesPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesPhoneNumber, true), gettype($salesPhoneNumber)), __LINE__);
        }
        $this->SalesPhoneNumber = $salesPhoneNumber;
        return $this;
    }
    /**
     * Get SalesFaxNumber value
     * @return string|null
     */
    public function getSalesFaxNumber()
    {
        return $this->SalesFaxNumber;
    }
    /**
     * Set SalesFaxNumber value
     * @param string $salesFaxNumber
     * @return \StructType\Supplier
     */
    public function setSalesFaxNumber($salesFaxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($salesFaxNumber) && !is_string($salesFaxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesFaxNumber, true), gettype($salesFaxNumber)), __LINE__);
        }
        $this->SalesFaxNumber = $salesFaxNumber;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\Supplier
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get VenueWebsiteURL value
     * @return string|null
     */
    public function getVenueWebsiteURL()
    {
        return $this->VenueWebsiteURL;
    }
    /**
     * Set VenueWebsiteURL value
     * @param string $venueWebsiteURL
     * @return \StructType\Supplier
     */
    public function setVenueWebsiteURL($venueWebsiteURL = null)
    {
        // validation for constraint: string
        if (!is_null($venueWebsiteURL) && !is_string($venueWebsiteURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueWebsiteURL, true), gettype($venueWebsiteURL)), __LINE__);
        }
        $this->VenueWebsiteURL = $venueWebsiteURL;
        return $this;
    }
    /**
     * Get CventStarRating value
     * @return string|null
     */
    public function getCventStarRating()
    {
        return $this->CventStarRating;
    }
    /**
     * Set CventStarRating value
     * @param string $cventStarRating
     * @return \StructType\Supplier
     */
    public function setCventStarRating($cventStarRating = null)
    {
        // validation for constraint: string
        if (!is_null($cventStarRating) && !is_string($cventStarRating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cventStarRating, true), gettype($cventStarRating)), __LINE__);
        }
        $this->CventStarRating = $cventStarRating;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\Supplier
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\Supplier
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Supplier
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\Supplier
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\Supplier
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\Supplier
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\Supplier
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Supplier
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get MetroArea value
     * @return string|null
     */
    public function getMetroArea()
    {
        return $this->MetroArea;
    }
    /**
     * Set MetroArea value
     * @param string $metroArea
     * @return \StructType\Supplier
     */
    public function setMetroArea($metroArea = null)
    {
        // validation for constraint: string
        if (!is_null($metroArea) && !is_string($metroArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metroArea, true), gettype($metroArea)), __LINE__);
        }
        $this->MetroArea = $metroArea;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\Supplier
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Supplier
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return string|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param string $cancellationPolicy
     * @return \StructType\Supplier
     */
    public function setCancellationPolicy($cancellationPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationPolicy) && !is_string($cancellationPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationPolicy, true), gettype($cancellationPolicy)), __LINE__);
        }
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get TotalSleepRooms value
     * @return int|null
     */
    public function getTotalSleepRooms()
    {
        return $this->TotalSleepRooms;
    }
    /**
     * Set TotalSleepRooms value
     * @param int $totalSleepRooms
     * @return \StructType\Supplier
     */
    public function setTotalSleepRooms($totalSleepRooms = null)
    {
        // validation for constraint: int
        if (!is_null($totalSleepRooms) && !(is_int($totalSleepRooms) || ctype_digit($totalSleepRooms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalSleepRooms, true), gettype($totalSleepRooms)), __LINE__);
        }
        $this->TotalSleepRooms = $totalSleepRooms;
        return $this;
    }
    /**
     * Get TotalSingleRooms value
     * @return int|null
     */
    public function getTotalSingleRooms()
    {
        return $this->TotalSingleRooms;
    }
    /**
     * Set TotalSingleRooms value
     * @param int $totalSingleRooms
     * @return \StructType\Supplier
     */
    public function setTotalSingleRooms($totalSingleRooms = null)
    {
        // validation for constraint: int
        if (!is_null($totalSingleRooms) && !(is_int($totalSingleRooms) || ctype_digit($totalSingleRooms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalSingleRooms, true), gettype($totalSingleRooms)), __LINE__);
        }
        $this->TotalSingleRooms = $totalSingleRooms;
        return $this;
    }
    /**
     * Get TotalDoubleRooms value
     * @return int|null
     */
    public function getTotalDoubleRooms()
    {
        return $this->TotalDoubleRooms;
    }
    /**
     * Set TotalDoubleRooms value
     * @param int $totalDoubleRooms
     * @return \StructType\Supplier
     */
    public function setTotalDoubleRooms($totalDoubleRooms = null)
    {
        // validation for constraint: int
        if (!is_null($totalDoubleRooms) && !(is_int($totalDoubleRooms) || ctype_digit($totalDoubleRooms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDoubleRooms, true), gettype($totalDoubleRooms)), __LINE__);
        }
        $this->TotalDoubleRooms = $totalDoubleRooms;
        return $this;
    }
    /**
     * Get TotalSuites value
     * @return int|null
     */
    public function getTotalSuites()
    {
        return $this->TotalSuites;
    }
    /**
     * Set TotalSuites value
     * @param int $totalSuites
     * @return \StructType\Supplier
     */
    public function setTotalSuites($totalSuites = null)
    {
        // validation for constraint: int
        if (!is_null($totalSuites) && !(is_int($totalSuites) || ctype_digit($totalSuites))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalSuites, true), gettype($totalSuites)), __LINE__);
        }
        $this->TotalSuites = $totalSuites;
        return $this;
    }
    /**
     * Get ProfileCompleteness value
     * @return float|null
     */
    public function getProfileCompleteness()
    {
        return $this->ProfileCompleteness;
    }
    /**
     * Set ProfileCompleteness value
     * @param float $profileCompleteness
     * @return \StructType\Supplier
     */
    public function setProfileCompleteness($profileCompleteness = null)
    {
        // validation for constraint: float
        if (!is_null($profileCompleteness) && !(is_float($profileCompleteness) || is_numeric($profileCompleteness))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($profileCompleteness, true), gettype($profileCompleteness)), __LINE__);
        }
        $this->ProfileCompleteness = $profileCompleteness;
        return $this;
    }
    /**
     * Get ProposalDefaultCompleteness value
     * @return float|null
     */
    public function getProposalDefaultCompleteness()
    {
        return $this->ProposalDefaultCompleteness;
    }
    /**
     * Set ProposalDefaultCompleteness value
     * @param float $proposalDefaultCompleteness
     * @return \StructType\Supplier
     */
    public function setProposalDefaultCompleteness($proposalDefaultCompleteness = null)
    {
        // validation for constraint: float
        if (!is_null($proposalDefaultCompleteness) && !(is_float($proposalDefaultCompleteness) || is_numeric($proposalDefaultCompleteness))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proposalDefaultCompleteness, true), gettype($proposalDefaultCompleteness)), __LINE__);
        }
        $this->ProposalDefaultCompleteness = $proposalDefaultCompleteness;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Supplier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
