<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Speaker StructType
 * @subpackage Structs
 */
class Speaker extends CvObject
{
    /**
     * The DocumentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentDetail[]
     */
    public $DocumentDetail;
    /**
     * The RelatedWebsitesDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RelatedWebsitesDetail[]
     */
    public $RelatedWebsitesDetail;
    /**
     * The AssignedSessions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AssignedSessions[]
     */
    public $AssignedSessions;
    /**
     * The SpeakerId
     * @var string
     */
    public $SpeakerId;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The Prefix
     * @var string
     */
    public $Prefix;
    /**
     * The Designation
     * @var string
     */
    public $Designation;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The SpeakerCode
     * @var string
     */
    public $SpeakerCode;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The FacebookURL
     * @var string
     */
    public $FacebookURL;
    /**
     * The LinkedInURL
     * @var string
     */
    public $LinkedInURL;
    /**
     * The TwitterURL
     * @var string
     */
    public $TwitterURL;
    /**
     * The CategoryId
     * @var string
     */
    public $CategoryId;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The DisplayOnWebsite
     * @var bool
     */
    public $DisplayOnWebsite;
    /**
     * The ProfileImageURL
     * @var string
     */
    public $ProfileImageURL;
    /**
     * The Biography
     * @var string
     */
    public $Biography;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * Constructor method for Speaker
     * @uses Speaker::setDocumentDetail()
     * @uses Speaker::setRelatedWebsitesDetail()
     * @uses Speaker::setAssignedSessions()
     * @uses Speaker::setSpeakerId()
     * @uses Speaker::setFirstName()
     * @uses Speaker::setLastName()
     * @uses Speaker::setEmailAddress()
     * @uses Speaker::setPrefix()
     * @uses Speaker::setDesignation()
     * @uses Speaker::setCompany()
     * @uses Speaker::setTitle()
     * @uses Speaker::setSpeakerCode()
     * @uses Speaker::setEventId()
     * @uses Speaker::setEventTitle()
     * @uses Speaker::setEventCode()
     * @uses Speaker::setFacebookURL()
     * @uses Speaker::setLinkedInURL()
     * @uses Speaker::setTwitterURL()
     * @uses Speaker::setCategoryId()
     * @uses Speaker::setCategory()
     * @uses Speaker::setDisplayOnWebsite()
     * @uses Speaker::setProfileImageURL()
     * @uses Speaker::setBiography()
     * @uses Speaker::setInternalNote()
     * @uses Speaker::setCreatedDate()
     * @uses Speaker::setCreatedBy()
     * @uses Speaker::setLastModifiedDate()
     * @uses Speaker::setLastModifiedBy()
     * @param \StructType\DocumentDetail[] $documentDetail
     * @param \StructType\RelatedWebsitesDetail[] $relatedWebsitesDetail
     * @param \StructType\AssignedSessions[] $assignedSessions
     * @param string $speakerId
     * @param string $firstName
     * @param string $lastName
     * @param string $emailAddress
     * @param string $prefix
     * @param string $designation
     * @param string $company
     * @param string $title
     * @param string $speakerCode
     * @param string $eventId
     * @param string $eventTitle
     * @param string $eventCode
     * @param string $facebookURL
     * @param string $linkedInURL
     * @param string $twitterURL
     * @param string $categoryId
     * @param string $category
     * @param bool $displayOnWebsite
     * @param string $profileImageURL
     * @param string $biography
     * @param string $internalNote
     * @param string $createdDate
     * @param string $createdBy
     * @param string $lastModifiedDate
     * @param string $lastModifiedBy
     */
    public function __construct(array $documentDetail = array(), array $relatedWebsitesDetail = array(), array $assignedSessions = array(), $speakerId = null, $firstName = null, $lastName = null, $emailAddress = null, $prefix = null, $designation = null, $company = null, $title = null, $speakerCode = null, $eventId = null, $eventTitle = null, $eventCode = null, $facebookURL = null, $linkedInURL = null, $twitterURL = null, $categoryId = null, $category = null, $displayOnWebsite = null, $profileImageURL = null, $biography = null, $internalNote = null, $createdDate = null, $createdBy = null, $lastModifiedDate = null, $lastModifiedBy = null)
    {
        $this
            ->setDocumentDetail($documentDetail)
            ->setRelatedWebsitesDetail($relatedWebsitesDetail)
            ->setAssignedSessions($assignedSessions)
            ->setSpeakerId($speakerId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmailAddress($emailAddress)
            ->setPrefix($prefix)
            ->setDesignation($designation)
            ->setCompany($company)
            ->setTitle($title)
            ->setSpeakerCode($speakerCode)
            ->setEventId($eventId)
            ->setEventTitle($eventTitle)
            ->setEventCode($eventCode)
            ->setFacebookURL($facebookURL)
            ->setLinkedInURL($linkedInURL)
            ->setTwitterURL($twitterURL)
            ->setCategoryId($categoryId)
            ->setCategory($category)
            ->setDisplayOnWebsite($displayOnWebsite)
            ->setProfileImageURL($profileImageURL)
            ->setBiography($biography)
            ->setInternalNote($internalNote)
            ->setCreatedDate($createdDate)
            ->setCreatedBy($createdBy)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastModifiedBy($lastModifiedBy);
    }
    /**
     * Get DocumentDetail value
     * @return \StructType\DocumentDetail[]|null
     */
    public function getDocumentDetail()
    {
        return $this->DocumentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentDetailForArrayConstraintsFromSetDocumentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $speakerDocumentDetailItem) {
            // validation for constraint: itemType
            if (!$speakerDocumentDetailItem instanceof \StructType\DocumentDetail) {
                $invalidValues[] = is_object($speakerDocumentDetailItem) ? get_class($speakerDocumentDetailItem) : sprintf('%s(%s)', gettype($speakerDocumentDetailItem), var_export($speakerDocumentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentDetail property can only contain items of type \StructType\DocumentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentDetail[] $documentDetail
     * @return \StructType\Speaker
     */
    public function setDocumentDetail(array $documentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($documentDetailArrayErrorMessage = self::validateDocumentDetailForArrayConstraintsFromSetDocumentDetail($documentDetail))) {
            throw new \InvalidArgumentException($documentDetailArrayErrorMessage, __LINE__);
        }
        $this->DocumentDetail = $documentDetail;
        return $this;
    }
    /**
     * Add item to DocumentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentDetail $item
     * @return \StructType\Speaker
     */
    public function addToDocumentDetail(\StructType\DocumentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentDetail) {
            throw new \InvalidArgumentException(sprintf('The DocumentDetail property can only contain items of type \StructType\DocumentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentDetail[] = $item;
        return $this;
    }
    /**
     * Get RelatedWebsitesDetail value
     * @return \StructType\RelatedWebsitesDetail[]|null
     */
    public function getRelatedWebsitesDetail()
    {
        return $this->RelatedWebsitesDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedWebsitesDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedWebsitesDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedWebsitesDetailForArrayConstraintsFromSetRelatedWebsitesDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $speakerRelatedWebsitesDetailItem) {
            // validation for constraint: itemType
            if (!$speakerRelatedWebsitesDetailItem instanceof \StructType\RelatedWebsitesDetail) {
                $invalidValues[] = is_object($speakerRelatedWebsitesDetailItem) ? get_class($speakerRelatedWebsitesDetailItem) : sprintf('%s(%s)', gettype($speakerRelatedWebsitesDetailItem), var_export($speakerRelatedWebsitesDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedWebsitesDetail property can only contain items of type \StructType\RelatedWebsitesDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedWebsitesDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedWebsitesDetail[] $relatedWebsitesDetail
     * @return \StructType\Speaker
     */
    public function setRelatedWebsitesDetail(array $relatedWebsitesDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedWebsitesDetailArrayErrorMessage = self::validateRelatedWebsitesDetailForArrayConstraintsFromSetRelatedWebsitesDetail($relatedWebsitesDetail))) {
            throw new \InvalidArgumentException($relatedWebsitesDetailArrayErrorMessage, __LINE__);
        }
        $this->RelatedWebsitesDetail = $relatedWebsitesDetail;
        return $this;
    }
    /**
     * Add item to RelatedWebsitesDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedWebsitesDetail $item
     * @return \StructType\Speaker
     */
    public function addToRelatedWebsitesDetail(\StructType\RelatedWebsitesDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatedWebsitesDetail) {
            throw new \InvalidArgumentException(sprintf('The RelatedWebsitesDetail property can only contain items of type \StructType\RelatedWebsitesDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedWebsitesDetail[] = $item;
        return $this;
    }
    /**
     * Get AssignedSessions value
     * @return \StructType\AssignedSessions[]|null
     */
    public function getAssignedSessions()
    {
        return $this->AssignedSessions;
    }
    /**
     * This method is responsible for validating the values passed to the setAssignedSessions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssignedSessions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssignedSessionsForArrayConstraintsFromSetAssignedSessions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $speakerAssignedSessionsItem) {
            // validation for constraint: itemType
            if (!$speakerAssignedSessionsItem instanceof \StructType\AssignedSessions) {
                $invalidValues[] = is_object($speakerAssignedSessionsItem) ? get_class($speakerAssignedSessionsItem) : sprintf('%s(%s)', gettype($speakerAssignedSessionsItem), var_export($speakerAssignedSessionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssignedSessions property can only contain items of type \StructType\AssignedSessions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssignedSessions value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedSessions[] $assignedSessions
     * @return \StructType\Speaker
     */
    public function setAssignedSessions(array $assignedSessions = array())
    {
        // validation for constraint: array
        if ('' !== ($assignedSessionsArrayErrorMessage = self::validateAssignedSessionsForArrayConstraintsFromSetAssignedSessions($assignedSessions))) {
            throw new \InvalidArgumentException($assignedSessionsArrayErrorMessage, __LINE__);
        }
        $this->AssignedSessions = $assignedSessions;
        return $this;
    }
    /**
     * Add item to AssignedSessions value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedSessions $item
     * @return \StructType\Speaker
     */
    public function addToAssignedSessions(\StructType\AssignedSessions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssignedSessions) {
            throw new \InvalidArgumentException(sprintf('The AssignedSessions property can only contain items of type \StructType\AssignedSessions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AssignedSessions[] = $item;
        return $this;
    }
    /**
     * Get SpeakerId value
     * @return string|null
     */
    public function getSpeakerId()
    {
        return $this->SpeakerId;
    }
    /**
     * Set SpeakerId value
     * @param string $speakerId
     * @return \StructType\Speaker
     */
    public function setSpeakerId($speakerId = null)
    {
        // validation for constraint: string
        if (!is_null($speakerId) && !is_string($speakerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($speakerId, true), gettype($speakerId)), __LINE__);
        }
        $this->SpeakerId = $speakerId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Speaker
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Speaker
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\Speaker
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \StructType\Speaker
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Get Designation value
     * @return string|null
     */
    public function getDesignation()
    {
        return $this->Designation;
    }
    /**
     * Set Designation value
     * @param string $designation
     * @return \StructType\Speaker
     */
    public function setDesignation($designation = null)
    {
        // validation for constraint: string
        if (!is_null($designation) && !is_string($designation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designation, true), gettype($designation)), __LINE__);
        }
        $this->Designation = $designation;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\Speaker
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Speaker
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get SpeakerCode value
     * @return string|null
     */
    public function getSpeakerCode()
    {
        return $this->SpeakerCode;
    }
    /**
     * Set SpeakerCode value
     * @param string $speakerCode
     * @return \StructType\Speaker
     */
    public function setSpeakerCode($speakerCode = null)
    {
        // validation for constraint: string
        if (!is_null($speakerCode) && !is_string($speakerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($speakerCode, true), gettype($speakerCode)), __LINE__);
        }
        $this->SpeakerCode = $speakerCode;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\Speaker
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\Speaker
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\Speaker
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get FacebookURL value
     * @return string|null
     */
    public function getFacebookURL()
    {
        return $this->FacebookURL;
    }
    /**
     * Set FacebookURL value
     * @param string $facebookURL
     * @return \StructType\Speaker
     */
    public function setFacebookURL($facebookURL = null)
    {
        // validation for constraint: string
        if (!is_null($facebookURL) && !is_string($facebookURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facebookURL, true), gettype($facebookURL)), __LINE__);
        }
        $this->FacebookURL = $facebookURL;
        return $this;
    }
    /**
     * Get LinkedInURL value
     * @return string|null
     */
    public function getLinkedInURL()
    {
        return $this->LinkedInURL;
    }
    /**
     * Set LinkedInURL value
     * @param string $linkedInURL
     * @return \StructType\Speaker
     */
    public function setLinkedInURL($linkedInURL = null)
    {
        // validation for constraint: string
        if (!is_null($linkedInURL) && !is_string($linkedInURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedInURL, true), gettype($linkedInURL)), __LINE__);
        }
        $this->LinkedInURL = $linkedInURL;
        return $this;
    }
    /**
     * Get TwitterURL value
     * @return string|null
     */
    public function getTwitterURL()
    {
        return $this->TwitterURL;
    }
    /**
     * Set TwitterURL value
     * @param string $twitterURL
     * @return \StructType\Speaker
     */
    public function setTwitterURL($twitterURL = null)
    {
        // validation for constraint: string
        if (!is_null($twitterURL) && !is_string($twitterURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($twitterURL, true), gettype($twitterURL)), __LINE__);
        }
        $this->TwitterURL = $twitterURL;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param string $categoryId
     * @return \StructType\Speaker
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\Speaker
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get DisplayOnWebsite value
     * @return bool|null
     */
    public function getDisplayOnWebsite()
    {
        return $this->DisplayOnWebsite;
    }
    /**
     * Set DisplayOnWebsite value
     * @param bool $displayOnWebsite
     * @return \StructType\Speaker
     */
    public function setDisplayOnWebsite($displayOnWebsite = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayOnWebsite) && !is_bool($displayOnWebsite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayOnWebsite, true), gettype($displayOnWebsite)), __LINE__);
        }
        $this->DisplayOnWebsite = $displayOnWebsite;
        return $this;
    }
    /**
     * Get ProfileImageURL value
     * @return string|null
     */
    public function getProfileImageURL()
    {
        return $this->ProfileImageURL;
    }
    /**
     * Set ProfileImageURL value
     * @param string $profileImageURL
     * @return \StructType\Speaker
     */
    public function setProfileImageURL($profileImageURL = null)
    {
        // validation for constraint: string
        if (!is_null($profileImageURL) && !is_string($profileImageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileImageURL, true), gettype($profileImageURL)), __LINE__);
        }
        $this->ProfileImageURL = $profileImageURL;
        return $this;
    }
    /**
     * Get Biography value
     * @return string|null
     */
    public function getBiography()
    {
        return $this->Biography;
    }
    /**
     * Set Biography value
     * @param string $biography
     * @return \StructType\Speaker
     */
    public function setBiography($biography = null)
    {
        // validation for constraint: string
        if (!is_null($biography) && !is_string($biography)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($biography, true), gettype($biography)), __LINE__);
        }
        $this->Biography = $biography;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\Speaker
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Speaker
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\Speaker
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Speaker
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\Speaker
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Speaker
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
