<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SleepingRoomDetail StructType
 * @subpackage Structs
 */
class SleepingRoomDetail extends AbstractStructBase
{
    /**
     * The RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The RoomQuantity
     * @var int
     */
    public $RoomQuantity;
    /**
     * The RoomRate
     * @var float
     */
    public $RoomRate;
    /**
     * Constructor method for SleepingRoomDetail
     * @uses SleepingRoomDetail::setRoomType()
     * @uses SleepingRoomDetail::setRoomQuantity()
     * @uses SleepingRoomDetail::setRoomRate()
     * @param string $roomType
     * @param int $roomQuantity
     * @param float $roomRate
     */
    public function __construct($roomType = null, $roomQuantity = null, $roomRate = null)
    {
        $this
            ->setRoomType($roomType)
            ->setRoomQuantity($roomQuantity)
            ->setRoomRate($roomRate);
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\SleepingRoomDetail
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomQuantity value
     * @return int|null
     */
    public function getRoomQuantity()
    {
        return $this->RoomQuantity;
    }
    /**
     * Set RoomQuantity value
     * @param int $roomQuantity
     * @return \StructType\SleepingRoomDetail
     */
    public function setRoomQuantity($roomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($roomQuantity) && !(is_int($roomQuantity) || ctype_digit($roomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomQuantity, true), gettype($roomQuantity)), __LINE__);
        }
        $this->RoomQuantity = $roomQuantity;
        return $this;
    }
    /**
     * Get RoomRate value
     * @return float|null
     */
    public function getRoomRate()
    {
        return $this->RoomRate;
    }
    /**
     * Set RoomRate value
     * @param float $roomRate
     * @return \StructType\SleepingRoomDetail
     */
    public function setRoomRate($roomRate = null)
    {
        // validation for constraint: float
        if (!is_null($roomRate) && !(is_float($roomRate) || is_numeric($roomRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($roomRate, true), gettype($roomRate)), __LINE__);
        }
        $this->RoomRate = $roomRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SleepingRoomDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
