<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleEventRegistration StructType
 * @subpackage Structs
 */
class SimpleEventRegistration extends AbstractStructBase
{
    /**
     * The RegAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RegAction;
    /**
     * The CvObjects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCvObject
     */
    public $CvObjects;
    /**
     * The EventId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventId;
    /**
     * The AdmissionItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdmissionItemID;
    /**
     * Constructor method for SimpleEventRegistration
     * @uses SimpleEventRegistration::setRegAction()
     * @uses SimpleEventRegistration::setCvObjects()
     * @uses SimpleEventRegistration::setEventId()
     * @uses SimpleEventRegistration::setAdmissionItemID()
     * @param string $regAction
     * @param \ArrayType\ArrayOfCvObject $cvObjects
     * @param string $eventId
     * @param string $admissionItemID
     */
    public function __construct($regAction = null, \ArrayType\ArrayOfCvObject $cvObjects = null, $eventId = null, $admissionItemID = null)
    {
        $this
            ->setRegAction($regAction)
            ->setCvObjects($cvObjects)
            ->setEventId($eventId)
            ->setAdmissionItemID($admissionItemID);
    }
    /**
     * Get RegAction value
     * @return string
     */
    public function getRegAction()
    {
        return $this->RegAction;
    }
    /**
     * Set RegAction value
     * @uses \EnumType\RegistrationAction::valueIsValid()
     * @uses \EnumType\RegistrationAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regAction
     * @return \StructType\SimpleEventRegistration
     */
    public function setRegAction($regAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegistrationAction::valueIsValid($regAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RegistrationAction', is_array($regAction) ? implode(', ', $regAction) : var_export($regAction, true), implode(', ', \EnumType\RegistrationAction::getValidValues())), __LINE__);
        }
        $this->RegAction = $regAction;
        return $this;
    }
    /**
     * Get CvObjects value
     * @return \ArrayType\ArrayOfCvObject|null
     */
    public function getCvObjects()
    {
        return $this->CvObjects;
    }
    /**
     * Set CvObjects value
     * @param \ArrayType\ArrayOfCvObject $cvObjects
     * @return \StructType\SimpleEventRegistration
     */
    public function setCvObjects(\ArrayType\ArrayOfCvObject $cvObjects = null)
    {
        $this->CvObjects = $cvObjects;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\SimpleEventRegistration
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get AdmissionItemID value
     * @return string|null
     */
    public function getAdmissionItemID()
    {
        return $this->AdmissionItemID;
    }
    /**
     * Set AdmissionItemID value
     * @param string $admissionItemID
     * @return \StructType\SimpleEventRegistration
     */
    public function setAdmissionItemID($admissionItemID = null)
    {
        // validation for constraint: string
        if (!is_null($admissionItemID) && !is_string($admissionItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($admissionItemID, true), gettype($admissionItemID)), __LINE__);
        }
        $this->AdmissionItemID = $admissionItemID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SimpleEventRegistration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
