<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SessionRegInvitee StructType
 * @subpackage Structs
 */
class SessionRegInvitee extends CvObject
{
    /**
     * The SessionRegActionType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SessionRegActionType;
    /**
     * The CvInvitee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CvInvitee[]
     */
    public $CvInvitee;
    /**
     * The ProductId
     * @var string
     */
    public $ProductId;
    /**
     * Constructor method for SessionRegInvitee
     * @uses SessionRegInvitee::setSessionRegActionType()
     * @uses SessionRegInvitee::setCvInvitee()
     * @uses SessionRegInvitee::setProductId()
     * @param string $sessionRegActionType
     * @param \StructType\CvInvitee[] $cvInvitee
     * @param string $productId
     */
    public function __construct($sessionRegActionType = null, array $cvInvitee = array(), $productId = null)
    {
        $this
            ->setSessionRegActionType($sessionRegActionType)
            ->setCvInvitee($cvInvitee)
            ->setProductId($productId);
    }
    /**
     * Get SessionRegActionType value
     * @return string
     */
    public function getSessionRegActionType()
    {
        return $this->SessionRegActionType;
    }
    /**
     * Set SessionRegActionType value
     * @uses \EnumType\SessionRegActionType::valueIsValid()
     * @uses \EnumType\SessionRegActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sessionRegActionType
     * @return \StructType\SessionRegInvitee
     */
    public function setSessionRegActionType($sessionRegActionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SessionRegActionType::valueIsValid($sessionRegActionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SessionRegActionType', is_array($sessionRegActionType) ? implode(', ', $sessionRegActionType) : var_export($sessionRegActionType, true), implode(', ', \EnumType\SessionRegActionType::getValidValues())), __LINE__);
        }
        $this->SessionRegActionType = $sessionRegActionType;
        return $this;
    }
    /**
     * Get CvInvitee value
     * @return \StructType\CvInvitee[]|null
     */
    public function getCvInvitee()
    {
        return $this->CvInvitee;
    }
    /**
     * This method is responsible for validating the values passed to the setCvInvitee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCvInvitee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCvInviteeForArrayConstraintsFromSetCvInvitee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sessionRegInviteeCvInviteeItem) {
            // validation for constraint: itemType
            if (!$sessionRegInviteeCvInviteeItem instanceof \StructType\CvInvitee) {
                $invalidValues[] = is_object($sessionRegInviteeCvInviteeItem) ? get_class($sessionRegInviteeCvInviteeItem) : sprintf('%s(%s)', gettype($sessionRegInviteeCvInviteeItem), var_export($sessionRegInviteeCvInviteeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CvInvitee property can only contain items of type \StructType\CvInvitee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CvInvitee value
     * @throws \InvalidArgumentException
     * @param \StructType\CvInvitee[] $cvInvitee
     * @return \StructType\SessionRegInvitee
     */
    public function setCvInvitee(array $cvInvitee = array())
    {
        // validation for constraint: array
        if ('' !== ($cvInviteeArrayErrorMessage = self::validateCvInviteeForArrayConstraintsFromSetCvInvitee($cvInvitee))) {
            throw new \InvalidArgumentException($cvInviteeArrayErrorMessage, __LINE__);
        }
        $this->CvInvitee = $cvInvitee;
        return $this;
    }
    /**
     * Add item to CvInvitee value
     * @throws \InvalidArgumentException
     * @param \StructType\CvInvitee $item
     * @return \StructType\SessionRegInvitee
     */
    public function addToCvInvitee(\StructType\CvInvitee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CvInvitee) {
            throw new \InvalidArgumentException(sprintf('The CvInvitee property can only contain items of type \StructType\CvInvitee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CvInvitee[] = $item;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \StructType\SessionRegInvitee
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SessionRegInvitee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
