<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Session StructType
 * @subpackage Structs
 */
class Session extends CvObject
{
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The ProductName
     * @var string
     */
    public $ProductName;
    /**
     * The ProductCode
     * @var string
     */
    public $ProductCode;
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * @var string
     */
    public $EndTime;
    /**
     * The DataTagCode
     * @var string
     */
    public $DataTagCode;
    /**
     * The ProductDescription
     * @var string
     */
    public $ProductDescription;
    /**
     * The SessionLocationName
     * @var string
     */
    public $SessionLocationName;
    /**
     * The SessionLocationCode
     * @var string
     */
    public $SessionLocationCode;
    /**
     * The RegistrantInformation
     * @var string
     */
    public $RegistrantInformation;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The AutoCloseDate
     * @var string
     */
    public $AutoCloseDate;
    /**
     * The Capacity
     * @var int
     */
    public $Capacity;
    /**
     * The EnableWaitlist
     * @var bool
     */
    public $EnableWaitlist;
    /**
     * The WaitlistCapacity
     * @var int
     */
    public $WaitlistCapacity;
    /**
     * Constructor method for Session
     * @uses Session::setCustomFieldDetail()
     * @uses Session::setEventId()
     * @uses Session::setProductName()
     * @uses Session::setProductCode()
     * @uses Session::setProductType()
     * @uses Session::setStartTime()
     * @uses Session::setEndTime()
     * @uses Session::setDataTagCode()
     * @uses Session::setProductDescription()
     * @uses Session::setSessionLocationName()
     * @uses Session::setSessionLocationCode()
     * @uses Session::setRegistrantInformation()
     * @uses Session::setStatus()
     * @uses Session::setAutoCloseDate()
     * @uses Session::setCapacity()
     * @uses Session::setEnableWaitlist()
     * @uses Session::setWaitlistCapacity()
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param string $eventId
     * @param string $productName
     * @param string $productCode
     * @param string $productType
     * @param string $startTime
     * @param string $endTime
     * @param string $dataTagCode
     * @param string $productDescription
     * @param string $sessionLocationName
     * @param string $sessionLocationCode
     * @param string $registrantInformation
     * @param string $status
     * @param string $autoCloseDate
     * @param int $capacity
     * @param bool $enableWaitlist
     * @param int $waitlistCapacity
     */
    public function __construct(array $customFieldDetail = array(), $eventId = null, $productName = null, $productCode = null, $productType = null, $startTime = null, $endTime = null, $dataTagCode = null, $productDescription = null, $sessionLocationName = null, $sessionLocationCode = null, $registrantInformation = null, $status = null, $autoCloseDate = null, $capacity = null, $enableWaitlist = null, $waitlistCapacity = null)
    {
        $this
            ->setCustomFieldDetail($customFieldDetail)
            ->setEventId($eventId)
            ->setProductName($productName)
            ->setProductCode($productCode)
            ->setProductType($productType)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setDataTagCode($dataTagCode)
            ->setProductDescription($productDescription)
            ->setSessionLocationName($sessionLocationName)
            ->setSessionLocationCode($sessionLocationCode)
            ->setRegistrantInformation($registrantInformation)
            ->setStatus($status)
            ->setAutoCloseDate($autoCloseDate)
            ->setCapacity($capacity)
            ->setEnableWaitlist($enableWaitlist)
            ->setWaitlistCapacity($waitlistCapacity);
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sessionCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$sessionCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($sessionCustomFieldDetailItem) ? get_class($sessionCustomFieldDetailItem) : sprintf('%s(%s)', gettype($sessionCustomFieldDetailItem), var_export($sessionCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\Session
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\Session
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\Session
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\Session
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\Session
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\Session
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\Session
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\Session
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get DataTagCode value
     * @return string|null
     */
    public function getDataTagCode()
    {
        return $this->DataTagCode;
    }
    /**
     * Set DataTagCode value
     * @param string $dataTagCode
     * @return \StructType\Session
     */
    public function setDataTagCode($dataTagCode = null)
    {
        // validation for constraint: string
        if (!is_null($dataTagCode) && !is_string($dataTagCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTagCode, true), gettype($dataTagCode)), __LINE__);
        }
        $this->DataTagCode = $dataTagCode;
        return $this;
    }
    /**
     * Get ProductDescription value
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->ProductDescription;
    }
    /**
     * Set ProductDescription value
     * @param string $productDescription
     * @return \StructType\Session
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productDescription, true), gettype($productDescription)), __LINE__);
        }
        $this->ProductDescription = $productDescription;
        return $this;
    }
    /**
     * Get SessionLocationName value
     * @return string|null
     */
    public function getSessionLocationName()
    {
        return $this->SessionLocationName;
    }
    /**
     * Set SessionLocationName value
     * @param string $sessionLocationName
     * @return \StructType\Session
     */
    public function setSessionLocationName($sessionLocationName = null)
    {
        // validation for constraint: string
        if (!is_null($sessionLocationName) && !is_string($sessionLocationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionLocationName, true), gettype($sessionLocationName)), __LINE__);
        }
        $this->SessionLocationName = $sessionLocationName;
        return $this;
    }
    /**
     * Get SessionLocationCode value
     * @return string|null
     */
    public function getSessionLocationCode()
    {
        return $this->SessionLocationCode;
    }
    /**
     * Set SessionLocationCode value
     * @param string $sessionLocationCode
     * @return \StructType\Session
     */
    public function setSessionLocationCode($sessionLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($sessionLocationCode) && !is_string($sessionLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionLocationCode, true), gettype($sessionLocationCode)), __LINE__);
        }
        $this->SessionLocationCode = $sessionLocationCode;
        return $this;
    }
    /**
     * Get RegistrantInformation value
     * @return string|null
     */
    public function getRegistrantInformation()
    {
        return $this->RegistrantInformation;
    }
    /**
     * Set RegistrantInformation value
     * @param string $registrantInformation
     * @return \StructType\Session
     */
    public function setRegistrantInformation($registrantInformation = null)
    {
        // validation for constraint: string
        if (!is_null($registrantInformation) && !is_string($registrantInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrantInformation, true), gettype($registrantInformation)), __LINE__);
        }
        $this->RegistrantInformation = $registrantInformation;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ProductStatus::valueIsValid()
     * @uses \EnumType\ProductStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Session
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ProductStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get AutoCloseDate value
     * @return string|null
     */
    public function getAutoCloseDate()
    {
        return $this->AutoCloseDate;
    }
    /**
     * Set AutoCloseDate value
     * @param string $autoCloseDate
     * @return \StructType\Session
     */
    public function setAutoCloseDate($autoCloseDate = null)
    {
        // validation for constraint: string
        if (!is_null($autoCloseDate) && !is_string($autoCloseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoCloseDate, true), gettype($autoCloseDate)), __LINE__);
        }
        $this->AutoCloseDate = $autoCloseDate;
        return $this;
    }
    /**
     * Get Capacity value
     * @return int|null
     */
    public function getCapacity()
    {
        return $this->Capacity;
    }
    /**
     * Set Capacity value
     * @param int $capacity
     * @return \StructType\Session
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        $this->Capacity = $capacity;
        return $this;
    }
    /**
     * Get EnableWaitlist value
     * @return bool|null
     */
    public function getEnableWaitlist()
    {
        return $this->EnableWaitlist;
    }
    /**
     * Set EnableWaitlist value
     * @param bool $enableWaitlist
     * @return \StructType\Session
     */
    public function setEnableWaitlist($enableWaitlist = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableWaitlist) && !is_bool($enableWaitlist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableWaitlist, true), gettype($enableWaitlist)), __LINE__);
        }
        $this->EnableWaitlist = $enableWaitlist;
        return $this;
    }
    /**
     * Get WaitlistCapacity value
     * @return int|null
     */
    public function getWaitlistCapacity()
    {
        return $this->WaitlistCapacity;
    }
    /**
     * Set WaitlistCapacity value
     * @param int $waitlistCapacity
     * @return \StructType\Session
     */
    public function setWaitlistCapacity($waitlistCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($waitlistCapacity) && !(is_int($waitlistCapacity) || ctype_digit($waitlistCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitlistCapacity, true), gettype($waitlistCapacity)), __LINE__);
        }
        $this->WaitlistCapacity = $waitlistCapacity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Session
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
