<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendEmailRequest StructType
 * @subpackage Structs
 */
class SendEmailRequest extends AbstractStructBase
{
    /**
     * The ActivityType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ActivityType;
    /**
     * The EmailTemplateName
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $EmailTemplateName;
    /**
     * The ResendToPreviousRecipients
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ResendToPreviousRecipients;
    /**
     * The RecipientId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCvObject
     */
    public $RecipientId;
    /**
     * The ActivityId
     * @var string
     */
    public $ActivityId;
    /**
     * The EmailName
     * @var string
     */
    public $EmailName;
    /**
     * Constructor method for SendEmailRequest
     * @uses SendEmailRequest::setActivityType()
     * @uses SendEmailRequest::setEmailTemplateName()
     * @uses SendEmailRequest::setResendToPreviousRecipients()
     * @uses SendEmailRequest::setRecipientId()
     * @uses SendEmailRequest::setActivityId()
     * @uses SendEmailRequest::setEmailName()
     * @param string $activityType
     * @param string $emailTemplateName
     * @param bool $resendToPreviousRecipients
     * @param \ArrayType\ArrayOfCvObject $recipientId
     * @param string $activityId
     * @param string $emailName
     */
    public function __construct($activityType = null, $emailTemplateName = null, $resendToPreviousRecipients = null, \ArrayType\ArrayOfCvObject $recipientId = null, $activityId = null, $emailName = null)
    {
        $this
            ->setActivityType($activityType)
            ->setEmailTemplateName($emailTemplateName)
            ->setResendToPreviousRecipients($resendToPreviousRecipients)
            ->setRecipientId($recipientId)
            ->setActivityId($activityId)
            ->setEmailName($emailName);
    }
    /**
     * Get ActivityType value
     * @return string
     */
    public function getActivityType()
    {
        return $this->ActivityType;
    }
    /**
     * Set ActivityType value
     * @uses \EnumType\ActivityType::valueIsValid()
     * @uses \EnumType\ActivityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityType
     * @return \StructType\SendEmailRequest
     */
    public function setActivityType($activityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivityType::valueIsValid($activityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActivityType', is_array($activityType) ? implode(', ', $activityType) : var_export($activityType, true), implode(', ', \EnumType\ActivityType::getValidValues())), __LINE__);
        }
        $this->ActivityType = $activityType;
        return $this;
    }
    /**
     * Get EmailTemplateName value
     * @return string
     */
    public function getEmailTemplateName()
    {
        return $this->EmailTemplateName;
    }
    /**
     * Set EmailTemplateName value
     * @uses \EnumType\EmailTemplate::valueIsValid()
     * @uses \EnumType\EmailTemplate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emailTemplateName
     * @return \StructType\SendEmailRequest
     */
    public function setEmailTemplateName($emailTemplateName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmailTemplate::valueIsValid($emailTemplateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmailTemplate', is_array($emailTemplateName) ? implode(', ', $emailTemplateName) : var_export($emailTemplateName, true), implode(', ', \EnumType\EmailTemplate::getValidValues())), __LINE__);
        }
        $this->EmailTemplateName = $emailTemplateName;
        return $this;
    }
    /**
     * Get ResendToPreviousRecipients value
     * @return bool
     */
    public function getResendToPreviousRecipients()
    {
        return $this->ResendToPreviousRecipients;
    }
    /**
     * Set ResendToPreviousRecipients value
     * @param bool $resendToPreviousRecipients
     * @return \StructType\SendEmailRequest
     */
    public function setResendToPreviousRecipients($resendToPreviousRecipients = null)
    {
        // validation for constraint: boolean
        if (!is_null($resendToPreviousRecipients) && !is_bool($resendToPreviousRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resendToPreviousRecipients, true), gettype($resendToPreviousRecipients)), __LINE__);
        }
        $this->ResendToPreviousRecipients = $resendToPreviousRecipients;
        return $this;
    }
    /**
     * Get RecipientId value
     * @return \ArrayType\ArrayOfCvObject|null
     */
    public function getRecipientId()
    {
        return $this->RecipientId;
    }
    /**
     * Set RecipientId value
     * @param \ArrayType\ArrayOfCvObject $recipientId
     * @return \StructType\SendEmailRequest
     */
    public function setRecipientId(\ArrayType\ArrayOfCvObject $recipientId = null)
    {
        $this->RecipientId = $recipientId;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return \StructType\SendEmailRequest
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get EmailName value
     * @return string|null
     */
    public function getEmailName()
    {
        return $this->EmailName;
    }
    /**
     * Set EmailName value
     * @param string $emailName
     * @return \StructType\SendEmailRequest
     */
    public function setEmailName($emailName = null)
    {
        // validation for constraint: string
        if (!is_null($emailName) && !is_string($emailName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailName, true), gettype($emailName)), __LINE__);
        }
        $this->EmailName = $emailName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendEmailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
