<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Search StructType
 * @subpackage Structs
 */
class Search extends AbstractStructBase
{
    /**
     * The ObjectType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ObjectType;
    /**
     * The CvSearchObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s1:CvSearchObject
     * @var \StructType\CvSearch
     */
    public $CvSearchObject;
    /**
     * Constructor method for Search
     * @uses Search::setObjectType()
     * @uses Search::setCvSearchObject()
     * @param string $objectType
     * @param \StructType\CvSearch $cvSearchObject
     */
    public function __construct($objectType = null, \StructType\CvSearch $cvSearchObject = null)
    {
        $this
            ->setObjectType($objectType)
            ->setCvSearchObject($cvSearchObject);
    }
    /**
     * Get ObjectType value
     * @return string
     */
    public function getObjectType()
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @uses \EnumType\CvObjectType::valueIsValid()
     * @uses \EnumType\CvObjectType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $objectType
     * @return \StructType\Search
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CvObjectType::valueIsValid($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvObjectType', is_array($objectType) ? implode(', ', $objectType) : var_export($objectType, true), implode(', ', \EnumType\CvObjectType::getValidValues())), __LINE__);
        }
        $this->ObjectType = $objectType;
        return $this;
    }
    /**
     * Get CvSearchObject value
     * @return \StructType\CvSearch|null
     */
    public function getCvSearchObject()
    {
        return $this->CvSearchObject;
    }
    /**
     * Set CvSearchObject value
     * @param \StructType\CvSearch $cvSearchObject
     * @return \StructType\Search
     */
    public function setCvSearchObject(\StructType\CvSearch $cvSearchObject = null)
    {
        $this->CvSearchObject = $cvSearchObject;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Search
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
