<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SavingsDetail StructType
 * @subpackage Structs
 */
class SavingsDetail extends AbstractStructBase
{
    /**
     * The SavingsDetailId
     * @var string
     */
    public $SavingsDetailId;
    /**
     * The SavingsName
     * @var string
     */
    public $SavingsName;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for SavingsDetail
     * @uses SavingsDetail::setSavingsDetailId()
     * @uses SavingsDetail::setSavingsName()
     * @uses SavingsDetail::setAmount()
     * @param string $savingsDetailId
     * @param string $savingsName
     * @param float $amount
     */
    public function __construct($savingsDetailId = null, $savingsName = null, $amount = null)
    {
        $this
            ->setSavingsDetailId($savingsDetailId)
            ->setSavingsName($savingsName)
            ->setAmount($amount);
    }
    /**
     * Get SavingsDetailId value
     * @return string|null
     */
    public function getSavingsDetailId()
    {
        return $this->SavingsDetailId;
    }
    /**
     * Set SavingsDetailId value
     * @param string $savingsDetailId
     * @return \StructType\SavingsDetail
     */
    public function setSavingsDetailId($savingsDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($savingsDetailId) && !is_string($savingsDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savingsDetailId, true), gettype($savingsDetailId)), __LINE__);
        }
        $this->SavingsDetailId = $savingsDetailId;
        return $this;
    }
    /**
     * Get SavingsName value
     * @return string|null
     */
    public function getSavingsName()
    {
        return $this->SavingsName;
    }
    /**
     * Set SavingsName value
     * @param string $savingsName
     * @return \StructType\SavingsDetail
     */
    public function setSavingsName($savingsName = null)
    {
        // validation for constraint: string
        if (!is_null($savingsName) && !is_string($savingsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savingsName, true), gettype($savingsName)), __LINE__);
        }
        $this->SavingsName = $savingsName;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SavingsDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SavingsDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
