<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RowDetail StructType
 * @subpackage Structs
 */
class RowDetail extends AbstractStructBase
{
    /**
     * The RowText
     * @var string
     */
    public $RowText;
    /**
     * Constructor method for RowDetail
     * @uses RowDetail::setRowText()
     * @param string $rowText
     */
    public function __construct($rowText = null)
    {
        $this
            ->setRowText($rowText);
    }
    /**
     * Get RowText value
     * @return string|null
     */
    public function getRowText()
    {
        return $this->RowText;
    }
    /**
     * Set RowText value
     * @param string $rowText
     * @return \StructType\RowDetail
     */
    public function setRowText($rowText = null)
    {
        // validation for constraint: string
        if (!is_null($rowText) && !is_string($rowText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowText, true), gettype($rowText)), __LINE__);
        }
        $this->RowText = $rowText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RowDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
