<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Retrieve StructType
 * @subpackage Structs
 */
class Retrieve extends AbstractStructBase
{
    /**
     * The ObjectType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ObjectType;
    /**
     * The Ids
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s1:Ids
     * @var \ArrayType\IdArray
     */
    public $Ids;
    /**
     * Constructor method for Retrieve
     * @uses Retrieve::setObjectType()
     * @uses Retrieve::setIds()
     * @param string $objectType
     * @param \ArrayType\IdArray $ids
     */
    public function __construct($objectType = null, \ArrayType\IdArray $ids = null)
    {
        $this
            ->setObjectType($objectType)
            ->setIds($ids);
    }
    /**
     * Get ObjectType value
     * @return string
     */
    public function getObjectType()
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @uses \EnumType\CvObjectType::valueIsValid()
     * @uses \EnumType\CvObjectType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $objectType
     * @return \StructType\Retrieve
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CvObjectType::valueIsValid($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvObjectType', is_array($objectType) ? implode(', ', $objectType) : var_export($objectType, true), implode(', ', \EnumType\CvObjectType::getValidValues())), __LINE__);
        }
        $this->ObjectType = $objectType;
        return $this;
    }
    /**
     * Get Ids value
     * @return \ArrayType\IdArray|null
     */
    public function getIds()
    {
        return $this->Ids;
    }
    /**
     * Set Ids value
     * @param \ArrayType\IdArray $ids
     * @return \StructType\Retrieve
     */
    public function setIds(\ArrayType\IdArray $ids = null)
    {
        $this->Ids = $ids;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Retrieve
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
