<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseSurveyDetail StructType
 * @subpackage Structs
 */
class ResponseSurveyDetail extends SurveyDetail
{
    /**
     * The QuestionCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuestionCode;
    /**
     * The QuestionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuestionNumber;
    /**
     * Constructor method for ResponseSurveyDetail
     * @uses ResponseSurveyDetail::setQuestionCode()
     * @uses ResponseSurveyDetail::setQuestionNumber()
     * @param string $questionCode
     * @param string $questionNumber
     */
    public function __construct($questionCode = null, $questionNumber = null)
    {
        $this
            ->setQuestionCode($questionCode)
            ->setQuestionNumber($questionNumber);
    }
    /**
     * Get QuestionCode value
     * @return string|null
     */
    public function getQuestionCode()
    {
        return $this->QuestionCode;
    }
    /**
     * Set QuestionCode value
     * @param string $questionCode
     * @return \StructType\ResponseSurveyDetail
     */
    public function setQuestionCode($questionCode = null)
    {
        // validation for constraint: string
        if (!is_null($questionCode) && !is_string($questionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionCode, true), gettype($questionCode)), __LINE__);
        }
        $this->QuestionCode = $questionCode;
        return $this;
    }
    /**
     * Get QuestionNumber value
     * @return string|null
     */
    public function getQuestionNumber()
    {
        return $this->QuestionNumber;
    }
    /**
     * Set QuestionNumber value
     * @param string $questionNumber
     * @return \StructType\ResponseSurveyDetail
     */
    public function setQuestionNumber($questionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($questionNumber) && !is_string($questionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionNumber, true), gettype($questionNumber)), __LINE__);
        }
        $this->QuestionNumber = $questionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseSurveyDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
