<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * @subpackage Structs
 */
class Response extends CvObject
{
    /**
     * The SurveyDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ResponseSurveyDetail[]
     */
    public $SurveyDetail;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * The ResponseID
     * @var string
     */
    public $ResponseID;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The WorkPhone
     * @var string
     */
    public $WorkPhone;
    /**
     * The SurveyId
     * @var string
     */
    public $SurveyId;
    /**
     * The SurveyCode
     * @var string
     */
    public $SurveyCode;
    /**
     * The SurveyTitle
     * @var string
     */
    public $SurveyTitle;
    /**
     * The SurveyLaunchDate
     * @var string
     */
    public $SurveyLaunchDate;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The ReferenceId
     * @var string
     */
    public $ReferenceId;
    /**
     * The InvitedBy
     * @var string
     */
    public $InvitedBy;
    /**
     * The CompletionDate
     * @var string
     */
    public $CompletionDate;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The ModifiedBy
     * @var string
     */
    public $ModifiedBy;
    /**
     * The ResponseMethod
     * @var string
     */
    public $ResponseMethod;
    /**
     * The ResponseNumber
     * @var int
     */
    public $ResponseNumber;
    /**
     * Constructor method for Response
     * @uses Response::setSurveyDetail()
     * @uses Response::setContactId()
     * @uses Response::setSourceId()
     * @uses Response::setResponseID()
     * @uses Response::setFirstName()
     * @uses Response::setLastName()
     * @uses Response::setCompany()
     * @uses Response::setTitle()
     * @uses Response::setEmailAddress()
     * @uses Response::setWorkPhone()
     * @uses Response::setSurveyId()
     * @uses Response::setSurveyCode()
     * @uses Response::setSurveyTitle()
     * @uses Response::setSurveyLaunchDate()
     * @uses Response::setStatus()
     * @uses Response::setInternalNote()
     * @uses Response::setReferenceId()
     * @uses Response::setInvitedBy()
     * @uses Response::setCompletionDate()
     * @uses Response::setLastModifiedDate()
     * @uses Response::setModifiedBy()
     * @uses Response::setResponseMethod()
     * @uses Response::setResponseNumber()
     * @param \StructType\ResponseSurveyDetail[] $surveyDetail
     * @param string $contactId
     * @param string $sourceId
     * @param string $responseID
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $title
     * @param string $emailAddress
     * @param string $workPhone
     * @param string $surveyId
     * @param string $surveyCode
     * @param string $surveyTitle
     * @param string $surveyLaunchDate
     * @param string $status
     * @param string $internalNote
     * @param string $referenceId
     * @param string $invitedBy
     * @param string $completionDate
     * @param string $lastModifiedDate
     * @param string $modifiedBy
     * @param string $responseMethod
     * @param int $responseNumber
     */
    public function __construct(array $surveyDetail = array(), $contactId = null, $sourceId = null, $responseID = null, $firstName = null, $lastName = null, $company = null, $title = null, $emailAddress = null, $workPhone = null, $surveyId = null, $surveyCode = null, $surveyTitle = null, $surveyLaunchDate = null, $status = null, $internalNote = null, $referenceId = null, $invitedBy = null, $completionDate = null, $lastModifiedDate = null, $modifiedBy = null, $responseMethod = null, $responseNumber = null)
    {
        $this
            ->setSurveyDetail($surveyDetail)
            ->setContactId($contactId)
            ->setSourceId($sourceId)
            ->setResponseID($responseID)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setTitle($title)
            ->setEmailAddress($emailAddress)
            ->setWorkPhone($workPhone)
            ->setSurveyId($surveyId)
            ->setSurveyCode($surveyCode)
            ->setSurveyTitle($surveyTitle)
            ->setSurveyLaunchDate($surveyLaunchDate)
            ->setStatus($status)
            ->setInternalNote($internalNote)
            ->setReferenceId($referenceId)
            ->setInvitedBy($invitedBy)
            ->setCompletionDate($completionDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setModifiedBy($modifiedBy)
            ->setResponseMethod($responseMethod)
            ->setResponseNumber($responseNumber);
    }
    /**
     * Get SurveyDetail value
     * @return \StructType\ResponseSurveyDetail[]|null
     */
    public function getSurveyDetail()
    {
        return $this->SurveyDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSurveyDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurveyDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSurveyDetailForArrayConstraintsFromSetSurveyDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseSurveyDetailItem) {
            // validation for constraint: itemType
            if (!$responseSurveyDetailItem instanceof \StructType\ResponseSurveyDetail) {
                $invalidValues[] = is_object($responseSurveyDetailItem) ? get_class($responseSurveyDetailItem) : sprintf('%s(%s)', gettype($responseSurveyDetailItem), var_export($responseSurveyDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SurveyDetail property can only contain items of type \StructType\ResponseSurveyDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ResponseSurveyDetail[] $surveyDetail
     * @return \StructType\Response
     */
    public function setSurveyDetail(array $surveyDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($surveyDetailArrayErrorMessage = self::validateSurveyDetailForArrayConstraintsFromSetSurveyDetail($surveyDetail))) {
            throw new \InvalidArgumentException($surveyDetailArrayErrorMessage, __LINE__);
        }
        $this->SurveyDetail = $surveyDetail;
        return $this;
    }
    /**
     * Add item to SurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ResponseSurveyDetail $item
     * @return \StructType\Response
     */
    public function addToSurveyDetail(\StructType\ResponseSurveyDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResponseSurveyDetail) {
            throw new \InvalidArgumentException(sprintf('The SurveyDetail property can only contain items of type \StructType\ResponseSurveyDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SurveyDetail[] = $item;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\Response
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\Response
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get ResponseID value
     * @return string|null
     */
    public function getResponseID()
    {
        return $this->ResponseID;
    }
    /**
     * Set ResponseID value
     * @param string $responseID
     * @return \StructType\Response
     */
    public function setResponseID($responseID = null)
    {
        // validation for constraint: string
        if (!is_null($responseID) && !is_string($responseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseID, true), gettype($responseID)), __LINE__);
        }
        $this->ResponseID = $responseID;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Response
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Response
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\Response
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Response
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\Response
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\Response
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get SurveyId value
     * @return string|null
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param string $surveyId
     * @return \StructType\Response
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: string
        if (!is_null($surveyId) && !is_string($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyId, true), gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get SurveyCode value
     * @return string|null
     */
    public function getSurveyCode()
    {
        return $this->SurveyCode;
    }
    /**
     * Set SurveyCode value
     * @param string $surveyCode
     * @return \StructType\Response
     */
    public function setSurveyCode($surveyCode = null)
    {
        // validation for constraint: string
        if (!is_null($surveyCode) && !is_string($surveyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyCode, true), gettype($surveyCode)), __LINE__);
        }
        $this->SurveyCode = $surveyCode;
        return $this;
    }
    /**
     * Get SurveyTitle value
     * @return string|null
     */
    public function getSurveyTitle()
    {
        return $this->SurveyTitle;
    }
    /**
     * Set SurveyTitle value
     * @param string $surveyTitle
     * @return \StructType\Response
     */
    public function setSurveyTitle($surveyTitle = null)
    {
        // validation for constraint: string
        if (!is_null($surveyTitle) && !is_string($surveyTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyTitle, true), gettype($surveyTitle)), __LINE__);
        }
        $this->SurveyTitle = $surveyTitle;
        return $this;
    }
    /**
     * Get SurveyLaunchDate value
     * @return string|null
     */
    public function getSurveyLaunchDate()
    {
        return $this->SurveyLaunchDate;
    }
    /**
     * Set SurveyLaunchDate value
     * @param string $surveyLaunchDate
     * @return \StructType\Response
     */
    public function setSurveyLaunchDate($surveyLaunchDate = null)
    {
        // validation for constraint: string
        if (!is_null($surveyLaunchDate) && !is_string($surveyLaunchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyLaunchDate, true), gettype($surveyLaunchDate)), __LINE__);
        }
        $this->SurveyLaunchDate = $surveyLaunchDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Response
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\Response
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\Response
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Get InvitedBy value
     * @return string|null
     */
    public function getInvitedBy()
    {
        return $this->InvitedBy;
    }
    /**
     * Set InvitedBy value
     * @param string $invitedBy
     * @return \StructType\Response
     */
    public function setInvitedBy($invitedBy = null)
    {
        // validation for constraint: string
        if (!is_null($invitedBy) && !is_string($invitedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invitedBy, true), gettype($invitedBy)), __LINE__);
        }
        $this->InvitedBy = $invitedBy;
        return $this;
    }
    /**
     * Get CompletionDate value
     * @return string|null
     */
    public function getCompletionDate()
    {
        return $this->CompletionDate;
    }
    /**
     * Set CompletionDate value
     * @param string $completionDate
     * @return \StructType\Response
     */
    public function setCompletionDate($completionDate = null)
    {
        // validation for constraint: string
        if (!is_null($completionDate) && !is_string($completionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completionDate, true), gettype($completionDate)), __LINE__);
        }
        $this->CompletionDate = $completionDate;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Response
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return string|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param string $modifiedBy
     * @return \StructType\Response
     */
    public function setModifiedBy($modifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedBy) && !is_string($modifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedBy, true), gettype($modifiedBy)), __LINE__);
        }
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Get ResponseMethod value
     * @return string|null
     */
    public function getResponseMethod()
    {
        return $this->ResponseMethod;
    }
    /**
     * Set ResponseMethod value
     * @param string $responseMethod
     * @return \StructType\Response
     */
    public function setResponseMethod($responseMethod = null)
    {
        // validation for constraint: string
        if (!is_null($responseMethod) && !is_string($responseMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMethod, true), gettype($responseMethod)), __LINE__);
        }
        $this->ResponseMethod = $responseMethod;
        return $this;
    }
    /**
     * Get ResponseNumber value
     * @return int|null
     */
    public function getResponseNumber()
    {
        return $this->ResponseNumber;
    }
    /**
     * Set ResponseNumber value
     * @param int $responseNumber
     * @return \StructType\Response
     */
    public function setResponseNumber($responseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($responseNumber) && !(is_int($responseNumber) || ctype_digit($responseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($responseNumber, true), gettype($responseNumber)), __LINE__);
        }
        $this->ResponseNumber = $responseNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
