<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Respondent StructType
 * @subpackage Structs
 */
class Respondent extends CvObject
{
    /**
     * The WeblinkDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WeblinkDetail[]
     */
    public $WeblinkDetail;
    /**
     * The TargetedListId
     * @var string
     */
    public $TargetedListId;
    /**
     * The TargetedListName
     * @var string
     */
    public $TargetedListName;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * The ResponseID
     * @var string
     */
    public $ResponseID;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The WorkPhone
     * @var string
     */
    public $WorkPhone;
    /**
     * The SurveyId
     * @var string
     */
    public $SurveyId;
    /**
     * The SurveyCode
     * @var string
     */
    public $SurveyCode;
    /**
     * The SurveyTitle
     * @var string
     */
    public $SurveyTitle;
    /**
     * The SurveyLaunchDate
     * @var string
     */
    public $SurveyLaunchDate;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The ReferenceId
     * @var string
     */
    public $ReferenceId;
    /**
     * The ResponseScore
     * @var float
     */
    public $ResponseScore;
    /**
     * Constructor method for Respondent
     * @uses Respondent::setWeblinkDetail()
     * @uses Respondent::setTargetedListId()
     * @uses Respondent::setTargetedListName()
     * @uses Respondent::setContactId()
     * @uses Respondent::setSourceId()
     * @uses Respondent::setResponseID()
     * @uses Respondent::setFirstName()
     * @uses Respondent::setLastName()
     * @uses Respondent::setCompany()
     * @uses Respondent::setTitle()
     * @uses Respondent::setEmailAddress()
     * @uses Respondent::setWorkPhone()
     * @uses Respondent::setSurveyId()
     * @uses Respondent::setSurveyCode()
     * @uses Respondent::setSurveyTitle()
     * @uses Respondent::setSurveyLaunchDate()
     * @uses Respondent::setStatus()
     * @uses Respondent::setInternalNote()
     * @uses Respondent::setReferenceId()
     * @uses Respondent::setResponseScore()
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @param string $targetedListId
     * @param string $targetedListName
     * @param string $contactId
     * @param string $sourceId
     * @param string $responseID
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $title
     * @param string $emailAddress
     * @param string $workPhone
     * @param string $surveyId
     * @param string $surveyCode
     * @param string $surveyTitle
     * @param string $surveyLaunchDate
     * @param string $status
     * @param string $internalNote
     * @param string $referenceId
     * @param float $responseScore
     */
    public function __construct(array $weblinkDetail = array(), $targetedListId = null, $targetedListName = null, $contactId = null, $sourceId = null, $responseID = null, $firstName = null, $lastName = null, $company = null, $title = null, $emailAddress = null, $workPhone = null, $surveyId = null, $surveyCode = null, $surveyTitle = null, $surveyLaunchDate = null, $status = null, $internalNote = null, $referenceId = null, $responseScore = null)
    {
        $this
            ->setWeblinkDetail($weblinkDetail)
            ->setTargetedListId($targetedListId)
            ->setTargetedListName($targetedListName)
            ->setContactId($contactId)
            ->setSourceId($sourceId)
            ->setResponseID($responseID)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setTitle($title)
            ->setEmailAddress($emailAddress)
            ->setWorkPhone($workPhone)
            ->setSurveyId($surveyId)
            ->setSurveyCode($surveyCode)
            ->setSurveyTitle($surveyTitle)
            ->setSurveyLaunchDate($surveyLaunchDate)
            ->setStatus($status)
            ->setInternalNote($internalNote)
            ->setReferenceId($referenceId)
            ->setResponseScore($responseScore);
    }
    /**
     * Get WeblinkDetail value
     * @return \StructType\WeblinkDetail[]|null
     */
    public function getWeblinkDetail()
    {
        return $this->WeblinkDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setWeblinkDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeblinkDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $respondentWeblinkDetailItem) {
            // validation for constraint: itemType
            if (!$respondentWeblinkDetailItem instanceof \StructType\WeblinkDetail) {
                $invalidValues[] = is_object($respondentWeblinkDetailItem) ? get_class($respondentWeblinkDetailItem) : sprintf('%s(%s)', gettype($respondentWeblinkDetailItem), var_export($respondentWeblinkDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @return \StructType\Respondent
     */
    public function setWeblinkDetail(array $weblinkDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($weblinkDetailArrayErrorMessage = self::validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail($weblinkDetail))) {
            throw new \InvalidArgumentException($weblinkDetailArrayErrorMessage, __LINE__);
        }
        $this->WeblinkDetail = $weblinkDetail;
        return $this;
    }
    /**
     * Add item to WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail $item
     * @return \StructType\Respondent
     */
    public function addToWeblinkDetail(\StructType\WeblinkDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WeblinkDetail) {
            throw new \InvalidArgumentException(sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WeblinkDetail[] = $item;
        return $this;
    }
    /**
     * Get TargetedListId value
     * @return string|null
     */
    public function getTargetedListId()
    {
        return $this->TargetedListId;
    }
    /**
     * Set TargetedListId value
     * @param string $targetedListId
     * @return \StructType\Respondent
     */
    public function setTargetedListId($targetedListId = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListId) && !is_string($targetedListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListId, true), gettype($targetedListId)), __LINE__);
        }
        $this->TargetedListId = $targetedListId;
        return $this;
    }
    /**
     * Get TargetedListName value
     * @return string|null
     */
    public function getTargetedListName()
    {
        return $this->TargetedListName;
    }
    /**
     * Set TargetedListName value
     * @param string $targetedListName
     * @return \StructType\Respondent
     */
    public function setTargetedListName($targetedListName = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListName) && !is_string($targetedListName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListName, true), gettype($targetedListName)), __LINE__);
        }
        $this->TargetedListName = $targetedListName;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\Respondent
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\Respondent
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get ResponseID value
     * @return string|null
     */
    public function getResponseID()
    {
        return $this->ResponseID;
    }
    /**
     * Set ResponseID value
     * @param string $responseID
     * @return \StructType\Respondent
     */
    public function setResponseID($responseID = null)
    {
        // validation for constraint: string
        if (!is_null($responseID) && !is_string($responseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseID, true), gettype($responseID)), __LINE__);
        }
        $this->ResponseID = $responseID;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Respondent
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Respondent
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\Respondent
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Respondent
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\Respondent
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\Respondent
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get SurveyId value
     * @return string|null
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param string $surveyId
     * @return \StructType\Respondent
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: string
        if (!is_null($surveyId) && !is_string($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyId, true), gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get SurveyCode value
     * @return string|null
     */
    public function getSurveyCode()
    {
        return $this->SurveyCode;
    }
    /**
     * Set SurveyCode value
     * @param string $surveyCode
     * @return \StructType\Respondent
     */
    public function setSurveyCode($surveyCode = null)
    {
        // validation for constraint: string
        if (!is_null($surveyCode) && !is_string($surveyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyCode, true), gettype($surveyCode)), __LINE__);
        }
        $this->SurveyCode = $surveyCode;
        return $this;
    }
    /**
     * Get SurveyTitle value
     * @return string|null
     */
    public function getSurveyTitle()
    {
        return $this->SurveyTitle;
    }
    /**
     * Set SurveyTitle value
     * @param string $surveyTitle
     * @return \StructType\Respondent
     */
    public function setSurveyTitle($surveyTitle = null)
    {
        // validation for constraint: string
        if (!is_null($surveyTitle) && !is_string($surveyTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyTitle, true), gettype($surveyTitle)), __LINE__);
        }
        $this->SurveyTitle = $surveyTitle;
        return $this;
    }
    /**
     * Get SurveyLaunchDate value
     * @return string|null
     */
    public function getSurveyLaunchDate()
    {
        return $this->SurveyLaunchDate;
    }
    /**
     * Set SurveyLaunchDate value
     * @param string $surveyLaunchDate
     * @return \StructType\Respondent
     */
    public function setSurveyLaunchDate($surveyLaunchDate = null)
    {
        // validation for constraint: string
        if (!is_null($surveyLaunchDate) && !is_string($surveyLaunchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyLaunchDate, true), gettype($surveyLaunchDate)), __LINE__);
        }
        $this->SurveyLaunchDate = $surveyLaunchDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\RespondentStatus::valueIsValid()
     * @uses \EnumType\RespondentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Respondent
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RespondentStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RespondentStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\RespondentStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\Respondent
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\Respondent
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Get ResponseScore value
     * @return float|null
     */
    public function getResponseScore()
    {
        return $this->ResponseScore;
    }
    /**
     * Set ResponseScore value
     * @param float $responseScore
     * @return \StructType\Respondent
     */
    public function setResponseScore($responseScore = null)
    {
        // validation for constraint: float
        if (!is_null($responseScore) && !(is_float($responseScore) || is_numeric($responseScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($responseScore, true), gettype($responseScore)), __LINE__);
        }
        $this->ResponseScore = $responseScore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Respondent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
