<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedWebsitesDetail StructType
 * @subpackage Structs
 */
class RelatedWebsitesDetail extends AbstractStructBase
{
    /**
     * The LinkName
     * @var string
     */
    public $LinkName;
    /**
     * The LinkURL
     * @var string
     */
    public $LinkURL;
    /**
     * The DisplayLink
     * @var bool
     */
    public $DisplayLink;
    /**
     * Constructor method for RelatedWebsitesDetail
     * @uses RelatedWebsitesDetail::setLinkName()
     * @uses RelatedWebsitesDetail::setLinkURL()
     * @uses RelatedWebsitesDetail::setDisplayLink()
     * @param string $linkName
     * @param string $linkURL
     * @param bool $displayLink
     */
    public function __construct($linkName = null, $linkURL = null, $displayLink = null)
    {
        $this
            ->setLinkName($linkName)
            ->setLinkURL($linkURL)
            ->setDisplayLink($displayLink);
    }
    /**
     * Get LinkName value
     * @return string|null
     */
    public function getLinkName()
    {
        return $this->LinkName;
    }
    /**
     * Set LinkName value
     * @param string $linkName
     * @return \StructType\RelatedWebsitesDetail
     */
    public function setLinkName($linkName = null)
    {
        // validation for constraint: string
        if (!is_null($linkName) && !is_string($linkName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkName, true), gettype($linkName)), __LINE__);
        }
        $this->LinkName = $linkName;
        return $this;
    }
    /**
     * Get LinkURL value
     * @return string|null
     */
    public function getLinkURL()
    {
        return $this->LinkURL;
    }
    /**
     * Set LinkURL value
     * @param string $linkURL
     * @return \StructType\RelatedWebsitesDetail
     */
    public function setLinkURL($linkURL = null)
    {
        // validation for constraint: string
        if (!is_null($linkURL) && !is_string($linkURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkURL, true), gettype($linkURL)), __LINE__);
        }
        $this->LinkURL = $linkURL;
        return $this;
    }
    /**
     * Get DisplayLink value
     * @return bool|null
     */
    public function getDisplayLink()
    {
        return $this->DisplayLink;
    }
    /**
     * Set DisplayLink value
     * @param bool $displayLink
     * @return \StructType\RelatedWebsitesDetail
     */
    public function setDisplayLink($displayLink = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayLink) && !is_bool($displayLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayLink, true), gettype($displayLink)), __LINE__);
        }
        $this->DisplayLink = $displayLink;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelatedWebsitesDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
