<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegretSurveyDetail StructType
 * @subpackage Structs
 */
class RegretSurveyDetail extends AbstractStructBase
{
    /**
     * The AnswerText
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AnswerText;
    /**
     * The EventAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventAnswer[]
     */
    public $EventAnswer;
    /**
     * The QuestionId
     * @var string
     */
    public $QuestionId;
    /**
     * The QuestionCode
     * @var string
     */
    public $QuestionCode;
    /**
     * The SurveyType
     * @var string
     */
    public $SurveyType;
    /**
     * The QuestionText
     * @var string
     */
    public $QuestionText;
    /**
     * Constructor method for RegretSurveyDetail
     * @uses RegretSurveyDetail::setAnswerText()
     * @uses RegretSurveyDetail::setEventAnswer()
     * @uses RegretSurveyDetail::setQuestionId()
     * @uses RegretSurveyDetail::setQuestionCode()
     * @uses RegretSurveyDetail::setSurveyType()
     * @uses RegretSurveyDetail::setQuestionText()
     * @param string[] $answerText
     * @param \StructType\EventAnswer[] $eventAnswer
     * @param string $questionId
     * @param string $questionCode
     * @param string $surveyType
     * @param string $questionText
     */
    public function __construct(array $answerText = array(), array $eventAnswer = array(), $questionId = null, $questionCode = null, $surveyType = null, $questionText = null)
    {
        $this
            ->setAnswerText($answerText)
            ->setEventAnswer($eventAnswer)
            ->setQuestionId($questionId)
            ->setQuestionCode($questionCode)
            ->setSurveyType($surveyType)
            ->setQuestionText($questionText);
    }
    /**
     * Get AnswerText value
     * @return string[]|null
     */
    public function getAnswerText()
    {
        return $this->AnswerText;
    }
    /**
     * This method is responsible for validating the values passed to the setAnswerText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswerText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnswerTextForArrayConstraintsFromSetAnswerText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $regretSurveyDetailAnswerTextItem) {
            // validation for constraint: itemType
            if (!is_string($regretSurveyDetailAnswerTextItem)) {
                $invalidValues[] = is_object($regretSurveyDetailAnswerTextItem) ? get_class($regretSurveyDetailAnswerTextItem) : sprintf('%s(%s)', gettype($regretSurveyDetailAnswerTextItem), var_export($regretSurveyDetailAnswerTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AnswerText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AnswerText value
     * @throws \InvalidArgumentException
     * @param string[] $answerText
     * @return \StructType\RegretSurveyDetail
     */
    public function setAnswerText(array $answerText = array())
    {
        // validation for constraint: array
        if ('' !== ($answerTextArrayErrorMessage = self::validateAnswerTextForArrayConstraintsFromSetAnswerText($answerText))) {
            throw new \InvalidArgumentException($answerTextArrayErrorMessage, __LINE__);
        }
        $this->AnswerText = $answerText;
        return $this;
    }
    /**
     * Add item to AnswerText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RegretSurveyDetail
     */
    public function addToAnswerText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AnswerText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AnswerText[] = $item;
        return $this;
    }
    /**
     * Get EventAnswer value
     * @return \StructType\EventAnswer[]|null
     */
    public function getEventAnswer()
    {
        return $this->EventAnswer;
    }
    /**
     * This method is responsible for validating the values passed to the setEventAnswer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventAnswer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventAnswerForArrayConstraintsFromSetEventAnswer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $regretSurveyDetailEventAnswerItem) {
            // validation for constraint: itemType
            if (!$regretSurveyDetailEventAnswerItem instanceof \StructType\EventAnswer) {
                $invalidValues[] = is_object($regretSurveyDetailEventAnswerItem) ? get_class($regretSurveyDetailEventAnswerItem) : sprintf('%s(%s)', gettype($regretSurveyDetailEventAnswerItem), var_export($regretSurveyDetailEventAnswerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventAnswer property can only contain items of type \StructType\EventAnswer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\EventAnswer[] $eventAnswer
     * @return \StructType\RegretSurveyDetail
     */
    public function setEventAnswer(array $eventAnswer = array())
    {
        // validation for constraint: array
        if ('' !== ($eventAnswerArrayErrorMessage = self::validateEventAnswerForArrayConstraintsFromSetEventAnswer($eventAnswer))) {
            throw new \InvalidArgumentException($eventAnswerArrayErrorMessage, __LINE__);
        }
        $this->EventAnswer = $eventAnswer;
        return $this;
    }
    /**
     * Add item to EventAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\EventAnswer $item
     * @return \StructType\RegretSurveyDetail
     */
    public function addToEventAnswer(\StructType\EventAnswer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventAnswer) {
            throw new \InvalidArgumentException(sprintf('The EventAnswer property can only contain items of type \StructType\EventAnswer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventAnswer[] = $item;
        return $this;
    }
    /**
     * Get QuestionId value
     * @return string|null
     */
    public function getQuestionId()
    {
        return $this->QuestionId;
    }
    /**
     * Set QuestionId value
     * @param string $questionId
     * @return \StructType\RegretSurveyDetail
     */
    public function setQuestionId($questionId = null)
    {
        // validation for constraint: string
        if (!is_null($questionId) && !is_string($questionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionId, true), gettype($questionId)), __LINE__);
        }
        $this->QuestionId = $questionId;
        return $this;
    }
    /**
     * Get QuestionCode value
     * @return string|null
     */
    public function getQuestionCode()
    {
        return $this->QuestionCode;
    }
    /**
     * Set QuestionCode value
     * @param string $questionCode
     * @return \StructType\RegretSurveyDetail
     */
    public function setQuestionCode($questionCode = null)
    {
        // validation for constraint: string
        if (!is_null($questionCode) && !is_string($questionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionCode, true), gettype($questionCode)), __LINE__);
        }
        $this->QuestionCode = $questionCode;
        return $this;
    }
    /**
     * Get SurveyType value
     * @return string|null
     */
    public function getSurveyType()
    {
        return $this->SurveyType;
    }
    /**
     * Set SurveyType value
     * @param string $surveyType
     * @return \StructType\RegretSurveyDetail
     */
    public function setSurveyType($surveyType = null)
    {
        // validation for constraint: string
        if (!is_null($surveyType) && !is_string($surveyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyType, true), gettype($surveyType)), __LINE__);
        }
        $this->SurveyType = $surveyType;
        return $this;
    }
    /**
     * Get QuestionText value
     * @return string|null
     */
    public function getQuestionText()
    {
        return $this->QuestionText;
    }
    /**
     * Set QuestionText value
     * @param string $questionText
     * @return \StructType\RegretSurveyDetail
     */
    public function setQuestionText($questionText = null)
    {
        // validation for constraint: string
        if (!is_null($questionText) && !is_string($questionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionText, true), gettype($questionText)), __LINE__);
        }
        $this->QuestionText = $questionText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegretSurveyDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
