<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Registration StructType
 * @subpackage Structs
 */
class Registration extends CvObject
{
    /**
     * The EventSurveyDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventSurveyDetail[]
     */
    public $EventSurveyDetail;
    /**
     * The GuestDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GuestDetail[]
     */
    public $GuestDetail;
    /**
     * The OrderDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderDetail[]
     */
    public $OrderDetail;
    /**
     * The PaymentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentDetail[]
     */
    public $PaymentDetail;
    /**
     * The TargetedListId
     * @var string
     */
    public $TargetedListId;
    /**
     * The TargetedListName
     * @var string
     */
    public $TargetedListName;
    /**
     * The InviteeId
     * @var string
     */
    public $InviteeId;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The CCEmailAddress
     * @var string
     */
    public $CCEmailAddress;
    /**
     * The WorkPhone
     * @var string
     */
    public $WorkPhone;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The GroupId
     * @var string
     */
    public $GroupId;
    /**
     * The GroupLeader
     * @var bool
     */
    public $GroupLeader;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The InvitedBy
     * @var string
     */
    public $InvitedBy;
    /**
     * The RegistrationDate
     * @var string
     */
    public $RegistrationDate;
    /**
     * The CancelledDate
     * @var string
     */
    public $CancelledDate;
    /**
     * The OriginalResponseDate
     * @var string
     */
    public $OriginalResponseDate;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The ModifiedBy
     * @var string
     */
    public $ModifiedBy;
    /**
     * The ResponseMethod
     * @var string
     */
    public $ResponseMethod;
    /**
     * The ConfirmationNumber
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The RegistrationType
     * @var string
     */
    public $RegistrationType;
    /**
     * The RegistrationTypeCode
     * @var string
     */
    public $RegistrationTypeCode;
    /**
     * The Participant
     * @var bool
     */
    public $Participant;
    /**
     * The Credit
     * @var float
     */
    public $Credit;
    /**
     * The ReferenceId
     * @var string
     */
    public $ReferenceId;
    /**
     * The IsTestRegistrant
     * @var bool
     */
    public $IsTestRegistrant;
    /**
     * Constructor method for Registration
     * @uses Registration::setEventSurveyDetail()
     * @uses Registration::setGuestDetail()
     * @uses Registration::setOrderDetail()
     * @uses Registration::setPaymentDetail()
     * @uses Registration::setTargetedListId()
     * @uses Registration::setTargetedListName()
     * @uses Registration::setInviteeId()
     * @uses Registration::setContactId()
     * @uses Registration::setSourceId()
     * @uses Registration::setFirstName()
     * @uses Registration::setLastName()
     * @uses Registration::setCompany()
     * @uses Registration::setTitle()
     * @uses Registration::setEmailAddress()
     * @uses Registration::setCCEmailAddress()
     * @uses Registration::setWorkPhone()
     * @uses Registration::setEventId()
     * @uses Registration::setEventCode()
     * @uses Registration::setEventTitle()
     * @uses Registration::setEventStartDate()
     * @uses Registration::setStatus()
     * @uses Registration::setGroupId()
     * @uses Registration::setGroupLeader()
     * @uses Registration::setInternalNote()
     * @uses Registration::setInvitedBy()
     * @uses Registration::setRegistrationDate()
     * @uses Registration::setCancelledDate()
     * @uses Registration::setOriginalResponseDate()
     * @uses Registration::setLastModifiedDate()
     * @uses Registration::setModifiedBy()
     * @uses Registration::setResponseMethod()
     * @uses Registration::setConfirmationNumber()
     * @uses Registration::setRegistrationType()
     * @uses Registration::setRegistrationTypeCode()
     * @uses Registration::setParticipant()
     * @uses Registration::setCredit()
     * @uses Registration::setReferenceId()
     * @uses Registration::setIsTestRegistrant()
     * @param \StructType\EventSurveyDetail[] $eventSurveyDetail
     * @param \StructType\GuestDetail[] $guestDetail
     * @param \StructType\OrderDetail[] $orderDetail
     * @param \StructType\PaymentDetail[] $paymentDetail
     * @param string $targetedListId
     * @param string $targetedListName
     * @param string $inviteeId
     * @param string $contactId
     * @param string $sourceId
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $title
     * @param string $emailAddress
     * @param string $cCEmailAddress
     * @param string $workPhone
     * @param string $eventId
     * @param string $eventCode
     * @param string $eventTitle
     * @param string $eventStartDate
     * @param string $status
     * @param string $groupId
     * @param bool $groupLeader
     * @param string $internalNote
     * @param string $invitedBy
     * @param string $registrationDate
     * @param string $cancelledDate
     * @param string $originalResponseDate
     * @param string $lastModifiedDate
     * @param string $modifiedBy
     * @param string $responseMethod
     * @param string $confirmationNumber
     * @param string $registrationType
     * @param string $registrationTypeCode
     * @param bool $participant
     * @param float $credit
     * @param string $referenceId
     * @param bool $isTestRegistrant
     */
    public function __construct(array $eventSurveyDetail = array(), array $guestDetail = array(), array $orderDetail = array(), array $paymentDetail = array(), $targetedListId = null, $targetedListName = null, $inviteeId = null, $contactId = null, $sourceId = null, $firstName = null, $lastName = null, $company = null, $title = null, $emailAddress = null, $cCEmailAddress = null, $workPhone = null, $eventId = null, $eventCode = null, $eventTitle = null, $eventStartDate = null, $status = null, $groupId = null, $groupLeader = null, $internalNote = null, $invitedBy = null, $registrationDate = null, $cancelledDate = null, $originalResponseDate = null, $lastModifiedDate = null, $modifiedBy = null, $responseMethod = null, $confirmationNumber = null, $registrationType = null, $registrationTypeCode = null, $participant = null, $credit = null, $referenceId = null, $isTestRegistrant = null)
    {
        $this
            ->setEventSurveyDetail($eventSurveyDetail)
            ->setGuestDetail($guestDetail)
            ->setOrderDetail($orderDetail)
            ->setPaymentDetail($paymentDetail)
            ->setTargetedListId($targetedListId)
            ->setTargetedListName($targetedListName)
            ->setInviteeId($inviteeId)
            ->setContactId($contactId)
            ->setSourceId($sourceId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setTitle($title)
            ->setEmailAddress($emailAddress)
            ->setCCEmailAddress($cCEmailAddress)
            ->setWorkPhone($workPhone)
            ->setEventId($eventId)
            ->setEventCode($eventCode)
            ->setEventTitle($eventTitle)
            ->setEventStartDate($eventStartDate)
            ->setStatus($status)
            ->setGroupId($groupId)
            ->setGroupLeader($groupLeader)
            ->setInternalNote($internalNote)
            ->setInvitedBy($invitedBy)
            ->setRegistrationDate($registrationDate)
            ->setCancelledDate($cancelledDate)
            ->setOriginalResponseDate($originalResponseDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setModifiedBy($modifiedBy)
            ->setResponseMethod($responseMethod)
            ->setConfirmationNumber($confirmationNumber)
            ->setRegistrationType($registrationType)
            ->setRegistrationTypeCode($registrationTypeCode)
            ->setParticipant($participant)
            ->setCredit($credit)
            ->setReferenceId($referenceId)
            ->setIsTestRegistrant($isTestRegistrant);
    }
    /**
     * Get EventSurveyDetail value
     * @return \StructType\EventSurveyDetail[]|null
     */
    public function getEventSurveyDetail()
    {
        return $this->EventSurveyDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setEventSurveyDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventSurveyDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventSurveyDetailForArrayConstraintsFromSetEventSurveyDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $registrationEventSurveyDetailItem) {
            // validation for constraint: itemType
            if (!$registrationEventSurveyDetailItem instanceof \StructType\EventSurveyDetail) {
                $invalidValues[] = is_object($registrationEventSurveyDetailItem) ? get_class($registrationEventSurveyDetailItem) : sprintf('%s(%s)', gettype($registrationEventSurveyDetailItem), var_export($registrationEventSurveyDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventSurveyDetail property can only contain items of type \StructType\EventSurveyDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EventSurveyDetail[] $eventSurveyDetail
     * @return \StructType\Registration
     */
    public function setEventSurveyDetail(array $eventSurveyDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($eventSurveyDetailArrayErrorMessage = self::validateEventSurveyDetailForArrayConstraintsFromSetEventSurveyDetail($eventSurveyDetail))) {
            throw new \InvalidArgumentException($eventSurveyDetailArrayErrorMessage, __LINE__);
        }
        $this->EventSurveyDetail = $eventSurveyDetail;
        return $this;
    }
    /**
     * Add item to EventSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EventSurveyDetail $item
     * @return \StructType\Registration
     */
    public function addToEventSurveyDetail(\StructType\EventSurveyDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventSurveyDetail) {
            throw new \InvalidArgumentException(sprintf('The EventSurveyDetail property can only contain items of type \StructType\EventSurveyDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventSurveyDetail[] = $item;
        return $this;
    }
    /**
     * Get GuestDetail value
     * @return \StructType\GuestDetail[]|null
     */
    public function getGuestDetail()
    {
        return $this->GuestDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestDetailForArrayConstraintsFromSetGuestDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $registrationGuestDetailItem) {
            // validation for constraint: itemType
            if (!$registrationGuestDetailItem instanceof \StructType\GuestDetail) {
                $invalidValues[] = is_object($registrationGuestDetailItem) ? get_class($registrationGuestDetailItem) : sprintf('%s(%s)', gettype($registrationGuestDetailItem), var_export($registrationGuestDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestDetail property can only contain items of type \StructType\GuestDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestDetail[] $guestDetail
     * @return \StructType\Registration
     */
    public function setGuestDetail(array $guestDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($guestDetailArrayErrorMessage = self::validateGuestDetailForArrayConstraintsFromSetGuestDetail($guestDetail))) {
            throw new \InvalidArgumentException($guestDetailArrayErrorMessage, __LINE__);
        }
        $this->GuestDetail = $guestDetail;
        return $this;
    }
    /**
     * Add item to GuestDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestDetail $item
     * @return \StructType\Registration
     */
    public function addToGuestDetail(\StructType\GuestDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestDetail) {
            throw new \InvalidArgumentException(sprintf('The GuestDetail property can only contain items of type \StructType\GuestDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GuestDetail[] = $item;
        return $this;
    }
    /**
     * Get OrderDetail value
     * @return \StructType\OrderDetail[]|null
     */
    public function getOrderDetail()
    {
        return $this->OrderDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderDetailForArrayConstraintsFromSetOrderDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $registrationOrderDetailItem) {
            // validation for constraint: itemType
            if (!$registrationOrderDetailItem instanceof \StructType\OrderDetail) {
                $invalidValues[] = is_object($registrationOrderDetailItem) ? get_class($registrationOrderDetailItem) : sprintf('%s(%s)', gettype($registrationOrderDetailItem), var_export($registrationOrderDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderDetail property can only contain items of type \StructType\OrderDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDetail[] $orderDetail
     * @return \StructType\Registration
     */
    public function setOrderDetail(array $orderDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($orderDetailArrayErrorMessage = self::validateOrderDetailForArrayConstraintsFromSetOrderDetail($orderDetail))) {
            throw new \InvalidArgumentException($orderDetailArrayErrorMessage, __LINE__);
        }
        $this->OrderDetail = $orderDetail;
        return $this;
    }
    /**
     * Add item to OrderDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDetail $item
     * @return \StructType\Registration
     */
    public function addToOrderDetail(\StructType\OrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderDetail) {
            throw new \InvalidArgumentException(sprintf('The OrderDetail property can only contain items of type \StructType\OrderDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderDetail[] = $item;
        return $this;
    }
    /**
     * Get PaymentDetail value
     * @return \StructType\PaymentDetail[]|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentDetailForArrayConstraintsFromSetPaymentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $registrationPaymentDetailItem) {
            // validation for constraint: itemType
            if (!$registrationPaymentDetailItem instanceof \StructType\PaymentDetail) {
                $invalidValues[] = is_object($registrationPaymentDetailItem) ? get_class($registrationPaymentDetailItem) : sprintf('%s(%s)', gettype($registrationPaymentDetailItem), var_export($registrationPaymentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentDetail property can only contain items of type \StructType\PaymentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDetail[] $paymentDetail
     * @return \StructType\Registration
     */
    public function setPaymentDetail(array $paymentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentDetailArrayErrorMessage = self::validatePaymentDetailForArrayConstraintsFromSetPaymentDetail($paymentDetail))) {
            throw new \InvalidArgumentException($paymentDetailArrayErrorMessage, __LINE__);
        }
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Add item to PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDetail $item
     * @return \StructType\Registration
     */
    public function addToPaymentDetail(\StructType\PaymentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of type \StructType\PaymentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentDetail[] = $item;
        return $this;
    }
    /**
     * Get TargetedListId value
     * @return string|null
     */
    public function getTargetedListId()
    {
        return $this->TargetedListId;
    }
    /**
     * Set TargetedListId value
     * @param string $targetedListId
     * @return \StructType\Registration
     */
    public function setTargetedListId($targetedListId = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListId) && !is_string($targetedListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListId, true), gettype($targetedListId)), __LINE__);
        }
        $this->TargetedListId = $targetedListId;
        return $this;
    }
    /**
     * Get TargetedListName value
     * @return string|null
     */
    public function getTargetedListName()
    {
        return $this->TargetedListName;
    }
    /**
     * Set TargetedListName value
     * @param string $targetedListName
     * @return \StructType\Registration
     */
    public function setTargetedListName($targetedListName = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListName) && !is_string($targetedListName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListName, true), gettype($targetedListName)), __LINE__);
        }
        $this->TargetedListName = $targetedListName;
        return $this;
    }
    /**
     * Get InviteeId value
     * @return string|null
     */
    public function getInviteeId()
    {
        return $this->InviteeId;
    }
    /**
     * Set InviteeId value
     * @param string $inviteeId
     * @return \StructType\Registration
     */
    public function setInviteeId($inviteeId = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeId) && !is_string($inviteeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeId, true), gettype($inviteeId)), __LINE__);
        }
        $this->InviteeId = $inviteeId;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\Registration
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\Registration
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Registration
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Registration
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\Registration
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Registration
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\Registration
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get CCEmailAddress value
     * @return string|null
     */
    public function getCCEmailAddress()
    {
        return $this->CCEmailAddress;
    }
    /**
     * Set CCEmailAddress value
     * @param string $cCEmailAddress
     * @return \StructType\Registration
     */
    public function setCCEmailAddress($cCEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($cCEmailAddress) && !is_string($cCEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCEmailAddress, true), gettype($cCEmailAddress)), __LINE__);
        }
        $this->CCEmailAddress = $cCEmailAddress;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\Registration
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\Registration
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\Registration
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\Registration
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\Registration
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Registration
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get GroupId value
     * @return string|null
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param string $groupId
     * @return \StructType\Registration
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get GroupLeader value
     * @return bool|null
     */
    public function getGroupLeader()
    {
        return $this->GroupLeader;
    }
    /**
     * Set GroupLeader value
     * @param bool $groupLeader
     * @return \StructType\Registration
     */
    public function setGroupLeader($groupLeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupLeader) && !is_bool($groupLeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupLeader, true), gettype($groupLeader)), __LINE__);
        }
        $this->GroupLeader = $groupLeader;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\Registration
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get InvitedBy value
     * @return string|null
     */
    public function getInvitedBy()
    {
        return $this->InvitedBy;
    }
    /**
     * Set InvitedBy value
     * @param string $invitedBy
     * @return \StructType\Registration
     */
    public function setInvitedBy($invitedBy = null)
    {
        // validation for constraint: string
        if (!is_null($invitedBy) && !is_string($invitedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invitedBy, true), gettype($invitedBy)), __LINE__);
        }
        $this->InvitedBy = $invitedBy;
        return $this;
    }
    /**
     * Get RegistrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->RegistrationDate;
    }
    /**
     * Set RegistrationDate value
     * @param string $registrationDate
     * @return \StructType\Registration
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        $this->RegistrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get CancelledDate value
     * @return string|null
     */
    public function getCancelledDate()
    {
        return $this->CancelledDate;
    }
    /**
     * Set CancelledDate value
     * @param string $cancelledDate
     * @return \StructType\Registration
     */
    public function setCancelledDate($cancelledDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelledDate) && !is_string($cancelledDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelledDate, true), gettype($cancelledDate)), __LINE__);
        }
        $this->CancelledDate = $cancelledDate;
        return $this;
    }
    /**
     * Get OriginalResponseDate value
     * @return string|null
     */
    public function getOriginalResponseDate()
    {
        return $this->OriginalResponseDate;
    }
    /**
     * Set OriginalResponseDate value
     * @param string $originalResponseDate
     * @return \StructType\Registration
     */
    public function setOriginalResponseDate($originalResponseDate = null)
    {
        // validation for constraint: string
        if (!is_null($originalResponseDate) && !is_string($originalResponseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalResponseDate, true), gettype($originalResponseDate)), __LINE__);
        }
        $this->OriginalResponseDate = $originalResponseDate;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Registration
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return string|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param string $modifiedBy
     * @return \StructType\Registration
     */
    public function setModifiedBy($modifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedBy) && !is_string($modifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedBy, true), gettype($modifiedBy)), __LINE__);
        }
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Get ResponseMethod value
     * @return string|null
     */
    public function getResponseMethod()
    {
        return $this->ResponseMethod;
    }
    /**
     * Set ResponseMethod value
     * @param string $responseMethod
     * @return \StructType\Registration
     */
    public function setResponseMethod($responseMethod = null)
    {
        // validation for constraint: string
        if (!is_null($responseMethod) && !is_string($responseMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMethod, true), gettype($responseMethod)), __LINE__);
        }
        $this->ResponseMethod = $responseMethod;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\Registration
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get RegistrationType value
     * @return string|null
     */
    public function getRegistrationType()
    {
        return $this->RegistrationType;
    }
    /**
     * Set RegistrationType value
     * @param string $registrationType
     * @return \StructType\Registration
     */
    public function setRegistrationType($registrationType = null)
    {
        // validation for constraint: string
        if (!is_null($registrationType) && !is_string($registrationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationType, true), gettype($registrationType)), __LINE__);
        }
        $this->RegistrationType = $registrationType;
        return $this;
    }
    /**
     * Get RegistrationTypeCode value
     * @return string|null
     */
    public function getRegistrationTypeCode()
    {
        return $this->RegistrationTypeCode;
    }
    /**
     * Set RegistrationTypeCode value
     * @param string $registrationTypeCode
     * @return \StructType\Registration
     */
    public function setRegistrationTypeCode($registrationTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($registrationTypeCode) && !is_string($registrationTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationTypeCode, true), gettype($registrationTypeCode)), __LINE__);
        }
        $this->RegistrationTypeCode = $registrationTypeCode;
        return $this;
    }
    /**
     * Get Participant value
     * @return bool|null
     */
    public function getParticipant()
    {
        return $this->Participant;
    }
    /**
     * Set Participant value
     * @param bool $participant
     * @return \StructType\Registration
     */
    public function setParticipant($participant = null)
    {
        // validation for constraint: boolean
        if (!is_null($participant) && !is_bool($participant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($participant, true), gettype($participant)), __LINE__);
        }
        $this->Participant = $participant;
        return $this;
    }
    /**
     * Get Credit value
     * @return float|null
     */
    public function getCredit()
    {
        return $this->Credit;
    }
    /**
     * Set Credit value
     * @param float $credit
     * @return \StructType\Registration
     */
    public function setCredit($credit = null)
    {
        // validation for constraint: float
        if (!is_null($credit) && !(is_float($credit) || is_numeric($credit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credit, true), gettype($credit)), __LINE__);
        }
        $this->Credit = $credit;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\Registration
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Get IsTestRegistrant value
     * @return bool|null
     */
    public function getIsTestRegistrant()
    {
        return $this->IsTestRegistrant;
    }
    /**
     * Set IsTestRegistrant value
     * @param bool $isTestRegistrant
     * @return \StructType\Registration
     */
    public function setIsTestRegistrant($isTestRegistrant = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTestRegistrant) && !is_bool($isTestRegistrant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTestRegistrant, true), gettype($isTestRegistrant)), __LINE__);
        }
        $this->IsTestRegistrant = $isTestRegistrant;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Registration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
