<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateHistory StructType
 * @subpackage Structs
 */
class RateHistory extends CvObject
{
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The VenueID
     * @var string
     */
    public $VenueID;
    /**
     * The VenueCode
     * @var string
     */
    public $VenueCode;
    /**
     * The VenueName
     * @var string
     */
    public $VenueName;
    /**
     * The RateName
     * @var string
     */
    public $RateName;
    /**
     * The RateStartDate
     * @var string
     */
    public $RateStartDate;
    /**
     * The RateEndDate
     * @var string
     */
    public $RateEndDate;
    /**
     * The MinimumRate
     * @var float
     */
    public $MinimumRate;
    /**
     * The MaximumRate
     * @var float
     */
    public $MaximumRate;
    /**
     * The RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The RoomNightCount
     * @var int
     */
    public $RoomNightCount;
    /**
     * The Comment
     * @var string
     */
    public $Comment;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The ContractedRate
     * @var bool
     */
    public $ContractedRate;
    /**
     * The ContractDate
     * @var string
     */
    public $ContractDate;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * Constructor method for RateHistory
     * @uses RateHistory::setID()
     * @uses RateHistory::setVenueID()
     * @uses RateHistory::setVenueCode()
     * @uses RateHistory::setVenueName()
     * @uses RateHistory::setRateName()
     * @uses RateHistory::setRateStartDate()
     * @uses RateHistory::setRateEndDate()
     * @uses RateHistory::setMinimumRate()
     * @uses RateHistory::setMaximumRate()
     * @uses RateHistory::setRoomType()
     * @uses RateHistory::setRoomNightCount()
     * @uses RateHistory::setComment()
     * @uses RateHistory::setCurrency()
     * @uses RateHistory::setContractedRate()
     * @uses RateHistory::setContractDate()
     * @uses RateHistory::setCreatedDate()
     * @uses RateHistory::setCreatedBy()
     * @uses RateHistory::setLastModifiedDate()
     * @uses RateHistory::setLastModifiedBy()
     * @param string $iD
     * @param string $venueID
     * @param string $venueCode
     * @param string $venueName
     * @param string $rateName
     * @param string $rateStartDate
     * @param string $rateEndDate
     * @param float $minimumRate
     * @param float $maximumRate
     * @param string $roomType
     * @param int $roomNightCount
     * @param string $comment
     * @param string $currency
     * @param bool $contractedRate
     * @param string $contractDate
     * @param string $createdDate
     * @param string $createdBy
     * @param string $lastModifiedDate
     * @param string $lastModifiedBy
     */
    public function __construct($iD = null, $venueID = null, $venueCode = null, $venueName = null, $rateName = null, $rateStartDate = null, $rateEndDate = null, $minimumRate = null, $maximumRate = null, $roomType = null, $roomNightCount = null, $comment = null, $currency = null, $contractedRate = null, $contractDate = null, $createdDate = null, $createdBy = null, $lastModifiedDate = null, $lastModifiedBy = null)
    {
        $this
            ->setID($iD)
            ->setVenueID($venueID)
            ->setVenueCode($venueCode)
            ->setVenueName($venueName)
            ->setRateName($rateName)
            ->setRateStartDate($rateStartDate)
            ->setRateEndDate($rateEndDate)
            ->setMinimumRate($minimumRate)
            ->setMaximumRate($maximumRate)
            ->setRoomType($roomType)
            ->setRoomNightCount($roomNightCount)
            ->setComment($comment)
            ->setCurrency($currency)
            ->setContractedRate($contractedRate)
            ->setContractDate($contractDate)
            ->setCreatedDate($createdDate)
            ->setCreatedBy($createdBy)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastModifiedBy($lastModifiedBy);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\RateHistory
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get VenueID value
     * @return string|null
     */
    public function getVenueID()
    {
        return $this->VenueID;
    }
    /**
     * Set VenueID value
     * @param string $venueID
     * @return \StructType\RateHistory
     */
    public function setVenueID($venueID = null)
    {
        // validation for constraint: string
        if (!is_null($venueID) && !is_string($venueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueID, true), gettype($venueID)), __LINE__);
        }
        $this->VenueID = $venueID;
        return $this;
    }
    /**
     * Get VenueCode value
     * @return string|null
     */
    public function getVenueCode()
    {
        return $this->VenueCode;
    }
    /**
     * Set VenueCode value
     * @param string $venueCode
     * @return \StructType\RateHistory
     */
    public function setVenueCode($venueCode = null)
    {
        // validation for constraint: string
        if (!is_null($venueCode) && !is_string($venueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueCode, true), gettype($venueCode)), __LINE__);
        }
        $this->VenueCode = $venueCode;
        return $this;
    }
    /**
     * Get VenueName value
     * @return string|null
     */
    public function getVenueName()
    {
        return $this->VenueName;
    }
    /**
     * Set VenueName value
     * @param string $venueName
     * @return \StructType\RateHistory
     */
    public function setVenueName($venueName = null)
    {
        // validation for constraint: string
        if (!is_null($venueName) && !is_string($venueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueName, true), gettype($venueName)), __LINE__);
        }
        $this->VenueName = $venueName;
        return $this;
    }
    /**
     * Get RateName value
     * @return string|null
     */
    public function getRateName()
    {
        return $this->RateName;
    }
    /**
     * Set RateName value
     * @param string $rateName
     * @return \StructType\RateHistory
     */
    public function setRateName($rateName = null)
    {
        // validation for constraint: string
        if (!is_null($rateName) && !is_string($rateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateName, true), gettype($rateName)), __LINE__);
        }
        $this->RateName = $rateName;
        return $this;
    }
    /**
     * Get RateStartDate value
     * @return string|null
     */
    public function getRateStartDate()
    {
        return $this->RateStartDate;
    }
    /**
     * Set RateStartDate value
     * @param string $rateStartDate
     * @return \StructType\RateHistory
     */
    public function setRateStartDate($rateStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($rateStartDate) && !is_string($rateStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateStartDate, true), gettype($rateStartDate)), __LINE__);
        }
        $this->RateStartDate = $rateStartDate;
        return $this;
    }
    /**
     * Get RateEndDate value
     * @return string|null
     */
    public function getRateEndDate()
    {
        return $this->RateEndDate;
    }
    /**
     * Set RateEndDate value
     * @param string $rateEndDate
     * @return \StructType\RateHistory
     */
    public function setRateEndDate($rateEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($rateEndDate) && !is_string($rateEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateEndDate, true), gettype($rateEndDate)), __LINE__);
        }
        $this->RateEndDate = $rateEndDate;
        return $this;
    }
    /**
     * Get MinimumRate value
     * @return float|null
     */
    public function getMinimumRate()
    {
        return $this->MinimumRate;
    }
    /**
     * Set MinimumRate value
     * @param float $minimumRate
     * @return \StructType\RateHistory
     */
    public function setMinimumRate($minimumRate = null)
    {
        // validation for constraint: float
        if (!is_null($minimumRate) && !(is_float($minimumRate) || is_numeric($minimumRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumRate, true), gettype($minimumRate)), __LINE__);
        }
        $this->MinimumRate = $minimumRate;
        return $this;
    }
    /**
     * Get MaximumRate value
     * @return float|null
     */
    public function getMaximumRate()
    {
        return $this->MaximumRate;
    }
    /**
     * Set MaximumRate value
     * @param float $maximumRate
     * @return \StructType\RateHistory
     */
    public function setMaximumRate($maximumRate = null)
    {
        // validation for constraint: float
        if (!is_null($maximumRate) && !(is_float($maximumRate) || is_numeric($maximumRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumRate, true), gettype($maximumRate)), __LINE__);
        }
        $this->MaximumRate = $maximumRate;
        return $this;
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\RateHistory
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomNightCount value
     * @return int|null
     */
    public function getRoomNightCount()
    {
        return $this->RoomNightCount;
    }
    /**
     * Set RoomNightCount value
     * @param int $roomNightCount
     * @return \StructType\RateHistory
     */
    public function setRoomNightCount($roomNightCount = null)
    {
        // validation for constraint: int
        if (!is_null($roomNightCount) && !(is_int($roomNightCount) || ctype_digit($roomNightCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomNightCount, true), gettype($roomNightCount)), __LINE__);
        }
        $this->RoomNightCount = $roomNightCount;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\RateHistory
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\RateHistory
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ContractedRate value
     * @return bool|null
     */
    public function getContractedRate()
    {
        return $this->ContractedRate;
    }
    /**
     * Set ContractedRate value
     * @param bool $contractedRate
     * @return \StructType\RateHistory
     */
    public function setContractedRate($contractedRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($contractedRate) && !is_bool($contractedRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contractedRate, true), gettype($contractedRate)), __LINE__);
        }
        $this->ContractedRate = $contractedRate;
        return $this;
    }
    /**
     * Get ContractDate value
     * @return string|null
     */
    public function getContractDate()
    {
        return $this->ContractDate;
    }
    /**
     * Set ContractDate value
     * @param string $contractDate
     * @return \StructType\RateHistory
     */
    public function setContractDate($contractDate = null)
    {
        // validation for constraint: string
        if (!is_null($contractDate) && !is_string($contractDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractDate, true), gettype($contractDate)), __LINE__);
        }
        $this->ContractDate = $contractDate;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\RateHistory
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\RateHistory
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\RateHistory
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\RateHistory
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
