<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPSupplierDetail StructType
 * @subpackage Structs
 */
class RFPSupplierDetail extends SupplierDetail
{
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The VenueBrand
     * @var string
     */
    public $VenueBrand;
    /**
     * The VenueChain
     * @var string
     */
    public $VenueChain;
    /**
     * The Preferred
     * @var bool
     */
    public $Preferred;
    /**
     * The MainPhone
     * @var string
     */
    public $MainPhone;
    /**
     * The SalesPhone
     * @var string
     */
    public $SalesPhone;
    /**
     * The BidReceivedDate
     * @var string
     */
    public $BidReceivedDate;
    /**
     * The LastResponseDate
     * @var string
     */
    public $LastResponseDate;
    /**
     * The RFPSentDate
     * @var string
     */
    public $RFPSentDate;
    /**
     * Constructor method for RFPSupplierDetail
     * @uses RFPSupplierDetail::setInternalNote()
     * @uses RFPSupplierDetail::setVenueBrand()
     * @uses RFPSupplierDetail::setVenueChain()
     * @uses RFPSupplierDetail::setPreferred()
     * @uses RFPSupplierDetail::setMainPhone()
     * @uses RFPSupplierDetail::setSalesPhone()
     * @uses RFPSupplierDetail::setBidReceivedDate()
     * @uses RFPSupplierDetail::setLastResponseDate()
     * @uses RFPSupplierDetail::setRFPSentDate()
     * @param string $internalNote
     * @param string $venueBrand
     * @param string $venueChain
     * @param bool $preferred
     * @param string $mainPhone
     * @param string $salesPhone
     * @param string $bidReceivedDate
     * @param string $lastResponseDate
     * @param string $rFPSentDate
     */
    public function __construct($internalNote = null, $venueBrand = null, $venueChain = null, $preferred = null, $mainPhone = null, $salesPhone = null, $bidReceivedDate = null, $lastResponseDate = null, $rFPSentDate = null)
    {
        $this
            ->setInternalNote($internalNote)
            ->setVenueBrand($venueBrand)
            ->setVenueChain($venueChain)
            ->setPreferred($preferred)
            ->setMainPhone($mainPhone)
            ->setSalesPhone($salesPhone)
            ->setBidReceivedDate($bidReceivedDate)
            ->setLastResponseDate($lastResponseDate)
            ->setRFPSentDate($rFPSentDate);
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\RFPSupplierDetail
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get VenueBrand value
     * @return string|null
     */
    public function getVenueBrand()
    {
        return $this->VenueBrand;
    }
    /**
     * Set VenueBrand value
     * @param string $venueBrand
     * @return \StructType\RFPSupplierDetail
     */
    public function setVenueBrand($venueBrand = null)
    {
        // validation for constraint: string
        if (!is_null($venueBrand) && !is_string($venueBrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueBrand, true), gettype($venueBrand)), __LINE__);
        }
        $this->VenueBrand = $venueBrand;
        return $this;
    }
    /**
     * Get VenueChain value
     * @return string|null
     */
    public function getVenueChain()
    {
        return $this->VenueChain;
    }
    /**
     * Set VenueChain value
     * @param string $venueChain
     * @return \StructType\RFPSupplierDetail
     */
    public function setVenueChain($venueChain = null)
    {
        // validation for constraint: string
        if (!is_null($venueChain) && !is_string($venueChain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueChain, true), gettype($venueChain)), __LINE__);
        }
        $this->VenueChain = $venueChain;
        return $this;
    }
    /**
     * Get Preferred value
     * @return bool|null
     */
    public function getPreferred()
    {
        return $this->Preferred;
    }
    /**
     * Set Preferred value
     * @param bool $preferred
     * @return \StructType\RFPSupplierDetail
     */
    public function setPreferred($preferred = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferred) && !is_bool($preferred)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferred, true), gettype($preferred)), __LINE__);
        }
        $this->Preferred = $preferred;
        return $this;
    }
    /**
     * Get MainPhone value
     * @return string|null
     */
    public function getMainPhone()
    {
        return $this->MainPhone;
    }
    /**
     * Set MainPhone value
     * @param string $mainPhone
     * @return \StructType\RFPSupplierDetail
     */
    public function setMainPhone($mainPhone = null)
    {
        // validation for constraint: string
        if (!is_null($mainPhone) && !is_string($mainPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainPhone, true), gettype($mainPhone)), __LINE__);
        }
        $this->MainPhone = $mainPhone;
        return $this;
    }
    /**
     * Get SalesPhone value
     * @return string|null
     */
    public function getSalesPhone()
    {
        return $this->SalesPhone;
    }
    /**
     * Set SalesPhone value
     * @param string $salesPhone
     * @return \StructType\RFPSupplierDetail
     */
    public function setSalesPhone($salesPhone = null)
    {
        // validation for constraint: string
        if (!is_null($salesPhone) && !is_string($salesPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesPhone, true), gettype($salesPhone)), __LINE__);
        }
        $this->SalesPhone = $salesPhone;
        return $this;
    }
    /**
     * Get BidReceivedDate value
     * @return string|null
     */
    public function getBidReceivedDate()
    {
        return $this->BidReceivedDate;
    }
    /**
     * Set BidReceivedDate value
     * @param string $bidReceivedDate
     * @return \StructType\RFPSupplierDetail
     */
    public function setBidReceivedDate($bidReceivedDate = null)
    {
        // validation for constraint: string
        if (!is_null($bidReceivedDate) && !is_string($bidReceivedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bidReceivedDate, true), gettype($bidReceivedDate)), __LINE__);
        }
        $this->BidReceivedDate = $bidReceivedDate;
        return $this;
    }
    /**
     * Get LastResponseDate value
     * @return string|null
     */
    public function getLastResponseDate()
    {
        return $this->LastResponseDate;
    }
    /**
     * Set LastResponseDate value
     * @param string $lastResponseDate
     * @return \StructType\RFPSupplierDetail
     */
    public function setLastResponseDate($lastResponseDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastResponseDate) && !is_string($lastResponseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastResponseDate, true), gettype($lastResponseDate)), __LINE__);
        }
        $this->LastResponseDate = $lastResponseDate;
        return $this;
    }
    /**
     * Get RFPSentDate value
     * @return string|null
     */
    public function getRFPSentDate()
    {
        return $this->RFPSentDate;
    }
    /**
     * Set RFPSentDate value
     * @param string $rFPSentDate
     * @return \StructType\RFPSupplierDetail
     */
    public function setRFPSentDate($rFPSentDate = null)
    {
        // validation for constraint: string
        if (!is_null($rFPSentDate) && !is_string($rFPSentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPSentDate, true), gettype($rFPSentDate)), __LINE__);
        }
        $this->RFPSentDate = $rFPSentDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPSupplierDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
