<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPSleepRoomInfo StructType
 * @subpackage Structs
 */
class RFPSleepRoomInfo extends AbstractStructBase
{
    /**
     * The SleepRoomDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPSleepRoomDetail[]
     */
    public $SleepRoomDetail;
    /**
     * The OccupancyPerRoomDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPOccupancyPerRoomDetail[]
     */
    public $OccupancyPerRoomDetail;
    /**
     * The CheckInDate
     * @var string
     */
    public $CheckInDate;
    /**
     * The BudgetedRoomRate
     * @var float
     */
    public $BudgetedRoomRate;
    /**
     * The SleepRoomAdditionalInformation
     * @var string
     */
    public $SleepRoomAdditionalInformation;
    /**
     * Constructor method for RFPSleepRoomInfo
     * @uses RFPSleepRoomInfo::setSleepRoomDetail()
     * @uses RFPSleepRoomInfo::setOccupancyPerRoomDetail()
     * @uses RFPSleepRoomInfo::setCheckInDate()
     * @uses RFPSleepRoomInfo::setBudgetedRoomRate()
     * @uses RFPSleepRoomInfo::setSleepRoomAdditionalInformation()
     * @param \StructType\RFPSleepRoomDetail[] $sleepRoomDetail
     * @param \StructType\RFPOccupancyPerRoomDetail[] $occupancyPerRoomDetail
     * @param string $checkInDate
     * @param float $budgetedRoomRate
     * @param string $sleepRoomAdditionalInformation
     */
    public function __construct(array $sleepRoomDetail = array(), array $occupancyPerRoomDetail = array(), $checkInDate = null, $budgetedRoomRate = null, $sleepRoomAdditionalInformation = null)
    {
        $this
            ->setSleepRoomDetail($sleepRoomDetail)
            ->setOccupancyPerRoomDetail($occupancyPerRoomDetail)
            ->setCheckInDate($checkInDate)
            ->setBudgetedRoomRate($budgetedRoomRate)
            ->setSleepRoomAdditionalInformation($sleepRoomAdditionalInformation);
    }
    /**
     * Get SleepRoomDetail value
     * @return \StructType\RFPSleepRoomDetail[]|null
     */
    public function getSleepRoomDetail()
    {
        return $this->SleepRoomDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSleepRoomDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSleepRoomDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSleepRoomDetailForArrayConstraintsFromSetSleepRoomDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPSleepRoomInfoSleepRoomDetailItem) {
            // validation for constraint: itemType
            if (!$rFPSleepRoomInfoSleepRoomDetailItem instanceof \StructType\RFPSleepRoomDetail) {
                $invalidValues[] = is_object($rFPSleepRoomInfoSleepRoomDetailItem) ? get_class($rFPSleepRoomInfoSleepRoomDetailItem) : sprintf('%s(%s)', gettype($rFPSleepRoomInfoSleepRoomDetailItem), var_export($rFPSleepRoomInfoSleepRoomDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SleepRoomDetail property can only contain items of type \StructType\RFPSleepRoomDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SleepRoomDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPSleepRoomDetail[] $sleepRoomDetail
     * @return \StructType\RFPSleepRoomInfo
     */
    public function setSleepRoomDetail(array $sleepRoomDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($sleepRoomDetailArrayErrorMessage = self::validateSleepRoomDetailForArrayConstraintsFromSetSleepRoomDetail($sleepRoomDetail))) {
            throw new \InvalidArgumentException($sleepRoomDetailArrayErrorMessage, __LINE__);
        }
        $this->SleepRoomDetail = $sleepRoomDetail;
        return $this;
    }
    /**
     * Add item to SleepRoomDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPSleepRoomDetail $item
     * @return \StructType\RFPSleepRoomInfo
     */
    public function addToSleepRoomDetail(\StructType\RFPSleepRoomDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPSleepRoomDetail) {
            throw new \InvalidArgumentException(sprintf('The SleepRoomDetail property can only contain items of type \StructType\RFPSleepRoomDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SleepRoomDetail[] = $item;
        return $this;
    }
    /**
     * Get OccupancyPerRoomDetail value
     * @return \StructType\RFPOccupancyPerRoomDetail[]|null
     */
    public function getOccupancyPerRoomDetail()
    {
        return $this->OccupancyPerRoomDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setOccupancyPerRoomDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOccupancyPerRoomDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOccupancyPerRoomDetailForArrayConstraintsFromSetOccupancyPerRoomDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPSleepRoomInfoOccupancyPerRoomDetailItem) {
            // validation for constraint: itemType
            if (!$rFPSleepRoomInfoOccupancyPerRoomDetailItem instanceof \StructType\RFPOccupancyPerRoomDetail) {
                $invalidValues[] = is_object($rFPSleepRoomInfoOccupancyPerRoomDetailItem) ? get_class($rFPSleepRoomInfoOccupancyPerRoomDetailItem) : sprintf('%s(%s)', gettype($rFPSleepRoomInfoOccupancyPerRoomDetailItem), var_export($rFPSleepRoomInfoOccupancyPerRoomDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OccupancyPerRoomDetail property can only contain items of type \StructType\RFPOccupancyPerRoomDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OccupancyPerRoomDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPOccupancyPerRoomDetail[] $occupancyPerRoomDetail
     * @return \StructType\RFPSleepRoomInfo
     */
    public function setOccupancyPerRoomDetail(array $occupancyPerRoomDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($occupancyPerRoomDetailArrayErrorMessage = self::validateOccupancyPerRoomDetailForArrayConstraintsFromSetOccupancyPerRoomDetail($occupancyPerRoomDetail))) {
            throw new \InvalidArgumentException($occupancyPerRoomDetailArrayErrorMessage, __LINE__);
        }
        $this->OccupancyPerRoomDetail = $occupancyPerRoomDetail;
        return $this;
    }
    /**
     * Add item to OccupancyPerRoomDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPOccupancyPerRoomDetail $item
     * @return \StructType\RFPSleepRoomInfo
     */
    public function addToOccupancyPerRoomDetail(\StructType\RFPOccupancyPerRoomDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPOccupancyPerRoomDetail) {
            throw new \InvalidArgumentException(sprintf('The OccupancyPerRoomDetail property can only contain items of type \StructType\RFPOccupancyPerRoomDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OccupancyPerRoomDetail[] = $item;
        return $this;
    }
    /**
     * Get CheckInDate value
     * @return string|null
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \StructType\RFPSleepRoomInfo
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInDate, true), gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get BudgetedRoomRate value
     * @return float|null
     */
    public function getBudgetedRoomRate()
    {
        return $this->BudgetedRoomRate;
    }
    /**
     * Set BudgetedRoomRate value
     * @param float $budgetedRoomRate
     * @return \StructType\RFPSleepRoomInfo
     */
    public function setBudgetedRoomRate($budgetedRoomRate = null)
    {
        // validation for constraint: float
        if (!is_null($budgetedRoomRate) && !(is_float($budgetedRoomRate) || is_numeric($budgetedRoomRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($budgetedRoomRate, true), gettype($budgetedRoomRate)), __LINE__);
        }
        $this->BudgetedRoomRate = $budgetedRoomRate;
        return $this;
    }
    /**
     * Get SleepRoomAdditionalInformation value
     * @return string|null
     */
    public function getSleepRoomAdditionalInformation()
    {
        return $this->SleepRoomAdditionalInformation;
    }
    /**
     * Set SleepRoomAdditionalInformation value
     * @param string $sleepRoomAdditionalInformation
     * @return \StructType\RFPSleepRoomInfo
     */
    public function setSleepRoomAdditionalInformation($sleepRoomAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($sleepRoomAdditionalInformation) && !is_string($sleepRoomAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sleepRoomAdditionalInformation, true), gettype($sleepRoomAdditionalInformation)), __LINE__);
        }
        $this->SleepRoomAdditionalInformation = $sleepRoomAdditionalInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPSleepRoomInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
