<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPSleepRoomDetail StructType
 * @subpackage Structs
 */
class RFPSleepRoomDetail extends AbstractStructBase
{
    /**
     * The DayNumber
     * @var int
     */
    public $DayNumber;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The AnyRoomQuantity
     * @var int
     */
    public $AnyRoomQuantity;
    /**
     * The SingleRoomQuantity
     * @var int
     */
    public $SingleRoomQuantity;
    /**
     * The DoubleRoomQuantity
     * @var int
     */
    public $DoubleRoomQuantity;
    /**
     * The SuiteQuantity
     * @var int
     */
    public $SuiteQuantity;
    /**
     * The SleepRoomNote
     * @var string
     */
    public $SleepRoomNote;
    /**
     * The StaffRoomQuantity
     * @var int
     */
    public $StaffRoomQuantity;
    /**
     * Constructor method for RFPSleepRoomDetail
     * @uses RFPSleepRoomDetail::setDayNumber()
     * @uses RFPSleepRoomDetail::setDate()
     * @uses RFPSleepRoomDetail::setAnyRoomQuantity()
     * @uses RFPSleepRoomDetail::setSingleRoomQuantity()
     * @uses RFPSleepRoomDetail::setDoubleRoomQuantity()
     * @uses RFPSleepRoomDetail::setSuiteQuantity()
     * @uses RFPSleepRoomDetail::setSleepRoomNote()
     * @uses RFPSleepRoomDetail::setStaffRoomQuantity()
     * @param int $dayNumber
     * @param string $date
     * @param int $anyRoomQuantity
     * @param int $singleRoomQuantity
     * @param int $doubleRoomQuantity
     * @param int $suiteQuantity
     * @param string $sleepRoomNote
     * @param int $staffRoomQuantity
     */
    public function __construct($dayNumber = null, $date = null, $anyRoomQuantity = null, $singleRoomQuantity = null, $doubleRoomQuantity = null, $suiteQuantity = null, $sleepRoomNote = null, $staffRoomQuantity = null)
    {
        $this
            ->setDayNumber($dayNumber)
            ->setDate($date)
            ->setAnyRoomQuantity($anyRoomQuantity)
            ->setSingleRoomQuantity($singleRoomQuantity)
            ->setDoubleRoomQuantity($doubleRoomQuantity)
            ->setSuiteQuantity($suiteQuantity)
            ->setSleepRoomNote($sleepRoomNote)
            ->setStaffRoomQuantity($staffRoomQuantity);
    }
    /**
     * Get DayNumber value
     * @return int|null
     */
    public function getDayNumber()
    {
        return $this->DayNumber;
    }
    /**
     * Set DayNumber value
     * @param int $dayNumber
     * @return \StructType\RFPSleepRoomDetail
     */
    public function setDayNumber($dayNumber = null)
    {
        // validation for constraint: int
        if (!is_null($dayNumber) && !(is_int($dayNumber) || ctype_digit($dayNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dayNumber, true), gettype($dayNumber)), __LINE__);
        }
        $this->DayNumber = $dayNumber;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\RFPSleepRoomDetail
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get AnyRoomQuantity value
     * @return int|null
     */
    public function getAnyRoomQuantity()
    {
        return $this->AnyRoomQuantity;
    }
    /**
     * Set AnyRoomQuantity value
     * @param int $anyRoomQuantity
     * @return \StructType\RFPSleepRoomDetail
     */
    public function setAnyRoomQuantity($anyRoomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($anyRoomQuantity) && !(is_int($anyRoomQuantity) || ctype_digit($anyRoomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anyRoomQuantity, true), gettype($anyRoomQuantity)), __LINE__);
        }
        $this->AnyRoomQuantity = $anyRoomQuantity;
        return $this;
    }
    /**
     * Get SingleRoomQuantity value
     * @return int|null
     */
    public function getSingleRoomQuantity()
    {
        return $this->SingleRoomQuantity;
    }
    /**
     * Set SingleRoomQuantity value
     * @param int $singleRoomQuantity
     * @return \StructType\RFPSleepRoomDetail
     */
    public function setSingleRoomQuantity($singleRoomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($singleRoomQuantity) && !(is_int($singleRoomQuantity) || ctype_digit($singleRoomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($singleRoomQuantity, true), gettype($singleRoomQuantity)), __LINE__);
        }
        $this->SingleRoomQuantity = $singleRoomQuantity;
        return $this;
    }
    /**
     * Get DoubleRoomQuantity value
     * @return int|null
     */
    public function getDoubleRoomQuantity()
    {
        return $this->DoubleRoomQuantity;
    }
    /**
     * Set DoubleRoomQuantity value
     * @param int $doubleRoomQuantity
     * @return \StructType\RFPSleepRoomDetail
     */
    public function setDoubleRoomQuantity($doubleRoomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($doubleRoomQuantity) && !(is_int($doubleRoomQuantity) || ctype_digit($doubleRoomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doubleRoomQuantity, true), gettype($doubleRoomQuantity)), __LINE__);
        }
        $this->DoubleRoomQuantity = $doubleRoomQuantity;
        return $this;
    }
    /**
     * Get SuiteQuantity value
     * @return int|null
     */
    public function getSuiteQuantity()
    {
        return $this->SuiteQuantity;
    }
    /**
     * Set SuiteQuantity value
     * @param int $suiteQuantity
     * @return \StructType\RFPSleepRoomDetail
     */
    public function setSuiteQuantity($suiteQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($suiteQuantity) && !(is_int($suiteQuantity) || ctype_digit($suiteQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($suiteQuantity, true), gettype($suiteQuantity)), __LINE__);
        }
        $this->SuiteQuantity = $suiteQuantity;
        return $this;
    }
    /**
     * Get SleepRoomNote value
     * @return string|null
     */
    public function getSleepRoomNote()
    {
        return $this->SleepRoomNote;
    }
    /**
     * Set SleepRoomNote value
     * @param string $sleepRoomNote
     * @return \StructType\RFPSleepRoomDetail
     */
    public function setSleepRoomNote($sleepRoomNote = null)
    {
        // validation for constraint: string
        if (!is_null($sleepRoomNote) && !is_string($sleepRoomNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sleepRoomNote, true), gettype($sleepRoomNote)), __LINE__);
        }
        $this->SleepRoomNote = $sleepRoomNote;
        return $this;
    }
    /**
     * Get StaffRoomQuantity value
     * @return int|null
     */
    public function getStaffRoomQuantity()
    {
        return $this->StaffRoomQuantity;
    }
    /**
     * Set StaffRoomQuantity value
     * @param int $staffRoomQuantity
     * @return \StructType\RFPSleepRoomDetail
     */
    public function setStaffRoomQuantity($staffRoomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($staffRoomQuantity) && !(is_int($staffRoomQuantity) || ctype_digit($staffRoomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($staffRoomQuantity, true), gettype($staffRoomQuantity)), __LINE__);
        }
        $this->StaffRoomQuantity = $staffRoomQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPSleepRoomDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
