<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPRequestInfoMeetingRoomAvailabilityDetail StructType
 * @subpackage Structs
 */
class RFPRequestInfoMeetingRoomAvailabilityDetail extends AbstractStructBase
{
    /**
     * The DayNumber
     * @var int
     */
    public $DayNumber;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * @var string
     */
    public $EndTime;
    /**
     * The AgendaItem
     * @var string
     */
    public $AgendaItem;
    /**
     * The AgendaItemType
     * @var string
     */
    public $AgendaItemType;
    /**
     * The SetupType
     * @var string
     */
    public $SetupType;
    /**
     * The RoomSize
     * @var int
     */
    public $RoomSize;
    /**
     * The NumberOfPeople
     * @var int
     */
    public $NumberOfPeople;
    /**
     * The TwentyFourHourHold
     * @var bool
     */
    public $TwentyFourHourHold;
    /**
     * The MeetingRoomAdditionalInfo
     * @var string
     */
    public $MeetingRoomAdditionalInfo;
    /**
     * Constructor method for RFPRequestInfoMeetingRoomAvailabilityDetail
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setDayNumber()
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setStartTime()
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setEndTime()
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setAgendaItem()
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setAgendaItemType()
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setSetupType()
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setRoomSize()
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setNumberOfPeople()
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setTwentyFourHourHold()
     * @uses RFPRequestInfoMeetingRoomAvailabilityDetail::setMeetingRoomAdditionalInfo()
     * @param int $dayNumber
     * @param string $startTime
     * @param string $endTime
     * @param string $agendaItem
     * @param string $agendaItemType
     * @param string $setupType
     * @param int $roomSize
     * @param int $numberOfPeople
     * @param bool $twentyFourHourHold
     * @param string $meetingRoomAdditionalInfo
     */
    public function __construct($dayNumber = null, $startTime = null, $endTime = null, $agendaItem = null, $agendaItemType = null, $setupType = null, $roomSize = null, $numberOfPeople = null, $twentyFourHourHold = null, $meetingRoomAdditionalInfo = null)
    {
        $this
            ->setDayNumber($dayNumber)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setAgendaItem($agendaItem)
            ->setAgendaItemType($agendaItemType)
            ->setSetupType($setupType)
            ->setRoomSize($roomSize)
            ->setNumberOfPeople($numberOfPeople)
            ->setTwentyFourHourHold($twentyFourHourHold)
            ->setMeetingRoomAdditionalInfo($meetingRoomAdditionalInfo);
    }
    /**
     * Get DayNumber value
     * @return int|null
     */
    public function getDayNumber()
    {
        return $this->DayNumber;
    }
    /**
     * Set DayNumber value
     * @param int $dayNumber
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setDayNumber($dayNumber = null)
    {
        // validation for constraint: int
        if (!is_null($dayNumber) && !(is_int($dayNumber) || ctype_digit($dayNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dayNumber, true), gettype($dayNumber)), __LINE__);
        }
        $this->DayNumber = $dayNumber;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get AgendaItem value
     * @return string|null
     */
    public function getAgendaItem()
    {
        return $this->AgendaItem;
    }
    /**
     * Set AgendaItem value
     * @param string $agendaItem
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setAgendaItem($agendaItem = null)
    {
        // validation for constraint: string
        if (!is_null($agendaItem) && !is_string($agendaItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agendaItem, true), gettype($agendaItem)), __LINE__);
        }
        $this->AgendaItem = $agendaItem;
        return $this;
    }
    /**
     * Get AgendaItemType value
     * @return string|null
     */
    public function getAgendaItemType()
    {
        return $this->AgendaItemType;
    }
    /**
     * Set AgendaItemType value
     * @param string $agendaItemType
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setAgendaItemType($agendaItemType = null)
    {
        // validation for constraint: string
        if (!is_null($agendaItemType) && !is_string($agendaItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agendaItemType, true), gettype($agendaItemType)), __LINE__);
        }
        $this->AgendaItemType = $agendaItemType;
        return $this;
    }
    /**
     * Get SetupType value
     * @return string|null
     */
    public function getSetupType()
    {
        return $this->SetupType;
    }
    /**
     * Set SetupType value
     * @param string $setupType
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setSetupType($setupType = null)
    {
        // validation for constraint: string
        if (!is_null($setupType) && !is_string($setupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($setupType, true), gettype($setupType)), __LINE__);
        }
        $this->SetupType = $setupType;
        return $this;
    }
    /**
     * Get RoomSize value
     * @return int|null
     */
    public function getRoomSize()
    {
        return $this->RoomSize;
    }
    /**
     * Set RoomSize value
     * @param int $roomSize
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setRoomSize($roomSize = null)
    {
        // validation for constraint: int
        if (!is_null($roomSize) && !(is_int($roomSize) || ctype_digit($roomSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomSize, true), gettype($roomSize)), __LINE__);
        }
        $this->RoomSize = $roomSize;
        return $this;
    }
    /**
     * Get NumberOfPeople value
     * @return int|null
     */
    public function getNumberOfPeople()
    {
        return $this->NumberOfPeople;
    }
    /**
     * Set NumberOfPeople value
     * @param int $numberOfPeople
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setNumberOfPeople($numberOfPeople = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPeople) && !(is_int($numberOfPeople) || ctype_digit($numberOfPeople))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPeople, true), gettype($numberOfPeople)), __LINE__);
        }
        $this->NumberOfPeople = $numberOfPeople;
        return $this;
    }
    /**
     * Get TwentyFourHourHold value
     * @return bool|null
     */
    public function getTwentyFourHourHold()
    {
        return $this->TwentyFourHourHold;
    }
    /**
     * Set TwentyFourHourHold value
     * @param bool $twentyFourHourHold
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setTwentyFourHourHold($twentyFourHourHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($twentyFourHourHold) && !is_bool($twentyFourHourHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($twentyFourHourHold, true), gettype($twentyFourHourHold)), __LINE__);
        }
        $this->TwentyFourHourHold = $twentyFourHourHold;
        return $this;
    }
    /**
     * Get MeetingRoomAdditionalInfo value
     * @return string|null
     */
    public function getMeetingRoomAdditionalInfo()
    {
        return $this->MeetingRoomAdditionalInfo;
    }
    /**
     * Set MeetingRoomAdditionalInfo value
     * @param string $meetingRoomAdditionalInfo
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public function setMeetingRoomAdditionalInfo($meetingRoomAdditionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomAdditionalInfo) && !is_string($meetingRoomAdditionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomAdditionalInfo, true), gettype($meetingRoomAdditionalInfo)), __LINE__);
        }
        $this->MeetingRoomAdditionalInfo = $meetingRoomAdditionalInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
