<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPRequestInfo StructType
 * @subpackage Structs
 */
class RFPRequestInfo extends AbstractStructBase
{
    /**
     * The MeetingRoomAvailabilityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail[]
     */
    public $MeetingRoomAvailabilityDetail;
    /**
     * The SleepingRoomAvailabilityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPRequestInfoSleepingRoomAvailabilityDetail[]
     */
    public $SleepingRoomAvailabilityDetail;
    /**
     * The ExpectedAttendees
     * @var int
     */
    public $ExpectedAttendees;
    /**
     * The AlternateStartDate1
     * @var string
     */
    public $AlternateStartDate1;
    /**
     * The AlternateEndDate1
     * @var string
     */
    public $AlternateEndDate1;
    /**
     * The AlternateDate1Note
     * @var string
     */
    public $AlternateDate1Note;
    /**
     * The AlternateStartDate2
     * @var string
     */
    public $AlternateStartDate2;
    /**
     * The AlternateEndDate2
     * @var string
     */
    public $AlternateEndDate2;
    /**
     * The AlternateDate2Note
     * @var string
     */
    public $AlternateDate2Note;
    /**
     * The TotalMeetingSpace
     * @var string
     */
    public $TotalMeetingSpace;
    /**
     * The LargestMeetingRoom
     * @var string
     */
    public $LargestMeetingRoom;
    /**
     * The BusinessObjectives
     * @var string
     */
    public $BusinessObjectives;
    /**
     * The DestinationsUnderConsideration
     * @var string
     */
    public $DestinationsUnderConsideration;
    /**
     * The BudgetedRoomRate
     * @var float
     */
    public $BudgetedRoomRate;
    /**
     * The SleepRoomAdditionalInfo
     * @var string
     */
    public $SleepRoomAdditionalInfo;
    /**
     * The TotalMeetingRoomsNeeded
     * @var int
     */
    public $TotalMeetingRoomsNeeded;
    /**
     * The MeetingRoomAdditionalInfo
     * @var string
     */
    public $MeetingRoomAdditionalInfo;
    /**
     * The ConcessionAndContractual
     * @var string
     */
    public $ConcessionAndContractual;
    /**
     * The DecisionDate
     * @var string
     */
    public $DecisionDate;
    /**
     * The ResponseDueDate
     * @var string
     */
    public $ResponseDueDate;
    /**
     * The AVNeeds
     * @var string
     */
    public $AVNeeds;
    /**
     * The AttendeesPerDay
     * @var int
     */
    public $AttendeesPerDay;
    /**
     * The EventType
     * @var string
     */
    public $EventType;
    /**
     * The ContractSignatureLocation
     * @var string
     */
    public $ContractSignatureLocation;
    /**
     * The TotalBudget
     * @var float
     */
    public $TotalBudget;
    /**
     * The EventDetailsAdditionalInformation
     * @var string
     */
    public $EventDetailsAdditionalInformation;
    /**
     * The FandBBudget
     * @var float
     */
    public $FandBBudget;
    /**
     * The BillingInformation
     * @var string
     */
    public $BillingInformation;
    /**
     * Constructor method for RFPRequestInfo
     * @uses RFPRequestInfo::setMeetingRoomAvailabilityDetail()
     * @uses RFPRequestInfo::setSleepingRoomAvailabilityDetail()
     * @uses RFPRequestInfo::setExpectedAttendees()
     * @uses RFPRequestInfo::setAlternateStartDate1()
     * @uses RFPRequestInfo::setAlternateEndDate1()
     * @uses RFPRequestInfo::setAlternateDate1Note()
     * @uses RFPRequestInfo::setAlternateStartDate2()
     * @uses RFPRequestInfo::setAlternateEndDate2()
     * @uses RFPRequestInfo::setAlternateDate2Note()
     * @uses RFPRequestInfo::setTotalMeetingSpace()
     * @uses RFPRequestInfo::setLargestMeetingRoom()
     * @uses RFPRequestInfo::setBusinessObjectives()
     * @uses RFPRequestInfo::setDestinationsUnderConsideration()
     * @uses RFPRequestInfo::setBudgetedRoomRate()
     * @uses RFPRequestInfo::setSleepRoomAdditionalInfo()
     * @uses RFPRequestInfo::setTotalMeetingRoomsNeeded()
     * @uses RFPRequestInfo::setMeetingRoomAdditionalInfo()
     * @uses RFPRequestInfo::setConcessionAndContractual()
     * @uses RFPRequestInfo::setDecisionDate()
     * @uses RFPRequestInfo::setResponseDueDate()
     * @uses RFPRequestInfo::setAVNeeds()
     * @uses RFPRequestInfo::setAttendeesPerDay()
     * @uses RFPRequestInfo::setEventType()
     * @uses RFPRequestInfo::setContractSignatureLocation()
     * @uses RFPRequestInfo::setTotalBudget()
     * @uses RFPRequestInfo::setEventDetailsAdditionalInformation()
     * @uses RFPRequestInfo::setFandBBudget()
     * @uses RFPRequestInfo::setBillingInformation()
     * @param \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail[] $meetingRoomAvailabilityDetail
     * @param \StructType\RFPRequestInfoSleepingRoomAvailabilityDetail[] $sleepingRoomAvailabilityDetail
     * @param int $expectedAttendees
     * @param string $alternateStartDate1
     * @param string $alternateEndDate1
     * @param string $alternateDate1Note
     * @param string $alternateStartDate2
     * @param string $alternateEndDate2
     * @param string $alternateDate2Note
     * @param string $totalMeetingSpace
     * @param string $largestMeetingRoom
     * @param string $businessObjectives
     * @param string $destinationsUnderConsideration
     * @param float $budgetedRoomRate
     * @param string $sleepRoomAdditionalInfo
     * @param int $totalMeetingRoomsNeeded
     * @param string $meetingRoomAdditionalInfo
     * @param string $concessionAndContractual
     * @param string $decisionDate
     * @param string $responseDueDate
     * @param string $aVNeeds
     * @param int $attendeesPerDay
     * @param string $eventType
     * @param string $contractSignatureLocation
     * @param float $totalBudget
     * @param string $eventDetailsAdditionalInformation
     * @param float $fandBBudget
     * @param string $billingInformation
     */
    public function __construct(array $meetingRoomAvailabilityDetail = array(), array $sleepingRoomAvailabilityDetail = array(), $expectedAttendees = null, $alternateStartDate1 = null, $alternateEndDate1 = null, $alternateDate1Note = null, $alternateStartDate2 = null, $alternateEndDate2 = null, $alternateDate2Note = null, $totalMeetingSpace = null, $largestMeetingRoom = null, $businessObjectives = null, $destinationsUnderConsideration = null, $budgetedRoomRate = null, $sleepRoomAdditionalInfo = null, $totalMeetingRoomsNeeded = null, $meetingRoomAdditionalInfo = null, $concessionAndContractual = null, $decisionDate = null, $responseDueDate = null, $aVNeeds = null, $attendeesPerDay = null, $eventType = null, $contractSignatureLocation = null, $totalBudget = null, $eventDetailsAdditionalInformation = null, $fandBBudget = null, $billingInformation = null)
    {
        $this
            ->setMeetingRoomAvailabilityDetail($meetingRoomAvailabilityDetail)
            ->setSleepingRoomAvailabilityDetail($sleepingRoomAvailabilityDetail)
            ->setExpectedAttendees($expectedAttendees)
            ->setAlternateStartDate1($alternateStartDate1)
            ->setAlternateEndDate1($alternateEndDate1)
            ->setAlternateDate1Note($alternateDate1Note)
            ->setAlternateStartDate2($alternateStartDate2)
            ->setAlternateEndDate2($alternateEndDate2)
            ->setAlternateDate2Note($alternateDate2Note)
            ->setTotalMeetingSpace($totalMeetingSpace)
            ->setLargestMeetingRoom($largestMeetingRoom)
            ->setBusinessObjectives($businessObjectives)
            ->setDestinationsUnderConsideration($destinationsUnderConsideration)
            ->setBudgetedRoomRate($budgetedRoomRate)
            ->setSleepRoomAdditionalInfo($sleepRoomAdditionalInfo)
            ->setTotalMeetingRoomsNeeded($totalMeetingRoomsNeeded)
            ->setMeetingRoomAdditionalInfo($meetingRoomAdditionalInfo)
            ->setConcessionAndContractual($concessionAndContractual)
            ->setDecisionDate($decisionDate)
            ->setResponseDueDate($responseDueDate)
            ->setAVNeeds($aVNeeds)
            ->setAttendeesPerDay($attendeesPerDay)
            ->setEventType($eventType)
            ->setContractSignatureLocation($contractSignatureLocation)
            ->setTotalBudget($totalBudget)
            ->setEventDetailsAdditionalInformation($eventDetailsAdditionalInformation)
            ->setFandBBudget($fandBBudget)
            ->setBillingInformation($billingInformation);
    }
    /**
     * Get MeetingRoomAvailabilityDetail value
     * @return \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail[]|null
     */
    public function getMeetingRoomAvailabilityDetail()
    {
        return $this->MeetingRoomAvailabilityDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setMeetingRoomAvailabilityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeetingRoomAvailabilityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeetingRoomAvailabilityDetailForArrayConstraintsFromSetMeetingRoomAvailabilityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPRequestInfoMeetingRoomAvailabilityDetailItem) {
            // validation for constraint: itemType
            if (!$rFPRequestInfoMeetingRoomAvailabilityDetailItem instanceof \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail) {
                $invalidValues[] = is_object($rFPRequestInfoMeetingRoomAvailabilityDetailItem) ? get_class($rFPRequestInfoMeetingRoomAvailabilityDetailItem) : sprintf('%s(%s)', gettype($rFPRequestInfoMeetingRoomAvailabilityDetailItem), var_export($rFPRequestInfoMeetingRoomAvailabilityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeetingRoomAvailabilityDetail property can only contain items of type \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeetingRoomAvailabilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail[] $meetingRoomAvailabilityDetail
     * @return \StructType\RFPRequestInfo
     */
    public function setMeetingRoomAvailabilityDetail(array $meetingRoomAvailabilityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($meetingRoomAvailabilityDetailArrayErrorMessage = self::validateMeetingRoomAvailabilityDetailForArrayConstraintsFromSetMeetingRoomAvailabilityDetail($meetingRoomAvailabilityDetail))) {
            throw new \InvalidArgumentException($meetingRoomAvailabilityDetailArrayErrorMessage, __LINE__);
        }
        $this->MeetingRoomAvailabilityDetail = $meetingRoomAvailabilityDetail;
        return $this;
    }
    /**
     * Add item to MeetingRoomAvailabilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail $item
     * @return \StructType\RFPRequestInfo
     */
    public function addToMeetingRoomAvailabilityDetail(\StructType\RFPRequestInfoMeetingRoomAvailabilityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail) {
            throw new \InvalidArgumentException(sprintf('The MeetingRoomAvailabilityDetail property can only contain items of type \StructType\RFPRequestInfoMeetingRoomAvailabilityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeetingRoomAvailabilityDetail[] = $item;
        return $this;
    }
    /**
     * Get SleepingRoomAvailabilityDetail value
     * @return \StructType\RFPRequestInfoSleepingRoomAvailabilityDetail[]|null
     */
    public function getSleepingRoomAvailabilityDetail()
    {
        return $this->SleepingRoomAvailabilityDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSleepingRoomAvailabilityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSleepingRoomAvailabilityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSleepingRoomAvailabilityDetailForArrayConstraintsFromSetSleepingRoomAvailabilityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPRequestInfoSleepingRoomAvailabilityDetailItem) {
            // validation for constraint: itemType
            if (!$rFPRequestInfoSleepingRoomAvailabilityDetailItem instanceof \StructType\RFPRequestInfoSleepingRoomAvailabilityDetail) {
                $invalidValues[] = is_object($rFPRequestInfoSleepingRoomAvailabilityDetailItem) ? get_class($rFPRequestInfoSleepingRoomAvailabilityDetailItem) : sprintf('%s(%s)', gettype($rFPRequestInfoSleepingRoomAvailabilityDetailItem), var_export($rFPRequestInfoSleepingRoomAvailabilityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SleepingRoomAvailabilityDetail property can only contain items of type \StructType\RFPRequestInfoSleepingRoomAvailabilityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SleepingRoomAvailabilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPRequestInfoSleepingRoomAvailabilityDetail[] $sleepingRoomAvailabilityDetail
     * @return \StructType\RFPRequestInfo
     */
    public function setSleepingRoomAvailabilityDetail(array $sleepingRoomAvailabilityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($sleepingRoomAvailabilityDetailArrayErrorMessage = self::validateSleepingRoomAvailabilityDetailForArrayConstraintsFromSetSleepingRoomAvailabilityDetail($sleepingRoomAvailabilityDetail))) {
            throw new \InvalidArgumentException($sleepingRoomAvailabilityDetailArrayErrorMessage, __LINE__);
        }
        $this->SleepingRoomAvailabilityDetail = $sleepingRoomAvailabilityDetail;
        return $this;
    }
    /**
     * Add item to SleepingRoomAvailabilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPRequestInfoSleepingRoomAvailabilityDetail $item
     * @return \StructType\RFPRequestInfo
     */
    public function addToSleepingRoomAvailabilityDetail(\StructType\RFPRequestInfoSleepingRoomAvailabilityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPRequestInfoSleepingRoomAvailabilityDetail) {
            throw new \InvalidArgumentException(sprintf('The SleepingRoomAvailabilityDetail property can only contain items of type \StructType\RFPRequestInfoSleepingRoomAvailabilityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SleepingRoomAvailabilityDetail[] = $item;
        return $this;
    }
    /**
     * Get ExpectedAttendees value
     * @return int|null
     */
    public function getExpectedAttendees()
    {
        return $this->ExpectedAttendees;
    }
    /**
     * Set ExpectedAttendees value
     * @param int $expectedAttendees
     * @return \StructType\RFPRequestInfo
     */
    public function setExpectedAttendees($expectedAttendees = null)
    {
        // validation for constraint: int
        if (!is_null($expectedAttendees) && !(is_int($expectedAttendees) || ctype_digit($expectedAttendees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expectedAttendees, true), gettype($expectedAttendees)), __LINE__);
        }
        $this->ExpectedAttendees = $expectedAttendees;
        return $this;
    }
    /**
     * Get AlternateStartDate1 value
     * @return string|null
     */
    public function getAlternateStartDate1()
    {
        return $this->AlternateStartDate1;
    }
    /**
     * Set AlternateStartDate1 value
     * @param string $alternateStartDate1
     * @return \StructType\RFPRequestInfo
     */
    public function setAlternateStartDate1($alternateStartDate1 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateStartDate1) && !is_string($alternateStartDate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateStartDate1, true), gettype($alternateStartDate1)), __LINE__);
        }
        $this->AlternateStartDate1 = $alternateStartDate1;
        return $this;
    }
    /**
     * Get AlternateEndDate1 value
     * @return string|null
     */
    public function getAlternateEndDate1()
    {
        return $this->AlternateEndDate1;
    }
    /**
     * Set AlternateEndDate1 value
     * @param string $alternateEndDate1
     * @return \StructType\RFPRequestInfo
     */
    public function setAlternateEndDate1($alternateEndDate1 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateEndDate1) && !is_string($alternateEndDate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateEndDate1, true), gettype($alternateEndDate1)), __LINE__);
        }
        $this->AlternateEndDate1 = $alternateEndDate1;
        return $this;
    }
    /**
     * Get AlternateDate1Note value
     * @return string|null
     */
    public function getAlternateDate1Note()
    {
        return $this->AlternateDate1Note;
    }
    /**
     * Set AlternateDate1Note value
     * @param string $alternateDate1Note
     * @return \StructType\RFPRequestInfo
     */
    public function setAlternateDate1Note($alternateDate1Note = null)
    {
        // validation for constraint: string
        if (!is_null($alternateDate1Note) && !is_string($alternateDate1Note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateDate1Note, true), gettype($alternateDate1Note)), __LINE__);
        }
        $this->AlternateDate1Note = $alternateDate1Note;
        return $this;
    }
    /**
     * Get AlternateStartDate2 value
     * @return string|null
     */
    public function getAlternateStartDate2()
    {
        return $this->AlternateStartDate2;
    }
    /**
     * Set AlternateStartDate2 value
     * @param string $alternateStartDate2
     * @return \StructType\RFPRequestInfo
     */
    public function setAlternateStartDate2($alternateStartDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateStartDate2) && !is_string($alternateStartDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateStartDate2, true), gettype($alternateStartDate2)), __LINE__);
        }
        $this->AlternateStartDate2 = $alternateStartDate2;
        return $this;
    }
    /**
     * Get AlternateEndDate2 value
     * @return string|null
     */
    public function getAlternateEndDate2()
    {
        return $this->AlternateEndDate2;
    }
    /**
     * Set AlternateEndDate2 value
     * @param string $alternateEndDate2
     * @return \StructType\RFPRequestInfo
     */
    public function setAlternateEndDate2($alternateEndDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateEndDate2) && !is_string($alternateEndDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateEndDate2, true), gettype($alternateEndDate2)), __LINE__);
        }
        $this->AlternateEndDate2 = $alternateEndDate2;
        return $this;
    }
    /**
     * Get AlternateDate2Note value
     * @return string|null
     */
    public function getAlternateDate2Note()
    {
        return $this->AlternateDate2Note;
    }
    /**
     * Set AlternateDate2Note value
     * @param string $alternateDate2Note
     * @return \StructType\RFPRequestInfo
     */
    public function setAlternateDate2Note($alternateDate2Note = null)
    {
        // validation for constraint: string
        if (!is_null($alternateDate2Note) && !is_string($alternateDate2Note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateDate2Note, true), gettype($alternateDate2Note)), __LINE__);
        }
        $this->AlternateDate2Note = $alternateDate2Note;
        return $this;
    }
    /**
     * Get TotalMeetingSpace value
     * @return string|null
     */
    public function getTotalMeetingSpace()
    {
        return $this->TotalMeetingSpace;
    }
    /**
     * Set TotalMeetingSpace value
     * @param string $totalMeetingSpace
     * @return \StructType\RFPRequestInfo
     */
    public function setTotalMeetingSpace($totalMeetingSpace = null)
    {
        // validation for constraint: string
        if (!is_null($totalMeetingSpace) && !is_string($totalMeetingSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalMeetingSpace, true), gettype($totalMeetingSpace)), __LINE__);
        }
        $this->TotalMeetingSpace = $totalMeetingSpace;
        return $this;
    }
    /**
     * Get LargestMeetingRoom value
     * @return string|null
     */
    public function getLargestMeetingRoom()
    {
        return $this->LargestMeetingRoom;
    }
    /**
     * Set LargestMeetingRoom value
     * @param string $largestMeetingRoom
     * @return \StructType\RFPRequestInfo
     */
    public function setLargestMeetingRoom($largestMeetingRoom = null)
    {
        // validation for constraint: string
        if (!is_null($largestMeetingRoom) && !is_string($largestMeetingRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($largestMeetingRoom, true), gettype($largestMeetingRoom)), __LINE__);
        }
        $this->LargestMeetingRoom = $largestMeetingRoom;
        return $this;
    }
    /**
     * Get BusinessObjectives value
     * @return string|null
     */
    public function getBusinessObjectives()
    {
        return $this->BusinessObjectives;
    }
    /**
     * Set BusinessObjectives value
     * @param string $businessObjectives
     * @return \StructType\RFPRequestInfo
     */
    public function setBusinessObjectives($businessObjectives = null)
    {
        // validation for constraint: string
        if (!is_null($businessObjectives) && !is_string($businessObjectives)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessObjectives, true), gettype($businessObjectives)), __LINE__);
        }
        $this->BusinessObjectives = $businessObjectives;
        return $this;
    }
    /**
     * Get DestinationsUnderConsideration value
     * @return string|null
     */
    public function getDestinationsUnderConsideration()
    {
        return $this->DestinationsUnderConsideration;
    }
    /**
     * Set DestinationsUnderConsideration value
     * @param string $destinationsUnderConsideration
     * @return \StructType\RFPRequestInfo
     */
    public function setDestinationsUnderConsideration($destinationsUnderConsideration = null)
    {
        // validation for constraint: string
        if (!is_null($destinationsUnderConsideration) && !is_string($destinationsUnderConsideration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationsUnderConsideration, true), gettype($destinationsUnderConsideration)), __LINE__);
        }
        $this->DestinationsUnderConsideration = $destinationsUnderConsideration;
        return $this;
    }
    /**
     * Get BudgetedRoomRate value
     * @return float|null
     */
    public function getBudgetedRoomRate()
    {
        return $this->BudgetedRoomRate;
    }
    /**
     * Set BudgetedRoomRate value
     * @param float $budgetedRoomRate
     * @return \StructType\RFPRequestInfo
     */
    public function setBudgetedRoomRate($budgetedRoomRate = null)
    {
        // validation for constraint: float
        if (!is_null($budgetedRoomRate) && !(is_float($budgetedRoomRate) || is_numeric($budgetedRoomRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($budgetedRoomRate, true), gettype($budgetedRoomRate)), __LINE__);
        }
        $this->BudgetedRoomRate = $budgetedRoomRate;
        return $this;
    }
    /**
     * Get SleepRoomAdditionalInfo value
     * @return string|null
     */
    public function getSleepRoomAdditionalInfo()
    {
        return $this->SleepRoomAdditionalInfo;
    }
    /**
     * Set SleepRoomAdditionalInfo value
     * @param string $sleepRoomAdditionalInfo
     * @return \StructType\RFPRequestInfo
     */
    public function setSleepRoomAdditionalInfo($sleepRoomAdditionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($sleepRoomAdditionalInfo) && !is_string($sleepRoomAdditionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sleepRoomAdditionalInfo, true), gettype($sleepRoomAdditionalInfo)), __LINE__);
        }
        $this->SleepRoomAdditionalInfo = $sleepRoomAdditionalInfo;
        return $this;
    }
    /**
     * Get TotalMeetingRoomsNeeded value
     * @return int|null
     */
    public function getTotalMeetingRoomsNeeded()
    {
        return $this->TotalMeetingRoomsNeeded;
    }
    /**
     * Set TotalMeetingRoomsNeeded value
     * @param int $totalMeetingRoomsNeeded
     * @return \StructType\RFPRequestInfo
     */
    public function setTotalMeetingRoomsNeeded($totalMeetingRoomsNeeded = null)
    {
        // validation for constraint: int
        if (!is_null($totalMeetingRoomsNeeded) && !(is_int($totalMeetingRoomsNeeded) || ctype_digit($totalMeetingRoomsNeeded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMeetingRoomsNeeded, true), gettype($totalMeetingRoomsNeeded)), __LINE__);
        }
        $this->TotalMeetingRoomsNeeded = $totalMeetingRoomsNeeded;
        return $this;
    }
    /**
     * Get MeetingRoomAdditionalInfo value
     * @return string|null
     */
    public function getMeetingRoomAdditionalInfo()
    {
        return $this->MeetingRoomAdditionalInfo;
    }
    /**
     * Set MeetingRoomAdditionalInfo value
     * @param string $meetingRoomAdditionalInfo
     * @return \StructType\RFPRequestInfo
     */
    public function setMeetingRoomAdditionalInfo($meetingRoomAdditionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomAdditionalInfo) && !is_string($meetingRoomAdditionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomAdditionalInfo, true), gettype($meetingRoomAdditionalInfo)), __LINE__);
        }
        $this->MeetingRoomAdditionalInfo = $meetingRoomAdditionalInfo;
        return $this;
    }
    /**
     * Get ConcessionAndContractual value
     * @return string|null
     */
    public function getConcessionAndContractual()
    {
        return $this->ConcessionAndContractual;
    }
    /**
     * Set ConcessionAndContractual value
     * @param string $concessionAndContractual
     * @return \StructType\RFPRequestInfo
     */
    public function setConcessionAndContractual($concessionAndContractual = null)
    {
        // validation for constraint: string
        if (!is_null($concessionAndContractual) && !is_string($concessionAndContractual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($concessionAndContractual, true), gettype($concessionAndContractual)), __LINE__);
        }
        $this->ConcessionAndContractual = $concessionAndContractual;
        return $this;
    }
    /**
     * Get DecisionDate value
     * @return string|null
     */
    public function getDecisionDate()
    {
        return $this->DecisionDate;
    }
    /**
     * Set DecisionDate value
     * @param string $decisionDate
     * @return \StructType\RFPRequestInfo
     */
    public function setDecisionDate($decisionDate = null)
    {
        // validation for constraint: string
        if (!is_null($decisionDate) && !is_string($decisionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decisionDate, true), gettype($decisionDate)), __LINE__);
        }
        $this->DecisionDate = $decisionDate;
        return $this;
    }
    /**
     * Get ResponseDueDate value
     * @return string|null
     */
    public function getResponseDueDate()
    {
        return $this->ResponseDueDate;
    }
    /**
     * Set ResponseDueDate value
     * @param string $responseDueDate
     * @return \StructType\RFPRequestInfo
     */
    public function setResponseDueDate($responseDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($responseDueDate) && !is_string($responseDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDueDate, true), gettype($responseDueDate)), __LINE__);
        }
        $this->ResponseDueDate = $responseDueDate;
        return $this;
    }
    /**
     * Get AVNeeds value
     * @return string|null
     */
    public function getAVNeeds()
    {
        return $this->AVNeeds;
    }
    /**
     * Set AVNeeds value
     * @param string $aVNeeds
     * @return \StructType\RFPRequestInfo
     */
    public function setAVNeeds($aVNeeds = null)
    {
        // validation for constraint: string
        if (!is_null($aVNeeds) && !is_string($aVNeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVNeeds, true), gettype($aVNeeds)), __LINE__);
        }
        $this->AVNeeds = $aVNeeds;
        return $this;
    }
    /**
     * Get AttendeesPerDay value
     * @return int|null
     */
    public function getAttendeesPerDay()
    {
        return $this->AttendeesPerDay;
    }
    /**
     * Set AttendeesPerDay value
     * @param int $attendeesPerDay
     * @return \StructType\RFPRequestInfo
     */
    public function setAttendeesPerDay($attendeesPerDay = null)
    {
        // validation for constraint: int
        if (!is_null($attendeesPerDay) && !(is_int($attendeesPerDay) || ctype_digit($attendeesPerDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attendeesPerDay, true), gettype($attendeesPerDay)), __LINE__);
        }
        $this->AttendeesPerDay = $attendeesPerDay;
        return $this;
    }
    /**
     * Get EventType value
     * @return string|null
     */
    public function getEventType()
    {
        return $this->EventType;
    }
    /**
     * Set EventType value
     * @param string $eventType
     * @return \StructType\RFPRequestInfo
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: string
        if (!is_null($eventType) && !is_string($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType, true), gettype($eventType)), __LINE__);
        }
        $this->EventType = $eventType;
        return $this;
    }
    /**
     * Get ContractSignatureLocation value
     * @return string|null
     */
    public function getContractSignatureLocation()
    {
        return $this->ContractSignatureLocation;
    }
    /**
     * Set ContractSignatureLocation value
     * @param string $contractSignatureLocation
     * @return \StructType\RFPRequestInfo
     */
    public function setContractSignatureLocation($contractSignatureLocation = null)
    {
        // validation for constraint: string
        if (!is_null($contractSignatureLocation) && !is_string($contractSignatureLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractSignatureLocation, true), gettype($contractSignatureLocation)), __LINE__);
        }
        $this->ContractSignatureLocation = $contractSignatureLocation;
        return $this;
    }
    /**
     * Get TotalBudget value
     * @return float|null
     */
    public function getTotalBudget()
    {
        return $this->TotalBudget;
    }
    /**
     * Set TotalBudget value
     * @param float $totalBudget
     * @return \StructType\RFPRequestInfo
     */
    public function setTotalBudget($totalBudget = null)
    {
        // validation for constraint: float
        if (!is_null($totalBudget) && !(is_float($totalBudget) || is_numeric($totalBudget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalBudget, true), gettype($totalBudget)), __LINE__);
        }
        $this->TotalBudget = $totalBudget;
        return $this;
    }
    /**
     * Get EventDetailsAdditionalInformation value
     * @return string|null
     */
    public function getEventDetailsAdditionalInformation()
    {
        return $this->EventDetailsAdditionalInformation;
    }
    /**
     * Set EventDetailsAdditionalInformation value
     * @param string $eventDetailsAdditionalInformation
     * @return \StructType\RFPRequestInfo
     */
    public function setEventDetailsAdditionalInformation($eventDetailsAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($eventDetailsAdditionalInformation) && !is_string($eventDetailsAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDetailsAdditionalInformation, true), gettype($eventDetailsAdditionalInformation)), __LINE__);
        }
        $this->EventDetailsAdditionalInformation = $eventDetailsAdditionalInformation;
        return $this;
    }
    /**
     * Get FandBBudget value
     * @return float|null
     */
    public function getFandBBudget()
    {
        return $this->FandBBudget;
    }
    /**
     * Set FandBBudget value
     * @param float $fandBBudget
     * @return \StructType\RFPRequestInfo
     */
    public function setFandBBudget($fandBBudget = null)
    {
        // validation for constraint: float
        if (!is_null($fandBBudget) && !(is_float($fandBBudget) || is_numeric($fandBBudget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fandBBudget, true), gettype($fandBBudget)), __LINE__);
        }
        $this->FandBBudget = $fandBBudget;
        return $this;
    }
    /**
     * Get BillingInformation value
     * @return string|null
     */
    public function getBillingInformation()
    {
        return $this->BillingInformation;
    }
    /**
     * Set BillingInformation value
     * @param string $billingInformation
     * @return \StructType\RFPRequestInfo
     */
    public function setBillingInformation($billingInformation = null)
    {
        // validation for constraint: string
        if (!is_null($billingInformation) && !is_string($billingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingInformation, true), gettype($billingInformation)), __LINE__);
        }
        $this->BillingInformation = $billingInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPRequestInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
