<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPQuestionDetail StructType
 * @subpackage Structs
 */
class RFPQuestionDetail extends AbstractStructBase
{
    /**
     * The QuestionId
     * @var string
     */
    public $QuestionId;
    /**
     * The QuestionType
     * @var string
     */
    public $QuestionType;
    /**
     * The QuestionText
     * @var string
     */
    public $QuestionText;
    /**
     * Constructor method for RFPQuestionDetail
     * @uses RFPQuestionDetail::setQuestionId()
     * @uses RFPQuestionDetail::setQuestionType()
     * @uses RFPQuestionDetail::setQuestionText()
     * @param string $questionId
     * @param string $questionType
     * @param string $questionText
     */
    public function __construct($questionId = null, $questionType = null, $questionText = null)
    {
        $this
            ->setQuestionId($questionId)
            ->setQuestionType($questionType)
            ->setQuestionText($questionText);
    }
    /**
     * Get QuestionId value
     * @return string|null
     */
    public function getQuestionId()
    {
        return $this->QuestionId;
    }
    /**
     * Set QuestionId value
     * @param string $questionId
     * @return \StructType\RFPQuestionDetail
     */
    public function setQuestionId($questionId = null)
    {
        // validation for constraint: string
        if (!is_null($questionId) && !is_string($questionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionId, true), gettype($questionId)), __LINE__);
        }
        $this->QuestionId = $questionId;
        return $this;
    }
    /**
     * Get QuestionType value
     * @return string|null
     */
    public function getQuestionType()
    {
        return $this->QuestionType;
    }
    /**
     * Set QuestionType value
     * @param string $questionType
     * @return \StructType\RFPQuestionDetail
     */
    public function setQuestionType($questionType = null)
    {
        // validation for constraint: string
        if (!is_null($questionType) && !is_string($questionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionType, true), gettype($questionType)), __LINE__);
        }
        $this->QuestionType = $questionType;
        return $this;
    }
    /**
     * Get QuestionText value
     * @return string|null
     */
    public function getQuestionText()
    {
        return $this->QuestionText;
    }
    /**
     * Set QuestionText value
     * @param string $questionText
     * @return \StructType\RFPQuestionDetail
     */
    public function setQuestionText($questionText = null)
    {
        // validation for constraint: string
        if (!is_null($questionText) && !is_string($questionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionText, true), gettype($questionText)), __LINE__);
        }
        $this->QuestionText = $questionText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPQuestionDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
