<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPParameters StructType
 * @subpackage Structs
 */
class RFPParameters extends CvObject
{
    /**
     * The RFPType
     * @var string
     */
    public $RFPType;
    /**
     * The RFPName
     * @var string
     */
    public $RFPName;
    /**
     * The ResponseDueDate
     * @var string
     */
    public $ResponseDueDate;
    /**
     * The DecisionDate
     * @var string
     */
    public $DecisionDate;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The RFPDescription
     * @var string
     */
    public $RFPDescription;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The EventName
     * @var string
     */
    public $EventName;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The EventEndDate
     * @var string
     */
    public $EventEndDate;
    /**
     * The TotalAttendees
     * @var int
     */
    public $TotalAttendees;
    /**
     * The DestinationsUnderConsideration
     * @var string
     */
    public $DestinationsUnderConsideration;
    /**
     * The OrganizationId
     * @var string
     */
    public $OrganizationId;
    /**
     * The BudgetedRoomRate
     * @var float
     */
    public $BudgetedRoomRate;
    /**
     * The KeyContactFirstName
     * @var string
     */
    public $KeyContactFirstName;
    /**
     * The KeyContactLastName
     * @var string
     */
    public $KeyContactLastName;
    /**
     * The KeyContactTitle
     * @var string
     */
    public $KeyContactTitle;
    /**
     * The KeyContactEmailAddress
     * @var string
     */
    public $KeyContactEmailAddress;
    /**
     * The KeyContactPhone
     * @var string
     */
    public $KeyContactPhone;
    /**
     * The KeyContactFax
     * @var string
     */
    public $KeyContactFax;
    /**
     * The KeyContactMobilePhone
     * @var string
     */
    public $KeyContactMobilePhone;
    /**
     * The KeyContactOrganization
     * @var string
     */
    public $KeyContactOrganization;
    /**
     * The KeyContactAddress1
     * @var string
     */
    public $KeyContactAddress1;
    /**
     * The KeyContactAddress2
     * @var string
     */
    public $KeyContactAddress2;
    /**
     * The KeyContactAddress3
     * @var string
     */
    public $KeyContactAddress3;
    /**
     * The KeyContactCity
     * @var string
     */
    public $KeyContactCity;
    /**
     * The KeyContactStateCode
     * @var string
     */
    public $KeyContactStateCode;
    /**
     * The KeyContactPostalCode
     * @var string
     */
    public $KeyContactPostalCode;
    /**
     * The KeyContactCountryCode
     * @var string
     */
    public $KeyContactCountryCode;
    /**
     * Constructor method for RFPParameters
     * @uses RFPParameters::setRFPType()
     * @uses RFPParameters::setRFPName()
     * @uses RFPParameters::setResponseDueDate()
     * @uses RFPParameters::setDecisionDate()
     * @uses RFPParameters::setCurrencyCode()
     * @uses RFPParameters::setRFPDescription()
     * @uses RFPParameters::setInternalNote()
     * @uses RFPParameters::setEventName()
     * @uses RFPParameters::setEventStartDate()
     * @uses RFPParameters::setEventEndDate()
     * @uses RFPParameters::setTotalAttendees()
     * @uses RFPParameters::setDestinationsUnderConsideration()
     * @uses RFPParameters::setOrganizationId()
     * @uses RFPParameters::setBudgetedRoomRate()
     * @uses RFPParameters::setKeyContactFirstName()
     * @uses RFPParameters::setKeyContactLastName()
     * @uses RFPParameters::setKeyContactTitle()
     * @uses RFPParameters::setKeyContactEmailAddress()
     * @uses RFPParameters::setKeyContactPhone()
     * @uses RFPParameters::setKeyContactFax()
     * @uses RFPParameters::setKeyContactMobilePhone()
     * @uses RFPParameters::setKeyContactOrganization()
     * @uses RFPParameters::setKeyContactAddress1()
     * @uses RFPParameters::setKeyContactAddress2()
     * @uses RFPParameters::setKeyContactAddress3()
     * @uses RFPParameters::setKeyContactCity()
     * @uses RFPParameters::setKeyContactStateCode()
     * @uses RFPParameters::setKeyContactPostalCode()
     * @uses RFPParameters::setKeyContactCountryCode()
     * @param string $rFPType
     * @param string $rFPName
     * @param string $responseDueDate
     * @param string $decisionDate
     * @param string $currencyCode
     * @param string $rFPDescription
     * @param string $internalNote
     * @param string $eventName
     * @param string $eventStartDate
     * @param string $eventEndDate
     * @param int $totalAttendees
     * @param string $destinationsUnderConsideration
     * @param string $organizationId
     * @param float $budgetedRoomRate
     * @param string $keyContactFirstName
     * @param string $keyContactLastName
     * @param string $keyContactTitle
     * @param string $keyContactEmailAddress
     * @param string $keyContactPhone
     * @param string $keyContactFax
     * @param string $keyContactMobilePhone
     * @param string $keyContactOrganization
     * @param string $keyContactAddress1
     * @param string $keyContactAddress2
     * @param string $keyContactAddress3
     * @param string $keyContactCity
     * @param string $keyContactStateCode
     * @param string $keyContactPostalCode
     * @param string $keyContactCountryCode
     */
    public function __construct($rFPType = null, $rFPName = null, $responseDueDate = null, $decisionDate = null, $currencyCode = null, $rFPDescription = null, $internalNote = null, $eventName = null, $eventStartDate = null, $eventEndDate = null, $totalAttendees = null, $destinationsUnderConsideration = null, $organizationId = null, $budgetedRoomRate = null, $keyContactFirstName = null, $keyContactLastName = null, $keyContactTitle = null, $keyContactEmailAddress = null, $keyContactPhone = null, $keyContactFax = null, $keyContactMobilePhone = null, $keyContactOrganization = null, $keyContactAddress1 = null, $keyContactAddress2 = null, $keyContactAddress3 = null, $keyContactCity = null, $keyContactStateCode = null, $keyContactPostalCode = null, $keyContactCountryCode = null)
    {
        $this
            ->setRFPType($rFPType)
            ->setRFPName($rFPName)
            ->setResponseDueDate($responseDueDate)
            ->setDecisionDate($decisionDate)
            ->setCurrencyCode($currencyCode)
            ->setRFPDescription($rFPDescription)
            ->setInternalNote($internalNote)
            ->setEventName($eventName)
            ->setEventStartDate($eventStartDate)
            ->setEventEndDate($eventEndDate)
            ->setTotalAttendees($totalAttendees)
            ->setDestinationsUnderConsideration($destinationsUnderConsideration)
            ->setOrganizationId($organizationId)
            ->setBudgetedRoomRate($budgetedRoomRate)
            ->setKeyContactFirstName($keyContactFirstName)
            ->setKeyContactLastName($keyContactLastName)
            ->setKeyContactTitle($keyContactTitle)
            ->setKeyContactEmailAddress($keyContactEmailAddress)
            ->setKeyContactPhone($keyContactPhone)
            ->setKeyContactFax($keyContactFax)
            ->setKeyContactMobilePhone($keyContactMobilePhone)
            ->setKeyContactOrganization($keyContactOrganization)
            ->setKeyContactAddress1($keyContactAddress1)
            ->setKeyContactAddress2($keyContactAddress2)
            ->setKeyContactAddress3($keyContactAddress3)
            ->setKeyContactCity($keyContactCity)
            ->setKeyContactStateCode($keyContactStateCode)
            ->setKeyContactPostalCode($keyContactPostalCode)
            ->setKeyContactCountryCode($keyContactCountryCode);
    }
    /**
     * Get RFPType value
     * @return string|null
     */
    public function getRFPType()
    {
        return $this->RFPType;
    }
    /**
     * Set RFPType value
     * @param string $rFPType
     * @return \StructType\RFPParameters
     */
    public function setRFPType($rFPType = null)
    {
        // validation for constraint: string
        if (!is_null($rFPType) && !is_string($rFPType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPType, true), gettype($rFPType)), __LINE__);
        }
        $this->RFPType = $rFPType;
        return $this;
    }
    /**
     * Get RFPName value
     * @return string|null
     */
    public function getRFPName()
    {
        return $this->RFPName;
    }
    /**
     * Set RFPName value
     * @param string $rFPName
     * @return \StructType\RFPParameters
     */
    public function setRFPName($rFPName = null)
    {
        // validation for constraint: string
        if (!is_null($rFPName) && !is_string($rFPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPName, true), gettype($rFPName)), __LINE__);
        }
        $this->RFPName = $rFPName;
        return $this;
    }
    /**
     * Get ResponseDueDate value
     * @return string|null
     */
    public function getResponseDueDate()
    {
        return $this->ResponseDueDate;
    }
    /**
     * Set ResponseDueDate value
     * @param string $responseDueDate
     * @return \StructType\RFPParameters
     */
    public function setResponseDueDate($responseDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($responseDueDate) && !is_string($responseDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDueDate, true), gettype($responseDueDate)), __LINE__);
        }
        $this->ResponseDueDate = $responseDueDate;
        return $this;
    }
    /**
     * Get DecisionDate value
     * @return string|null
     */
    public function getDecisionDate()
    {
        return $this->DecisionDate;
    }
    /**
     * Set DecisionDate value
     * @param string $decisionDate
     * @return \StructType\RFPParameters
     */
    public function setDecisionDate($decisionDate = null)
    {
        // validation for constraint: string
        if (!is_null($decisionDate) && !is_string($decisionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decisionDate, true), gettype($decisionDate)), __LINE__);
        }
        $this->DecisionDate = $decisionDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\RFPParameters
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get RFPDescription value
     * @return string|null
     */
    public function getRFPDescription()
    {
        return $this->RFPDescription;
    }
    /**
     * Set RFPDescription value
     * @param string $rFPDescription
     * @return \StructType\RFPParameters
     */
    public function setRFPDescription($rFPDescription = null)
    {
        // validation for constraint: string
        if (!is_null($rFPDescription) && !is_string($rFPDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPDescription, true), gettype($rFPDescription)), __LINE__);
        }
        $this->RFPDescription = $rFPDescription;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\RFPParameters
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get EventName value
     * @return string|null
     */
    public function getEventName()
    {
        return $this->EventName;
    }
    /**
     * Set EventName value
     * @param string $eventName
     * @return \StructType\RFPParameters
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        $this->EventName = $eventName;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\RFPParameters
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get EventEndDate value
     * @return string|null
     */
    public function getEventEndDate()
    {
        return $this->EventEndDate;
    }
    /**
     * Set EventEndDate value
     * @param string $eventEndDate
     * @return \StructType\RFPParameters
     */
    public function setEventEndDate($eventEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventEndDate) && !is_string($eventEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventEndDate, true), gettype($eventEndDate)), __LINE__);
        }
        $this->EventEndDate = $eventEndDate;
        return $this;
    }
    /**
     * Get TotalAttendees value
     * @return int|null
     */
    public function getTotalAttendees()
    {
        return $this->TotalAttendees;
    }
    /**
     * Set TotalAttendees value
     * @param int $totalAttendees
     * @return \StructType\RFPParameters
     */
    public function setTotalAttendees($totalAttendees = null)
    {
        // validation for constraint: int
        if (!is_null($totalAttendees) && !(is_int($totalAttendees) || ctype_digit($totalAttendees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalAttendees, true), gettype($totalAttendees)), __LINE__);
        }
        $this->TotalAttendees = $totalAttendees;
        return $this;
    }
    /**
     * Get DestinationsUnderConsideration value
     * @return string|null
     */
    public function getDestinationsUnderConsideration()
    {
        return $this->DestinationsUnderConsideration;
    }
    /**
     * Set DestinationsUnderConsideration value
     * @param string $destinationsUnderConsideration
     * @return \StructType\RFPParameters
     */
    public function setDestinationsUnderConsideration($destinationsUnderConsideration = null)
    {
        // validation for constraint: string
        if (!is_null($destinationsUnderConsideration) && !is_string($destinationsUnderConsideration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationsUnderConsideration, true), gettype($destinationsUnderConsideration)), __LINE__);
        }
        $this->DestinationsUnderConsideration = $destinationsUnderConsideration;
        return $this;
    }
    /**
     * Get OrganizationId value
     * @return string|null
     */
    public function getOrganizationId()
    {
        return $this->OrganizationId;
    }
    /**
     * Set OrganizationId value
     * @param string $organizationId
     * @return \StructType\RFPParameters
     */
    public function setOrganizationId($organizationId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationId) && !is_string($organizationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationId, true), gettype($organizationId)), __LINE__);
        }
        $this->OrganizationId = $organizationId;
        return $this;
    }
    /**
     * Get BudgetedRoomRate value
     * @return float|null
     */
    public function getBudgetedRoomRate()
    {
        return $this->BudgetedRoomRate;
    }
    /**
     * Set BudgetedRoomRate value
     * @param float $budgetedRoomRate
     * @return \StructType\RFPParameters
     */
    public function setBudgetedRoomRate($budgetedRoomRate = null)
    {
        // validation for constraint: float
        if (!is_null($budgetedRoomRate) && !(is_float($budgetedRoomRate) || is_numeric($budgetedRoomRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($budgetedRoomRate, true), gettype($budgetedRoomRate)), __LINE__);
        }
        $this->BudgetedRoomRate = $budgetedRoomRate;
        return $this;
    }
    /**
     * Get KeyContactFirstName value
     * @return string|null
     */
    public function getKeyContactFirstName()
    {
        return $this->KeyContactFirstName;
    }
    /**
     * Set KeyContactFirstName value
     * @param string $keyContactFirstName
     * @return \StructType\RFPParameters
     */
    public function setKeyContactFirstName($keyContactFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactFirstName) && !is_string($keyContactFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactFirstName, true), gettype($keyContactFirstName)), __LINE__);
        }
        $this->KeyContactFirstName = $keyContactFirstName;
        return $this;
    }
    /**
     * Get KeyContactLastName value
     * @return string|null
     */
    public function getKeyContactLastName()
    {
        return $this->KeyContactLastName;
    }
    /**
     * Set KeyContactLastName value
     * @param string $keyContactLastName
     * @return \StructType\RFPParameters
     */
    public function setKeyContactLastName($keyContactLastName = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactLastName) && !is_string($keyContactLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactLastName, true), gettype($keyContactLastName)), __LINE__);
        }
        $this->KeyContactLastName = $keyContactLastName;
        return $this;
    }
    /**
     * Get KeyContactTitle value
     * @return string|null
     */
    public function getKeyContactTitle()
    {
        return $this->KeyContactTitle;
    }
    /**
     * Set KeyContactTitle value
     * @param string $keyContactTitle
     * @return \StructType\RFPParameters
     */
    public function setKeyContactTitle($keyContactTitle = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactTitle) && !is_string($keyContactTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactTitle, true), gettype($keyContactTitle)), __LINE__);
        }
        $this->KeyContactTitle = $keyContactTitle;
        return $this;
    }
    /**
     * Get KeyContactEmailAddress value
     * @return string|null
     */
    public function getKeyContactEmailAddress()
    {
        return $this->KeyContactEmailAddress;
    }
    /**
     * Set KeyContactEmailAddress value
     * @param string $keyContactEmailAddress
     * @return \StructType\RFPParameters
     */
    public function setKeyContactEmailAddress($keyContactEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactEmailAddress) && !is_string($keyContactEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactEmailAddress, true), gettype($keyContactEmailAddress)), __LINE__);
        }
        $this->KeyContactEmailAddress = $keyContactEmailAddress;
        return $this;
    }
    /**
     * Get KeyContactPhone value
     * @return string|null
     */
    public function getKeyContactPhone()
    {
        return $this->KeyContactPhone;
    }
    /**
     * Set KeyContactPhone value
     * @param string $keyContactPhone
     * @return \StructType\RFPParameters
     */
    public function setKeyContactPhone($keyContactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactPhone) && !is_string($keyContactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactPhone, true), gettype($keyContactPhone)), __LINE__);
        }
        $this->KeyContactPhone = $keyContactPhone;
        return $this;
    }
    /**
     * Get KeyContactFax value
     * @return string|null
     */
    public function getKeyContactFax()
    {
        return $this->KeyContactFax;
    }
    /**
     * Set KeyContactFax value
     * @param string $keyContactFax
     * @return \StructType\RFPParameters
     */
    public function setKeyContactFax($keyContactFax = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactFax) && !is_string($keyContactFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactFax, true), gettype($keyContactFax)), __LINE__);
        }
        $this->KeyContactFax = $keyContactFax;
        return $this;
    }
    /**
     * Get KeyContactMobilePhone value
     * @return string|null
     */
    public function getKeyContactMobilePhone()
    {
        return $this->KeyContactMobilePhone;
    }
    /**
     * Set KeyContactMobilePhone value
     * @param string $keyContactMobilePhone
     * @return \StructType\RFPParameters
     */
    public function setKeyContactMobilePhone($keyContactMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactMobilePhone) && !is_string($keyContactMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactMobilePhone, true), gettype($keyContactMobilePhone)), __LINE__);
        }
        $this->KeyContactMobilePhone = $keyContactMobilePhone;
        return $this;
    }
    /**
     * Get KeyContactOrganization value
     * @return string|null
     */
    public function getKeyContactOrganization()
    {
        return $this->KeyContactOrganization;
    }
    /**
     * Set KeyContactOrganization value
     * @param string $keyContactOrganization
     * @return \StructType\RFPParameters
     */
    public function setKeyContactOrganization($keyContactOrganization = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactOrganization) && !is_string($keyContactOrganization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactOrganization, true), gettype($keyContactOrganization)), __LINE__);
        }
        $this->KeyContactOrganization = $keyContactOrganization;
        return $this;
    }
    /**
     * Get KeyContactAddress1 value
     * @return string|null
     */
    public function getKeyContactAddress1()
    {
        return $this->KeyContactAddress1;
    }
    /**
     * Set KeyContactAddress1 value
     * @param string $keyContactAddress1
     * @return \StructType\RFPParameters
     */
    public function setKeyContactAddress1($keyContactAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactAddress1) && !is_string($keyContactAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactAddress1, true), gettype($keyContactAddress1)), __LINE__);
        }
        $this->KeyContactAddress1 = $keyContactAddress1;
        return $this;
    }
    /**
     * Get KeyContactAddress2 value
     * @return string|null
     */
    public function getKeyContactAddress2()
    {
        return $this->KeyContactAddress2;
    }
    /**
     * Set KeyContactAddress2 value
     * @param string $keyContactAddress2
     * @return \StructType\RFPParameters
     */
    public function setKeyContactAddress2($keyContactAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactAddress2) && !is_string($keyContactAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactAddress2, true), gettype($keyContactAddress2)), __LINE__);
        }
        $this->KeyContactAddress2 = $keyContactAddress2;
        return $this;
    }
    /**
     * Get KeyContactAddress3 value
     * @return string|null
     */
    public function getKeyContactAddress3()
    {
        return $this->KeyContactAddress3;
    }
    /**
     * Set KeyContactAddress3 value
     * @param string $keyContactAddress3
     * @return \StructType\RFPParameters
     */
    public function setKeyContactAddress3($keyContactAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactAddress3) && !is_string($keyContactAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactAddress3, true), gettype($keyContactAddress3)), __LINE__);
        }
        $this->KeyContactAddress3 = $keyContactAddress3;
        return $this;
    }
    /**
     * Get KeyContactCity value
     * @return string|null
     */
    public function getKeyContactCity()
    {
        return $this->KeyContactCity;
    }
    /**
     * Set KeyContactCity value
     * @param string $keyContactCity
     * @return \StructType\RFPParameters
     */
    public function setKeyContactCity($keyContactCity = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactCity) && !is_string($keyContactCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactCity, true), gettype($keyContactCity)), __LINE__);
        }
        $this->KeyContactCity = $keyContactCity;
        return $this;
    }
    /**
     * Get KeyContactStateCode value
     * @return string|null
     */
    public function getKeyContactStateCode()
    {
        return $this->KeyContactStateCode;
    }
    /**
     * Set KeyContactStateCode value
     * @param string $keyContactStateCode
     * @return \StructType\RFPParameters
     */
    public function setKeyContactStateCode($keyContactStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactStateCode) && !is_string($keyContactStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactStateCode, true), gettype($keyContactStateCode)), __LINE__);
        }
        $this->KeyContactStateCode = $keyContactStateCode;
        return $this;
    }
    /**
     * Get KeyContactPostalCode value
     * @return string|null
     */
    public function getKeyContactPostalCode()
    {
        return $this->KeyContactPostalCode;
    }
    /**
     * Set KeyContactPostalCode value
     * @param string $keyContactPostalCode
     * @return \StructType\RFPParameters
     */
    public function setKeyContactPostalCode($keyContactPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactPostalCode) && !is_string($keyContactPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactPostalCode, true), gettype($keyContactPostalCode)), __LINE__);
        }
        $this->KeyContactPostalCode = $keyContactPostalCode;
        return $this;
    }
    /**
     * Get KeyContactCountryCode value
     * @return string|null
     */
    public function getKeyContactCountryCode()
    {
        return $this->KeyContactCountryCode;
    }
    /**
     * Set KeyContactCountryCode value
     * @param string $keyContactCountryCode
     * @return \StructType\RFPParameters
     */
    public function setKeyContactCountryCode($keyContactCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($keyContactCountryCode) && !is_string($keyContactCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyContactCountryCode, true), gettype($keyContactCountryCode)), __LINE__);
        }
        $this->KeyContactCountryCode = $keyContactCountryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
