<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPOrganizationInfo StructType
 * @subpackage Structs
 */
class RFPOrganizationInfo extends AbstractStructBase
{
    /**
     * The Organization
     * @var string
     */
    public $Organization;
    /**
     * The OrganizationType
     * @var string
     */
    public $OrganizationType;
    /**
     * The OrganizationAddress1
     * @var string
     */
    public $OrganizationAddress1;
    /**
     * The OrganizationAddress2
     * @var string
     */
    public $OrganizationAddress2;
    /**
     * The OrganizationAddress3
     * @var string
     */
    public $OrganizationAddress3;
    /**
     * The OrganizationCity
     * @var string
     */
    public $OrganizationCity;
    /**
     * The OrganizationState
     * @var string
     */
    public $OrganizationState;
    /**
     * The OrganizationStateCode
     * @var string
     */
    public $OrganizationStateCode;
    /**
     * The OrganizationPostalCode
     * @var string
     */
    public $OrganizationPostalCode;
    /**
     * The OrganizationCountry
     * @var string
     */
    public $OrganizationCountry;
    /**
     * The OrganizationCountryCode
     * @var string
     */
    public $OrganizationCountryCode;
    /**
     * The EmployeesRange
     * @var int
     */
    public $EmployeesRange;
    /**
     * The Employees
     * @var int
     */
    public $Employees;
    /**
     * The EventsPerYear
     * @var int
     */
    public $EventsPerYear;
    /**
     * The SingleDayEvents
     * @var string
     */
    public $SingleDayEvents;
    /**
     * The MultiDayEvents
     * @var string
     */
    public $MultiDayEvents;
    /**
     * The AverageAttendeesPerEventRange
     * @var int
     */
    public $AverageAttendeesPerEventRange;
    /**
     * The AverageAttendeesPerEvent
     * @var int
     */
    public $AverageAttendeesPerEvent;
    /**
     * The AverageRoomNightsPerEventRange
     * @var int
     */
    public $AverageRoomNightsPerEventRange;
    /**
     * The AverageRoomNightsPerEvent
     * @var int
     */
    public $AverageRoomNightsPerEvent;
    /**
     * The TotalAttendeesPerYearRange
     * @var int
     */
    public $TotalAttendeesPerYearRange;
    /**
     * The TotalAttendeesPerYear
     * @var int
     */
    public $TotalAttendeesPerYear;
    /**
     * The TotalRoomNightsPerYearRange
     * @var int
     */
    public $TotalRoomNightsPerYearRange;
    /**
     * The TotalRoomNightsPerYear
     * @var int
     */
    public $TotalRoomNightsPerYear;
    /**
     * The OrganizationInformation
     * @var string
     */
    public $OrganizationInformation;
    /**
     * Constructor method for RFPOrganizationInfo
     * @uses RFPOrganizationInfo::setOrganization()
     * @uses RFPOrganizationInfo::setOrganizationType()
     * @uses RFPOrganizationInfo::setOrganizationAddress1()
     * @uses RFPOrganizationInfo::setOrganizationAddress2()
     * @uses RFPOrganizationInfo::setOrganizationAddress3()
     * @uses RFPOrganizationInfo::setOrganizationCity()
     * @uses RFPOrganizationInfo::setOrganizationState()
     * @uses RFPOrganizationInfo::setOrganizationStateCode()
     * @uses RFPOrganizationInfo::setOrganizationPostalCode()
     * @uses RFPOrganizationInfo::setOrganizationCountry()
     * @uses RFPOrganizationInfo::setOrganizationCountryCode()
     * @uses RFPOrganizationInfo::setEmployeesRange()
     * @uses RFPOrganizationInfo::setEmployees()
     * @uses RFPOrganizationInfo::setEventsPerYear()
     * @uses RFPOrganizationInfo::setSingleDayEvents()
     * @uses RFPOrganizationInfo::setMultiDayEvents()
     * @uses RFPOrganizationInfo::setAverageAttendeesPerEventRange()
     * @uses RFPOrganizationInfo::setAverageAttendeesPerEvent()
     * @uses RFPOrganizationInfo::setAverageRoomNightsPerEventRange()
     * @uses RFPOrganizationInfo::setAverageRoomNightsPerEvent()
     * @uses RFPOrganizationInfo::setTotalAttendeesPerYearRange()
     * @uses RFPOrganizationInfo::setTotalAttendeesPerYear()
     * @uses RFPOrganizationInfo::setTotalRoomNightsPerYearRange()
     * @uses RFPOrganizationInfo::setTotalRoomNightsPerYear()
     * @uses RFPOrganizationInfo::setOrganizationInformation()
     * @param string $organization
     * @param string $organizationType
     * @param string $organizationAddress1
     * @param string $organizationAddress2
     * @param string $organizationAddress3
     * @param string $organizationCity
     * @param string $organizationState
     * @param string $organizationStateCode
     * @param string $organizationPostalCode
     * @param string $organizationCountry
     * @param string $organizationCountryCode
     * @param int $employeesRange
     * @param int $employees
     * @param int $eventsPerYear
     * @param string $singleDayEvents
     * @param string $multiDayEvents
     * @param int $averageAttendeesPerEventRange
     * @param int $averageAttendeesPerEvent
     * @param int $averageRoomNightsPerEventRange
     * @param int $averageRoomNightsPerEvent
     * @param int $totalAttendeesPerYearRange
     * @param int $totalAttendeesPerYear
     * @param int $totalRoomNightsPerYearRange
     * @param int $totalRoomNightsPerYear
     * @param string $organizationInformation
     */
    public function __construct($organization = null, $organizationType = null, $organizationAddress1 = null, $organizationAddress2 = null, $organizationAddress3 = null, $organizationCity = null, $organizationState = null, $organizationStateCode = null, $organizationPostalCode = null, $organizationCountry = null, $organizationCountryCode = null, $employeesRange = null, $employees = null, $eventsPerYear = null, $singleDayEvents = null, $multiDayEvents = null, $averageAttendeesPerEventRange = null, $averageAttendeesPerEvent = null, $averageRoomNightsPerEventRange = null, $averageRoomNightsPerEvent = null, $totalAttendeesPerYearRange = null, $totalAttendeesPerYear = null, $totalRoomNightsPerYearRange = null, $totalRoomNightsPerYear = null, $organizationInformation = null)
    {
        $this
            ->setOrganization($organization)
            ->setOrganizationType($organizationType)
            ->setOrganizationAddress1($organizationAddress1)
            ->setOrganizationAddress2($organizationAddress2)
            ->setOrganizationAddress3($organizationAddress3)
            ->setOrganizationCity($organizationCity)
            ->setOrganizationState($organizationState)
            ->setOrganizationStateCode($organizationStateCode)
            ->setOrganizationPostalCode($organizationPostalCode)
            ->setOrganizationCountry($organizationCountry)
            ->setOrganizationCountryCode($organizationCountryCode)
            ->setEmployeesRange($employeesRange)
            ->setEmployees($employees)
            ->setEventsPerYear($eventsPerYear)
            ->setSingleDayEvents($singleDayEvents)
            ->setMultiDayEvents($multiDayEvents)
            ->setAverageAttendeesPerEventRange($averageAttendeesPerEventRange)
            ->setAverageAttendeesPerEvent($averageAttendeesPerEvent)
            ->setAverageRoomNightsPerEventRange($averageRoomNightsPerEventRange)
            ->setAverageRoomNightsPerEvent($averageRoomNightsPerEvent)
            ->setTotalAttendeesPerYearRange($totalAttendeesPerYearRange)
            ->setTotalAttendeesPerYear($totalAttendeesPerYear)
            ->setTotalRoomNightsPerYearRange($totalRoomNightsPerYearRange)
            ->setTotalRoomNightsPerYear($totalRoomNightsPerYear)
            ->setOrganizationInformation($organizationInformation);
    }
    /**
     * Get Organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param string $organization
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganization($organization = null)
    {
        // validation for constraint: string
        if (!is_null($organization) && !is_string($organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organization, true), gettype($organization)), __LINE__);
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get OrganizationType value
     * @return string|null
     */
    public function getOrganizationType()
    {
        return $this->OrganizationType;
    }
    /**
     * Set OrganizationType value
     * @param string $organizationType
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationType($organizationType = null)
    {
        // validation for constraint: string
        if (!is_null($organizationType) && !is_string($organizationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationType, true), gettype($organizationType)), __LINE__);
        }
        $this->OrganizationType = $organizationType;
        return $this;
    }
    /**
     * Get OrganizationAddress1 value
     * @return string|null
     */
    public function getOrganizationAddress1()
    {
        return $this->OrganizationAddress1;
    }
    /**
     * Set OrganizationAddress1 value
     * @param string $organizationAddress1
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationAddress1($organizationAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($organizationAddress1) && !is_string($organizationAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationAddress1, true), gettype($organizationAddress1)), __LINE__);
        }
        $this->OrganizationAddress1 = $organizationAddress1;
        return $this;
    }
    /**
     * Get OrganizationAddress2 value
     * @return string|null
     */
    public function getOrganizationAddress2()
    {
        return $this->OrganizationAddress2;
    }
    /**
     * Set OrganizationAddress2 value
     * @param string $organizationAddress2
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationAddress2($organizationAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($organizationAddress2) && !is_string($organizationAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationAddress2, true), gettype($organizationAddress2)), __LINE__);
        }
        $this->OrganizationAddress2 = $organizationAddress2;
        return $this;
    }
    /**
     * Get OrganizationAddress3 value
     * @return string|null
     */
    public function getOrganizationAddress3()
    {
        return $this->OrganizationAddress3;
    }
    /**
     * Set OrganizationAddress3 value
     * @param string $organizationAddress3
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationAddress3($organizationAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($organizationAddress3) && !is_string($organizationAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationAddress3, true), gettype($organizationAddress3)), __LINE__);
        }
        $this->OrganizationAddress3 = $organizationAddress3;
        return $this;
    }
    /**
     * Get OrganizationCity value
     * @return string|null
     */
    public function getOrganizationCity()
    {
        return $this->OrganizationCity;
    }
    /**
     * Set OrganizationCity value
     * @param string $organizationCity
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationCity($organizationCity = null)
    {
        // validation for constraint: string
        if (!is_null($organizationCity) && !is_string($organizationCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationCity, true), gettype($organizationCity)), __LINE__);
        }
        $this->OrganizationCity = $organizationCity;
        return $this;
    }
    /**
     * Get OrganizationState value
     * @return string|null
     */
    public function getOrganizationState()
    {
        return $this->OrganizationState;
    }
    /**
     * Set OrganizationState value
     * @param string $organizationState
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationState($organizationState = null)
    {
        // validation for constraint: string
        if (!is_null($organizationState) && !is_string($organizationState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationState, true), gettype($organizationState)), __LINE__);
        }
        $this->OrganizationState = $organizationState;
        return $this;
    }
    /**
     * Get OrganizationStateCode value
     * @return string|null
     */
    public function getOrganizationStateCode()
    {
        return $this->OrganizationStateCode;
    }
    /**
     * Set OrganizationStateCode value
     * @param string $organizationStateCode
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationStateCode($organizationStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($organizationStateCode) && !is_string($organizationStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationStateCode, true), gettype($organizationStateCode)), __LINE__);
        }
        $this->OrganizationStateCode = $organizationStateCode;
        return $this;
    }
    /**
     * Get OrganizationPostalCode value
     * @return string|null
     */
    public function getOrganizationPostalCode()
    {
        return $this->OrganizationPostalCode;
    }
    /**
     * Set OrganizationPostalCode value
     * @param string $organizationPostalCode
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationPostalCode($organizationPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($organizationPostalCode) && !is_string($organizationPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationPostalCode, true), gettype($organizationPostalCode)), __LINE__);
        }
        $this->OrganizationPostalCode = $organizationPostalCode;
        return $this;
    }
    /**
     * Get OrganizationCountry value
     * @return string|null
     */
    public function getOrganizationCountry()
    {
        return $this->OrganizationCountry;
    }
    /**
     * Set OrganizationCountry value
     * @param string $organizationCountry
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationCountry($organizationCountry = null)
    {
        // validation for constraint: string
        if (!is_null($organizationCountry) && !is_string($organizationCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationCountry, true), gettype($organizationCountry)), __LINE__);
        }
        $this->OrganizationCountry = $organizationCountry;
        return $this;
    }
    /**
     * Get OrganizationCountryCode value
     * @return string|null
     */
    public function getOrganizationCountryCode()
    {
        return $this->OrganizationCountryCode;
    }
    /**
     * Set OrganizationCountryCode value
     * @param string $organizationCountryCode
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationCountryCode($organizationCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($organizationCountryCode) && !is_string($organizationCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationCountryCode, true), gettype($organizationCountryCode)), __LINE__);
        }
        $this->OrganizationCountryCode = $organizationCountryCode;
        return $this;
    }
    /**
     * Get EmployeesRange value
     * @return int|null
     */
    public function getEmployeesRange()
    {
        return $this->EmployeesRange;
    }
    /**
     * Set EmployeesRange value
     * @param int $employeesRange
     * @return \StructType\RFPOrganizationInfo
     */
    public function setEmployeesRange($employeesRange = null)
    {
        // validation for constraint: int
        if (!is_null($employeesRange) && !(is_int($employeesRange) || ctype_digit($employeesRange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($employeesRange, true), gettype($employeesRange)), __LINE__);
        }
        $this->EmployeesRange = $employeesRange;
        return $this;
    }
    /**
     * Get Employees value
     * @return int|null
     */
    public function getEmployees()
    {
        return $this->Employees;
    }
    /**
     * Set Employees value
     * @param int $employees
     * @return \StructType\RFPOrganizationInfo
     */
    public function setEmployees($employees = null)
    {
        // validation for constraint: int
        if (!is_null($employees) && !(is_int($employees) || ctype_digit($employees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($employees, true), gettype($employees)), __LINE__);
        }
        $this->Employees = $employees;
        return $this;
    }
    /**
     * Get EventsPerYear value
     * @return int|null
     */
    public function getEventsPerYear()
    {
        return $this->EventsPerYear;
    }
    /**
     * Set EventsPerYear value
     * @param int $eventsPerYear
     * @return \StructType\RFPOrganizationInfo
     */
    public function setEventsPerYear($eventsPerYear = null)
    {
        // validation for constraint: int
        if (!is_null($eventsPerYear) && !(is_int($eventsPerYear) || ctype_digit($eventsPerYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventsPerYear, true), gettype($eventsPerYear)), __LINE__);
        }
        $this->EventsPerYear = $eventsPerYear;
        return $this;
    }
    /**
     * Get SingleDayEvents value
     * @return string|null
     */
    public function getSingleDayEvents()
    {
        return $this->SingleDayEvents;
    }
    /**
     * Set SingleDayEvents value
     * @param string $singleDayEvents
     * @return \StructType\RFPOrganizationInfo
     */
    public function setSingleDayEvents($singleDayEvents = null)
    {
        // validation for constraint: string
        if (!is_null($singleDayEvents) && !is_string($singleDayEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleDayEvents, true), gettype($singleDayEvents)), __LINE__);
        }
        $this->SingleDayEvents = $singleDayEvents;
        return $this;
    }
    /**
     * Get MultiDayEvents value
     * @return string|null
     */
    public function getMultiDayEvents()
    {
        return $this->MultiDayEvents;
    }
    /**
     * Set MultiDayEvents value
     * @param string $multiDayEvents
     * @return \StructType\RFPOrganizationInfo
     */
    public function setMultiDayEvents($multiDayEvents = null)
    {
        // validation for constraint: string
        if (!is_null($multiDayEvents) && !is_string($multiDayEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multiDayEvents, true), gettype($multiDayEvents)), __LINE__);
        }
        $this->MultiDayEvents = $multiDayEvents;
        return $this;
    }
    /**
     * Get AverageAttendeesPerEventRange value
     * @return int|null
     */
    public function getAverageAttendeesPerEventRange()
    {
        return $this->AverageAttendeesPerEventRange;
    }
    /**
     * Set AverageAttendeesPerEventRange value
     * @param int $averageAttendeesPerEventRange
     * @return \StructType\RFPOrganizationInfo
     */
    public function setAverageAttendeesPerEventRange($averageAttendeesPerEventRange = null)
    {
        // validation for constraint: int
        if (!is_null($averageAttendeesPerEventRange) && !(is_int($averageAttendeesPerEventRange) || ctype_digit($averageAttendeesPerEventRange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($averageAttendeesPerEventRange, true), gettype($averageAttendeesPerEventRange)), __LINE__);
        }
        $this->AverageAttendeesPerEventRange = $averageAttendeesPerEventRange;
        return $this;
    }
    /**
     * Get AverageAttendeesPerEvent value
     * @return int|null
     */
    public function getAverageAttendeesPerEvent()
    {
        return $this->AverageAttendeesPerEvent;
    }
    /**
     * Set AverageAttendeesPerEvent value
     * @param int $averageAttendeesPerEvent
     * @return \StructType\RFPOrganizationInfo
     */
    public function setAverageAttendeesPerEvent($averageAttendeesPerEvent = null)
    {
        // validation for constraint: int
        if (!is_null($averageAttendeesPerEvent) && !(is_int($averageAttendeesPerEvent) || ctype_digit($averageAttendeesPerEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($averageAttendeesPerEvent, true), gettype($averageAttendeesPerEvent)), __LINE__);
        }
        $this->AverageAttendeesPerEvent = $averageAttendeesPerEvent;
        return $this;
    }
    /**
     * Get AverageRoomNightsPerEventRange value
     * @return int|null
     */
    public function getAverageRoomNightsPerEventRange()
    {
        return $this->AverageRoomNightsPerEventRange;
    }
    /**
     * Set AverageRoomNightsPerEventRange value
     * @param int $averageRoomNightsPerEventRange
     * @return \StructType\RFPOrganizationInfo
     */
    public function setAverageRoomNightsPerEventRange($averageRoomNightsPerEventRange = null)
    {
        // validation for constraint: int
        if (!is_null($averageRoomNightsPerEventRange) && !(is_int($averageRoomNightsPerEventRange) || ctype_digit($averageRoomNightsPerEventRange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($averageRoomNightsPerEventRange, true), gettype($averageRoomNightsPerEventRange)), __LINE__);
        }
        $this->AverageRoomNightsPerEventRange = $averageRoomNightsPerEventRange;
        return $this;
    }
    /**
     * Get AverageRoomNightsPerEvent value
     * @return int|null
     */
    public function getAverageRoomNightsPerEvent()
    {
        return $this->AverageRoomNightsPerEvent;
    }
    /**
     * Set AverageRoomNightsPerEvent value
     * @param int $averageRoomNightsPerEvent
     * @return \StructType\RFPOrganizationInfo
     */
    public function setAverageRoomNightsPerEvent($averageRoomNightsPerEvent = null)
    {
        // validation for constraint: int
        if (!is_null($averageRoomNightsPerEvent) && !(is_int($averageRoomNightsPerEvent) || ctype_digit($averageRoomNightsPerEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($averageRoomNightsPerEvent, true), gettype($averageRoomNightsPerEvent)), __LINE__);
        }
        $this->AverageRoomNightsPerEvent = $averageRoomNightsPerEvent;
        return $this;
    }
    /**
     * Get TotalAttendeesPerYearRange value
     * @return int|null
     */
    public function getTotalAttendeesPerYearRange()
    {
        return $this->TotalAttendeesPerYearRange;
    }
    /**
     * Set TotalAttendeesPerYearRange value
     * @param int $totalAttendeesPerYearRange
     * @return \StructType\RFPOrganizationInfo
     */
    public function setTotalAttendeesPerYearRange($totalAttendeesPerYearRange = null)
    {
        // validation for constraint: int
        if (!is_null($totalAttendeesPerYearRange) && !(is_int($totalAttendeesPerYearRange) || ctype_digit($totalAttendeesPerYearRange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalAttendeesPerYearRange, true), gettype($totalAttendeesPerYearRange)), __LINE__);
        }
        $this->TotalAttendeesPerYearRange = $totalAttendeesPerYearRange;
        return $this;
    }
    /**
     * Get TotalAttendeesPerYear value
     * @return int|null
     */
    public function getTotalAttendeesPerYear()
    {
        return $this->TotalAttendeesPerYear;
    }
    /**
     * Set TotalAttendeesPerYear value
     * @param int $totalAttendeesPerYear
     * @return \StructType\RFPOrganizationInfo
     */
    public function setTotalAttendeesPerYear($totalAttendeesPerYear = null)
    {
        // validation for constraint: int
        if (!is_null($totalAttendeesPerYear) && !(is_int($totalAttendeesPerYear) || ctype_digit($totalAttendeesPerYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalAttendeesPerYear, true), gettype($totalAttendeesPerYear)), __LINE__);
        }
        $this->TotalAttendeesPerYear = $totalAttendeesPerYear;
        return $this;
    }
    /**
     * Get TotalRoomNightsPerYearRange value
     * @return int|null
     */
    public function getTotalRoomNightsPerYearRange()
    {
        return $this->TotalRoomNightsPerYearRange;
    }
    /**
     * Set TotalRoomNightsPerYearRange value
     * @param int $totalRoomNightsPerYearRange
     * @return \StructType\RFPOrganizationInfo
     */
    public function setTotalRoomNightsPerYearRange($totalRoomNightsPerYearRange = null)
    {
        // validation for constraint: int
        if (!is_null($totalRoomNightsPerYearRange) && !(is_int($totalRoomNightsPerYearRange) || ctype_digit($totalRoomNightsPerYearRange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRoomNightsPerYearRange, true), gettype($totalRoomNightsPerYearRange)), __LINE__);
        }
        $this->TotalRoomNightsPerYearRange = $totalRoomNightsPerYearRange;
        return $this;
    }
    /**
     * Get TotalRoomNightsPerYear value
     * @return int|null
     */
    public function getTotalRoomNightsPerYear()
    {
        return $this->TotalRoomNightsPerYear;
    }
    /**
     * Set TotalRoomNightsPerYear value
     * @param int $totalRoomNightsPerYear
     * @return \StructType\RFPOrganizationInfo
     */
    public function setTotalRoomNightsPerYear($totalRoomNightsPerYear = null)
    {
        // validation for constraint: int
        if (!is_null($totalRoomNightsPerYear) && !(is_int($totalRoomNightsPerYear) || ctype_digit($totalRoomNightsPerYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRoomNightsPerYear, true), gettype($totalRoomNightsPerYear)), __LINE__);
        }
        $this->TotalRoomNightsPerYear = $totalRoomNightsPerYear;
        return $this;
    }
    /**
     * Get OrganizationInformation value
     * @return string|null
     */
    public function getOrganizationInformation()
    {
        return $this->OrganizationInformation;
    }
    /**
     * Set OrganizationInformation value
     * @param string $organizationInformation
     * @return \StructType\RFPOrganizationInfo
     */
    public function setOrganizationInformation($organizationInformation = null)
    {
        // validation for constraint: string
        if (!is_null($organizationInformation) && !is_string($organizationInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationInformation, true), gettype($organizationInformation)), __LINE__);
        }
        $this->OrganizationInformation = $organizationInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPOrganizationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
