<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPOccupancyPerRoomDetail StructType
 * @subpackage Structs
 */
class RFPOccupancyPerRoomDetail extends AbstractStructBase
{
    /**
     * The RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The Occupancy
     * @var string
     */
    public $Occupancy;
    /**
     * Constructor method for RFPOccupancyPerRoomDetail
     * @uses RFPOccupancyPerRoomDetail::setRoomType()
     * @uses RFPOccupancyPerRoomDetail::setOccupancy()
     * @param string $roomType
     * @param string $occupancy
     */
    public function __construct($roomType = null, $occupancy = null)
    {
        $this
            ->setRoomType($roomType)
            ->setOccupancy($occupancy);
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\RFPOccupancyPerRoomDetail
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return string|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @param string $occupancy
     * @return \StructType\RFPOccupancyPerRoomDetail
     */
    public function setOccupancy($occupancy = null)
    {
        // validation for constraint: string
        if (!is_null($occupancy) && !is_string($occupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupancy, true), gettype($occupancy)), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPOccupancyPerRoomDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
