<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPEventRequirementInfo StructType
 * @subpackage Structs
 */
class RFPEventRequirementInfo extends AbstractStructBase
{
    /**
     * The MeetingRoomDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPMeetingRoomDetail[]
     */
    public $MeetingRoomDetail;
    /**
     * The FoodAndBeverageBudget
     * @var float
     */
    public $FoodAndBeverageBudget;
    /**
     * The TotalMeetingRooms
     * @var int
     */
    public $TotalMeetingRooms;
    /**
     * The MeetingRoomSizeType
     * @var string
     */
    public $MeetingRoomSizeType;
    /**
     * The MeetingRoomAdditionalInformation
     * @var string
     */
    public $MeetingRoomAdditionalInformation;
    /**
     * The AmenityAdditionalInformation
     * @var string
     */
    public $AmenityAdditionalInformation;
    /**
     * Constructor method for RFPEventRequirementInfo
     * @uses RFPEventRequirementInfo::setMeetingRoomDetail()
     * @uses RFPEventRequirementInfo::setFoodAndBeverageBudget()
     * @uses RFPEventRequirementInfo::setTotalMeetingRooms()
     * @uses RFPEventRequirementInfo::setMeetingRoomSizeType()
     * @uses RFPEventRequirementInfo::setMeetingRoomAdditionalInformation()
     * @uses RFPEventRequirementInfo::setAmenityAdditionalInformation()
     * @param \StructType\RFPMeetingRoomDetail[] $meetingRoomDetail
     * @param float $foodAndBeverageBudget
     * @param int $totalMeetingRooms
     * @param string $meetingRoomSizeType
     * @param string $meetingRoomAdditionalInformation
     * @param string $amenityAdditionalInformation
     */
    public function __construct(array $meetingRoomDetail = array(), $foodAndBeverageBudget = null, $totalMeetingRooms = null, $meetingRoomSizeType = null, $meetingRoomAdditionalInformation = null, $amenityAdditionalInformation = null)
    {
        $this
            ->setMeetingRoomDetail($meetingRoomDetail)
            ->setFoodAndBeverageBudget($foodAndBeverageBudget)
            ->setTotalMeetingRooms($totalMeetingRooms)
            ->setMeetingRoomSizeType($meetingRoomSizeType)
            ->setMeetingRoomAdditionalInformation($meetingRoomAdditionalInformation)
            ->setAmenityAdditionalInformation($amenityAdditionalInformation);
    }
    /**
     * Get MeetingRoomDetail value
     * @return \StructType\RFPMeetingRoomDetail[]|null
     */
    public function getMeetingRoomDetail()
    {
        return $this->MeetingRoomDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setMeetingRoomDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeetingRoomDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeetingRoomDetailForArrayConstraintsFromSetMeetingRoomDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPEventRequirementInfoMeetingRoomDetailItem) {
            // validation for constraint: itemType
            if (!$rFPEventRequirementInfoMeetingRoomDetailItem instanceof \StructType\RFPMeetingRoomDetail) {
                $invalidValues[] = is_object($rFPEventRequirementInfoMeetingRoomDetailItem) ? get_class($rFPEventRequirementInfoMeetingRoomDetailItem) : sprintf('%s(%s)', gettype($rFPEventRequirementInfoMeetingRoomDetailItem), var_export($rFPEventRequirementInfoMeetingRoomDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeetingRoomDetail property can only contain items of type \StructType\RFPMeetingRoomDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeetingRoomDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPMeetingRoomDetail[] $meetingRoomDetail
     * @return \StructType\RFPEventRequirementInfo
     */
    public function setMeetingRoomDetail(array $meetingRoomDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($meetingRoomDetailArrayErrorMessage = self::validateMeetingRoomDetailForArrayConstraintsFromSetMeetingRoomDetail($meetingRoomDetail))) {
            throw new \InvalidArgumentException($meetingRoomDetailArrayErrorMessage, __LINE__);
        }
        $this->MeetingRoomDetail = $meetingRoomDetail;
        return $this;
    }
    /**
     * Add item to MeetingRoomDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPMeetingRoomDetail $item
     * @return \StructType\RFPEventRequirementInfo
     */
    public function addToMeetingRoomDetail(\StructType\RFPMeetingRoomDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPMeetingRoomDetail) {
            throw new \InvalidArgumentException(sprintf('The MeetingRoomDetail property can only contain items of type \StructType\RFPMeetingRoomDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeetingRoomDetail[] = $item;
        return $this;
    }
    /**
     * Get FoodAndBeverageBudget value
     * @return float|null
     */
    public function getFoodAndBeverageBudget()
    {
        return $this->FoodAndBeverageBudget;
    }
    /**
     * Set FoodAndBeverageBudget value
     * @param float $foodAndBeverageBudget
     * @return \StructType\RFPEventRequirementInfo
     */
    public function setFoodAndBeverageBudget($foodAndBeverageBudget = null)
    {
        // validation for constraint: float
        if (!is_null($foodAndBeverageBudget) && !(is_float($foodAndBeverageBudget) || is_numeric($foodAndBeverageBudget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($foodAndBeverageBudget, true), gettype($foodAndBeverageBudget)), __LINE__);
        }
        $this->FoodAndBeverageBudget = $foodAndBeverageBudget;
        return $this;
    }
    /**
     * Get TotalMeetingRooms value
     * @return int|null
     */
    public function getTotalMeetingRooms()
    {
        return $this->TotalMeetingRooms;
    }
    /**
     * Set TotalMeetingRooms value
     * @param int $totalMeetingRooms
     * @return \StructType\RFPEventRequirementInfo
     */
    public function setTotalMeetingRooms($totalMeetingRooms = null)
    {
        // validation for constraint: int
        if (!is_null($totalMeetingRooms) && !(is_int($totalMeetingRooms) || ctype_digit($totalMeetingRooms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMeetingRooms, true), gettype($totalMeetingRooms)), __LINE__);
        }
        $this->TotalMeetingRooms = $totalMeetingRooms;
        return $this;
    }
    /**
     * Get MeetingRoomSizeType value
     * @return string|null
     */
    public function getMeetingRoomSizeType()
    {
        return $this->MeetingRoomSizeType;
    }
    /**
     * Set MeetingRoomSizeType value
     * @param string $meetingRoomSizeType
     * @return \StructType\RFPEventRequirementInfo
     */
    public function setMeetingRoomSizeType($meetingRoomSizeType = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomSizeType) && !is_string($meetingRoomSizeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomSizeType, true), gettype($meetingRoomSizeType)), __LINE__);
        }
        $this->MeetingRoomSizeType = $meetingRoomSizeType;
        return $this;
    }
    /**
     * Get MeetingRoomAdditionalInformation value
     * @return string|null
     */
    public function getMeetingRoomAdditionalInformation()
    {
        return $this->MeetingRoomAdditionalInformation;
    }
    /**
     * Set MeetingRoomAdditionalInformation value
     * @param string $meetingRoomAdditionalInformation
     * @return \StructType\RFPEventRequirementInfo
     */
    public function setMeetingRoomAdditionalInformation($meetingRoomAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomAdditionalInformation) && !is_string($meetingRoomAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomAdditionalInformation, true), gettype($meetingRoomAdditionalInformation)), __LINE__);
        }
        $this->MeetingRoomAdditionalInformation = $meetingRoomAdditionalInformation;
        return $this;
    }
    /**
     * Get AmenityAdditionalInformation value
     * @return string|null
     */
    public function getAmenityAdditionalInformation()
    {
        return $this->AmenityAdditionalInformation;
    }
    /**
     * Set AmenityAdditionalInformation value
     * @param string $amenityAdditionalInformation
     * @return \StructType\RFPEventRequirementInfo
     */
    public function setAmenityAdditionalInformation($amenityAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($amenityAdditionalInformation) && !is_string($amenityAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amenityAdditionalInformation, true), gettype($amenityAdditionalInformation)), __LINE__);
        }
        $this->AmenityAdditionalInformation = $amenityAdditionalInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPEventRequirementInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
