<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPEventHistoryDetail StructType
 * @subpackage Structs
 */
class RFPEventHistoryDetail extends BaseRFPEventHistoryDetail
{
    /**
     * The EventHistoryNote
     * @var string
     */
    public $EventHistoryNote;
    /**
     * The FoodAndBeverageSpend
     * @var string
     */
    public $FoodAndBeverageSpend;
    /**
     * Constructor method for RFPEventHistoryDetail
     * @uses RFPEventHistoryDetail::setEventHistoryNote()
     * @uses RFPEventHistoryDetail::setFoodAndBeverageSpend()
     * @param string $eventHistoryNote
     * @param string $foodAndBeverageSpend
     */
    public function __construct($eventHistoryNote = null, $foodAndBeverageSpend = null)
    {
        $this
            ->setEventHistoryNote($eventHistoryNote)
            ->setFoodAndBeverageSpend($foodAndBeverageSpend);
    }
    /**
     * Get EventHistoryNote value
     * @return string|null
     */
    public function getEventHistoryNote()
    {
        return $this->EventHistoryNote;
    }
    /**
     * Set EventHistoryNote value
     * @param string $eventHistoryNote
     * @return \StructType\RFPEventHistoryDetail
     */
    public function setEventHistoryNote($eventHistoryNote = null)
    {
        // validation for constraint: string
        if (!is_null($eventHistoryNote) && !is_string($eventHistoryNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventHistoryNote, true), gettype($eventHistoryNote)), __LINE__);
        }
        $this->EventHistoryNote = $eventHistoryNote;
        return $this;
    }
    /**
     * Get FoodAndBeverageSpend value
     * @return string|null
     */
    public function getFoodAndBeverageSpend()
    {
        return $this->FoodAndBeverageSpend;
    }
    /**
     * Set FoodAndBeverageSpend value
     * @param string $foodAndBeverageSpend
     * @return \StructType\RFPEventHistoryDetail
     */
    public function setFoodAndBeverageSpend($foodAndBeverageSpend = null)
    {
        // validation for constraint: string
        if (!is_null($foodAndBeverageSpend) && !is_string($foodAndBeverageSpend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foodAndBeverageSpend, true), gettype($foodAndBeverageSpend)), __LINE__);
        }
        $this->FoodAndBeverageSpend = $foodAndBeverageSpend;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPEventHistoryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
