<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFPDinnerInfo StructType
 * @subpackage Structs
 */
class RFPDinnerInfo extends AbstractStructBase
{
    /**
     * The DinnerStartDate
     * @var string
     */
    public $DinnerStartDate;
    /**
     * The DinnerEndDate
     * @var string
     */
    public $DinnerEndDate;
    /**
     * The DinnerAttendees
     * @var int
     */
    public $DinnerAttendees;
    /**
     * The DinnerFoodAndBeverage
     * @var float
     */
    public $DinnerFoodAndBeverage;
    /**
     * The DinnerContractSignatureLocation
     * @var string
     */
    public $DinnerContractSignatureLocation;
    /**
     * The DinnerAdditionalInformation
     * @var string
     */
    public $DinnerAdditionalInformation;
    /**
     * The DinnerPrivateRoom
     * @var bool
     */
    public $DinnerPrivateRoom;
    /**
     * The DinnerAVRequirements
     * @var string
     */
    public $DinnerAVRequirements;
    /**
     * The DinnerAlcoholPolicy
     * @var string
     */
    public $DinnerAlcoholPolicy;
    /**
     * The DinnerSpecialNeeds
     * @var string
     */
    public $DinnerSpecialNeeds;
    /**
     * Constructor method for RFPDinnerInfo
     * @uses RFPDinnerInfo::setDinnerStartDate()
     * @uses RFPDinnerInfo::setDinnerEndDate()
     * @uses RFPDinnerInfo::setDinnerAttendees()
     * @uses RFPDinnerInfo::setDinnerFoodAndBeverage()
     * @uses RFPDinnerInfo::setDinnerContractSignatureLocation()
     * @uses RFPDinnerInfo::setDinnerAdditionalInformation()
     * @uses RFPDinnerInfo::setDinnerPrivateRoom()
     * @uses RFPDinnerInfo::setDinnerAVRequirements()
     * @uses RFPDinnerInfo::setDinnerAlcoholPolicy()
     * @uses RFPDinnerInfo::setDinnerSpecialNeeds()
     * @param string $dinnerStartDate
     * @param string $dinnerEndDate
     * @param int $dinnerAttendees
     * @param float $dinnerFoodAndBeverage
     * @param string $dinnerContractSignatureLocation
     * @param string $dinnerAdditionalInformation
     * @param bool $dinnerPrivateRoom
     * @param string $dinnerAVRequirements
     * @param string $dinnerAlcoholPolicy
     * @param string $dinnerSpecialNeeds
     */
    public function __construct($dinnerStartDate = null, $dinnerEndDate = null, $dinnerAttendees = null, $dinnerFoodAndBeverage = null, $dinnerContractSignatureLocation = null, $dinnerAdditionalInformation = null, $dinnerPrivateRoom = null, $dinnerAVRequirements = null, $dinnerAlcoholPolicy = null, $dinnerSpecialNeeds = null)
    {
        $this
            ->setDinnerStartDate($dinnerStartDate)
            ->setDinnerEndDate($dinnerEndDate)
            ->setDinnerAttendees($dinnerAttendees)
            ->setDinnerFoodAndBeverage($dinnerFoodAndBeverage)
            ->setDinnerContractSignatureLocation($dinnerContractSignatureLocation)
            ->setDinnerAdditionalInformation($dinnerAdditionalInformation)
            ->setDinnerPrivateRoom($dinnerPrivateRoom)
            ->setDinnerAVRequirements($dinnerAVRequirements)
            ->setDinnerAlcoholPolicy($dinnerAlcoholPolicy)
            ->setDinnerSpecialNeeds($dinnerSpecialNeeds);
    }
    /**
     * Get DinnerStartDate value
     * @return string|null
     */
    public function getDinnerStartDate()
    {
        return $this->DinnerStartDate;
    }
    /**
     * Set DinnerStartDate value
     * @param string $dinnerStartDate
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerStartDate($dinnerStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($dinnerStartDate) && !is_string($dinnerStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dinnerStartDate, true), gettype($dinnerStartDate)), __LINE__);
        }
        $this->DinnerStartDate = $dinnerStartDate;
        return $this;
    }
    /**
     * Get DinnerEndDate value
     * @return string|null
     */
    public function getDinnerEndDate()
    {
        return $this->DinnerEndDate;
    }
    /**
     * Set DinnerEndDate value
     * @param string $dinnerEndDate
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerEndDate($dinnerEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($dinnerEndDate) && !is_string($dinnerEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dinnerEndDate, true), gettype($dinnerEndDate)), __LINE__);
        }
        $this->DinnerEndDate = $dinnerEndDate;
        return $this;
    }
    /**
     * Get DinnerAttendees value
     * @return int|null
     */
    public function getDinnerAttendees()
    {
        return $this->DinnerAttendees;
    }
    /**
     * Set DinnerAttendees value
     * @param int $dinnerAttendees
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerAttendees($dinnerAttendees = null)
    {
        // validation for constraint: int
        if (!is_null($dinnerAttendees) && !(is_int($dinnerAttendees) || ctype_digit($dinnerAttendees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dinnerAttendees, true), gettype($dinnerAttendees)), __LINE__);
        }
        $this->DinnerAttendees = $dinnerAttendees;
        return $this;
    }
    /**
     * Get DinnerFoodAndBeverage value
     * @return float|null
     */
    public function getDinnerFoodAndBeverage()
    {
        return $this->DinnerFoodAndBeverage;
    }
    /**
     * Set DinnerFoodAndBeverage value
     * @param float $dinnerFoodAndBeverage
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerFoodAndBeverage($dinnerFoodAndBeverage = null)
    {
        // validation for constraint: float
        if (!is_null($dinnerFoodAndBeverage) && !(is_float($dinnerFoodAndBeverage) || is_numeric($dinnerFoodAndBeverage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dinnerFoodAndBeverage, true), gettype($dinnerFoodAndBeverage)), __LINE__);
        }
        $this->DinnerFoodAndBeverage = $dinnerFoodAndBeverage;
        return $this;
    }
    /**
     * Get DinnerContractSignatureLocation value
     * @return string|null
     */
    public function getDinnerContractSignatureLocation()
    {
        return $this->DinnerContractSignatureLocation;
    }
    /**
     * Set DinnerContractSignatureLocation value
     * @param string $dinnerContractSignatureLocation
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerContractSignatureLocation($dinnerContractSignatureLocation = null)
    {
        // validation for constraint: string
        if (!is_null($dinnerContractSignatureLocation) && !is_string($dinnerContractSignatureLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dinnerContractSignatureLocation, true), gettype($dinnerContractSignatureLocation)), __LINE__);
        }
        $this->DinnerContractSignatureLocation = $dinnerContractSignatureLocation;
        return $this;
    }
    /**
     * Get DinnerAdditionalInformation value
     * @return string|null
     */
    public function getDinnerAdditionalInformation()
    {
        return $this->DinnerAdditionalInformation;
    }
    /**
     * Set DinnerAdditionalInformation value
     * @param string $dinnerAdditionalInformation
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerAdditionalInformation($dinnerAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($dinnerAdditionalInformation) && !is_string($dinnerAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dinnerAdditionalInformation, true), gettype($dinnerAdditionalInformation)), __LINE__);
        }
        $this->DinnerAdditionalInformation = $dinnerAdditionalInformation;
        return $this;
    }
    /**
     * Get DinnerPrivateRoom value
     * @return bool|null
     */
    public function getDinnerPrivateRoom()
    {
        return $this->DinnerPrivateRoom;
    }
    /**
     * Set DinnerPrivateRoom value
     * @param bool $dinnerPrivateRoom
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerPrivateRoom($dinnerPrivateRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($dinnerPrivateRoom) && !is_bool($dinnerPrivateRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dinnerPrivateRoom, true), gettype($dinnerPrivateRoom)), __LINE__);
        }
        $this->DinnerPrivateRoom = $dinnerPrivateRoom;
        return $this;
    }
    /**
     * Get DinnerAVRequirements value
     * @return string|null
     */
    public function getDinnerAVRequirements()
    {
        return $this->DinnerAVRequirements;
    }
    /**
     * Set DinnerAVRequirements value
     * @param string $dinnerAVRequirements
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerAVRequirements($dinnerAVRequirements = null)
    {
        // validation for constraint: string
        if (!is_null($dinnerAVRequirements) && !is_string($dinnerAVRequirements)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dinnerAVRequirements, true), gettype($dinnerAVRequirements)), __LINE__);
        }
        $this->DinnerAVRequirements = $dinnerAVRequirements;
        return $this;
    }
    /**
     * Get DinnerAlcoholPolicy value
     * @return string|null
     */
    public function getDinnerAlcoholPolicy()
    {
        return $this->DinnerAlcoholPolicy;
    }
    /**
     * Set DinnerAlcoholPolicy value
     * @param string $dinnerAlcoholPolicy
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerAlcoholPolicy($dinnerAlcoholPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($dinnerAlcoholPolicy) && !is_string($dinnerAlcoholPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dinnerAlcoholPolicy, true), gettype($dinnerAlcoholPolicy)), __LINE__);
        }
        $this->DinnerAlcoholPolicy = $dinnerAlcoholPolicy;
        return $this;
    }
    /**
     * Get DinnerSpecialNeeds value
     * @return string|null
     */
    public function getDinnerSpecialNeeds()
    {
        return $this->DinnerSpecialNeeds;
    }
    /**
     * Set DinnerSpecialNeeds value
     * @param string $dinnerSpecialNeeds
     * @return \StructType\RFPDinnerInfo
     */
    public function setDinnerSpecialNeeds($dinnerSpecialNeeds = null)
    {
        // validation for constraint: string
        if (!is_null($dinnerSpecialNeeds) && !is_string($dinnerSpecialNeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dinnerSpecialNeeds, true), gettype($dinnerSpecialNeeds)), __LINE__);
        }
        $this->DinnerSpecialNeeds = $dinnerSpecialNeeds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFPDinnerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
