<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFP StructType
 * @subpackage Structs
 */
class RFP extends CvObject
{
    /**
     * The EventInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPEventInfo
     */
    public $EventInfo;
    /**
     * The AlternateDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPAlternateDate[]
     */
    public $AlternateDates;
    /**
     * The OrganizationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPOrganizationInfo
     */
    public $OrganizationInfo;
    /**
     * The KeyContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPKeyContactInfo
     */
    public $KeyContactInfo;
    /**
     * The EventRequirementInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPEventRequirementInfo
     */
    public $EventRequirementInfo;
    /**
     * The SleepRoomInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPSleepRoomInfo
     */
    public $SleepRoomInfo;
    /**
     * The AttachmentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPAttachmentDetail[]
     */
    public $AttachmentDetail;
    /**
     * The QuestionDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPQuestionDetail[]
     */
    public $QuestionDetail;
    /**
     * The DinnerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RFPDinnerInfo
     */
    public $DinnerInfo;
    /**
     * The SupplierDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPSupplierDetail[]
     */
    public $SupplierDetail;
    /**
     * The ContractedDataDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractedDataDetail[]
     */
    public $ContractedDataDetail;
    /**
     * The UserVisibilityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserDetail[]
     */
    public $UserVisibilityDetail;
    /**
     * The UserGroupVisibilityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserGroupDetail[]
     */
    public $UserGroupVisibilityDetail;
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The RFPType
     * @var string
     */
    public $RFPType;
    /**
     * The RFPStatus
     * @var string
     */
    public $RFPStatus;
    /**
     * The RFPCode
     * @var string
     */
    public $RFPCode;
    /**
     * The RFPName
     * @var string
     */
    public $RFPName;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The ResponseDueDate
     * @var string
     */
    public $ResponseDueDate;
    /**
     * The DecisionDate
     * @var string
     */
    public $DecisionDate;
    /**
     * The AwardedDate
     * @var string
     */
    public $AwardedDate;
    /**
     * The CancelledDate
     * @var string
     */
    public $CancelledDate;
    /**
     * The CancelReason
     * @var string
     */
    public $CancelReason;
    /**
     * The CancelReasonComments
     * @var string
     */
    public $CancelReasonComments;
    /**
     * The MultiAwarded
     * @var bool
     */
    public $MultiAwarded;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The RFPDescription
     * @var string
     */
    public $RFPDescription;
    /**
     * The DecisionFactors
     * @var string
     */
    public $DecisionFactors;
    /**
     * The Commissionable
     * @var bool
     */
    public $Commissionable;
    /**
     * The CommissionRate
     * @var float
     */
    public $CommissionRate;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The ReceivePackageRatesResponse
     * @var bool
     */
    public $ReceivePackageRatesResponse;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The Archived
     * @var bool
     */
    public $Archived;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The QuickRFP
     * @var bool
     */
    public $QuickRFP;
    /**
     * The CityWideFlag
     * @var bool
     */
    public $CityWideFlag;
    /**
     * The AcceptRebates
     * @var bool
     */
    public $AcceptRebates;
    /**
     * The Rebate
     * @var float
     */
    public $Rebate;
    /**
     * The RebateType
     * @var string
     */
    public $RebateType;
    /**
     * Constructor method for RFP
     * @uses RFP::setEventInfo()
     * @uses RFP::setAlternateDates()
     * @uses RFP::setOrganizationInfo()
     * @uses RFP::setKeyContactInfo()
     * @uses RFP::setEventRequirementInfo()
     * @uses RFP::setSleepRoomInfo()
     * @uses RFP::setAttachmentDetail()
     * @uses RFP::setQuestionDetail()
     * @uses RFP::setDinnerInfo()
     * @uses RFP::setSupplierDetail()
     * @uses RFP::setContractedDataDetail()
     * @uses RFP::setUserVisibilityDetail()
     * @uses RFP::setUserGroupVisibilityDetail()
     * @uses RFP::setCustomFieldDetail()
     * @uses RFP::setRFPType()
     * @uses RFP::setRFPStatus()
     * @uses RFP::setRFPCode()
     * @uses RFP::setRFPName()
     * @uses RFP::setEventId()
     * @uses RFP::setEventCode()
     * @uses RFP::setEventTitle()
     * @uses RFP::setResponseDueDate()
     * @uses RFP::setDecisionDate()
     * @uses RFP::setAwardedDate()
     * @uses RFP::setCancelledDate()
     * @uses RFP::setCancelReason()
     * @uses RFP::setCancelReasonComments()
     * @uses RFP::setMultiAwarded()
     * @uses RFP::setCurrency()
     * @uses RFP::setRFPDescription()
     * @uses RFP::setDecisionFactors()
     * @uses RFP::setCommissionable()
     * @uses RFP::setCommissionRate()
     * @uses RFP::setInternalNote()
     * @uses RFP::setReceivePackageRatesResponse()
     * @uses RFP::setCreatedDate()
     * @uses RFP::setArchived()
     * @uses RFP::setCreatedBy()
     * @uses RFP::setLastModifiedDate()
     * @uses RFP::setLastModifiedBy()
     * @uses RFP::setQuickRFP()
     * @uses RFP::setCityWideFlag()
     * @uses RFP::setAcceptRebates()
     * @uses RFP::setRebate()
     * @uses RFP::setRebateType()
     * @param \StructType\RFPEventInfo $eventInfo
     * @param \StructType\RFPAlternateDate[] $alternateDates
     * @param \StructType\RFPOrganizationInfo $organizationInfo
     * @param \StructType\RFPKeyContactInfo $keyContactInfo
     * @param \StructType\RFPEventRequirementInfo $eventRequirementInfo
     * @param \StructType\RFPSleepRoomInfo $sleepRoomInfo
     * @param \StructType\RFPAttachmentDetail[] $attachmentDetail
     * @param \StructType\RFPQuestionDetail[] $questionDetail
     * @param \StructType\RFPDinnerInfo $dinnerInfo
     * @param \StructType\RFPSupplierDetail[] $supplierDetail
     * @param \StructType\ContractedDataDetail[] $contractedDataDetail
     * @param \StructType\UserDetail[] $userVisibilityDetail
     * @param \StructType\UserGroupDetail[] $userGroupVisibilityDetail
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param string $rFPType
     * @param string $rFPStatus
     * @param string $rFPCode
     * @param string $rFPName
     * @param string $eventId
     * @param string $eventCode
     * @param string $eventTitle
     * @param string $responseDueDate
     * @param string $decisionDate
     * @param string $awardedDate
     * @param string $cancelledDate
     * @param string $cancelReason
     * @param string $cancelReasonComments
     * @param bool $multiAwarded
     * @param string $currency
     * @param string $rFPDescription
     * @param string $decisionFactors
     * @param bool $commissionable
     * @param float $commissionRate
     * @param string $internalNote
     * @param bool $receivePackageRatesResponse
     * @param string $createdDate
     * @param bool $archived
     * @param string $createdBy
     * @param string $lastModifiedDate
     * @param string $lastModifiedBy
     * @param bool $quickRFP
     * @param bool $cityWideFlag
     * @param bool $acceptRebates
     * @param float $rebate
     * @param string $rebateType
     */
    public function __construct(\StructType\RFPEventInfo $eventInfo = null, array $alternateDates = array(), \StructType\RFPOrganizationInfo $organizationInfo = null, \StructType\RFPKeyContactInfo $keyContactInfo = null, \StructType\RFPEventRequirementInfo $eventRequirementInfo = null, \StructType\RFPSleepRoomInfo $sleepRoomInfo = null, array $attachmentDetail = array(), array $questionDetail = array(), \StructType\RFPDinnerInfo $dinnerInfo = null, array $supplierDetail = array(), array $contractedDataDetail = array(), array $userVisibilityDetail = array(), array $userGroupVisibilityDetail = array(), array $customFieldDetail = array(), $rFPType = null, $rFPStatus = null, $rFPCode = null, $rFPName = null, $eventId = null, $eventCode = null, $eventTitle = null, $responseDueDate = null, $decisionDate = null, $awardedDate = null, $cancelledDate = null, $cancelReason = null, $cancelReasonComments = null, $multiAwarded = null, $currency = null, $rFPDescription = null, $decisionFactors = null, $commissionable = null, $commissionRate = null, $internalNote = null, $receivePackageRatesResponse = null, $createdDate = null, $archived = null, $createdBy = null, $lastModifiedDate = null, $lastModifiedBy = null, $quickRFP = null, $cityWideFlag = null, $acceptRebates = null, $rebate = null, $rebateType = null)
    {
        $this
            ->setEventInfo($eventInfo)
            ->setAlternateDates($alternateDates)
            ->setOrganizationInfo($organizationInfo)
            ->setKeyContactInfo($keyContactInfo)
            ->setEventRequirementInfo($eventRequirementInfo)
            ->setSleepRoomInfo($sleepRoomInfo)
            ->setAttachmentDetail($attachmentDetail)
            ->setQuestionDetail($questionDetail)
            ->setDinnerInfo($dinnerInfo)
            ->setSupplierDetail($supplierDetail)
            ->setContractedDataDetail($contractedDataDetail)
            ->setUserVisibilityDetail($userVisibilityDetail)
            ->setUserGroupVisibilityDetail($userGroupVisibilityDetail)
            ->setCustomFieldDetail($customFieldDetail)
            ->setRFPType($rFPType)
            ->setRFPStatus($rFPStatus)
            ->setRFPCode($rFPCode)
            ->setRFPName($rFPName)
            ->setEventId($eventId)
            ->setEventCode($eventCode)
            ->setEventTitle($eventTitle)
            ->setResponseDueDate($responseDueDate)
            ->setDecisionDate($decisionDate)
            ->setAwardedDate($awardedDate)
            ->setCancelledDate($cancelledDate)
            ->setCancelReason($cancelReason)
            ->setCancelReasonComments($cancelReasonComments)
            ->setMultiAwarded($multiAwarded)
            ->setCurrency($currency)
            ->setRFPDescription($rFPDescription)
            ->setDecisionFactors($decisionFactors)
            ->setCommissionable($commissionable)
            ->setCommissionRate($commissionRate)
            ->setInternalNote($internalNote)
            ->setReceivePackageRatesResponse($receivePackageRatesResponse)
            ->setCreatedDate($createdDate)
            ->setArchived($archived)
            ->setCreatedBy($createdBy)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setQuickRFP($quickRFP)
            ->setCityWideFlag($cityWideFlag)
            ->setAcceptRebates($acceptRebates)
            ->setRebate($rebate)
            ->setRebateType($rebateType);
    }
    /**
     * Get EventInfo value
     * @return \StructType\RFPEventInfo|null
     */
    public function getEventInfo()
    {
        return $this->EventInfo;
    }
    /**
     * Set EventInfo value
     * @param \StructType\RFPEventInfo $eventInfo
     * @return \StructType\RFP
     */
    public function setEventInfo(\StructType\RFPEventInfo $eventInfo = null)
    {
        $this->EventInfo = $eventInfo;
        return $this;
    }
    /**
     * Get AlternateDates value
     * @return \StructType\RFPAlternateDate[]|null
     */
    public function getAlternateDates()
    {
        return $this->AlternateDates;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternateDates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateDates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternateDatesForArrayConstraintsFromSetAlternateDates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPAlternateDatesItem) {
            // validation for constraint: itemType
            if (!$rFPAlternateDatesItem instanceof \StructType\RFPAlternateDate) {
                $invalidValues[] = is_object($rFPAlternateDatesItem) ? get_class($rFPAlternateDatesItem) : sprintf('%s(%s)', gettype($rFPAlternateDatesItem), var_export($rFPAlternateDatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlternateDates property can only contain items of type \StructType\RFPAlternateDate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlternateDates value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPAlternateDate[] $alternateDates
     * @return \StructType\RFP
     */
    public function setAlternateDates(array $alternateDates = array())
    {
        // validation for constraint: array
        if ('' !== ($alternateDatesArrayErrorMessage = self::validateAlternateDatesForArrayConstraintsFromSetAlternateDates($alternateDates))) {
            throw new \InvalidArgumentException($alternateDatesArrayErrorMessage, __LINE__);
        }
        $this->AlternateDates = $alternateDates;
        return $this;
    }
    /**
     * Add item to AlternateDates value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPAlternateDate $item
     * @return \StructType\RFP
     */
    public function addToAlternateDates(\StructType\RFPAlternateDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPAlternateDate) {
            throw new \InvalidArgumentException(sprintf('The AlternateDates property can only contain items of type \StructType\RFPAlternateDate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlternateDates[] = $item;
        return $this;
    }
    /**
     * Get OrganizationInfo value
     * @return \StructType\RFPOrganizationInfo|null
     */
    public function getOrganizationInfo()
    {
        return $this->OrganizationInfo;
    }
    /**
     * Set OrganizationInfo value
     * @param \StructType\RFPOrganizationInfo $organizationInfo
     * @return \StructType\RFP
     */
    public function setOrganizationInfo(\StructType\RFPOrganizationInfo $organizationInfo = null)
    {
        $this->OrganizationInfo = $organizationInfo;
        return $this;
    }
    /**
     * Get KeyContactInfo value
     * @return \StructType\RFPKeyContactInfo|null
     */
    public function getKeyContactInfo()
    {
        return $this->KeyContactInfo;
    }
    /**
     * Set KeyContactInfo value
     * @param \StructType\RFPKeyContactInfo $keyContactInfo
     * @return \StructType\RFP
     */
    public function setKeyContactInfo(\StructType\RFPKeyContactInfo $keyContactInfo = null)
    {
        $this->KeyContactInfo = $keyContactInfo;
        return $this;
    }
    /**
     * Get EventRequirementInfo value
     * @return \StructType\RFPEventRequirementInfo|null
     */
    public function getEventRequirementInfo()
    {
        return $this->EventRequirementInfo;
    }
    /**
     * Set EventRequirementInfo value
     * @param \StructType\RFPEventRequirementInfo $eventRequirementInfo
     * @return \StructType\RFP
     */
    public function setEventRequirementInfo(\StructType\RFPEventRequirementInfo $eventRequirementInfo = null)
    {
        $this->EventRequirementInfo = $eventRequirementInfo;
        return $this;
    }
    /**
     * Get SleepRoomInfo value
     * @return \StructType\RFPSleepRoomInfo|null
     */
    public function getSleepRoomInfo()
    {
        return $this->SleepRoomInfo;
    }
    /**
     * Set SleepRoomInfo value
     * @param \StructType\RFPSleepRoomInfo $sleepRoomInfo
     * @return \StructType\RFP
     */
    public function setSleepRoomInfo(\StructType\RFPSleepRoomInfo $sleepRoomInfo = null)
    {
        $this->SleepRoomInfo = $sleepRoomInfo;
        return $this;
    }
    /**
     * Get AttachmentDetail value
     * @return \StructType\RFPAttachmentDetail[]|null
     */
    public function getAttachmentDetail()
    {
        return $this->AttachmentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachmentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachmentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentDetailForArrayConstraintsFromSetAttachmentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPAttachmentDetailItem) {
            // validation for constraint: itemType
            if (!$rFPAttachmentDetailItem instanceof \StructType\RFPAttachmentDetail) {
                $invalidValues[] = is_object($rFPAttachmentDetailItem) ? get_class($rFPAttachmentDetailItem) : sprintf('%s(%s)', gettype($rFPAttachmentDetailItem), var_export($rFPAttachmentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttachmentDetail property can only contain items of type \StructType\RFPAttachmentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttachmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPAttachmentDetail[] $attachmentDetail
     * @return \StructType\RFP
     */
    public function setAttachmentDetail(array $attachmentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentDetailArrayErrorMessage = self::validateAttachmentDetailForArrayConstraintsFromSetAttachmentDetail($attachmentDetail))) {
            throw new \InvalidArgumentException($attachmentDetailArrayErrorMessage, __LINE__);
        }
        $this->AttachmentDetail = $attachmentDetail;
        return $this;
    }
    /**
     * Add item to AttachmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPAttachmentDetail $item
     * @return \StructType\RFP
     */
    public function addToAttachmentDetail(\StructType\RFPAttachmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPAttachmentDetail) {
            throw new \InvalidArgumentException(sprintf('The AttachmentDetail property can only contain items of type \StructType\RFPAttachmentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttachmentDetail[] = $item;
        return $this;
    }
    /**
     * Get QuestionDetail value
     * @return \StructType\RFPQuestionDetail[]|null
     */
    public function getQuestionDetail()
    {
        return $this->QuestionDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestionDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestionDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestionDetailForArrayConstraintsFromSetQuestionDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPQuestionDetailItem) {
            // validation for constraint: itemType
            if (!$rFPQuestionDetailItem instanceof \StructType\RFPQuestionDetail) {
                $invalidValues[] = is_object($rFPQuestionDetailItem) ? get_class($rFPQuestionDetailItem) : sprintf('%s(%s)', gettype($rFPQuestionDetailItem), var_export($rFPQuestionDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The QuestionDetail property can only contain items of type \StructType\RFPQuestionDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set QuestionDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPQuestionDetail[] $questionDetail
     * @return \StructType\RFP
     */
    public function setQuestionDetail(array $questionDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($questionDetailArrayErrorMessage = self::validateQuestionDetailForArrayConstraintsFromSetQuestionDetail($questionDetail))) {
            throw new \InvalidArgumentException($questionDetailArrayErrorMessage, __LINE__);
        }
        $this->QuestionDetail = $questionDetail;
        return $this;
    }
    /**
     * Add item to QuestionDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPQuestionDetail $item
     * @return \StructType\RFP
     */
    public function addToQuestionDetail(\StructType\RFPQuestionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPQuestionDetail) {
            throw new \InvalidArgumentException(sprintf('The QuestionDetail property can only contain items of type \StructType\RFPQuestionDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->QuestionDetail[] = $item;
        return $this;
    }
    /**
     * Get DinnerInfo value
     * @return \StructType\RFPDinnerInfo|null
     */
    public function getDinnerInfo()
    {
        return $this->DinnerInfo;
    }
    /**
     * Set DinnerInfo value
     * @param \StructType\RFPDinnerInfo $dinnerInfo
     * @return \StructType\RFP
     */
    public function setDinnerInfo(\StructType\RFPDinnerInfo $dinnerInfo = null)
    {
        $this->DinnerInfo = $dinnerInfo;
        return $this;
    }
    /**
     * Get SupplierDetail value
     * @return \StructType\RFPSupplierDetail[]|null
     */
    public function getSupplierDetail()
    {
        return $this->SupplierDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplierDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplierDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplierDetailForArrayConstraintsFromSetSupplierDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPSupplierDetailItem) {
            // validation for constraint: itemType
            if (!$rFPSupplierDetailItem instanceof \StructType\RFPSupplierDetail) {
                $invalidValues[] = is_object($rFPSupplierDetailItem) ? get_class($rFPSupplierDetailItem) : sprintf('%s(%s)', gettype($rFPSupplierDetailItem), var_export($rFPSupplierDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplierDetail property can only contain items of type \StructType\RFPSupplierDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplierDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPSupplierDetail[] $supplierDetail
     * @return \StructType\RFP
     */
    public function setSupplierDetail(array $supplierDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($supplierDetailArrayErrorMessage = self::validateSupplierDetailForArrayConstraintsFromSetSupplierDetail($supplierDetail))) {
            throw new \InvalidArgumentException($supplierDetailArrayErrorMessage, __LINE__);
        }
        $this->SupplierDetail = $supplierDetail;
        return $this;
    }
    /**
     * Add item to SupplierDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPSupplierDetail $item
     * @return \StructType\RFP
     */
    public function addToSupplierDetail(\StructType\RFPSupplierDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPSupplierDetail) {
            throw new \InvalidArgumentException(sprintf('The SupplierDetail property can only contain items of type \StructType\RFPSupplierDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SupplierDetail[] = $item;
        return $this;
    }
    /**
     * Get ContractedDataDetail value
     * @return \StructType\ContractedDataDetail[]|null
     */
    public function getContractedDataDetail()
    {
        return $this->ContractedDataDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setContractedDataDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContractedDataDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractedDataDetailForArrayConstraintsFromSetContractedDataDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPContractedDataDetailItem) {
            // validation for constraint: itemType
            if (!$rFPContractedDataDetailItem instanceof \StructType\ContractedDataDetail) {
                $invalidValues[] = is_object($rFPContractedDataDetailItem) ? get_class($rFPContractedDataDetailItem) : sprintf('%s(%s)', gettype($rFPContractedDataDetailItem), var_export($rFPContractedDataDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContractedDataDetail property can only contain items of type \StructType\ContractedDataDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContractedDataDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractedDataDetail[] $contractedDataDetail
     * @return \StructType\RFP
     */
    public function setContractedDataDetail(array $contractedDataDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($contractedDataDetailArrayErrorMessage = self::validateContractedDataDetailForArrayConstraintsFromSetContractedDataDetail($contractedDataDetail))) {
            throw new \InvalidArgumentException($contractedDataDetailArrayErrorMessage, __LINE__);
        }
        $this->ContractedDataDetail = $contractedDataDetail;
        return $this;
    }
    /**
     * Add item to ContractedDataDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractedDataDetail $item
     * @return \StructType\RFP
     */
    public function addToContractedDataDetail(\StructType\ContractedDataDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractedDataDetail) {
            throw new \InvalidArgumentException(sprintf('The ContractedDataDetail property can only contain items of type \StructType\ContractedDataDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContractedDataDetail[] = $item;
        return $this;
    }
    /**
     * Get UserVisibilityDetail value
     * @return \StructType\UserDetail[]|null
     */
    public function getUserVisibilityDetail()
    {
        return $this->UserVisibilityDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setUserVisibilityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserVisibilityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserVisibilityDetailForArrayConstraintsFromSetUserVisibilityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPUserVisibilityDetailItem) {
            // validation for constraint: itemType
            if (!$rFPUserVisibilityDetailItem instanceof \StructType\UserDetail) {
                $invalidValues[] = is_object($rFPUserVisibilityDetailItem) ? get_class($rFPUserVisibilityDetailItem) : sprintf('%s(%s)', gettype($rFPUserVisibilityDetailItem), var_export($rFPUserVisibilityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserVisibilityDetail property can only contain items of type \StructType\UserDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserVisibilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\UserDetail[] $userVisibilityDetail
     * @return \StructType\RFP
     */
    public function setUserVisibilityDetail(array $userVisibilityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($userVisibilityDetailArrayErrorMessage = self::validateUserVisibilityDetailForArrayConstraintsFromSetUserVisibilityDetail($userVisibilityDetail))) {
            throw new \InvalidArgumentException($userVisibilityDetailArrayErrorMessage, __LINE__);
        }
        $this->UserVisibilityDetail = $userVisibilityDetail;
        return $this;
    }
    /**
     * Add item to UserVisibilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\UserDetail $item
     * @return \StructType\RFP
     */
    public function addToUserVisibilityDetail(\StructType\UserDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserDetail) {
            throw new \InvalidArgumentException(sprintf('The UserVisibilityDetail property can only contain items of type \StructType\UserDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserVisibilityDetail[] = $item;
        return $this;
    }
    /**
     * Get UserGroupVisibilityDetail value
     * @return \StructType\UserGroupDetail[]|null
     */
    public function getUserGroupVisibilityDetail()
    {
        return $this->UserGroupVisibilityDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setUserGroupVisibilityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserGroupVisibilityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserGroupVisibilityDetailForArrayConstraintsFromSetUserGroupVisibilityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPUserGroupVisibilityDetailItem) {
            // validation for constraint: itemType
            if (!$rFPUserGroupVisibilityDetailItem instanceof \StructType\UserGroupDetail) {
                $invalidValues[] = is_object($rFPUserGroupVisibilityDetailItem) ? get_class($rFPUserGroupVisibilityDetailItem) : sprintf('%s(%s)', gettype($rFPUserGroupVisibilityDetailItem), var_export($rFPUserGroupVisibilityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserGroupVisibilityDetail property can only contain items of type \StructType\UserGroupDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserGroupVisibilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\UserGroupDetail[] $userGroupVisibilityDetail
     * @return \StructType\RFP
     */
    public function setUserGroupVisibilityDetail(array $userGroupVisibilityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($userGroupVisibilityDetailArrayErrorMessage = self::validateUserGroupVisibilityDetailForArrayConstraintsFromSetUserGroupVisibilityDetail($userGroupVisibilityDetail))) {
            throw new \InvalidArgumentException($userGroupVisibilityDetailArrayErrorMessage, __LINE__);
        }
        $this->UserGroupVisibilityDetail = $userGroupVisibilityDetail;
        return $this;
    }
    /**
     * Add item to UserGroupVisibilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\UserGroupDetail $item
     * @return \StructType\RFP
     */
    public function addToUserGroupVisibilityDetail(\StructType\UserGroupDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserGroupDetail) {
            throw new \InvalidArgumentException(sprintf('The UserGroupVisibilityDetail property can only contain items of type \StructType\UserGroupDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserGroupVisibilityDetail[] = $item;
        return $this;
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFPCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$rFPCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($rFPCustomFieldDetailItem) ? get_class($rFPCustomFieldDetailItem) : sprintf('%s(%s)', gettype($rFPCustomFieldDetailItem), var_export($rFPCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\RFP
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\RFP
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get RFPType value
     * @return string|null
     */
    public function getRFPType()
    {
        return $this->RFPType;
    }
    /**
     * Set RFPType value
     * @param string $rFPType
     * @return \StructType\RFP
     */
    public function setRFPType($rFPType = null)
    {
        // validation for constraint: string
        if (!is_null($rFPType) && !is_string($rFPType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPType, true), gettype($rFPType)), __LINE__);
        }
        $this->RFPType = $rFPType;
        return $this;
    }
    /**
     * Get RFPStatus value
     * @return string|null
     */
    public function getRFPStatus()
    {
        return $this->RFPStatus;
    }
    /**
     * Set RFPStatus value
     * @param string $rFPStatus
     * @return \StructType\RFP
     */
    public function setRFPStatus($rFPStatus = null)
    {
        // validation for constraint: string
        if (!is_null($rFPStatus) && !is_string($rFPStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPStatus, true), gettype($rFPStatus)), __LINE__);
        }
        $this->RFPStatus = $rFPStatus;
        return $this;
    }
    /**
     * Get RFPCode value
     * @return string|null
     */
    public function getRFPCode()
    {
        return $this->RFPCode;
    }
    /**
     * Set RFPCode value
     * @param string $rFPCode
     * @return \StructType\RFP
     */
    public function setRFPCode($rFPCode = null)
    {
        // validation for constraint: string
        if (!is_null($rFPCode) && !is_string($rFPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPCode, true), gettype($rFPCode)), __LINE__);
        }
        $this->RFPCode = $rFPCode;
        return $this;
    }
    /**
     * Get RFPName value
     * @return string|null
     */
    public function getRFPName()
    {
        return $this->RFPName;
    }
    /**
     * Set RFPName value
     * @param string $rFPName
     * @return \StructType\RFP
     */
    public function setRFPName($rFPName = null)
    {
        // validation for constraint: string
        if (!is_null($rFPName) && !is_string($rFPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPName, true), gettype($rFPName)), __LINE__);
        }
        $this->RFPName = $rFPName;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\RFP
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\RFP
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\RFP
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get ResponseDueDate value
     * @return string|null
     */
    public function getResponseDueDate()
    {
        return $this->ResponseDueDate;
    }
    /**
     * Set ResponseDueDate value
     * @param string $responseDueDate
     * @return \StructType\RFP
     */
    public function setResponseDueDate($responseDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($responseDueDate) && !is_string($responseDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDueDate, true), gettype($responseDueDate)), __LINE__);
        }
        $this->ResponseDueDate = $responseDueDate;
        return $this;
    }
    /**
     * Get DecisionDate value
     * @return string|null
     */
    public function getDecisionDate()
    {
        return $this->DecisionDate;
    }
    /**
     * Set DecisionDate value
     * @param string $decisionDate
     * @return \StructType\RFP
     */
    public function setDecisionDate($decisionDate = null)
    {
        // validation for constraint: string
        if (!is_null($decisionDate) && !is_string($decisionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decisionDate, true), gettype($decisionDate)), __LINE__);
        }
        $this->DecisionDate = $decisionDate;
        return $this;
    }
    /**
     * Get AwardedDate value
     * @return string|null
     */
    public function getAwardedDate()
    {
        return $this->AwardedDate;
    }
    /**
     * Set AwardedDate value
     * @param string $awardedDate
     * @return \StructType\RFP
     */
    public function setAwardedDate($awardedDate = null)
    {
        // validation for constraint: string
        if (!is_null($awardedDate) && !is_string($awardedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awardedDate, true), gettype($awardedDate)), __LINE__);
        }
        $this->AwardedDate = $awardedDate;
        return $this;
    }
    /**
     * Get CancelledDate value
     * @return string|null
     */
    public function getCancelledDate()
    {
        return $this->CancelledDate;
    }
    /**
     * Set CancelledDate value
     * @param string $cancelledDate
     * @return \StructType\RFP
     */
    public function setCancelledDate($cancelledDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelledDate) && !is_string($cancelledDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelledDate, true), gettype($cancelledDate)), __LINE__);
        }
        $this->CancelledDate = $cancelledDate;
        return $this;
    }
    /**
     * Get CancelReason value
     * @return string|null
     */
    public function getCancelReason()
    {
        return $this->CancelReason;
    }
    /**
     * Set CancelReason value
     * @param string $cancelReason
     * @return \StructType\RFP
     */
    public function setCancelReason($cancelReason = null)
    {
        // validation for constraint: string
        if (!is_null($cancelReason) && !is_string($cancelReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelReason, true), gettype($cancelReason)), __LINE__);
        }
        $this->CancelReason = $cancelReason;
        return $this;
    }
    /**
     * Get CancelReasonComments value
     * @return string|null
     */
    public function getCancelReasonComments()
    {
        return $this->CancelReasonComments;
    }
    /**
     * Set CancelReasonComments value
     * @param string $cancelReasonComments
     * @return \StructType\RFP
     */
    public function setCancelReasonComments($cancelReasonComments = null)
    {
        // validation for constraint: string
        if (!is_null($cancelReasonComments) && !is_string($cancelReasonComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelReasonComments, true), gettype($cancelReasonComments)), __LINE__);
        }
        $this->CancelReasonComments = $cancelReasonComments;
        return $this;
    }
    /**
     * Get MultiAwarded value
     * @return bool|null
     */
    public function getMultiAwarded()
    {
        return $this->MultiAwarded;
    }
    /**
     * Set MultiAwarded value
     * @param bool $multiAwarded
     * @return \StructType\RFP
     */
    public function setMultiAwarded($multiAwarded = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiAwarded) && !is_bool($multiAwarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiAwarded, true), gettype($multiAwarded)), __LINE__);
        }
        $this->MultiAwarded = $multiAwarded;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\RFP
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get RFPDescription value
     * @return string|null
     */
    public function getRFPDescription()
    {
        return $this->RFPDescription;
    }
    /**
     * Set RFPDescription value
     * @param string $rFPDescription
     * @return \StructType\RFP
     */
    public function setRFPDescription($rFPDescription = null)
    {
        // validation for constraint: string
        if (!is_null($rFPDescription) && !is_string($rFPDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFPDescription, true), gettype($rFPDescription)), __LINE__);
        }
        $this->RFPDescription = $rFPDescription;
        return $this;
    }
    /**
     * Get DecisionFactors value
     * @return string|null
     */
    public function getDecisionFactors()
    {
        return $this->DecisionFactors;
    }
    /**
     * Set DecisionFactors value
     * @param string $decisionFactors
     * @return \StructType\RFP
     */
    public function setDecisionFactors($decisionFactors = null)
    {
        // validation for constraint: string
        if (!is_null($decisionFactors) && !is_string($decisionFactors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decisionFactors, true), gettype($decisionFactors)), __LINE__);
        }
        $this->DecisionFactors = $decisionFactors;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return bool|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param bool $commissionable
     * @return \StructType\RFP
     */
    public function setCommissionable($commissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionable) && !is_bool($commissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionable, true), gettype($commissionable)), __LINE__);
        }
        $this->Commissionable = $commissionable;
        return $this;
    }
    /**
     * Get CommissionRate value
     * @return float|null
     */
    public function getCommissionRate()
    {
        return $this->CommissionRate;
    }
    /**
     * Set CommissionRate value
     * @param float $commissionRate
     * @return \StructType\RFP
     */
    public function setCommissionRate($commissionRate = null)
    {
        // validation for constraint: float
        if (!is_null($commissionRate) && !(is_float($commissionRate) || is_numeric($commissionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionRate, true), gettype($commissionRate)), __LINE__);
        }
        $this->CommissionRate = $commissionRate;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\RFP
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get ReceivePackageRatesResponse value
     * @return bool|null
     */
    public function getReceivePackageRatesResponse()
    {
        return $this->ReceivePackageRatesResponse;
    }
    /**
     * Set ReceivePackageRatesResponse value
     * @param bool $receivePackageRatesResponse
     * @return \StructType\RFP
     */
    public function setReceivePackageRatesResponse($receivePackageRatesResponse = null)
    {
        // validation for constraint: boolean
        if (!is_null($receivePackageRatesResponse) && !is_bool($receivePackageRatesResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($receivePackageRatesResponse, true), gettype($receivePackageRatesResponse)), __LINE__);
        }
        $this->ReceivePackageRatesResponse = $receivePackageRatesResponse;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\RFP
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get Archived value
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->Archived;
    }
    /**
     * Set Archived value
     * @param bool $archived
     * @return \StructType\RFP
     */
    public function setArchived($archived = null)
    {
        // validation for constraint: boolean
        if (!is_null($archived) && !is_bool($archived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($archived, true), gettype($archived)), __LINE__);
        }
        $this->Archived = $archived;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\RFP
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\RFP
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\RFP
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get QuickRFP value
     * @return bool|null
     */
    public function getQuickRFP()
    {
        return $this->QuickRFP;
    }
    /**
     * Set QuickRFP value
     * @param bool $quickRFP
     * @return \StructType\RFP
     */
    public function setQuickRFP($quickRFP = null)
    {
        // validation for constraint: boolean
        if (!is_null($quickRFP) && !is_bool($quickRFP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($quickRFP, true), gettype($quickRFP)), __LINE__);
        }
        $this->QuickRFP = $quickRFP;
        return $this;
    }
    /**
     * Get CityWideFlag value
     * @return bool|null
     */
    public function getCityWideFlag()
    {
        return $this->CityWideFlag;
    }
    /**
     * Set CityWideFlag value
     * @param bool $cityWideFlag
     * @return \StructType\RFP
     */
    public function setCityWideFlag($cityWideFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($cityWideFlag) && !is_bool($cityWideFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cityWideFlag, true), gettype($cityWideFlag)), __LINE__);
        }
        $this->CityWideFlag = $cityWideFlag;
        return $this;
    }
    /**
     * Get AcceptRebates value
     * @return bool|null
     */
    public function getAcceptRebates()
    {
        return $this->AcceptRebates;
    }
    /**
     * Set AcceptRebates value
     * @param bool $acceptRebates
     * @return \StructType\RFP
     */
    public function setAcceptRebates($acceptRebates = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptRebates) && !is_bool($acceptRebates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acceptRebates, true), gettype($acceptRebates)), __LINE__);
        }
        $this->AcceptRebates = $acceptRebates;
        return $this;
    }
    /**
     * Get Rebate value
     * @return float|null
     */
    public function getRebate()
    {
        return $this->Rebate;
    }
    /**
     * Set Rebate value
     * @param float $rebate
     * @return \StructType\RFP
     */
    public function setRebate($rebate = null)
    {
        // validation for constraint: float
        if (!is_null($rebate) && !(is_float($rebate) || is_numeric($rebate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rebate, true), gettype($rebate)), __LINE__);
        }
        $this->Rebate = $rebate;
        return $this;
    }
    /**
     * Get RebateType value
     * @return string|null
     */
    public function getRebateType()
    {
        return $this->RebateType;
    }
    /**
     * Set RebateType value
     * @param string $rebateType
     * @return \StructType\RFP
     */
    public function setRebateType($rebateType = null)
    {
        // validation for constraint: string
        if (!is_null($rebateType) && !is_string($rebateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rebateType, true), gettype($rebateType)), __LINE__);
        }
        $this->RebateType = $rebateType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
