<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProposalSleepRoomInfo StructType
 * @subpackage Structs
 */
class ProposalSleepRoomInfo extends AbstractStructBase
{
    /**
     * The SleepRoomAvailabilityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProposalSleepRoomAvailabilityDetail[]
     */
    public $SleepRoomAvailabilityDetail;
    /**
     * The AdditionalFeeDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProposalAdditionalFeeDetail[]
     */
    public $AdditionalFeeDetail;
    /**
     * The CheckInDate
     * @var string
     */
    public $CheckInDate;
    /**
     * The SleepRoomNeedsMet
     * @var bool
     */
    public $SleepRoomNeedsMet;
    /**
     * The SleepRoomNeedsMetAdditionalInfo
     * @var string
     */
    public $SleepRoomNeedsMetAdditionalInfo;
    /**
     * The FeeAdditionalInformation
     * @var string
     */
    public $FeeAdditionalInformation;
    /**
     * Constructor method for ProposalSleepRoomInfo
     * @uses ProposalSleepRoomInfo::setSleepRoomAvailabilityDetail()
     * @uses ProposalSleepRoomInfo::setAdditionalFeeDetail()
     * @uses ProposalSleepRoomInfo::setCheckInDate()
     * @uses ProposalSleepRoomInfo::setSleepRoomNeedsMet()
     * @uses ProposalSleepRoomInfo::setSleepRoomNeedsMetAdditionalInfo()
     * @uses ProposalSleepRoomInfo::setFeeAdditionalInformation()
     * @param \StructType\ProposalSleepRoomAvailabilityDetail[] $sleepRoomAvailabilityDetail
     * @param \StructType\ProposalAdditionalFeeDetail[] $additionalFeeDetail
     * @param string $checkInDate
     * @param bool $sleepRoomNeedsMet
     * @param string $sleepRoomNeedsMetAdditionalInfo
     * @param string $feeAdditionalInformation
     */
    public function __construct(array $sleepRoomAvailabilityDetail = array(), array $additionalFeeDetail = array(), $checkInDate = null, $sleepRoomNeedsMet = null, $sleepRoomNeedsMetAdditionalInfo = null, $feeAdditionalInformation = null)
    {
        $this
            ->setSleepRoomAvailabilityDetail($sleepRoomAvailabilityDetail)
            ->setAdditionalFeeDetail($additionalFeeDetail)
            ->setCheckInDate($checkInDate)
            ->setSleepRoomNeedsMet($sleepRoomNeedsMet)
            ->setSleepRoomNeedsMetAdditionalInfo($sleepRoomNeedsMetAdditionalInfo)
            ->setFeeAdditionalInformation($feeAdditionalInformation);
    }
    /**
     * Get SleepRoomAvailabilityDetail value
     * @return \StructType\ProposalSleepRoomAvailabilityDetail[]|null
     */
    public function getSleepRoomAvailabilityDetail()
    {
        return $this->SleepRoomAvailabilityDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSleepRoomAvailabilityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSleepRoomAvailabilityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSleepRoomAvailabilityDetailForArrayConstraintsFromSetSleepRoomAvailabilityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $proposalSleepRoomInfoSleepRoomAvailabilityDetailItem) {
            // validation for constraint: itemType
            if (!$proposalSleepRoomInfoSleepRoomAvailabilityDetailItem instanceof \StructType\ProposalSleepRoomAvailabilityDetail) {
                $invalidValues[] = is_object($proposalSleepRoomInfoSleepRoomAvailabilityDetailItem) ? get_class($proposalSleepRoomInfoSleepRoomAvailabilityDetailItem) : sprintf('%s(%s)', gettype($proposalSleepRoomInfoSleepRoomAvailabilityDetailItem), var_export($proposalSleepRoomInfoSleepRoomAvailabilityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SleepRoomAvailabilityDetail property can only contain items of type \StructType\ProposalSleepRoomAvailabilityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SleepRoomAvailabilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalSleepRoomAvailabilityDetail[] $sleepRoomAvailabilityDetail
     * @return \StructType\ProposalSleepRoomInfo
     */
    public function setSleepRoomAvailabilityDetail(array $sleepRoomAvailabilityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($sleepRoomAvailabilityDetailArrayErrorMessage = self::validateSleepRoomAvailabilityDetailForArrayConstraintsFromSetSleepRoomAvailabilityDetail($sleepRoomAvailabilityDetail))) {
            throw new \InvalidArgumentException($sleepRoomAvailabilityDetailArrayErrorMessage, __LINE__);
        }
        $this->SleepRoomAvailabilityDetail = $sleepRoomAvailabilityDetail;
        return $this;
    }
    /**
     * Add item to SleepRoomAvailabilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalSleepRoomAvailabilityDetail $item
     * @return \StructType\ProposalSleepRoomInfo
     */
    public function addToSleepRoomAvailabilityDetail(\StructType\ProposalSleepRoomAvailabilityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProposalSleepRoomAvailabilityDetail) {
            throw new \InvalidArgumentException(sprintf('The SleepRoomAvailabilityDetail property can only contain items of type \StructType\ProposalSleepRoomAvailabilityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SleepRoomAvailabilityDetail[] = $item;
        return $this;
    }
    /**
     * Get AdditionalFeeDetail value
     * @return \StructType\ProposalAdditionalFeeDetail[]|null
     */
    public function getAdditionalFeeDetail()
    {
        return $this->AdditionalFeeDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalFeeDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalFeeDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalFeeDetailForArrayConstraintsFromSetAdditionalFeeDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $proposalSleepRoomInfoAdditionalFeeDetailItem) {
            // validation for constraint: itemType
            if (!$proposalSleepRoomInfoAdditionalFeeDetailItem instanceof \StructType\ProposalAdditionalFeeDetail) {
                $invalidValues[] = is_object($proposalSleepRoomInfoAdditionalFeeDetailItem) ? get_class($proposalSleepRoomInfoAdditionalFeeDetailItem) : sprintf('%s(%s)', gettype($proposalSleepRoomInfoAdditionalFeeDetailItem), var_export($proposalSleepRoomInfoAdditionalFeeDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalFeeDetail property can only contain items of type \StructType\ProposalAdditionalFeeDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalFeeDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalAdditionalFeeDetail[] $additionalFeeDetail
     * @return \StructType\ProposalSleepRoomInfo
     */
    public function setAdditionalFeeDetail(array $additionalFeeDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalFeeDetailArrayErrorMessage = self::validateAdditionalFeeDetailForArrayConstraintsFromSetAdditionalFeeDetail($additionalFeeDetail))) {
            throw new \InvalidArgumentException($additionalFeeDetailArrayErrorMessage, __LINE__);
        }
        $this->AdditionalFeeDetail = $additionalFeeDetail;
        return $this;
    }
    /**
     * Add item to AdditionalFeeDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalAdditionalFeeDetail $item
     * @return \StructType\ProposalSleepRoomInfo
     */
    public function addToAdditionalFeeDetail(\StructType\ProposalAdditionalFeeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProposalAdditionalFeeDetail) {
            throw new \InvalidArgumentException(sprintf('The AdditionalFeeDetail property can only contain items of type \StructType\ProposalAdditionalFeeDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalFeeDetail[] = $item;
        return $this;
    }
    /**
     * Get CheckInDate value
     * @return string|null
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \StructType\ProposalSleepRoomInfo
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInDate, true), gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get SleepRoomNeedsMet value
     * @return bool|null
     */
    public function getSleepRoomNeedsMet()
    {
        return $this->SleepRoomNeedsMet;
    }
    /**
     * Set SleepRoomNeedsMet value
     * @param bool $sleepRoomNeedsMet
     * @return \StructType\ProposalSleepRoomInfo
     */
    public function setSleepRoomNeedsMet($sleepRoomNeedsMet = null)
    {
        // validation for constraint: boolean
        if (!is_null($sleepRoomNeedsMet) && !is_bool($sleepRoomNeedsMet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sleepRoomNeedsMet, true), gettype($sleepRoomNeedsMet)), __LINE__);
        }
        $this->SleepRoomNeedsMet = $sleepRoomNeedsMet;
        return $this;
    }
    /**
     * Get SleepRoomNeedsMetAdditionalInfo value
     * @return string|null
     */
    public function getSleepRoomNeedsMetAdditionalInfo()
    {
        return $this->SleepRoomNeedsMetAdditionalInfo;
    }
    /**
     * Set SleepRoomNeedsMetAdditionalInfo value
     * @param string $sleepRoomNeedsMetAdditionalInfo
     * @return \StructType\ProposalSleepRoomInfo
     */
    public function setSleepRoomNeedsMetAdditionalInfo($sleepRoomNeedsMetAdditionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($sleepRoomNeedsMetAdditionalInfo) && !is_string($sleepRoomNeedsMetAdditionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sleepRoomNeedsMetAdditionalInfo, true), gettype($sleepRoomNeedsMetAdditionalInfo)), __LINE__);
        }
        $this->SleepRoomNeedsMetAdditionalInfo = $sleepRoomNeedsMetAdditionalInfo;
        return $this;
    }
    /**
     * Get FeeAdditionalInformation value
     * @return string|null
     */
    public function getFeeAdditionalInformation()
    {
        return $this->FeeAdditionalInformation;
    }
    /**
     * Set FeeAdditionalInformation value
     * @param string $feeAdditionalInformation
     * @return \StructType\ProposalSleepRoomInfo
     */
    public function setFeeAdditionalInformation($feeAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($feeAdditionalInformation) && !is_string($feeAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeAdditionalInformation, true), gettype($feeAdditionalInformation)), __LINE__);
        }
        $this->FeeAdditionalInformation = $feeAdditionalInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProposalSleepRoomInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
