<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProposalPackagePricingDetail StructType
 * @subpackage Structs
 */
class ProposalPackagePricingDetail extends AbstractStructBase
{
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Package
     * @var string
     */
    public $Package;
    /**
     * The Occupancy
     * @var string
     */
    public $Occupancy;
    /**
     * The RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The PerPersonPerDay
     * @var float
     */
    public $PerPersonPerDay;
    /**
     * The PackagePricingNote
     * @var string
     */
    public $PackagePricingNote;
    /**
     * Constructor method for ProposalPackagePricingDetail
     * @uses ProposalPackagePricingDetail::setDate()
     * @uses ProposalPackagePricingDetail::setPackage()
     * @uses ProposalPackagePricingDetail::setOccupancy()
     * @uses ProposalPackagePricingDetail::setRoomType()
     * @uses ProposalPackagePricingDetail::setPerPersonPerDay()
     * @uses ProposalPackagePricingDetail::setPackagePricingNote()
     * @param string $date
     * @param string $package
     * @param string $occupancy
     * @param string $roomType
     * @param float $perPersonPerDay
     * @param string $packagePricingNote
     */
    public function __construct($date = null, $package = null, $occupancy = null, $roomType = null, $perPersonPerDay = null, $packagePricingNote = null)
    {
        $this
            ->setDate($date)
            ->setPackage($package)
            ->setOccupancy($occupancy)
            ->setRoomType($roomType)
            ->setPerPersonPerDay($perPersonPerDay)
            ->setPackagePricingNote($packagePricingNote);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\ProposalPackagePricingDetail
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Package value
     * @return string|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * Set Package value
     * @param string $package
     * @return \StructType\ProposalPackagePricingDetail
     */
    public function setPackage($package = null)
    {
        // validation for constraint: string
        if (!is_null($package) && !is_string($package)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($package, true), gettype($package)), __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return string|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @param string $occupancy
     * @return \StructType\ProposalPackagePricingDetail
     */
    public function setOccupancy($occupancy = null)
    {
        // validation for constraint: string
        if (!is_null($occupancy) && !is_string($occupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupancy, true), gettype($occupancy)), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\ProposalPackagePricingDetail
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get PerPersonPerDay value
     * @return float|null
     */
    public function getPerPersonPerDay()
    {
        return $this->PerPersonPerDay;
    }
    /**
     * Set PerPersonPerDay value
     * @param float $perPersonPerDay
     * @return \StructType\ProposalPackagePricingDetail
     */
    public function setPerPersonPerDay($perPersonPerDay = null)
    {
        // validation for constraint: float
        if (!is_null($perPersonPerDay) && !(is_float($perPersonPerDay) || is_numeric($perPersonPerDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($perPersonPerDay, true), gettype($perPersonPerDay)), __LINE__);
        }
        $this->PerPersonPerDay = $perPersonPerDay;
        return $this;
    }
    /**
     * Get PackagePricingNote value
     * @return string|null
     */
    public function getPackagePricingNote()
    {
        return $this->PackagePricingNote;
    }
    /**
     * Set PackagePricingNote value
     * @param string $packagePricingNote
     * @return \StructType\ProposalPackagePricingDetail
     */
    public function setPackagePricingNote($packagePricingNote = null)
    {
        // validation for constraint: string
        if (!is_null($packagePricingNote) && !is_string($packagePricingNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagePricingNote, true), gettype($packagePricingNote)), __LINE__);
        }
        $this->PackagePricingNote = $packagePricingNote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProposalPackagePricingDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
