<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProposalEventSpace StructType
 * @subpackage Structs
 */
class ProposalEventSpace extends AbstractStructBase
{
    /**
     * The RoomName
     * @var string
     */
    public $RoomName;
    /**
     * The RoomSize
     * @var int
     */
    public $RoomSize;
    /**
     * The CeilingHeight
     * @var int
     */
    public $CeilingHeight;
    /**
     * The TwentyFourHourHold
     * @var bool
     */
    public $TwentyFourHourHold;
    /**
     * The MoveInDate
     * @var string
     */
    public $MoveInDate;
    /**
     * The MoveInRate
     * @var float
     */
    public $MoveInRate;
    /**
     * The MoveInRateType
     * @var string
     */
    public $MoveInRateType;
    /**
     * The MoveOutDate
     * @var string
     */
    public $MoveOutDate;
    /**
     * The MoveOutRate
     * @var float
     */
    public $MoveOutRate;
    /**
     * The MoveOutRateType
     * @var string
     */
    public $MoveOutRateType;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The EventEndDate
     * @var string
     */
    public $EventEndDate;
    /**
     * The EventRate
     * @var float
     */
    public $EventRate;
    /**
     * The EventRateType
     * @var string
     */
    public $EventRateType;
    /**
     * The Note
     * @var string
     */
    public $Note;
    /**
     * Constructor method for ProposalEventSpace
     * @uses ProposalEventSpace::setRoomName()
     * @uses ProposalEventSpace::setRoomSize()
     * @uses ProposalEventSpace::setCeilingHeight()
     * @uses ProposalEventSpace::setTwentyFourHourHold()
     * @uses ProposalEventSpace::setMoveInDate()
     * @uses ProposalEventSpace::setMoveInRate()
     * @uses ProposalEventSpace::setMoveInRateType()
     * @uses ProposalEventSpace::setMoveOutDate()
     * @uses ProposalEventSpace::setMoveOutRate()
     * @uses ProposalEventSpace::setMoveOutRateType()
     * @uses ProposalEventSpace::setEventStartDate()
     * @uses ProposalEventSpace::setEventEndDate()
     * @uses ProposalEventSpace::setEventRate()
     * @uses ProposalEventSpace::setEventRateType()
     * @uses ProposalEventSpace::setNote()
     * @param string $roomName
     * @param int $roomSize
     * @param int $ceilingHeight
     * @param bool $twentyFourHourHold
     * @param string $moveInDate
     * @param float $moveInRate
     * @param string $moveInRateType
     * @param string $moveOutDate
     * @param float $moveOutRate
     * @param string $moveOutRateType
     * @param string $eventStartDate
     * @param string $eventEndDate
     * @param float $eventRate
     * @param string $eventRateType
     * @param string $note
     */
    public function __construct($roomName = null, $roomSize = null, $ceilingHeight = null, $twentyFourHourHold = null, $moveInDate = null, $moveInRate = null, $moveInRateType = null, $moveOutDate = null, $moveOutRate = null, $moveOutRateType = null, $eventStartDate = null, $eventEndDate = null, $eventRate = null, $eventRateType = null, $note = null)
    {
        $this
            ->setRoomName($roomName)
            ->setRoomSize($roomSize)
            ->setCeilingHeight($ceilingHeight)
            ->setTwentyFourHourHold($twentyFourHourHold)
            ->setMoveInDate($moveInDate)
            ->setMoveInRate($moveInRate)
            ->setMoveInRateType($moveInRateType)
            ->setMoveOutDate($moveOutDate)
            ->setMoveOutRate($moveOutRate)
            ->setMoveOutRateType($moveOutRateType)
            ->setEventStartDate($eventStartDate)
            ->setEventEndDate($eventEndDate)
            ->setEventRate($eventRate)
            ->setEventRateType($eventRateType)
            ->setNote($note);
    }
    /**
     * Get RoomName value
     * @return string|null
     */
    public function getRoomName()
    {
        return $this->RoomName;
    }
    /**
     * Set RoomName value
     * @param string $roomName
     * @return \StructType\ProposalEventSpace
     */
    public function setRoomName($roomName = null)
    {
        // validation for constraint: string
        if (!is_null($roomName) && !is_string($roomName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomName, true), gettype($roomName)), __LINE__);
        }
        $this->RoomName = $roomName;
        return $this;
    }
    /**
     * Get RoomSize value
     * @return int|null
     */
    public function getRoomSize()
    {
        return $this->RoomSize;
    }
    /**
     * Set RoomSize value
     * @param int $roomSize
     * @return \StructType\ProposalEventSpace
     */
    public function setRoomSize($roomSize = null)
    {
        // validation for constraint: int
        if (!is_null($roomSize) && !(is_int($roomSize) || ctype_digit($roomSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomSize, true), gettype($roomSize)), __LINE__);
        }
        $this->RoomSize = $roomSize;
        return $this;
    }
    /**
     * Get CeilingHeight value
     * @return int|null
     */
    public function getCeilingHeight()
    {
        return $this->CeilingHeight;
    }
    /**
     * Set CeilingHeight value
     * @param int $ceilingHeight
     * @return \StructType\ProposalEventSpace
     */
    public function setCeilingHeight($ceilingHeight = null)
    {
        // validation for constraint: int
        if (!is_null($ceilingHeight) && !(is_int($ceilingHeight) || ctype_digit($ceilingHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ceilingHeight, true), gettype($ceilingHeight)), __LINE__);
        }
        $this->CeilingHeight = $ceilingHeight;
        return $this;
    }
    /**
     * Get TwentyFourHourHold value
     * @return bool|null
     */
    public function getTwentyFourHourHold()
    {
        return $this->TwentyFourHourHold;
    }
    /**
     * Set TwentyFourHourHold value
     * @param bool $twentyFourHourHold
     * @return \StructType\ProposalEventSpace
     */
    public function setTwentyFourHourHold($twentyFourHourHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($twentyFourHourHold) && !is_bool($twentyFourHourHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($twentyFourHourHold, true), gettype($twentyFourHourHold)), __LINE__);
        }
        $this->TwentyFourHourHold = $twentyFourHourHold;
        return $this;
    }
    /**
     * Get MoveInDate value
     * @return string|null
     */
    public function getMoveInDate()
    {
        return $this->MoveInDate;
    }
    /**
     * Set MoveInDate value
     * @param string $moveInDate
     * @return \StructType\ProposalEventSpace
     */
    public function setMoveInDate($moveInDate = null)
    {
        // validation for constraint: string
        if (!is_null($moveInDate) && !is_string($moveInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moveInDate, true), gettype($moveInDate)), __LINE__);
        }
        $this->MoveInDate = $moveInDate;
        return $this;
    }
    /**
     * Get MoveInRate value
     * @return float|null
     */
    public function getMoveInRate()
    {
        return $this->MoveInRate;
    }
    /**
     * Set MoveInRate value
     * @param float $moveInRate
     * @return \StructType\ProposalEventSpace
     */
    public function setMoveInRate($moveInRate = null)
    {
        // validation for constraint: float
        if (!is_null($moveInRate) && !(is_float($moveInRate) || is_numeric($moveInRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($moveInRate, true), gettype($moveInRate)), __LINE__);
        }
        $this->MoveInRate = $moveInRate;
        return $this;
    }
    /**
     * Get MoveInRateType value
     * @return string|null
     */
    public function getMoveInRateType()
    {
        return $this->MoveInRateType;
    }
    /**
     * Set MoveInRateType value
     * @param string $moveInRateType
     * @return \StructType\ProposalEventSpace
     */
    public function setMoveInRateType($moveInRateType = null)
    {
        // validation for constraint: string
        if (!is_null($moveInRateType) && !is_string($moveInRateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moveInRateType, true), gettype($moveInRateType)), __LINE__);
        }
        $this->MoveInRateType = $moveInRateType;
        return $this;
    }
    /**
     * Get MoveOutDate value
     * @return string|null
     */
    public function getMoveOutDate()
    {
        return $this->MoveOutDate;
    }
    /**
     * Set MoveOutDate value
     * @param string $moveOutDate
     * @return \StructType\ProposalEventSpace
     */
    public function setMoveOutDate($moveOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($moveOutDate) && !is_string($moveOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moveOutDate, true), gettype($moveOutDate)), __LINE__);
        }
        $this->MoveOutDate = $moveOutDate;
        return $this;
    }
    /**
     * Get MoveOutRate value
     * @return float|null
     */
    public function getMoveOutRate()
    {
        return $this->MoveOutRate;
    }
    /**
     * Set MoveOutRate value
     * @param float $moveOutRate
     * @return \StructType\ProposalEventSpace
     */
    public function setMoveOutRate($moveOutRate = null)
    {
        // validation for constraint: float
        if (!is_null($moveOutRate) && !(is_float($moveOutRate) || is_numeric($moveOutRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($moveOutRate, true), gettype($moveOutRate)), __LINE__);
        }
        $this->MoveOutRate = $moveOutRate;
        return $this;
    }
    /**
     * Get MoveOutRateType value
     * @return string|null
     */
    public function getMoveOutRateType()
    {
        return $this->MoveOutRateType;
    }
    /**
     * Set MoveOutRateType value
     * @param string $moveOutRateType
     * @return \StructType\ProposalEventSpace
     */
    public function setMoveOutRateType($moveOutRateType = null)
    {
        // validation for constraint: string
        if (!is_null($moveOutRateType) && !is_string($moveOutRateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moveOutRateType, true), gettype($moveOutRateType)), __LINE__);
        }
        $this->MoveOutRateType = $moveOutRateType;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\ProposalEventSpace
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get EventEndDate value
     * @return string|null
     */
    public function getEventEndDate()
    {
        return $this->EventEndDate;
    }
    /**
     * Set EventEndDate value
     * @param string $eventEndDate
     * @return \StructType\ProposalEventSpace
     */
    public function setEventEndDate($eventEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventEndDate) && !is_string($eventEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventEndDate, true), gettype($eventEndDate)), __LINE__);
        }
        $this->EventEndDate = $eventEndDate;
        return $this;
    }
    /**
     * Get EventRate value
     * @return float|null
     */
    public function getEventRate()
    {
        return $this->EventRate;
    }
    /**
     * Set EventRate value
     * @param float $eventRate
     * @return \StructType\ProposalEventSpace
     */
    public function setEventRate($eventRate = null)
    {
        // validation for constraint: float
        if (!is_null($eventRate) && !(is_float($eventRate) || is_numeric($eventRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eventRate, true), gettype($eventRate)), __LINE__);
        }
        $this->EventRate = $eventRate;
        return $this;
    }
    /**
     * Get EventRateType value
     * @return string|null
     */
    public function getEventRateType()
    {
        return $this->EventRateType;
    }
    /**
     * Set EventRateType value
     * @param string $eventRateType
     * @return \StructType\ProposalEventSpace
     */
    public function setEventRateType($eventRateType = null)
    {
        // validation for constraint: string
        if (!is_null($eventRateType) && !is_string($eventRateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventRateType, true), gettype($eventRateType)), __LINE__);
        }
        $this->EventRateType = $eventRateType;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\ProposalEventSpace
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProposalEventSpace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
