<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProposalEventRequirementsInfo StructType
 * @subpackage Structs
 */
class ProposalEventRequirementsInfo extends AbstractStructBase
{
    /**
     * The MeetingRoomAvailabilityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProposalMeetingRoomAvailabilityDetail[]
     */
    public $MeetingRoomAvailabilityDetail;
    /**
     * The ProposalEstimatedCostDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProposalEstimatedCostDetail[]
     */
    public $ProposalEstimatedCostDetail;
    /**
     * The MeetingRoomNeedsMet
     * @var bool
     */
    public $MeetingRoomNeedsMet;
    /**
     * The MeetingRoomNeedsMetAdditionalInfo
     * @var string
     */
    public $MeetingRoomNeedsMetAdditionalInfo;
    /**
     * The TotalFoodAndBeverageMinimum
     * @var float
     */
    public $TotalFoodAndBeverageMinimum;
    /**
     * The FAndBMinimumNote
     * @var string
     */
    public $FAndBMinimumNote;
    /**
     * The ApplicableTax
     * @var float
     */
    public $ApplicableTax;
    /**
     * The ServiceCharge
     * @var float
     */
    public $ServiceCharge;
    /**
     * The MeetingRoomAdditionalInformation
     * @var string
     */
    public $MeetingRoomAdditionalInformation;
    /**
     * The AmenityAdditionalInformation
     * @var string
     */
    public $AmenityAdditionalInformation;
    /**
     * The RestaurantCostAdditionalInfo
     * @var string
     */
    public $RestaurantCostAdditionalInfo;
    /**
     * Constructor method for ProposalEventRequirementsInfo
     * @uses ProposalEventRequirementsInfo::setMeetingRoomAvailabilityDetail()
     * @uses ProposalEventRequirementsInfo::setProposalEstimatedCostDetail()
     * @uses ProposalEventRequirementsInfo::setMeetingRoomNeedsMet()
     * @uses ProposalEventRequirementsInfo::setMeetingRoomNeedsMetAdditionalInfo()
     * @uses ProposalEventRequirementsInfo::setTotalFoodAndBeverageMinimum()
     * @uses ProposalEventRequirementsInfo::setFAndBMinimumNote()
     * @uses ProposalEventRequirementsInfo::setApplicableTax()
     * @uses ProposalEventRequirementsInfo::setServiceCharge()
     * @uses ProposalEventRequirementsInfo::setMeetingRoomAdditionalInformation()
     * @uses ProposalEventRequirementsInfo::setAmenityAdditionalInformation()
     * @uses ProposalEventRequirementsInfo::setRestaurantCostAdditionalInfo()
     * @param \StructType\ProposalMeetingRoomAvailabilityDetail[] $meetingRoomAvailabilityDetail
     * @param \StructType\ProposalEstimatedCostDetail[] $proposalEstimatedCostDetail
     * @param bool $meetingRoomNeedsMet
     * @param string $meetingRoomNeedsMetAdditionalInfo
     * @param float $totalFoodAndBeverageMinimum
     * @param string $fAndBMinimumNote
     * @param float $applicableTax
     * @param float $serviceCharge
     * @param string $meetingRoomAdditionalInformation
     * @param string $amenityAdditionalInformation
     * @param string $restaurantCostAdditionalInfo
     */
    public function __construct(array $meetingRoomAvailabilityDetail = array(), array $proposalEstimatedCostDetail = array(), $meetingRoomNeedsMet = null, $meetingRoomNeedsMetAdditionalInfo = null, $totalFoodAndBeverageMinimum = null, $fAndBMinimumNote = null, $applicableTax = null, $serviceCharge = null, $meetingRoomAdditionalInformation = null, $amenityAdditionalInformation = null, $restaurantCostAdditionalInfo = null)
    {
        $this
            ->setMeetingRoomAvailabilityDetail($meetingRoomAvailabilityDetail)
            ->setProposalEstimatedCostDetail($proposalEstimatedCostDetail)
            ->setMeetingRoomNeedsMet($meetingRoomNeedsMet)
            ->setMeetingRoomNeedsMetAdditionalInfo($meetingRoomNeedsMetAdditionalInfo)
            ->setTotalFoodAndBeverageMinimum($totalFoodAndBeverageMinimum)
            ->setFAndBMinimumNote($fAndBMinimumNote)
            ->setApplicableTax($applicableTax)
            ->setServiceCharge($serviceCharge)
            ->setMeetingRoomAdditionalInformation($meetingRoomAdditionalInformation)
            ->setAmenityAdditionalInformation($amenityAdditionalInformation)
            ->setRestaurantCostAdditionalInfo($restaurantCostAdditionalInfo);
    }
    /**
     * Get MeetingRoomAvailabilityDetail value
     * @return \StructType\ProposalMeetingRoomAvailabilityDetail[]|null
     */
    public function getMeetingRoomAvailabilityDetail()
    {
        return $this->MeetingRoomAvailabilityDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setMeetingRoomAvailabilityDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeetingRoomAvailabilityDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeetingRoomAvailabilityDetailForArrayConstraintsFromSetMeetingRoomAvailabilityDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $proposalEventRequirementsInfoMeetingRoomAvailabilityDetailItem) {
            // validation for constraint: itemType
            if (!$proposalEventRequirementsInfoMeetingRoomAvailabilityDetailItem instanceof \StructType\ProposalMeetingRoomAvailabilityDetail) {
                $invalidValues[] = is_object($proposalEventRequirementsInfoMeetingRoomAvailabilityDetailItem) ? get_class($proposalEventRequirementsInfoMeetingRoomAvailabilityDetailItem) : sprintf('%s(%s)', gettype($proposalEventRequirementsInfoMeetingRoomAvailabilityDetailItem), var_export($proposalEventRequirementsInfoMeetingRoomAvailabilityDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeetingRoomAvailabilityDetail property can only contain items of type \StructType\ProposalMeetingRoomAvailabilityDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeetingRoomAvailabilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalMeetingRoomAvailabilityDetail[] $meetingRoomAvailabilityDetail
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setMeetingRoomAvailabilityDetail(array $meetingRoomAvailabilityDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($meetingRoomAvailabilityDetailArrayErrorMessage = self::validateMeetingRoomAvailabilityDetailForArrayConstraintsFromSetMeetingRoomAvailabilityDetail($meetingRoomAvailabilityDetail))) {
            throw new \InvalidArgumentException($meetingRoomAvailabilityDetailArrayErrorMessage, __LINE__);
        }
        $this->MeetingRoomAvailabilityDetail = $meetingRoomAvailabilityDetail;
        return $this;
    }
    /**
     * Add item to MeetingRoomAvailabilityDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalMeetingRoomAvailabilityDetail $item
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function addToMeetingRoomAvailabilityDetail(\StructType\ProposalMeetingRoomAvailabilityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProposalMeetingRoomAvailabilityDetail) {
            throw new \InvalidArgumentException(sprintf('The MeetingRoomAvailabilityDetail property can only contain items of type \StructType\ProposalMeetingRoomAvailabilityDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeetingRoomAvailabilityDetail[] = $item;
        return $this;
    }
    /**
     * Get ProposalEstimatedCostDetail value
     * @return \StructType\ProposalEstimatedCostDetail[]|null
     */
    public function getProposalEstimatedCostDetail()
    {
        return $this->ProposalEstimatedCostDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setProposalEstimatedCostDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProposalEstimatedCostDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProposalEstimatedCostDetailForArrayConstraintsFromSetProposalEstimatedCostDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $proposalEventRequirementsInfoProposalEstimatedCostDetailItem) {
            // validation for constraint: itemType
            if (!$proposalEventRequirementsInfoProposalEstimatedCostDetailItem instanceof \StructType\ProposalEstimatedCostDetail) {
                $invalidValues[] = is_object($proposalEventRequirementsInfoProposalEstimatedCostDetailItem) ? get_class($proposalEventRequirementsInfoProposalEstimatedCostDetailItem) : sprintf('%s(%s)', gettype($proposalEventRequirementsInfoProposalEstimatedCostDetailItem), var_export($proposalEventRequirementsInfoProposalEstimatedCostDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProposalEstimatedCostDetail property can only contain items of type \StructType\ProposalEstimatedCostDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProposalEstimatedCostDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalEstimatedCostDetail[] $proposalEstimatedCostDetail
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setProposalEstimatedCostDetail(array $proposalEstimatedCostDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($proposalEstimatedCostDetailArrayErrorMessage = self::validateProposalEstimatedCostDetailForArrayConstraintsFromSetProposalEstimatedCostDetail($proposalEstimatedCostDetail))) {
            throw new \InvalidArgumentException($proposalEstimatedCostDetailArrayErrorMessage, __LINE__);
        }
        $this->ProposalEstimatedCostDetail = $proposalEstimatedCostDetail;
        return $this;
    }
    /**
     * Add item to ProposalEstimatedCostDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProposalEstimatedCostDetail $item
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function addToProposalEstimatedCostDetail(\StructType\ProposalEstimatedCostDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProposalEstimatedCostDetail) {
            throw new \InvalidArgumentException(sprintf('The ProposalEstimatedCostDetail property can only contain items of type \StructType\ProposalEstimatedCostDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProposalEstimatedCostDetail[] = $item;
        return $this;
    }
    /**
     * Get MeetingRoomNeedsMet value
     * @return bool|null
     */
    public function getMeetingRoomNeedsMet()
    {
        return $this->MeetingRoomNeedsMet;
    }
    /**
     * Set MeetingRoomNeedsMet value
     * @param bool $meetingRoomNeedsMet
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setMeetingRoomNeedsMet($meetingRoomNeedsMet = null)
    {
        // validation for constraint: boolean
        if (!is_null($meetingRoomNeedsMet) && !is_bool($meetingRoomNeedsMet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($meetingRoomNeedsMet, true), gettype($meetingRoomNeedsMet)), __LINE__);
        }
        $this->MeetingRoomNeedsMet = $meetingRoomNeedsMet;
        return $this;
    }
    /**
     * Get MeetingRoomNeedsMetAdditionalInfo value
     * @return string|null
     */
    public function getMeetingRoomNeedsMetAdditionalInfo()
    {
        return $this->MeetingRoomNeedsMetAdditionalInfo;
    }
    /**
     * Set MeetingRoomNeedsMetAdditionalInfo value
     * @param string $meetingRoomNeedsMetAdditionalInfo
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setMeetingRoomNeedsMetAdditionalInfo($meetingRoomNeedsMetAdditionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomNeedsMetAdditionalInfo) && !is_string($meetingRoomNeedsMetAdditionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomNeedsMetAdditionalInfo, true), gettype($meetingRoomNeedsMetAdditionalInfo)), __LINE__);
        }
        $this->MeetingRoomNeedsMetAdditionalInfo = $meetingRoomNeedsMetAdditionalInfo;
        return $this;
    }
    /**
     * Get TotalFoodAndBeverageMinimum value
     * @return float|null
     */
    public function getTotalFoodAndBeverageMinimum()
    {
        return $this->TotalFoodAndBeverageMinimum;
    }
    /**
     * Set TotalFoodAndBeverageMinimum value
     * @param float $totalFoodAndBeverageMinimum
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setTotalFoodAndBeverageMinimum($totalFoodAndBeverageMinimum = null)
    {
        // validation for constraint: float
        if (!is_null($totalFoodAndBeverageMinimum) && !(is_float($totalFoodAndBeverageMinimum) || is_numeric($totalFoodAndBeverageMinimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalFoodAndBeverageMinimum, true), gettype($totalFoodAndBeverageMinimum)), __LINE__);
        }
        $this->TotalFoodAndBeverageMinimum = $totalFoodAndBeverageMinimum;
        return $this;
    }
    /**
     * Get FAndBMinimumNote value
     * @return string|null
     */
    public function getFAndBMinimumNote()
    {
        return $this->FAndBMinimumNote;
    }
    /**
     * Set FAndBMinimumNote value
     * @param string $fAndBMinimumNote
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setFAndBMinimumNote($fAndBMinimumNote = null)
    {
        // validation for constraint: string
        if (!is_null($fAndBMinimumNote) && !is_string($fAndBMinimumNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fAndBMinimumNote, true), gettype($fAndBMinimumNote)), __LINE__);
        }
        $this->FAndBMinimumNote = $fAndBMinimumNote;
        return $this;
    }
    /**
     * Get ApplicableTax value
     * @return float|null
     */
    public function getApplicableTax()
    {
        return $this->ApplicableTax;
    }
    /**
     * Set ApplicableTax value
     * @param float $applicableTax
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setApplicableTax($applicableTax = null)
    {
        // validation for constraint: float
        if (!is_null($applicableTax) && !(is_float($applicableTax) || is_numeric($applicableTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($applicableTax, true), gettype($applicableTax)), __LINE__);
        }
        $this->ApplicableTax = $applicableTax;
        return $this;
    }
    /**
     * Get ServiceCharge value
     * @return float|null
     */
    public function getServiceCharge()
    {
        return $this->ServiceCharge;
    }
    /**
     * Set ServiceCharge value
     * @param float $serviceCharge
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setServiceCharge($serviceCharge = null)
    {
        // validation for constraint: float
        if (!is_null($serviceCharge) && !(is_float($serviceCharge) || is_numeric($serviceCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($serviceCharge, true), gettype($serviceCharge)), __LINE__);
        }
        $this->ServiceCharge = $serviceCharge;
        return $this;
    }
    /**
     * Get MeetingRoomAdditionalInformation value
     * @return string|null
     */
    public function getMeetingRoomAdditionalInformation()
    {
        return $this->MeetingRoomAdditionalInformation;
    }
    /**
     * Set MeetingRoomAdditionalInformation value
     * @param string $meetingRoomAdditionalInformation
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setMeetingRoomAdditionalInformation($meetingRoomAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomAdditionalInformation) && !is_string($meetingRoomAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomAdditionalInformation, true), gettype($meetingRoomAdditionalInformation)), __LINE__);
        }
        $this->MeetingRoomAdditionalInformation = $meetingRoomAdditionalInformation;
        return $this;
    }
    /**
     * Get AmenityAdditionalInformation value
     * @return string|null
     */
    public function getAmenityAdditionalInformation()
    {
        return $this->AmenityAdditionalInformation;
    }
    /**
     * Set AmenityAdditionalInformation value
     * @param string $amenityAdditionalInformation
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setAmenityAdditionalInformation($amenityAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($amenityAdditionalInformation) && !is_string($amenityAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amenityAdditionalInformation, true), gettype($amenityAdditionalInformation)), __LINE__);
        }
        $this->AmenityAdditionalInformation = $amenityAdditionalInformation;
        return $this;
    }
    /**
     * Get RestaurantCostAdditionalInfo value
     * @return string|null
     */
    public function getRestaurantCostAdditionalInfo()
    {
        return $this->RestaurantCostAdditionalInfo;
    }
    /**
     * Set RestaurantCostAdditionalInfo value
     * @param string $restaurantCostAdditionalInfo
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public function setRestaurantCostAdditionalInfo($restaurantCostAdditionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($restaurantCostAdditionalInfo) && !is_string($restaurantCostAdditionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restaurantCostAdditionalInfo, true), gettype($restaurantCostAdditionalInfo)), __LINE__);
        }
        $this->RestaurantCostAdditionalInfo = $restaurantCostAdditionalInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProposalEventRequirementsInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
