<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProposalEventInfo StructType
 * @subpackage Structs
 */
class ProposalEventInfo extends AbstractStructBase
{
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The EventEndDate
     * @var string
     */
    public $EventEndDate;
    /**
     * The Availability
     * @var string
     */
    public $Availability;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The EstimatedTotalCost
     * @var float
     */
    public $EstimatedTotalCost;
    /**
     * The AdditionalInformation
     * @var string
     */
    public $AdditionalInformation;
    /**
     * The AlternateStartDate1
     * @var string
     */
    public $AlternateStartDate1;
    /**
     * The AlternateEndDate1
     * @var string
     */
    public $AlternateEndDate1;
    /**
     * The AlternateSleepRoomRate1
     * @var string
     */
    public $AlternateSleepRoomRate1;
    /**
     * The AlternateAdditionalInformation1
     * @var string
     */
    public $AlternateAdditionalInformation1;
    /**
     * The AlternateStartDate2
     * @var string
     */
    public $AlternateStartDate2;
    /**
     * The AlternateEndDate2
     * @var string
     */
    public $AlternateEndDate2;
    /**
     * The AlternateSleepRoomRate2
     * @var string
     */
    public $AlternateSleepRoomRate2;
    /**
     * The AlternateAdditionalInformation2
     * @var string
     */
    public $AlternateAdditionalInformation2;
    /**
     * The ConcessionAdditionalInformation
     * @var string
     */
    public $ConcessionAdditionalInformation;
    /**
     * Constructor method for ProposalEventInfo
     * @uses ProposalEventInfo::setEventStartDate()
     * @uses ProposalEventInfo::setEventEndDate()
     * @uses ProposalEventInfo::setAvailability()
     * @uses ProposalEventInfo::setCurrency()
     * @uses ProposalEventInfo::setEstimatedTotalCost()
     * @uses ProposalEventInfo::setAdditionalInformation()
     * @uses ProposalEventInfo::setAlternateStartDate1()
     * @uses ProposalEventInfo::setAlternateEndDate1()
     * @uses ProposalEventInfo::setAlternateSleepRoomRate1()
     * @uses ProposalEventInfo::setAlternateAdditionalInformation1()
     * @uses ProposalEventInfo::setAlternateStartDate2()
     * @uses ProposalEventInfo::setAlternateEndDate2()
     * @uses ProposalEventInfo::setAlternateSleepRoomRate2()
     * @uses ProposalEventInfo::setAlternateAdditionalInformation2()
     * @uses ProposalEventInfo::setConcessionAdditionalInformation()
     * @param string $eventStartDate
     * @param string $eventEndDate
     * @param string $availability
     * @param string $currency
     * @param float $estimatedTotalCost
     * @param string $additionalInformation
     * @param string $alternateStartDate1
     * @param string $alternateEndDate1
     * @param string $alternateSleepRoomRate1
     * @param string $alternateAdditionalInformation1
     * @param string $alternateStartDate2
     * @param string $alternateEndDate2
     * @param string $alternateSleepRoomRate2
     * @param string $alternateAdditionalInformation2
     * @param string $concessionAdditionalInformation
     */
    public function __construct($eventStartDate = null, $eventEndDate = null, $availability = null, $currency = null, $estimatedTotalCost = null, $additionalInformation = null, $alternateStartDate1 = null, $alternateEndDate1 = null, $alternateSleepRoomRate1 = null, $alternateAdditionalInformation1 = null, $alternateStartDate2 = null, $alternateEndDate2 = null, $alternateSleepRoomRate2 = null, $alternateAdditionalInformation2 = null, $concessionAdditionalInformation = null)
    {
        $this
            ->setEventStartDate($eventStartDate)
            ->setEventEndDate($eventEndDate)
            ->setAvailability($availability)
            ->setCurrency($currency)
            ->setEstimatedTotalCost($estimatedTotalCost)
            ->setAdditionalInformation($additionalInformation)
            ->setAlternateStartDate1($alternateStartDate1)
            ->setAlternateEndDate1($alternateEndDate1)
            ->setAlternateSleepRoomRate1($alternateSleepRoomRate1)
            ->setAlternateAdditionalInformation1($alternateAdditionalInformation1)
            ->setAlternateStartDate2($alternateStartDate2)
            ->setAlternateEndDate2($alternateEndDate2)
            ->setAlternateSleepRoomRate2($alternateSleepRoomRate2)
            ->setAlternateAdditionalInformation2($alternateAdditionalInformation2)
            ->setConcessionAdditionalInformation($concessionAdditionalInformation);
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\ProposalEventInfo
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get EventEndDate value
     * @return string|null
     */
    public function getEventEndDate()
    {
        return $this->EventEndDate;
    }
    /**
     * Set EventEndDate value
     * @param string $eventEndDate
     * @return \StructType\ProposalEventInfo
     */
    public function setEventEndDate($eventEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventEndDate) && !is_string($eventEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventEndDate, true), gettype($eventEndDate)), __LINE__);
        }
        $this->EventEndDate = $eventEndDate;
        return $this;
    }
    /**
     * Get Availability value
     * @return string|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param string $availability
     * @return \StructType\ProposalEventInfo
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: string
        if (!is_null($availability) && !is_string($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availability, true), gettype($availability)), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\ProposalEventInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get EstimatedTotalCost value
     * @return float|null
     */
    public function getEstimatedTotalCost()
    {
        return $this->EstimatedTotalCost;
    }
    /**
     * Set EstimatedTotalCost value
     * @param float $estimatedTotalCost
     * @return \StructType\ProposalEventInfo
     */
    public function setEstimatedTotalCost($estimatedTotalCost = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedTotalCost) && !(is_float($estimatedTotalCost) || is_numeric($estimatedTotalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedTotalCost, true), gettype($estimatedTotalCost)), __LINE__);
        }
        $this->EstimatedTotalCost = $estimatedTotalCost;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return string|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param string $additionalInformation
     * @return \StructType\ProposalEventInfo
     */
    public function setAdditionalInformation($additionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformation) && !is_string($additionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInformation, true), gettype($additionalInformation)), __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Get AlternateStartDate1 value
     * @return string|null
     */
    public function getAlternateStartDate1()
    {
        return $this->AlternateStartDate1;
    }
    /**
     * Set AlternateStartDate1 value
     * @param string $alternateStartDate1
     * @return \StructType\ProposalEventInfo
     */
    public function setAlternateStartDate1($alternateStartDate1 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateStartDate1) && !is_string($alternateStartDate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateStartDate1, true), gettype($alternateStartDate1)), __LINE__);
        }
        $this->AlternateStartDate1 = $alternateStartDate1;
        return $this;
    }
    /**
     * Get AlternateEndDate1 value
     * @return string|null
     */
    public function getAlternateEndDate1()
    {
        return $this->AlternateEndDate1;
    }
    /**
     * Set AlternateEndDate1 value
     * @param string $alternateEndDate1
     * @return \StructType\ProposalEventInfo
     */
    public function setAlternateEndDate1($alternateEndDate1 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateEndDate1) && !is_string($alternateEndDate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateEndDate1, true), gettype($alternateEndDate1)), __LINE__);
        }
        $this->AlternateEndDate1 = $alternateEndDate1;
        return $this;
    }
    /**
     * Get AlternateSleepRoomRate1 value
     * @return string|null
     */
    public function getAlternateSleepRoomRate1()
    {
        return $this->AlternateSleepRoomRate1;
    }
    /**
     * Set AlternateSleepRoomRate1 value
     * @param string $alternateSleepRoomRate1
     * @return \StructType\ProposalEventInfo
     */
    public function setAlternateSleepRoomRate1($alternateSleepRoomRate1 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateSleepRoomRate1) && !is_string($alternateSleepRoomRate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateSleepRoomRate1, true), gettype($alternateSleepRoomRate1)), __LINE__);
        }
        $this->AlternateSleepRoomRate1 = $alternateSleepRoomRate1;
        return $this;
    }
    /**
     * Get AlternateAdditionalInformation1 value
     * @return string|null
     */
    public function getAlternateAdditionalInformation1()
    {
        return $this->AlternateAdditionalInformation1;
    }
    /**
     * Set AlternateAdditionalInformation1 value
     * @param string $alternateAdditionalInformation1
     * @return \StructType\ProposalEventInfo
     */
    public function setAlternateAdditionalInformation1($alternateAdditionalInformation1 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateAdditionalInformation1) && !is_string($alternateAdditionalInformation1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateAdditionalInformation1, true), gettype($alternateAdditionalInformation1)), __LINE__);
        }
        $this->AlternateAdditionalInformation1 = $alternateAdditionalInformation1;
        return $this;
    }
    /**
     * Get AlternateStartDate2 value
     * @return string|null
     */
    public function getAlternateStartDate2()
    {
        return $this->AlternateStartDate2;
    }
    /**
     * Set AlternateStartDate2 value
     * @param string $alternateStartDate2
     * @return \StructType\ProposalEventInfo
     */
    public function setAlternateStartDate2($alternateStartDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateStartDate2) && !is_string($alternateStartDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateStartDate2, true), gettype($alternateStartDate2)), __LINE__);
        }
        $this->AlternateStartDate2 = $alternateStartDate2;
        return $this;
    }
    /**
     * Get AlternateEndDate2 value
     * @return string|null
     */
    public function getAlternateEndDate2()
    {
        return $this->AlternateEndDate2;
    }
    /**
     * Set AlternateEndDate2 value
     * @param string $alternateEndDate2
     * @return \StructType\ProposalEventInfo
     */
    public function setAlternateEndDate2($alternateEndDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateEndDate2) && !is_string($alternateEndDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateEndDate2, true), gettype($alternateEndDate2)), __LINE__);
        }
        $this->AlternateEndDate2 = $alternateEndDate2;
        return $this;
    }
    /**
     * Get AlternateSleepRoomRate2 value
     * @return string|null
     */
    public function getAlternateSleepRoomRate2()
    {
        return $this->AlternateSleepRoomRate2;
    }
    /**
     * Set AlternateSleepRoomRate2 value
     * @param string $alternateSleepRoomRate2
     * @return \StructType\ProposalEventInfo
     */
    public function setAlternateSleepRoomRate2($alternateSleepRoomRate2 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateSleepRoomRate2) && !is_string($alternateSleepRoomRate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateSleepRoomRate2, true), gettype($alternateSleepRoomRate2)), __LINE__);
        }
        $this->AlternateSleepRoomRate2 = $alternateSleepRoomRate2;
        return $this;
    }
    /**
     * Get AlternateAdditionalInformation2 value
     * @return string|null
     */
    public function getAlternateAdditionalInformation2()
    {
        return $this->AlternateAdditionalInformation2;
    }
    /**
     * Set AlternateAdditionalInformation2 value
     * @param string $alternateAdditionalInformation2
     * @return \StructType\ProposalEventInfo
     */
    public function setAlternateAdditionalInformation2($alternateAdditionalInformation2 = null)
    {
        // validation for constraint: string
        if (!is_null($alternateAdditionalInformation2) && !is_string($alternateAdditionalInformation2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateAdditionalInformation2, true), gettype($alternateAdditionalInformation2)), __LINE__);
        }
        $this->AlternateAdditionalInformation2 = $alternateAdditionalInformation2;
        return $this;
    }
    /**
     * Get ConcessionAdditionalInformation value
     * @return string|null
     */
    public function getConcessionAdditionalInformation()
    {
        return $this->ConcessionAdditionalInformation;
    }
    /**
     * Set ConcessionAdditionalInformation value
     * @param string $concessionAdditionalInformation
     * @return \StructType\ProposalEventInfo
     */
    public function setConcessionAdditionalInformation($concessionAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($concessionAdditionalInformation) && !is_string($concessionAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($concessionAdditionalInformation, true), gettype($concessionAdditionalInformation)), __LINE__);
        }
        $this->ConcessionAdditionalInformation = $concessionAdditionalInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProposalEventInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
