<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProposalEstimatedCostDetail StructType
 * @subpackage Structs
 */
class ProposalEstimatedCostDetail extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The TaxOrServiceCharge
     * @var string
     */
    public $TaxOrServiceCharge;
    /**
     * The Note
     * @var string
     */
    public $Note;
    /**
     * Constructor method for ProposalEstimatedCostDetail
     * @uses ProposalEstimatedCostDetail::setAmount()
     * @uses ProposalEstimatedCostDetail::setQuantity()
     * @uses ProposalEstimatedCostDetail::setType()
     * @uses ProposalEstimatedCostDetail::setTaxOrServiceCharge()
     * @uses ProposalEstimatedCostDetail::setNote()
     * @param float $amount
     * @param int $quantity
     * @param string $type
     * @param string $taxOrServiceCharge
     * @param string $note
     */
    public function __construct($amount = null, $quantity = null, $type = null, $taxOrServiceCharge = null, $note = null)
    {
        $this
            ->setAmount($amount)
            ->setQuantity($quantity)
            ->setType($type)
            ->setTaxOrServiceCharge($taxOrServiceCharge)
            ->setNote($note);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ProposalEstimatedCostDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ProposalEstimatedCostDetail
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ProposalEstimatedCostDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TaxOrServiceCharge value
     * @return string|null
     */
    public function getTaxOrServiceCharge()
    {
        return $this->TaxOrServiceCharge;
    }
    /**
     * Set TaxOrServiceCharge value
     * @param string $taxOrServiceCharge
     * @return \StructType\ProposalEstimatedCostDetail
     */
    public function setTaxOrServiceCharge($taxOrServiceCharge = null)
    {
        // validation for constraint: string
        if (!is_null($taxOrServiceCharge) && !is_string($taxOrServiceCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOrServiceCharge, true), gettype($taxOrServiceCharge)), __LINE__);
        }
        $this->TaxOrServiceCharge = $taxOrServiceCharge;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \StructType\ProposalEstimatedCostDetail
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProposalEstimatedCostDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
