<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProposalAlternateDate StructType
 * @subpackage Structs
 */
class ProposalAlternateDate extends AbstractStructBase
{
    /**
     * The DateType
     * @var string
     */
    public $DateType;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * The Availability
     * @var string
     */
    public $Availability;
    /**
     * The SleepRoomRate
     * Meta informations extracted from the WSDL
     * - default: N/A
     * @var string
     */
    public $SleepRoomRate;
    /**
     * The AdditionalInformation
     * @var string
     */
    public $AdditionalInformation;
    /**
     * Constructor method for ProposalAlternateDate
     * @uses ProposalAlternateDate::setDateType()
     * @uses ProposalAlternateDate::setStartDate()
     * @uses ProposalAlternateDate::setEndDate()
     * @uses ProposalAlternateDate::setAvailability()
     * @uses ProposalAlternateDate::setSleepRoomRate()
     * @uses ProposalAlternateDate::setAdditionalInformation()
     * @param string $dateType
     * @param string $startDate
     * @param string $endDate
     * @param string $availability
     * @param string $sleepRoomRate
     * @param string $additionalInformation
     */
    public function __construct($dateType = null, $startDate = null, $endDate = null, $availability = null, $sleepRoomRate = 'N/A', $additionalInformation = null)
    {
        $this
            ->setDateType($dateType)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setAvailability($availability)
            ->setSleepRoomRate($sleepRoomRate)
            ->setAdditionalInformation($additionalInformation);
    }
    /**
     * Get DateType value
     * @return string|null
     */
    public function getDateType()
    {
        return $this->DateType;
    }
    /**
     * Set DateType value
     * @param string $dateType
     * @return \StructType\ProposalAlternateDate
     */
    public function setDateType($dateType = null)
    {
        // validation for constraint: string
        if (!is_null($dateType) && !is_string($dateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateType, true), gettype($dateType)), __LINE__);
        }
        $this->DateType = $dateType;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ProposalAlternateDate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ProposalAlternateDate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Availability value
     * @return string|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param string $availability
     * @return \StructType\ProposalAlternateDate
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: string
        if (!is_null($availability) && !is_string($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availability, true), gettype($availability)), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get SleepRoomRate value
     * @return string|null
     */
    public function getSleepRoomRate()
    {
        return $this->SleepRoomRate;
    }
    /**
     * Set SleepRoomRate value
     * @param string $sleepRoomRate
     * @return \StructType\ProposalAlternateDate
     */
    public function setSleepRoomRate($sleepRoomRate = 'N/A')
    {
        // validation for constraint: string
        if (!is_null($sleepRoomRate) && !is_string($sleepRoomRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sleepRoomRate, true), gettype($sleepRoomRate)), __LINE__);
        }
        $this->SleepRoomRate = $sleepRoomRate;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return string|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param string $additionalInformation
     * @return \StructType\ProposalAlternateDate
     */
    public function setAdditionalInformation($additionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformation) && !is_string($additionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInformation, true), gettype($additionalInformation)), __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProposalAlternateDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
