<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDetail StructType
 * @subpackage Structs
 */
class ProductDetail extends AbstractStructBase
{
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The ProductId
     * @var string
     */
    public $ProductId;
    /**
     * The ProductName
     * @var string
     */
    public $ProductName;
    /**
     * The ProductCode
     * @var string
     */
    public $ProductCode;
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The ProductDescription
     * @var string
     */
    public $ProductDescription;
    /**
     * The SessionCategoryName
     * @var string
     */
    public $SessionCategoryName;
    /**
     * The SessionCategoryId
     * @var string
     */
    public $SessionCategoryId;
    /**
     * The IsIncluded
     * @var bool
     */
    public $IsIncluded;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * @var string
     */
    public $EndTime;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The Capacity
     * @var int
     */
    public $Capacity;
    /**
     * Constructor method for ProductDetail
     * @uses ProductDetail::setCustomFieldDetail()
     * @uses ProductDetail::setProductId()
     * @uses ProductDetail::setProductName()
     * @uses ProductDetail::setProductCode()
     * @uses ProductDetail::setProductType()
     * @uses ProductDetail::setProductDescription()
     * @uses ProductDetail::setSessionCategoryName()
     * @uses ProductDetail::setSessionCategoryId()
     * @uses ProductDetail::setIsIncluded()
     * @uses ProductDetail::setStartTime()
     * @uses ProductDetail::setEndTime()
     * @uses ProductDetail::setStatus()
     * @uses ProductDetail::setCapacity()
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param string $productId
     * @param string $productName
     * @param string $productCode
     * @param string $productType
     * @param string $productDescription
     * @param string $sessionCategoryName
     * @param string $sessionCategoryId
     * @param bool $isIncluded
     * @param string $startTime
     * @param string $endTime
     * @param string $status
     * @param int $capacity
     */
    public function __construct(array $customFieldDetail = array(), $productId = null, $productName = null, $productCode = null, $productType = null, $productDescription = null, $sessionCategoryName = null, $sessionCategoryId = null, $isIncluded = null, $startTime = null, $endTime = null, $status = null, $capacity = null)
    {
        $this
            ->setCustomFieldDetail($customFieldDetail)
            ->setProductId($productId)
            ->setProductName($productName)
            ->setProductCode($productCode)
            ->setProductType($productType)
            ->setProductDescription($productDescription)
            ->setSessionCategoryName($sessionCategoryName)
            ->setSessionCategoryId($sessionCategoryId)
            ->setIsIncluded($isIncluded)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setStatus($status)
            ->setCapacity($capacity);
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productDetailCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$productDetailCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($productDetailCustomFieldDetailItem) ? get_class($productDetailCustomFieldDetailItem) : sprintf('%s(%s)', gettype($productDetailCustomFieldDetailItem), var_export($productDetailCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\ProductDetail
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\ProductDetail
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \StructType\ProductDetail
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\ProductDetail
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\ProductDetail
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \StructType\ProductDetail
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ProductDescription value
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->ProductDescription;
    }
    /**
     * Set ProductDescription value
     * @param string $productDescription
     * @return \StructType\ProductDetail
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productDescription, true), gettype($productDescription)), __LINE__);
        }
        $this->ProductDescription = $productDescription;
        return $this;
    }
    /**
     * Get SessionCategoryName value
     * @return string|null
     */
    public function getSessionCategoryName()
    {
        return $this->SessionCategoryName;
    }
    /**
     * Set SessionCategoryName value
     * @param string $sessionCategoryName
     * @return \StructType\ProductDetail
     */
    public function setSessionCategoryName($sessionCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($sessionCategoryName) && !is_string($sessionCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionCategoryName, true), gettype($sessionCategoryName)), __LINE__);
        }
        $this->SessionCategoryName = $sessionCategoryName;
        return $this;
    }
    /**
     * Get SessionCategoryId value
     * @return string|null
     */
    public function getSessionCategoryId()
    {
        return $this->SessionCategoryId;
    }
    /**
     * Set SessionCategoryId value
     * @param string $sessionCategoryId
     * @return \StructType\ProductDetail
     */
    public function setSessionCategoryId($sessionCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionCategoryId) && !is_string($sessionCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionCategoryId, true), gettype($sessionCategoryId)), __LINE__);
        }
        $this->SessionCategoryId = $sessionCategoryId;
        return $this;
    }
    /**
     * Get IsIncluded value
     * @return bool|null
     */
    public function getIsIncluded()
    {
        return $this->IsIncluded;
    }
    /**
     * Set IsIncluded value
     * @param bool $isIncluded
     * @return \StructType\ProductDetail
     */
    public function setIsIncluded($isIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncluded) && !is_bool($isIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncluded, true), gettype($isIncluded)), __LINE__);
        }
        $this->IsIncluded = $isIncluded;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\ProductDetail
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\ProductDetail
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\ProductDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Capacity value
     * @return int|null
     */
    public function getCapacity()
    {
        return $this->Capacity;
    }
    /**
     * Set Capacity value
     * @param int $capacity
     * @return \StructType\ProductDetail
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        $this->Capacity = $capacity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
