<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessFormDetail StructType
 * @subpackage Structs
 */
class ProcessFormDetail extends AbstractStructBase
{
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The SubmittedBy
     * @var string
     */
    public $SubmittedBy;
    /**
     * The SubmittedDate
     * @var string
     */
    public $SubmittedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * Constructor method for ProcessFormDetail
     * @uses ProcessFormDetail::setID()
     * @uses ProcessFormDetail::setName()
     * @uses ProcessFormDetail::setStatus()
     * @uses ProcessFormDetail::setSubmittedBy()
     * @uses ProcessFormDetail::setSubmittedDate()
     * @uses ProcessFormDetail::setLastModifiedBy()
     * @uses ProcessFormDetail::setLastModifiedDate()
     * @param string $iD
     * @param string $name
     * @param string $status
     * @param string $submittedBy
     * @param string $submittedDate
     * @param string $lastModifiedBy
     * @param string $lastModifiedDate
     */
    public function __construct($iD = null, $name = null, $status = null, $submittedBy = null, $submittedDate = null, $lastModifiedBy = null, $lastModifiedDate = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setStatus($status)
            ->setSubmittedBy($submittedBy)
            ->setSubmittedDate($submittedDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\ProcessFormDetail
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ProcessFormDetail
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\ProcessFormDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SubmittedBy value
     * @return string|null
     */
    public function getSubmittedBy()
    {
        return $this->SubmittedBy;
    }
    /**
     * Set SubmittedBy value
     * @param string $submittedBy
     * @return \StructType\ProcessFormDetail
     */
    public function setSubmittedBy($submittedBy = null)
    {
        // validation for constraint: string
        if (!is_null($submittedBy) && !is_string($submittedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submittedBy, true), gettype($submittedBy)), __LINE__);
        }
        $this->SubmittedBy = $submittedBy;
        return $this;
    }
    /**
     * Get SubmittedDate value
     * @return string|null
     */
    public function getSubmittedDate()
    {
        return $this->SubmittedDate;
    }
    /**
     * Set SubmittedDate value
     * @param string $submittedDate
     * @return \StructType\ProcessFormDetail
     */
    public function setSubmittedDate($submittedDate = null)
    {
        // validation for constraint: string
        if (!is_null($submittedDate) && !is_string($submittedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submittedDate, true), gettype($submittedDate)), __LINE__);
        }
        $this->SubmittedDate = $submittedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\ProcessFormDetail
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\ProcessFormDetail
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessFormDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
