<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningStatusHistory StructType
 * @subpackage Structs
 */
class PlanningStatusHistory extends AbstractStructBase
{
    /**
     * The OldStatus
     * @var string
     */
    public $OldStatus;
    /**
     * The NewStatus
     * @var string
     */
    public $NewStatus;
    /**
     * The ActionDate
     * @var string
     */
    public $ActionDate;
    /**
     * The ModifiedBy
     * @var string
     */
    public $ModifiedBy;
    /**
     * The Comments
     * @var string
     */
    public $Comments;
    /**
     * Constructor method for PlanningStatusHistory
     * @uses PlanningStatusHistory::setOldStatus()
     * @uses PlanningStatusHistory::setNewStatus()
     * @uses PlanningStatusHistory::setActionDate()
     * @uses PlanningStatusHistory::setModifiedBy()
     * @uses PlanningStatusHistory::setComments()
     * @param string $oldStatus
     * @param string $newStatus
     * @param string $actionDate
     * @param string $modifiedBy
     * @param string $comments
     */
    public function __construct($oldStatus = null, $newStatus = null, $actionDate = null, $modifiedBy = null, $comments = null)
    {
        $this
            ->setOldStatus($oldStatus)
            ->setNewStatus($newStatus)
            ->setActionDate($actionDate)
            ->setModifiedBy($modifiedBy)
            ->setComments($comments);
    }
    /**
     * Get OldStatus value
     * @return string|null
     */
    public function getOldStatus()
    {
        return $this->OldStatus;
    }
    /**
     * Set OldStatus value
     * @param string $oldStatus
     * @return \StructType\PlanningStatusHistory
     */
    public function setOldStatus($oldStatus = null)
    {
        // validation for constraint: string
        if (!is_null($oldStatus) && !is_string($oldStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldStatus, true), gettype($oldStatus)), __LINE__);
        }
        $this->OldStatus = $oldStatus;
        return $this;
    }
    /**
     * Get NewStatus value
     * @return string|null
     */
    public function getNewStatus()
    {
        return $this->NewStatus;
    }
    /**
     * Set NewStatus value
     * @param string $newStatus
     * @return \StructType\PlanningStatusHistory
     */
    public function setNewStatus($newStatus = null)
    {
        // validation for constraint: string
        if (!is_null($newStatus) && !is_string($newStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newStatus, true), gettype($newStatus)), __LINE__);
        }
        $this->NewStatus = $newStatus;
        return $this;
    }
    /**
     * Get ActionDate value
     * @return string|null
     */
    public function getActionDate()
    {
        return $this->ActionDate;
    }
    /**
     * Set ActionDate value
     * @param string $actionDate
     * @return \StructType\PlanningStatusHistory
     */
    public function setActionDate($actionDate = null)
    {
        // validation for constraint: string
        if (!is_null($actionDate) && !is_string($actionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDate, true), gettype($actionDate)), __LINE__);
        }
        $this->ActionDate = $actionDate;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return string|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param string $modifiedBy
     * @return \StructType\PlanningStatusHistory
     */
    public function setModifiedBy($modifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedBy) && !is_string($modifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedBy, true), gettype($modifiedBy)), __LINE__);
        }
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\PlanningStatusHistory
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlanningStatusHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
