<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetail StructType
 * @subpackage Structs
 */
class PaymentDetail extends AbstractStructBase
{
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TransactionType;
    /**
     * The TransactionId
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionDate
     * @var string
     */
    public $TransactionDate;
    /**
     * The PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The TransactionNumber
     * @var string
     */
    public $TransactionNumber;
    /**
     * Constructor method for PaymentDetail
     * @uses PaymentDetail::setTransactionType()
     * @uses PaymentDetail::setTransactionId()
     * @uses PaymentDetail::setTransactionDate()
     * @uses PaymentDetail::setPaymentType()
     * @uses PaymentDetail::setReferenceNumber()
     * @uses PaymentDetail::setAmount()
     * @uses PaymentDetail::setTransactionNumber()
     * @param string $transactionType
     * @param string $transactionId
     * @param string $transactionDate
     * @param string $paymentType
     * @param string $referenceNumber
     * @param float $amount
     * @param string $transactionNumber
     */
    public function __construct($transactionType = null, $transactionId = null, $transactionDate = null, $paymentType = null, $referenceNumber = null, $amount = null, $transactionNumber = null)
    {
        $this
            ->setTransactionType($transactionType)
            ->setTransactionId($transactionId)
            ->setTransactionDate($transactionDate)
            ->setPaymentType($paymentType)
            ->setReferenceNumber($referenceNumber)
            ->setAmount($amount)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get TransactionType value
     * @return string
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \EnumType\TransactionType::valueIsValid()
     * @uses \EnumType\TransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\PaymentDetail
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionType', is_array($transactionType) ? implode(', ', $transactionType) : var_export($transactionType, true), implode(', ', \EnumType\TransactionType::getValidValues())), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \StructType\PaymentDetail
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\PaymentDetail
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\PaymentDetail
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\PaymentDetail
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\PaymentDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TransactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->TransactionNumber;
    }
    /**
     * Set TransactionNumber value
     * @param string $transactionNumber
     * @return \StructType\PaymentDetail
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->TransactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
