<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetail StructType
 * @subpackage Structs
 */
class OrderDetail extends AbstractStructBase
{
    /**
     * The DiscountDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DiscountDetail[]
     */
    public $DiscountDetail;
    /**
     * The OrderDetailItemId
     * @var string
     */
    public $OrderDetailItemId;
    /**
     * The OrderDetailId
     * @var string
     */
    public $OrderDetailId;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The ProductId
     * @var string
     */
    public $ProductId;
    /**
     * The ProductName
     * @var string
     */
    public $ProductName;
    /**
     * The ProductCode
     * @var string
     */
    public $ProductCode;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The ProductDescription
     * @var string
     */
    public $ProductDescription;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * @var string
     */
    public $EndTime;
    /**
     * The Action
     * @var string
     */
    public $Action;
    /**
     * The ActionDate
     * @var string
     */
    public $ActionDate;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The AmountPaid
     * @var float
     */
    public $AmountPaid;
    /**
     * The AmountDue
     * @var float
     */
    public $AmountDue;
    /**
     * The OrderNumber
     * @var string
     */
    public $OrderNumber;
    /**
     * The Participant
     * @var bool
     */
    public $Participant;
    /**
     * Constructor method for OrderDetail
     * @uses OrderDetail::setDiscountDetail()
     * @uses OrderDetail::setOrderDetailItemId()
     * @uses OrderDetail::setOrderDetailId()
     * @uses OrderDetail::setFirstName()
     * @uses OrderDetail::setLastName()
     * @uses OrderDetail::setProductId()
     * @uses OrderDetail::setProductName()
     * @uses OrderDetail::setProductCode()
     * @uses OrderDetail::setQuantity()
     * @uses OrderDetail::setProductType()
     * @uses OrderDetail::setProductDescription()
     * @uses OrderDetail::setStartTime()
     * @uses OrderDetail::setEndTime()
     * @uses OrderDetail::setAction()
     * @uses OrderDetail::setActionDate()
     * @uses OrderDetail::setAmount()
     * @uses OrderDetail::setAmountPaid()
     * @uses OrderDetail::setAmountDue()
     * @uses OrderDetail::setOrderNumber()
     * @uses OrderDetail::setParticipant()
     * @param \StructType\DiscountDetail[] $discountDetail
     * @param string $orderDetailItemId
     * @param string $orderDetailId
     * @param string $firstName
     * @param string $lastName
     * @param string $productId
     * @param string $productName
     * @param string $productCode
     * @param int $quantity
     * @param string $productType
     * @param string $productDescription
     * @param string $startTime
     * @param string $endTime
     * @param string $action
     * @param string $actionDate
     * @param float $amount
     * @param float $amountPaid
     * @param float $amountDue
     * @param string $orderNumber
     * @param bool $participant
     */
    public function __construct(array $discountDetail = array(), $orderDetailItemId = null, $orderDetailId = null, $firstName = null, $lastName = null, $productId = null, $productName = null, $productCode = null, $quantity = null, $productType = null, $productDescription = null, $startTime = null, $endTime = null, $action = null, $actionDate = null, $amount = null, $amountPaid = null, $amountDue = null, $orderNumber = null, $participant = null)
    {
        $this
            ->setDiscountDetail($discountDetail)
            ->setOrderDetailItemId($orderDetailItemId)
            ->setOrderDetailId($orderDetailId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setProductId($productId)
            ->setProductName($productName)
            ->setProductCode($productCode)
            ->setQuantity($quantity)
            ->setProductType($productType)
            ->setProductDescription($productDescription)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setAction($action)
            ->setActionDate($actionDate)
            ->setAmount($amount)
            ->setAmountPaid($amountPaid)
            ->setAmountDue($amountDue)
            ->setOrderNumber($orderNumber)
            ->setParticipant($participant);
    }
    /**
     * Get DiscountDetail value
     * @return \StructType\DiscountDetail[]|null
     */
    public function getDiscountDetail()
    {
        return $this->DiscountDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountDetailForArrayConstraintsFromSetDiscountDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDetailDiscountDetailItem) {
            // validation for constraint: itemType
            if (!$orderDetailDiscountDetailItem instanceof \StructType\DiscountDetail) {
                $invalidValues[] = is_object($orderDetailDiscountDetailItem) ? get_class($orderDetailDiscountDetailItem) : sprintf('%s(%s)', gettype($orderDetailDiscountDetailItem), var_export($orderDetailDiscountDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountDetail property can only contain items of type \StructType\DiscountDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountDetail[] $discountDetail
     * @return \StructType\OrderDetail
     */
    public function setDiscountDetail(array $discountDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($discountDetailArrayErrorMessage = self::validateDiscountDetailForArrayConstraintsFromSetDiscountDetail($discountDetail))) {
            throw new \InvalidArgumentException($discountDetailArrayErrorMessage, __LINE__);
        }
        $this->DiscountDetail = $discountDetail;
        return $this;
    }
    /**
     * Add item to DiscountDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountDetail $item
     * @return \StructType\OrderDetail
     */
    public function addToDiscountDetail(\StructType\DiscountDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscountDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountDetail property can only contain items of type \StructType\DiscountDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscountDetail[] = $item;
        return $this;
    }
    /**
     * Get OrderDetailItemId value
     * @return string|null
     */
    public function getOrderDetailItemId()
    {
        return $this->OrderDetailItemId;
    }
    /**
     * Set OrderDetailItemId value
     * @param string $orderDetailItemId
     * @return \StructType\OrderDetail
     */
    public function setOrderDetailItemId($orderDetailItemId = null)
    {
        // validation for constraint: string
        if (!is_null($orderDetailItemId) && !is_string($orderDetailItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDetailItemId, true), gettype($orderDetailItemId)), __LINE__);
        }
        $this->OrderDetailItemId = $orderDetailItemId;
        return $this;
    }
    /**
     * Get OrderDetailId value
     * @return string|null
     */
    public function getOrderDetailId()
    {
        return $this->OrderDetailId;
    }
    /**
     * Set OrderDetailId value
     * @param string $orderDetailId
     * @return \StructType\OrderDetail
     */
    public function setOrderDetailId($orderDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($orderDetailId) && !is_string($orderDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDetailId, true), gettype($orderDetailId)), __LINE__);
        }
        $this->OrderDetailId = $orderDetailId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\OrderDetail
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\OrderDetail
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \StructType\OrderDetail
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\OrderDetail
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\OrderDetail
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\OrderDetail
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \StructType\OrderDetail
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ProductDescription value
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->ProductDescription;
    }
    /**
     * Set ProductDescription value
     * @param string $productDescription
     * @return \StructType\OrderDetail
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productDescription, true), gettype($productDescription)), __LINE__);
        }
        $this->ProductDescription = $productDescription;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\OrderDetail
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\OrderDetail
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \StructType\OrderDetail
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get ActionDate value
     * @return string|null
     */
    public function getActionDate()
    {
        return $this->ActionDate;
    }
    /**
     * Set ActionDate value
     * @param string $actionDate
     * @return \StructType\OrderDetail
     */
    public function setActionDate($actionDate = null)
    {
        // validation for constraint: string
        if (!is_null($actionDate) && !is_string($actionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDate, true), gettype($actionDate)), __LINE__);
        }
        $this->ActionDate = $actionDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\OrderDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AmountPaid value
     * @return float|null
     */
    public function getAmountPaid()
    {
        return $this->AmountPaid;
    }
    /**
     * Set AmountPaid value
     * @param float $amountPaid
     * @return \StructType\OrderDetail
     */
    public function setAmountPaid($amountPaid = null)
    {
        // validation for constraint: float
        if (!is_null($amountPaid) && !(is_float($amountPaid) || is_numeric($amountPaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountPaid, true), gettype($amountPaid)), __LINE__);
        }
        $this->AmountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return float|null
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param float $amountDue
     * @return \StructType\OrderDetail
     */
    public function setAmountDue($amountDue = null)
    {
        // validation for constraint: float
        if (!is_null($amountDue) && !(is_float($amountDue) || is_numeric($amountDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDue, true), gettype($amountDue)), __LINE__);
        }
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\OrderDetail
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get Participant value
     * @return bool|null
     */
    public function getParticipant()
    {
        return $this->Participant;
    }
    /**
     * Set Participant value
     * @param bool $participant
     * @return \StructType\OrderDetail
     */
    public function setParticipant($participant = null)
    {
        // validation for constraint: boolean
        if (!is_null($participant) && !is_bool($participant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($participant, true), gettype($participant)), __LINE__);
        }
        $this->Participant = $participant;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
