<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeetingRequest StructType
 * @subpackage Structs
 */
class MeetingRequest extends CvObject
{
    /**
     * The EventRequestInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventRequestInfo[]
     */
    public $EventRequestInfo;
    /**
     * The RFPRequestInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFPRequestInfo[]
     */
    public $RFPRequestInfo;
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The DocumentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentDetail[]
     */
    public $DocumentDetail;
    /**
     * The EventSurveyDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventSurveyDetail[]
     */
    public $EventSurveyDetail;
    /**
     * The RequestName
     * @var string
     */
    public $RequestName;
    /**
     * The RequestStatus
     * @var string
     */
    public $RequestStatus;
    /**
     * The RequestCode
     * @var string
     */
    public $RequestCode;
    /**
     * The FormId
     * @var string
     */
    public $FormId;
    /**
     * The FormName
     * @var string
     */
    public $FormName;
    /**
     * The FormDescription
     * @var string
     */
    public $FormDescription;
    /**
     * The FormInternalNote
     * @var string
     */
    public $FormInternalNote;
    /**
     * The RequesterId
     * @var string
     */
    public $RequesterId;
    /**
     * The RequesterFirstName
     * @var string
     */
    public $RequesterFirstName;
    /**
     * The RequesterLastName
     * @var string
     */
    public $RequesterLastName;
    /**
     * The RequesterEmailAddress
     * @var string
     */
    public $RequesterEmailAddress;
    /**
     * The RequesterTitle
     * @var string
     */
    public $RequesterTitle;
    /**
     * The RequesterCompany
     * @var string
     */
    public $RequesterCompany;
    /**
     * The RequesterWorkPhone
     * @var string
     */
    public $RequesterWorkPhone;
    /**
     * The RequesterHomePhone
     * @var string
     */
    public $RequesterHomePhone;
    /**
     * The RequesterWorkFax
     * @var string
     */
    public $RequesterWorkFax;
    /**
     * The RequesterMobilePhone
     * @var string
     */
    public $RequesterMobilePhone;
    /**
     * The RequesterAddress1
     * @var string
     */
    public $RequesterAddress1;
    /**
     * The RequesterAddress2
     * @var string
     */
    public $RequesterAddress2;
    /**
     * The RequesterAddress3
     * @var string
     */
    public $RequesterAddress3;
    /**
     * The RequesterCity
     * @var string
     */
    public $RequesterCity;
    /**
     * The RequesterState
     * @var string
     */
    public $RequesterState;
    /**
     * The RequesterStateCode
     * @var string
     */
    public $RequesterStateCode;
    /**
     * The RequesterPostalCode
     * @var string
     */
    public $RequesterPostalCode;
    /**
     * The RequesterCountry
     * @var string
     */
    public $RequesterCountry;
    /**
     * The RequesterCountryCode
     * @var string
     */
    public $RequesterCountryCode;
    /**
     * The Archived
     * @var bool
     */
    public $Archived;
    /**
     * The ArchiveDate
     * @var string
     */
    public $ArchiveDate;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * Constructor method for MeetingRequest
     * @uses MeetingRequest::setEventRequestInfo()
     * @uses MeetingRequest::setRFPRequestInfo()
     * @uses MeetingRequest::setCustomFieldDetail()
     * @uses MeetingRequest::setDocumentDetail()
     * @uses MeetingRequest::setEventSurveyDetail()
     * @uses MeetingRequest::setRequestName()
     * @uses MeetingRequest::setRequestStatus()
     * @uses MeetingRequest::setRequestCode()
     * @uses MeetingRequest::setFormId()
     * @uses MeetingRequest::setFormName()
     * @uses MeetingRequest::setFormDescription()
     * @uses MeetingRequest::setFormInternalNote()
     * @uses MeetingRequest::setRequesterId()
     * @uses MeetingRequest::setRequesterFirstName()
     * @uses MeetingRequest::setRequesterLastName()
     * @uses MeetingRequest::setRequesterEmailAddress()
     * @uses MeetingRequest::setRequesterTitle()
     * @uses MeetingRequest::setRequesterCompany()
     * @uses MeetingRequest::setRequesterWorkPhone()
     * @uses MeetingRequest::setRequesterHomePhone()
     * @uses MeetingRequest::setRequesterWorkFax()
     * @uses MeetingRequest::setRequesterMobilePhone()
     * @uses MeetingRequest::setRequesterAddress1()
     * @uses MeetingRequest::setRequesterAddress2()
     * @uses MeetingRequest::setRequesterAddress3()
     * @uses MeetingRequest::setRequesterCity()
     * @uses MeetingRequest::setRequesterState()
     * @uses MeetingRequest::setRequesterStateCode()
     * @uses MeetingRequest::setRequesterPostalCode()
     * @uses MeetingRequest::setRequesterCountry()
     * @uses MeetingRequest::setRequesterCountryCode()
     * @uses MeetingRequest::setArchived()
     * @uses MeetingRequest::setArchiveDate()
     * @uses MeetingRequest::setCreatedBy()
     * @uses MeetingRequest::setCreatedDate()
     * @uses MeetingRequest::setLastModifiedBy()
     * @uses MeetingRequest::setLastModifiedDate()
     * @param \StructType\EventRequestInfo[] $eventRequestInfo
     * @param \StructType\RFPRequestInfo[] $rFPRequestInfo
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param \StructType\DocumentDetail[] $documentDetail
     * @param \StructType\EventSurveyDetail[] $eventSurveyDetail
     * @param string $requestName
     * @param string $requestStatus
     * @param string $requestCode
     * @param string $formId
     * @param string $formName
     * @param string $formDescription
     * @param string $formInternalNote
     * @param string $requesterId
     * @param string $requesterFirstName
     * @param string $requesterLastName
     * @param string $requesterEmailAddress
     * @param string $requesterTitle
     * @param string $requesterCompany
     * @param string $requesterWorkPhone
     * @param string $requesterHomePhone
     * @param string $requesterWorkFax
     * @param string $requesterMobilePhone
     * @param string $requesterAddress1
     * @param string $requesterAddress2
     * @param string $requesterAddress3
     * @param string $requesterCity
     * @param string $requesterState
     * @param string $requesterStateCode
     * @param string $requesterPostalCode
     * @param string $requesterCountry
     * @param string $requesterCountryCode
     * @param bool $archived
     * @param string $archiveDate
     * @param string $createdBy
     * @param string $createdDate
     * @param string $lastModifiedBy
     * @param string $lastModifiedDate
     */
    public function __construct(array $eventRequestInfo = array(), array $rFPRequestInfo = array(), array $customFieldDetail = array(), array $documentDetail = array(), array $eventSurveyDetail = array(), $requestName = null, $requestStatus = null, $requestCode = null, $formId = null, $formName = null, $formDescription = null, $formInternalNote = null, $requesterId = null, $requesterFirstName = null, $requesterLastName = null, $requesterEmailAddress = null, $requesterTitle = null, $requesterCompany = null, $requesterWorkPhone = null, $requesterHomePhone = null, $requesterWorkFax = null, $requesterMobilePhone = null, $requesterAddress1 = null, $requesterAddress2 = null, $requesterAddress3 = null, $requesterCity = null, $requesterState = null, $requesterStateCode = null, $requesterPostalCode = null, $requesterCountry = null, $requesterCountryCode = null, $archived = null, $archiveDate = null, $createdBy = null, $createdDate = null, $lastModifiedBy = null, $lastModifiedDate = null)
    {
        $this
            ->setEventRequestInfo($eventRequestInfo)
            ->setRFPRequestInfo($rFPRequestInfo)
            ->setCustomFieldDetail($customFieldDetail)
            ->setDocumentDetail($documentDetail)
            ->setEventSurveyDetail($eventSurveyDetail)
            ->setRequestName($requestName)
            ->setRequestStatus($requestStatus)
            ->setRequestCode($requestCode)
            ->setFormId($formId)
            ->setFormName($formName)
            ->setFormDescription($formDescription)
            ->setFormInternalNote($formInternalNote)
            ->setRequesterId($requesterId)
            ->setRequesterFirstName($requesterFirstName)
            ->setRequesterLastName($requesterLastName)
            ->setRequesterEmailAddress($requesterEmailAddress)
            ->setRequesterTitle($requesterTitle)
            ->setRequesterCompany($requesterCompany)
            ->setRequesterWorkPhone($requesterWorkPhone)
            ->setRequesterHomePhone($requesterHomePhone)
            ->setRequesterWorkFax($requesterWorkFax)
            ->setRequesterMobilePhone($requesterMobilePhone)
            ->setRequesterAddress1($requesterAddress1)
            ->setRequesterAddress2($requesterAddress2)
            ->setRequesterAddress3($requesterAddress3)
            ->setRequesterCity($requesterCity)
            ->setRequesterState($requesterState)
            ->setRequesterStateCode($requesterStateCode)
            ->setRequesterPostalCode($requesterPostalCode)
            ->setRequesterCountry($requesterCountry)
            ->setRequesterCountryCode($requesterCountryCode)
            ->setArchived($archived)
            ->setArchiveDate($archiveDate)
            ->setCreatedBy($createdBy)
            ->setCreatedDate($createdDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get EventRequestInfo value
     * @return \StructType\EventRequestInfo[]|null
     */
    public function getEventRequestInfo()
    {
        return $this->EventRequestInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setEventRequestInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventRequestInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventRequestInfoForArrayConstraintsFromSetEventRequestInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $meetingRequestEventRequestInfoItem) {
            // validation for constraint: itemType
            if (!$meetingRequestEventRequestInfoItem instanceof \StructType\EventRequestInfo) {
                $invalidValues[] = is_object($meetingRequestEventRequestInfoItem) ? get_class($meetingRequestEventRequestInfoItem) : sprintf('%s(%s)', gettype($meetingRequestEventRequestInfoItem), var_export($meetingRequestEventRequestInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventRequestInfo property can only contain items of type \StructType\EventRequestInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventRequestInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EventRequestInfo[] $eventRequestInfo
     * @return \StructType\MeetingRequest
     */
    public function setEventRequestInfo(array $eventRequestInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($eventRequestInfoArrayErrorMessage = self::validateEventRequestInfoForArrayConstraintsFromSetEventRequestInfo($eventRequestInfo))) {
            throw new \InvalidArgumentException($eventRequestInfoArrayErrorMessage, __LINE__);
        }
        $this->EventRequestInfo = $eventRequestInfo;
        return $this;
    }
    /**
     * Add item to EventRequestInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EventRequestInfo $item
     * @return \StructType\MeetingRequest
     */
    public function addToEventRequestInfo(\StructType\EventRequestInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventRequestInfo) {
            throw new \InvalidArgumentException(sprintf('The EventRequestInfo property can only contain items of type \StructType\EventRequestInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventRequestInfo[] = $item;
        return $this;
    }
    /**
     * Get RFPRequestInfo value
     * @return \StructType\RFPRequestInfo[]|null
     */
    public function getRFPRequestInfo()
    {
        return $this->RFPRequestInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setRFPRequestInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFPRequestInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFPRequestInfoForArrayConstraintsFromSetRFPRequestInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $meetingRequestRFPRequestInfoItem) {
            // validation for constraint: itemType
            if (!$meetingRequestRFPRequestInfoItem instanceof \StructType\RFPRequestInfo) {
                $invalidValues[] = is_object($meetingRequestRFPRequestInfoItem) ? get_class($meetingRequestRFPRequestInfoItem) : sprintf('%s(%s)', gettype($meetingRequestRFPRequestInfoItem), var_export($meetingRequestRFPRequestInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFPRequestInfo property can only contain items of type \StructType\RFPRequestInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFPRequestInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPRequestInfo[] $rFPRequestInfo
     * @return \StructType\MeetingRequest
     */
    public function setRFPRequestInfo(array $rFPRequestInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($rFPRequestInfoArrayErrorMessage = self::validateRFPRequestInfoForArrayConstraintsFromSetRFPRequestInfo($rFPRequestInfo))) {
            throw new \InvalidArgumentException($rFPRequestInfoArrayErrorMessage, __LINE__);
        }
        $this->RFPRequestInfo = $rFPRequestInfo;
        return $this;
    }
    /**
     * Add item to RFPRequestInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RFPRequestInfo $item
     * @return \StructType\MeetingRequest
     */
    public function addToRFPRequestInfo(\StructType\RFPRequestInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFPRequestInfo) {
            throw new \InvalidArgumentException(sprintf('The RFPRequestInfo property can only contain items of type \StructType\RFPRequestInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFPRequestInfo[] = $item;
        return $this;
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $meetingRequestCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$meetingRequestCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($meetingRequestCustomFieldDetailItem) ? get_class($meetingRequestCustomFieldDetailItem) : sprintf('%s(%s)', gettype($meetingRequestCustomFieldDetailItem), var_export($meetingRequestCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\MeetingRequest
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\MeetingRequest
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get DocumentDetail value
     * @return \StructType\DocumentDetail[]|null
     */
    public function getDocumentDetail()
    {
        return $this->DocumentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentDetailForArrayConstraintsFromSetDocumentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $meetingRequestDocumentDetailItem) {
            // validation for constraint: itemType
            if (!$meetingRequestDocumentDetailItem instanceof \StructType\DocumentDetail) {
                $invalidValues[] = is_object($meetingRequestDocumentDetailItem) ? get_class($meetingRequestDocumentDetailItem) : sprintf('%s(%s)', gettype($meetingRequestDocumentDetailItem), var_export($meetingRequestDocumentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentDetail property can only contain items of type \StructType\DocumentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentDetail[] $documentDetail
     * @return \StructType\MeetingRequest
     */
    public function setDocumentDetail(array $documentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($documentDetailArrayErrorMessage = self::validateDocumentDetailForArrayConstraintsFromSetDocumentDetail($documentDetail))) {
            throw new \InvalidArgumentException($documentDetailArrayErrorMessage, __LINE__);
        }
        $this->DocumentDetail = $documentDetail;
        return $this;
    }
    /**
     * Add item to DocumentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentDetail $item
     * @return \StructType\MeetingRequest
     */
    public function addToDocumentDetail(\StructType\DocumentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentDetail) {
            throw new \InvalidArgumentException(sprintf('The DocumentDetail property can only contain items of type \StructType\DocumentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentDetail[] = $item;
        return $this;
    }
    /**
     * Get EventSurveyDetail value
     * @return \StructType\EventSurveyDetail[]|null
     */
    public function getEventSurveyDetail()
    {
        return $this->EventSurveyDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setEventSurveyDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventSurveyDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventSurveyDetailForArrayConstraintsFromSetEventSurveyDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $meetingRequestEventSurveyDetailItem) {
            // validation for constraint: itemType
            if (!$meetingRequestEventSurveyDetailItem instanceof \StructType\EventSurveyDetail) {
                $invalidValues[] = is_object($meetingRequestEventSurveyDetailItem) ? get_class($meetingRequestEventSurveyDetailItem) : sprintf('%s(%s)', gettype($meetingRequestEventSurveyDetailItem), var_export($meetingRequestEventSurveyDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventSurveyDetail property can only contain items of type \StructType\EventSurveyDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EventSurveyDetail[] $eventSurveyDetail
     * @return \StructType\MeetingRequest
     */
    public function setEventSurveyDetail(array $eventSurveyDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($eventSurveyDetailArrayErrorMessage = self::validateEventSurveyDetailForArrayConstraintsFromSetEventSurveyDetail($eventSurveyDetail))) {
            throw new \InvalidArgumentException($eventSurveyDetailArrayErrorMessage, __LINE__);
        }
        $this->EventSurveyDetail = $eventSurveyDetail;
        return $this;
    }
    /**
     * Add item to EventSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EventSurveyDetail $item
     * @return \StructType\MeetingRequest
     */
    public function addToEventSurveyDetail(\StructType\EventSurveyDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventSurveyDetail) {
            throw new \InvalidArgumentException(sprintf('The EventSurveyDetail property can only contain items of type \StructType\EventSurveyDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventSurveyDetail[] = $item;
        return $this;
    }
    /**
     * Get RequestName value
     * @return string|null
     */
    public function getRequestName()
    {
        return $this->RequestName;
    }
    /**
     * Set RequestName value
     * @param string $requestName
     * @return \StructType\MeetingRequest
     */
    public function setRequestName($requestName = null)
    {
        // validation for constraint: string
        if (!is_null($requestName) && !is_string($requestName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestName, true), gettype($requestName)), __LINE__);
        }
        $this->RequestName = $requestName;
        return $this;
    }
    /**
     * Get RequestStatus value
     * @return string|null
     */
    public function getRequestStatus()
    {
        return $this->RequestStatus;
    }
    /**
     * Set RequestStatus value
     * @param string $requestStatus
     * @return \StructType\MeetingRequest
     */
    public function setRequestStatus($requestStatus = null)
    {
        // validation for constraint: string
        if (!is_null($requestStatus) && !is_string($requestStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestStatus, true), gettype($requestStatus)), __LINE__);
        }
        $this->RequestStatus = $requestStatus;
        return $this;
    }
    /**
     * Get RequestCode value
     * @return string|null
     */
    public function getRequestCode()
    {
        return $this->RequestCode;
    }
    /**
     * Set RequestCode value
     * @param string $requestCode
     * @return \StructType\MeetingRequest
     */
    public function setRequestCode($requestCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestCode) && !is_string($requestCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestCode, true), gettype($requestCode)), __LINE__);
        }
        $this->RequestCode = $requestCode;
        return $this;
    }
    /**
     * Get FormId value
     * @return string|null
     */
    public function getFormId()
    {
        return $this->FormId;
    }
    /**
     * Set FormId value
     * @param string $formId
     * @return \StructType\MeetingRequest
     */
    public function setFormId($formId = null)
    {
        // validation for constraint: string
        if (!is_null($formId) && !is_string($formId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formId, true), gettype($formId)), __LINE__);
        }
        $this->FormId = $formId;
        return $this;
    }
    /**
     * Get FormName value
     * @return string|null
     */
    public function getFormName()
    {
        return $this->FormName;
    }
    /**
     * Set FormName value
     * @param string $formName
     * @return \StructType\MeetingRequest
     */
    public function setFormName($formName = null)
    {
        // validation for constraint: string
        if (!is_null($formName) && !is_string($formName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formName, true), gettype($formName)), __LINE__);
        }
        $this->FormName = $formName;
        return $this;
    }
    /**
     * Get FormDescription value
     * @return string|null
     */
    public function getFormDescription()
    {
        return $this->FormDescription;
    }
    /**
     * Set FormDescription value
     * @param string $formDescription
     * @return \StructType\MeetingRequest
     */
    public function setFormDescription($formDescription = null)
    {
        // validation for constraint: string
        if (!is_null($formDescription) && !is_string($formDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formDescription, true), gettype($formDescription)), __LINE__);
        }
        $this->FormDescription = $formDescription;
        return $this;
    }
    /**
     * Get FormInternalNote value
     * @return string|null
     */
    public function getFormInternalNote()
    {
        return $this->FormInternalNote;
    }
    /**
     * Set FormInternalNote value
     * @param string $formInternalNote
     * @return \StructType\MeetingRequest
     */
    public function setFormInternalNote($formInternalNote = null)
    {
        // validation for constraint: string
        if (!is_null($formInternalNote) && !is_string($formInternalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formInternalNote, true), gettype($formInternalNote)), __LINE__);
        }
        $this->FormInternalNote = $formInternalNote;
        return $this;
    }
    /**
     * Get RequesterId value
     * @return string|null
     */
    public function getRequesterId()
    {
        return $this->RequesterId;
    }
    /**
     * Set RequesterId value
     * @param string $requesterId
     * @return \StructType\MeetingRequest
     */
    public function setRequesterId($requesterId = null)
    {
        // validation for constraint: string
        if (!is_null($requesterId) && !is_string($requesterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterId, true), gettype($requesterId)), __LINE__);
        }
        $this->RequesterId = $requesterId;
        return $this;
    }
    /**
     * Get RequesterFirstName value
     * @return string|null
     */
    public function getRequesterFirstName()
    {
        return $this->RequesterFirstName;
    }
    /**
     * Set RequesterFirstName value
     * @param string $requesterFirstName
     * @return \StructType\MeetingRequest
     */
    public function setRequesterFirstName($requesterFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterFirstName) && !is_string($requesterFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterFirstName, true), gettype($requesterFirstName)), __LINE__);
        }
        $this->RequesterFirstName = $requesterFirstName;
        return $this;
    }
    /**
     * Get RequesterLastName value
     * @return string|null
     */
    public function getRequesterLastName()
    {
        return $this->RequesterLastName;
    }
    /**
     * Set RequesterLastName value
     * @param string $requesterLastName
     * @return \StructType\MeetingRequest
     */
    public function setRequesterLastName($requesterLastName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterLastName) && !is_string($requesterLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterLastName, true), gettype($requesterLastName)), __LINE__);
        }
        $this->RequesterLastName = $requesterLastName;
        return $this;
    }
    /**
     * Get RequesterEmailAddress value
     * @return string|null
     */
    public function getRequesterEmailAddress()
    {
        return $this->RequesterEmailAddress;
    }
    /**
     * Set RequesterEmailAddress value
     * @param string $requesterEmailAddress
     * @return \StructType\MeetingRequest
     */
    public function setRequesterEmailAddress($requesterEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($requesterEmailAddress) && !is_string($requesterEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterEmailAddress, true), gettype($requesterEmailAddress)), __LINE__);
        }
        $this->RequesterEmailAddress = $requesterEmailAddress;
        return $this;
    }
    /**
     * Get RequesterTitle value
     * @return string|null
     */
    public function getRequesterTitle()
    {
        return $this->RequesterTitle;
    }
    /**
     * Set RequesterTitle value
     * @param string $requesterTitle
     * @return \StructType\MeetingRequest
     */
    public function setRequesterTitle($requesterTitle = null)
    {
        // validation for constraint: string
        if (!is_null($requesterTitle) && !is_string($requesterTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterTitle, true), gettype($requesterTitle)), __LINE__);
        }
        $this->RequesterTitle = $requesterTitle;
        return $this;
    }
    /**
     * Get RequesterCompany value
     * @return string|null
     */
    public function getRequesterCompany()
    {
        return $this->RequesterCompany;
    }
    /**
     * Set RequesterCompany value
     * @param string $requesterCompany
     * @return \StructType\MeetingRequest
     */
    public function setRequesterCompany($requesterCompany = null)
    {
        // validation for constraint: string
        if (!is_null($requesterCompany) && !is_string($requesterCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterCompany, true), gettype($requesterCompany)), __LINE__);
        }
        $this->RequesterCompany = $requesterCompany;
        return $this;
    }
    /**
     * Get RequesterWorkPhone value
     * @return string|null
     */
    public function getRequesterWorkPhone()
    {
        return $this->RequesterWorkPhone;
    }
    /**
     * Set RequesterWorkPhone value
     * @param string $requesterWorkPhone
     * @return \StructType\MeetingRequest
     */
    public function setRequesterWorkPhone($requesterWorkPhone = null)
    {
        // validation for constraint: string
        if (!is_null($requesterWorkPhone) && !is_string($requesterWorkPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterWorkPhone, true), gettype($requesterWorkPhone)), __LINE__);
        }
        $this->RequesterWorkPhone = $requesterWorkPhone;
        return $this;
    }
    /**
     * Get RequesterHomePhone value
     * @return string|null
     */
    public function getRequesterHomePhone()
    {
        return $this->RequesterHomePhone;
    }
    /**
     * Set RequesterHomePhone value
     * @param string $requesterHomePhone
     * @return \StructType\MeetingRequest
     */
    public function setRequesterHomePhone($requesterHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($requesterHomePhone) && !is_string($requesterHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterHomePhone, true), gettype($requesterHomePhone)), __LINE__);
        }
        $this->RequesterHomePhone = $requesterHomePhone;
        return $this;
    }
    /**
     * Get RequesterWorkFax value
     * @return string|null
     */
    public function getRequesterWorkFax()
    {
        return $this->RequesterWorkFax;
    }
    /**
     * Set RequesterWorkFax value
     * @param string $requesterWorkFax
     * @return \StructType\MeetingRequest
     */
    public function setRequesterWorkFax($requesterWorkFax = null)
    {
        // validation for constraint: string
        if (!is_null($requesterWorkFax) && !is_string($requesterWorkFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterWorkFax, true), gettype($requesterWorkFax)), __LINE__);
        }
        $this->RequesterWorkFax = $requesterWorkFax;
        return $this;
    }
    /**
     * Get RequesterMobilePhone value
     * @return string|null
     */
    public function getRequesterMobilePhone()
    {
        return $this->RequesterMobilePhone;
    }
    /**
     * Set RequesterMobilePhone value
     * @param string $requesterMobilePhone
     * @return \StructType\MeetingRequest
     */
    public function setRequesterMobilePhone($requesterMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($requesterMobilePhone) && !is_string($requesterMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterMobilePhone, true), gettype($requesterMobilePhone)), __LINE__);
        }
        $this->RequesterMobilePhone = $requesterMobilePhone;
        return $this;
    }
    /**
     * Get RequesterAddress1 value
     * @return string|null
     */
    public function getRequesterAddress1()
    {
        return $this->RequesterAddress1;
    }
    /**
     * Set RequesterAddress1 value
     * @param string $requesterAddress1
     * @return \StructType\MeetingRequest
     */
    public function setRequesterAddress1($requesterAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($requesterAddress1) && !is_string($requesterAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterAddress1, true), gettype($requesterAddress1)), __LINE__);
        }
        $this->RequesterAddress1 = $requesterAddress1;
        return $this;
    }
    /**
     * Get RequesterAddress2 value
     * @return string|null
     */
    public function getRequesterAddress2()
    {
        return $this->RequesterAddress2;
    }
    /**
     * Set RequesterAddress2 value
     * @param string $requesterAddress2
     * @return \StructType\MeetingRequest
     */
    public function setRequesterAddress2($requesterAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($requesterAddress2) && !is_string($requesterAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterAddress2, true), gettype($requesterAddress2)), __LINE__);
        }
        $this->RequesterAddress2 = $requesterAddress2;
        return $this;
    }
    /**
     * Get RequesterAddress3 value
     * @return string|null
     */
    public function getRequesterAddress3()
    {
        return $this->RequesterAddress3;
    }
    /**
     * Set RequesterAddress3 value
     * @param string $requesterAddress3
     * @return \StructType\MeetingRequest
     */
    public function setRequesterAddress3($requesterAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($requesterAddress3) && !is_string($requesterAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterAddress3, true), gettype($requesterAddress3)), __LINE__);
        }
        $this->RequesterAddress3 = $requesterAddress3;
        return $this;
    }
    /**
     * Get RequesterCity value
     * @return string|null
     */
    public function getRequesterCity()
    {
        return $this->RequesterCity;
    }
    /**
     * Set RequesterCity value
     * @param string $requesterCity
     * @return \StructType\MeetingRequest
     */
    public function setRequesterCity($requesterCity = null)
    {
        // validation for constraint: string
        if (!is_null($requesterCity) && !is_string($requesterCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterCity, true), gettype($requesterCity)), __LINE__);
        }
        $this->RequesterCity = $requesterCity;
        return $this;
    }
    /**
     * Get RequesterState value
     * @return string|null
     */
    public function getRequesterState()
    {
        return $this->RequesterState;
    }
    /**
     * Set RequesterState value
     * @param string $requesterState
     * @return \StructType\MeetingRequest
     */
    public function setRequesterState($requesterState = null)
    {
        // validation for constraint: string
        if (!is_null($requesterState) && !is_string($requesterState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterState, true), gettype($requesterState)), __LINE__);
        }
        $this->RequesterState = $requesterState;
        return $this;
    }
    /**
     * Get RequesterStateCode value
     * @return string|null
     */
    public function getRequesterStateCode()
    {
        return $this->RequesterStateCode;
    }
    /**
     * Set RequesterStateCode value
     * @param string $requesterStateCode
     * @return \StructType\MeetingRequest
     */
    public function setRequesterStateCode($requesterStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($requesterStateCode) && !is_string($requesterStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterStateCode, true), gettype($requesterStateCode)), __LINE__);
        }
        $this->RequesterStateCode = $requesterStateCode;
        return $this;
    }
    /**
     * Get RequesterPostalCode value
     * @return string|null
     */
    public function getRequesterPostalCode()
    {
        return $this->RequesterPostalCode;
    }
    /**
     * Set RequesterPostalCode value
     * @param string $requesterPostalCode
     * @return \StructType\MeetingRequest
     */
    public function setRequesterPostalCode($requesterPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($requesterPostalCode) && !is_string($requesterPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterPostalCode, true), gettype($requesterPostalCode)), __LINE__);
        }
        $this->RequesterPostalCode = $requesterPostalCode;
        return $this;
    }
    /**
     * Get RequesterCountry value
     * @return string|null
     */
    public function getRequesterCountry()
    {
        return $this->RequesterCountry;
    }
    /**
     * Set RequesterCountry value
     * @param string $requesterCountry
     * @return \StructType\MeetingRequest
     */
    public function setRequesterCountry($requesterCountry = null)
    {
        // validation for constraint: string
        if (!is_null($requesterCountry) && !is_string($requesterCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterCountry, true), gettype($requesterCountry)), __LINE__);
        }
        $this->RequesterCountry = $requesterCountry;
        return $this;
    }
    /**
     * Get RequesterCountryCode value
     * @return string|null
     */
    public function getRequesterCountryCode()
    {
        return $this->RequesterCountryCode;
    }
    /**
     * Set RequesterCountryCode value
     * @param string $requesterCountryCode
     * @return \StructType\MeetingRequest
     */
    public function setRequesterCountryCode($requesterCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($requesterCountryCode) && !is_string($requesterCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterCountryCode, true), gettype($requesterCountryCode)), __LINE__);
        }
        $this->RequesterCountryCode = $requesterCountryCode;
        return $this;
    }
    /**
     * Get Archived value
     * @return bool|null
     */
    public function getArchived()
    {
        return $this->Archived;
    }
    /**
     * Set Archived value
     * @param bool $archived
     * @return \StructType\MeetingRequest
     */
    public function setArchived($archived = null)
    {
        // validation for constraint: boolean
        if (!is_null($archived) && !is_bool($archived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($archived, true), gettype($archived)), __LINE__);
        }
        $this->Archived = $archived;
        return $this;
    }
    /**
     * Get ArchiveDate value
     * @return string|null
     */
    public function getArchiveDate()
    {
        return $this->ArchiveDate;
    }
    /**
     * Set ArchiveDate value
     * @param string $archiveDate
     * @return \StructType\MeetingRequest
     */
    public function setArchiveDate($archiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($archiveDate) && !is_string($archiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveDate, true), gettype($archiveDate)), __LINE__);
        }
        $this->ArchiveDate = $archiveDate;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\MeetingRequest
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\MeetingRequest
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\MeetingRequest
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\MeetingRequest
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeetingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
