<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManageUserGroup StructType
 * @subpackage Structs
 */
class ManageUserGroup extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupId;
    /**
     * The CvObjects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s1:CvObjects
     * @var \ArrayType\CvObjectArray
     */
    public $CvObjects;
    /**
     * Constructor method for ManageUserGroup
     * @uses ManageUserGroup::setAction()
     * @uses ManageUserGroup::setGroupId()
     * @uses ManageUserGroup::setCvObjects()
     * @param string $action
     * @param string $groupId
     * @param \ArrayType\CvObjectArray $cvObjects
     */
    public function __construct($action = null, $groupId = null, \ArrayType\CvObjectArray $cvObjects = null)
    {
        $this
            ->setAction($action)
            ->setGroupId($groupId)
            ->setCvObjects($cvObjects);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ManageGroupAction::valueIsValid()
     * @uses \EnumType\ManageGroupAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\ManageUserGroup
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ManageGroupAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ManageGroupAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\ManageGroupAction::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get GroupId value
     * @return string|null
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param string $groupId
     * @return \StructType\ManageUserGroup
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get CvObjects value
     * @return \ArrayType\CvObjectArray|null
     */
    public function getCvObjects()
    {
        return $this->CvObjects;
    }
    /**
     * Set CvObjects value
     * @param \ArrayType\CvObjectArray $cvObjects
     * @return \StructType\ManageUserGroup
     */
    public function setCvObjects(\ArrayType\CvObjectArray $cvObjects = null)
    {
        $this->CvObjects = $cvObjects;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ManageUserGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
