<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManageDistributionListMembers StructType
 * @subpackage Structs
 */
class ManageDistributionListMembers extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The DistListId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistListId;
    /**
     * The CvObjects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s1:CvObjects
     * @var \ArrayType\CvObjectArray
     */
    public $CvObjects;
    /**
     * Constructor method for ManageDistributionListMembers
     * @uses ManageDistributionListMembers::setAction()
     * @uses ManageDistributionListMembers::setDistListId()
     * @uses ManageDistributionListMembers::setCvObjects()
     * @param string $action
     * @param string $distListId
     * @param \ArrayType\CvObjectArray $cvObjects
     */
    public function __construct($action = null, $distListId = null, \ArrayType\CvObjectArray $cvObjects = null)
    {
        $this
            ->setAction($action)
            ->setDistListId($distListId)
            ->setCvObjects($cvObjects);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ManageDistributionListAction::valueIsValid()
     * @uses \EnumType\ManageDistributionListAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\ManageDistributionListMembers
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ManageDistributionListAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ManageDistributionListAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\ManageDistributionListAction::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get DistListId value
     * @return string|null
     */
    public function getDistListId()
    {
        return $this->DistListId;
    }
    /**
     * Set DistListId value
     * @param string $distListId
     * @return \StructType\ManageDistributionListMembers
     */
    public function setDistListId($distListId = null)
    {
        // validation for constraint: string
        if (!is_null($distListId) && !is_string($distListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distListId, true), gettype($distListId)), __LINE__);
        }
        $this->DistListId = $distListId;
        return $this;
    }
    /**
     * Get CvObjects value
     * @return \ArrayType\CvObjectArray|null
     */
    public function getCvObjects()
    {
        return $this->CvObjects;
    }
    /**
     * Set CvObjects value
     * @param \ArrayType\CvObjectArray $cvObjects
     * @return \StructType\ManageDistributionListMembers
     */
    public function setCvObjects(\ArrayType\CvObjectArray $cvObjects = null)
    {
        $this->CvObjects = $cvObjects;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ManageDistributionListMembers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
