<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginResult StructType
 * Meta informations extracted from the WSDL
 * - type: s1:LoginResult
 * @subpackage Structs
 */
class LoginResult extends AbstractStructBase
{
    /**
     * The LoginSuccess
     * @var bool
     */
    public $LoginSuccess;
    /**
     * The ServerURL
     * @var string
     */
    public $ServerURL;
    /**
     * The CventSessionHeader
     * @var string
     */
    public $CventSessionHeader;
    /**
     * The ErrorMessage
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for LoginResult
     * @uses LoginResult::setLoginSuccess()
     * @uses LoginResult::setServerURL()
     * @uses LoginResult::setCventSessionHeader()
     * @uses LoginResult::setErrorMessage()
     * @param bool $loginSuccess
     * @param string $serverURL
     * @param string $cventSessionHeader
     * @param string $errorMessage
     */
    public function __construct($loginSuccess = null, $serverURL = null, $cventSessionHeader = null, $errorMessage = null)
    {
        $this
            ->setLoginSuccess($loginSuccess)
            ->setServerURL($serverURL)
            ->setCventSessionHeader($cventSessionHeader)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get LoginSuccess value
     * @return bool|null
     */
    public function getLoginSuccess()
    {
        return $this->LoginSuccess;
    }
    /**
     * Set LoginSuccess value
     * @param bool $loginSuccess
     * @return \StructType\LoginResult
     */
    public function setLoginSuccess($loginSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($loginSuccess) && !is_bool($loginSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loginSuccess, true), gettype($loginSuccess)), __LINE__);
        }
        $this->LoginSuccess = $loginSuccess;
        return $this;
    }
    /**
     * Get ServerURL value
     * @return string|null
     */
    public function getServerURL()
    {
        return $this->ServerURL;
    }
    /**
     * Set ServerURL value
     * @param string $serverURL
     * @return \StructType\LoginResult
     */
    public function setServerURL($serverURL = null)
    {
        // validation for constraint: string
        if (!is_null($serverURL) && !is_string($serverURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverURL, true), gettype($serverURL)), __LINE__);
        }
        $this->ServerURL = $serverURL;
        return $this;
    }
    /**
     * Get CventSessionHeader value
     * @return string|null
     */
    public function getCventSessionHeader()
    {
        return $this->CventSessionHeader;
    }
    /**
     * Set CventSessionHeader value
     * @param string $cventSessionHeader
     * @return \StructType\LoginResult
     */
    public function setCventSessionHeader($cventSessionHeader = null)
    {
        // validation for constraint: string
        if (!is_null($cventSessionHeader) && !is_string($cventSessionHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cventSessionHeader, true), gettype($cventSessionHeader)), __LINE__);
        }
        $this->CventSessionHeader = $cventSessionHeader;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\LoginResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoginResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
