<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invitee StructType
 * @subpackage Structs
 */
class Invitee extends CvObject
{
    /**
     * The InternalInfoDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InternalInfoDetail[]
     */
    public $InternalInfoDetail;
    /**
     * The RegretSurveyDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegretSurveyDetail[]
     */
    public $RegretSurveyDetail;
    /**
     * The WeblinkDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WeblinkDetail[]
     */
    public $WeblinkDetail;
    /**
     * The TargetedListId
     * @var string
     */
    public $TargetedListId;
    /**
     * The TargetedListName
     * @var string
     */
    public $TargetedListName;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The CCEmailAddress
     * @var string
     */
    public $CCEmailAddress;
    /**
     * The WorkPhone
     * @var string
     */
    public $WorkPhone;
    /**
     * The Participant
     * @var bool
     */
    public $Participant;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The ConfirmationNumber
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The ReferenceId
     * @var string
     */
    public $ReferenceId;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The OriginalResponseDate
     * @var string
     */
    public $OriginalResponseDate;
    /**
     * The VoucherCode
     * @var string
     */
    public $VoucherCode;
    /**
     * The IsObfuscated
     * @var bool
     */
    public $IsObfuscated;
    /**
     * Constructor method for Invitee
     * @uses Invitee::setInternalInfoDetail()
     * @uses Invitee::setRegretSurveyDetail()
     * @uses Invitee::setWeblinkDetail()
     * @uses Invitee::setTargetedListId()
     * @uses Invitee::setTargetedListName()
     * @uses Invitee::setContactId()
     * @uses Invitee::setSourceId()
     * @uses Invitee::setFirstName()
     * @uses Invitee::setLastName()
     * @uses Invitee::setCompany()
     * @uses Invitee::setTitle()
     * @uses Invitee::setEmailAddress()
     * @uses Invitee::setCCEmailAddress()
     * @uses Invitee::setWorkPhone()
     * @uses Invitee::setParticipant()
     * @uses Invitee::setEventId()
     * @uses Invitee::setEventCode()
     * @uses Invitee::setEventTitle()
     * @uses Invitee::setEventStartDate()
     * @uses Invitee::setStatus()
     * @uses Invitee::setInternalNote()
     * @uses Invitee::setConfirmationNumber()
     * @uses Invitee::setReferenceId()
     * @uses Invitee::setLastModifiedDate()
     * @uses Invitee::setOriginalResponseDate()
     * @uses Invitee::setVoucherCode()
     * @uses Invitee::setIsObfuscated()
     * @param \StructType\InternalInfoDetail[] $internalInfoDetail
     * @param \StructType\RegretSurveyDetail[] $regretSurveyDetail
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @param string $targetedListId
     * @param string $targetedListName
     * @param string $contactId
     * @param string $sourceId
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $title
     * @param string $emailAddress
     * @param string $cCEmailAddress
     * @param string $workPhone
     * @param bool $participant
     * @param string $eventId
     * @param string $eventCode
     * @param string $eventTitle
     * @param string $eventStartDate
     * @param string $status
     * @param string $internalNote
     * @param string $confirmationNumber
     * @param string $referenceId
     * @param string $lastModifiedDate
     * @param string $originalResponseDate
     * @param string $voucherCode
     * @param bool $isObfuscated
     */
    public function __construct(array $internalInfoDetail = array(), array $regretSurveyDetail = array(), array $weblinkDetail = array(), $targetedListId = null, $targetedListName = null, $contactId = null, $sourceId = null, $firstName = null, $lastName = null, $company = null, $title = null, $emailAddress = null, $cCEmailAddress = null, $workPhone = null, $participant = null, $eventId = null, $eventCode = null, $eventTitle = null, $eventStartDate = null, $status = null, $internalNote = null, $confirmationNumber = null, $referenceId = null, $lastModifiedDate = null, $originalResponseDate = null, $voucherCode = null, $isObfuscated = null)
    {
        $this
            ->setInternalInfoDetail($internalInfoDetail)
            ->setRegretSurveyDetail($regretSurveyDetail)
            ->setWeblinkDetail($weblinkDetail)
            ->setTargetedListId($targetedListId)
            ->setTargetedListName($targetedListName)
            ->setContactId($contactId)
            ->setSourceId($sourceId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setTitle($title)
            ->setEmailAddress($emailAddress)
            ->setCCEmailAddress($cCEmailAddress)
            ->setWorkPhone($workPhone)
            ->setParticipant($participant)
            ->setEventId($eventId)
            ->setEventCode($eventCode)
            ->setEventTitle($eventTitle)
            ->setEventStartDate($eventStartDate)
            ->setStatus($status)
            ->setInternalNote($internalNote)
            ->setConfirmationNumber($confirmationNumber)
            ->setReferenceId($referenceId)
            ->setLastModifiedDate($lastModifiedDate)
            ->setOriginalResponseDate($originalResponseDate)
            ->setVoucherCode($voucherCode)
            ->setIsObfuscated($isObfuscated);
    }
    /**
     * Get InternalInfoDetail value
     * @return \StructType\InternalInfoDetail[]|null
     */
    public function getInternalInfoDetail()
    {
        return $this->InternalInfoDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalInfoDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalInfoDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalInfoDetailForArrayConstraintsFromSetInternalInfoDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inviteeInternalInfoDetailItem) {
            // validation for constraint: itemType
            if (!$inviteeInternalInfoDetailItem instanceof \StructType\InternalInfoDetail) {
                $invalidValues[] = is_object($inviteeInternalInfoDetailItem) ? get_class($inviteeInternalInfoDetailItem) : sprintf('%s(%s)', gettype($inviteeInternalInfoDetailItem), var_export($inviteeInternalInfoDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InternalInfoDetail property can only contain items of type \StructType\InternalInfoDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InternalInfoDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\InternalInfoDetail[] $internalInfoDetail
     * @return \StructType\Invitee
     */
    public function setInternalInfoDetail(array $internalInfoDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($internalInfoDetailArrayErrorMessage = self::validateInternalInfoDetailForArrayConstraintsFromSetInternalInfoDetail($internalInfoDetail))) {
            throw new \InvalidArgumentException($internalInfoDetailArrayErrorMessage, __LINE__);
        }
        $this->InternalInfoDetail = $internalInfoDetail;
        return $this;
    }
    /**
     * Add item to InternalInfoDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\InternalInfoDetail $item
     * @return \StructType\Invitee
     */
    public function addToInternalInfoDetail(\StructType\InternalInfoDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InternalInfoDetail) {
            throw new \InvalidArgumentException(sprintf('The InternalInfoDetail property can only contain items of type \StructType\InternalInfoDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InternalInfoDetail[] = $item;
        return $this;
    }
    /**
     * Get RegretSurveyDetail value
     * @return \StructType\RegretSurveyDetail[]|null
     */
    public function getRegretSurveyDetail()
    {
        return $this->RegretSurveyDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setRegretSurveyDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegretSurveyDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegretSurveyDetailForArrayConstraintsFromSetRegretSurveyDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inviteeRegretSurveyDetailItem) {
            // validation for constraint: itemType
            if (!$inviteeRegretSurveyDetailItem instanceof \StructType\RegretSurveyDetail) {
                $invalidValues[] = is_object($inviteeRegretSurveyDetailItem) ? get_class($inviteeRegretSurveyDetailItem) : sprintf('%s(%s)', gettype($inviteeRegretSurveyDetailItem), var_export($inviteeRegretSurveyDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RegretSurveyDetail property can only contain items of type \StructType\RegretSurveyDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RegretSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RegretSurveyDetail[] $regretSurveyDetail
     * @return \StructType\Invitee
     */
    public function setRegretSurveyDetail(array $regretSurveyDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($regretSurveyDetailArrayErrorMessage = self::validateRegretSurveyDetailForArrayConstraintsFromSetRegretSurveyDetail($regretSurveyDetail))) {
            throw new \InvalidArgumentException($regretSurveyDetailArrayErrorMessage, __LINE__);
        }
        $this->RegretSurveyDetail = $regretSurveyDetail;
        return $this;
    }
    /**
     * Add item to RegretSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RegretSurveyDetail $item
     * @return \StructType\Invitee
     */
    public function addToRegretSurveyDetail(\StructType\RegretSurveyDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegretSurveyDetail) {
            throw new \InvalidArgumentException(sprintf('The RegretSurveyDetail property can only contain items of type \StructType\RegretSurveyDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RegretSurveyDetail[] = $item;
        return $this;
    }
    /**
     * Get WeblinkDetail value
     * @return \StructType\WeblinkDetail[]|null
     */
    public function getWeblinkDetail()
    {
        return $this->WeblinkDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setWeblinkDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeblinkDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inviteeWeblinkDetailItem) {
            // validation for constraint: itemType
            if (!$inviteeWeblinkDetailItem instanceof \StructType\WeblinkDetail) {
                $invalidValues[] = is_object($inviteeWeblinkDetailItem) ? get_class($inviteeWeblinkDetailItem) : sprintf('%s(%s)', gettype($inviteeWeblinkDetailItem), var_export($inviteeWeblinkDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @return \StructType\Invitee
     */
    public function setWeblinkDetail(array $weblinkDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($weblinkDetailArrayErrorMessage = self::validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail($weblinkDetail))) {
            throw new \InvalidArgumentException($weblinkDetailArrayErrorMessage, __LINE__);
        }
        $this->WeblinkDetail = $weblinkDetail;
        return $this;
    }
    /**
     * Add item to WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail $item
     * @return \StructType\Invitee
     */
    public function addToWeblinkDetail(\StructType\WeblinkDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WeblinkDetail) {
            throw new \InvalidArgumentException(sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WeblinkDetail[] = $item;
        return $this;
    }
    /**
     * Get TargetedListId value
     * @return string|null
     */
    public function getTargetedListId()
    {
        return $this->TargetedListId;
    }
    /**
     * Set TargetedListId value
     * @param string $targetedListId
     * @return \StructType\Invitee
     */
    public function setTargetedListId($targetedListId = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListId) && !is_string($targetedListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListId, true), gettype($targetedListId)), __LINE__);
        }
        $this->TargetedListId = $targetedListId;
        return $this;
    }
    /**
     * Get TargetedListName value
     * @return string|null
     */
    public function getTargetedListName()
    {
        return $this->TargetedListName;
    }
    /**
     * Set TargetedListName value
     * @param string $targetedListName
     * @return \StructType\Invitee
     */
    public function setTargetedListName($targetedListName = null)
    {
        // validation for constraint: string
        if (!is_null($targetedListName) && !is_string($targetedListName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetedListName, true), gettype($targetedListName)), __LINE__);
        }
        $this->TargetedListName = $targetedListName;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\Invitee
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\Invitee
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Invitee
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Invitee
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\Invitee
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Invitee
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\Invitee
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get CCEmailAddress value
     * @return string|null
     */
    public function getCCEmailAddress()
    {
        return $this->CCEmailAddress;
    }
    /**
     * Set CCEmailAddress value
     * @param string $cCEmailAddress
     * @return \StructType\Invitee
     */
    public function setCCEmailAddress($cCEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($cCEmailAddress) && !is_string($cCEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCEmailAddress, true), gettype($cCEmailAddress)), __LINE__);
        }
        $this->CCEmailAddress = $cCEmailAddress;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\Invitee
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get Participant value
     * @return bool|null
     */
    public function getParticipant()
    {
        return $this->Participant;
    }
    /**
     * Set Participant value
     * @param bool $participant
     * @return \StructType\Invitee
     */
    public function setParticipant($participant = null)
    {
        // validation for constraint: boolean
        if (!is_null($participant) && !is_bool($participant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($participant, true), gettype($participant)), __LINE__);
        }
        $this->Participant = $participant;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\Invitee
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\Invitee
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\Invitee
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\Invitee
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\InviteeStatus::valueIsValid()
     * @uses \EnumType\InviteeStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Invitee
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InviteeStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InviteeStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\InviteeStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\Invitee
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\Invitee
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\Invitee
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Invitee
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get OriginalResponseDate value
     * @return string|null
     */
    public function getOriginalResponseDate()
    {
        return $this->OriginalResponseDate;
    }
    /**
     * Set OriginalResponseDate value
     * @param string $originalResponseDate
     * @return \StructType\Invitee
     */
    public function setOriginalResponseDate($originalResponseDate = null)
    {
        // validation for constraint: string
        if (!is_null($originalResponseDate) && !is_string($originalResponseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalResponseDate, true), gettype($originalResponseDate)), __LINE__);
        }
        $this->OriginalResponseDate = $originalResponseDate;
        return $this;
    }
    /**
     * Get VoucherCode value
     * @return string|null
     */
    public function getVoucherCode()
    {
        return $this->VoucherCode;
    }
    /**
     * Set VoucherCode value
     * @param string $voucherCode
     * @return \StructType\Invitee
     */
    public function setVoucherCode($voucherCode = null)
    {
        // validation for constraint: string
        if (!is_null($voucherCode) && !is_string($voucherCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherCode, true), gettype($voucherCode)), __LINE__);
        }
        $this->VoucherCode = $voucherCode;
        return $this;
    }
    /**
     * Get IsObfuscated value
     * @return bool|null
     */
    public function getIsObfuscated()
    {
        return $this->IsObfuscated;
    }
    /**
     * Set IsObfuscated value
     * @param bool $isObfuscated
     * @return \StructType\Invitee
     */
    public function setIsObfuscated($isObfuscated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObfuscated) && !is_bool($isObfuscated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObfuscated, true), gettype($isObfuscated)), __LINE__);
        }
        $this->IsObfuscated = $isObfuscated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Invitee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
